<!DOCTYPE html>
<html dir="<?php echo ($front_setting->is_active_rtl) ? "rtl" : "ltr"; ?>" lang="<?php echo ($front_setting->is_active_rtl) ? "ar" : "en"; ?>">

<head>
   <title><?php echo $page['title']; ?></title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

  <link href="https://fonts.googleapis.com/css?family=Work+Sans:100,200,300,400,500,600,700,800,900" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css?family=Fredericka+the+Great" rel="stylesheet">

  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/open-iconic-bootstrap.min.css">
  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/animate.css">

  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/owl.carousel.min.css">
  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/owl.theme.default.min.css">
  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/magnific-popup.css">

  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/aos.css">

  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/ionicons.min.css">

  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/flaticon.css">
  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/icomoon.css">
  <link rel="stylesheet" href="<?php echo $base_assets_url ?>css/style.css">
  <script type="text/javascript">
  	var base_url = "<?php echo base_url() ?>";
  </script>
  <?php echo $front_setting->google_analytics; ?>
</head>
<?php echo $header; ?>

<body>

<?php if($page['is_homepage']==1) { 
	echo $slider; ?>


<?php 

	if (!empty($services_content)) 
	{
	?>
	<section class="ftco-services ftco-no-pb">
		<div class="container-wrap">
			<div class="row no-gutters">
				 <?php
				 foreach ($services_content as $services_content_key => $services_content_value) {
					 ?>
					<div class="col-md-3 d-flex services align-self-stretch pb-4 px-4 ftco-animate <?php echo $services_content_value['section_class']; ?>">
						<div class="media block-6 d-block text-center">
							<div class="icon d-flex justify-content-center align-items-center">
								<?php echo $services_content_value['icon_text']; ?>
							</div>
							<div class="media-body p-2 mt-3">
								<h3 class="heading"><?php echo $services_content_value['title']; ?></h3>
								<p><?php echo $services_content_value['description']; ?></p>
							</div>
						</div>
					</div><?php
				 }?>
			</div>
		</div>
	</section><?php
	}
}?>

<?php 
if($page['is_homepage']==1) {
	if (!empty($directors_content)) 
	{
	   $d=0;
	   foreach ($directors_content as $directors_content_key => $directors_content_value) {
		if($d==0)
		{
	?>
	<section class="ftco-section ftco-no-pt ftc-no-pb">
		<div class="container">
			<div class="row">
				<div class="col-md-6 order-md-last wrap-about py-5 wrap-about bg-light"
					style="display: flex; justify-content: center; align-items: center;">
					<div class="text px-4 ftco-animate" style="text-align: center; max-width: 500px; width: 100%;">
						<img src="<?php echo $directors_content_value['feature_image']; ?>" alt="Director's Image" class="director-image mb-4"
							style="width: 100%; max-width: 300px; height: auto; margin-bottom: 20px;">
						<h4><?php echo $directors_content_value['director_name']; ?></h4>
						<h4><?php echo $directors_content_value['director_post']; ?></h4>
					</div>
				</div>
	
				<div class="col-md-6 wrap-about py-5 pr-md-4 ftco-animate">
					<h2 class="mb-4"><?php echo $directors_content_value['title']; ?></h2>
					<?php echo $directors_content_value['description']; ?>
				</div>
			</div>
		</div>
	</section><?php
			
		}
		$d++;
		}
	}
?>

<?php 

	if (!empty($directors_content)) 
	{
	   $d=0;
	   foreach ($directors_content as $directors_content_key => $directors_content_value) {
		if($d==1)
		{
	?>
	<section class="ftco-section ftco-no-pt ftc-no-pb">
		<div class="container">
			<div class="row">
				<div class="col-md-6 order-md-last wrap-about py-5 wrap-about"
					style="display: flex; justify-content: center; align-items: center;">
					<div class="text px-4 ftco-animate" style="text-align: center; max-width: 500px; width: 100%;">
						<img src="<?php echo $directors_content_value['feature_image']; ?>" alt="Director's Image" class="director-image mb-4"
							style="width: 100%; max-width: 300px; height: auto; margin-bottom: 20px;">
						<h4><?php echo $directors_content_value['director_name']; ?></h4>
						<h4><?php echo $directors_content_value['director_post']; ?></h4>
					</div>
				</div>
				<div class="col-md-6 order-md-last wrap-about py-5 wrap-about bg-light">
					<div class="text px-4 ftco-animate">
						<h2 class="mb-4"><?php echo $directors_content_value['title']; ?></h2>
						<?php echo $directors_content_value['description']; ?>
					</div>
				</div>
			</div>
		</div>
	</section><?php
			
		}
		$d++;
		}
	}
?>

<?php if (!empty($directors_content)) 
{
   $d=0;
   foreach ($directors_content as $directors_content_key => $directors_content_value) {
	if($d==2)
	{
?>
<section class="ftco-section ftco-no-pt ftc-no-pb">
	<div class="container">
		<div class="row">
			<div class="col-md-6 order-md-last wrap-about py-5 wrap-about bg-light"
				style="display: flex; justify-content: center; align-items: center;">
				<div class="text px-4 ftco-animate" style="text-align: center; max-width: 500px; width: 100%;">
					<img src="<?php echo $directors_content_value['feature_image']; ?>" alt="Director's Image" class="director-image mb-4"
						style="width: 100%; max-width: 300px; height: auto; margin-bottom: 20px;">
					<h4><?php echo $directors_content_value['title']; ?></h4>
					<h4><?php echo $directors_content_value['director_post']; ?></h4>
					<!--
							<p><a href="#" class="btn btn-secondary px-4 py-3">Read More</a></p>
							-->
				</div>
			</div>
			<div class="col-md-6 wrap-about py-5 pr-md-4 ftco-animate">
				<h2 class="mb-4"><?php echo $directors_content_value['title']; ?></h2>
				<?php echo $directors_content_value['description']; ?>
			</div>
		</div>
	</div>
</section>
<?php
		
	}
	$d++;
	}
}

?>

<section class="ftco-intro" style="background-image: url(<?php echo $base_assets_url; ?>images/bg_3.jpg);" data-stellar-background-ratio="0.5">
	<div class="overlay"></div>
	<div class="container">
		<div class="row">
			<div class="col-md-9">
				<h2>Teaching Your Child Some Good Manners</h2>
				<p class="mb-0">A small river named Duden flows by their place and supplies it with the necessary
					regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.
				</p>
			</div>
			<div class="col-md-3 d-flex align-items-center">
				<p class="mb-0"><a href="#" class="btn btn-secondary px-4 py-3">Take a Course</a></p>
			</div>
		</div>
	</div>
</section>

<section class="ftco-intro">
    <iframe width="100%" height="700"
        src="https://www.youtube.com/embed/tgbNymZ7vqY?autoplay=1&controls=1&mute=1&loop=1" title="YouTube video player"
        frameborder="0"
        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture web-share"
        allowfullscreen></iframe>
</section>

<?php if (!empty($teachers_content)) 
{
?>
<section class="ftco-section ftco-no-pb">
    <div class="container">
        <div class="row justify-content-center mb-5 pb-2">
            <div class="col-md-8 text-center heading-section ftco-animate">
                <h2 class="mb-4"><span>Certified</span> Teachers</h2>
                <p>Separated they live in. A small river named Duden flows by their place and supplies it with the
                    necessary regelialia. It is a paradisematic country</p>
            </div>
        </div>
        <div class="row">
            <?php
           foreach ($teachers_content as $teachers_content_key => $teachers_content_value) {
			?>
            <div class="col-md-6 col-lg-3 ftco-animate">
                <div class="staff">
                    <div class="img-wrap d-flex align-items-stretch">
                        <div class="img align-self-stretch" style="background-image: url(<?php echo $teachers_content_value['feature_image']; ?>"></div>
                    </div>
                    <div class="text pt-3 text-center">
                        <h3><?php echo $teachers_content_value['director_name']; ?></h3>
                        <span class="position mb-2"><?php echo $teachers_content_value['director_post']; ?></span>
                        <div class="faded">
                            <p><?php echo $teachers_content_value['description']; ?></p>
                            <?php 
							if($teachers_content_value['twitter_link']!='' || $teachers_content_value['facebook_link'] || $teachers_content_value['instagram_link']) { ?>
                            <ul class="ftco-social text-center">
                            	<?php 
								if($teachers_content_value['twitter_link']!='') { ?>
                                <li class="ftco-animate"><a target="_blank" href="<?php echo $teachers_content_value['twitter_link']; ?>"><span class="icon-twitter"></span></a></li><?php
								}
								if($teachers_content_value['facebook_link']!='') { ?>
                                	<li class="ftco-animate"><a target="_blank" href="<?php echo $teachers_content_value['facebook_link']; ?>"><span class="icon-facebook"></span></a></li><?php 
								}
								if($teachers_content_value['instagram_link']!='') { ?>
                               <?php /*?> <li class="ftco-animate"><a href="#"><span class="icon-google-plus"></span></a></li><?php */?>
                                <li class="ftco-animate"><a target="_blank" href="<?php echo $teachers_content_value['instagram_link']; ?>"><span class="icon-instagram"></span></a></li><?php } ?>
                            </ul><?php }?>
                        </div>
                    </div>
                </div>
            </div><?php
		    }?>
        </div>
    </div>
</section><?php
}?>

<section class="ftco-section ftco-counter img" id="section-counter" style="background-image: url(<?php echo $base_assets_url; ?>images/bg_4.jpg);"
    data-stellar-background-ratio="0.5">
    <div class="container">
        <div class="row justify-content-center mb-5 pb-2">
            <div class="col-md-8 text-center heading-section heading-section-black ftco-animate">
                <h2 class="mb-4"><span>20 Years of</span> Experience</h2>
                <p>Separated they live in. A small river named Duden flows by their place and supplies it with the
                    necessary regelialia. It is a paradisematic country</p>
            </div>
        </div>
        <div class="row d-md-flex align-items-center justify-content-center">
            <div class="col-lg-10">
                <div class="row d-md-flex align-items-center">
                    <div class="col-md d-flex justify-content-center counter-wrap ftco-animate">
                        <div class="block-18">
                            <div class="icon"><span class="flaticon-doctor"></span></div>
                            <div class="text">
                                <strong class="number" data-number="18">0</strong>
                                <span>Certified Teachers</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md d-flex justify-content-center counter-wrap ftco-animate">
                        <div class="block-18">
                            <div class="icon"><span class="flaticon-doctor"></span></div>
                            <div class="text">
                                <strong class="number" data-number="351">0</strong>
                                <span>Successful Kids</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md d-flex justify-content-center counter-wrap ftco-animate">
                        <div class="block-18">
                            <div class="icon"><span class="flaticon-doctor"></span></div>
                            <div class="text">
                                <strong class="number" data-number="564">0</strong>
                                <span>Happy Parents</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md d-flex justify-content-center counter-wrap ftco-animate">
                        <div class="block-18">
                            <div class="icon"><span class="flaticon-doctor"></span></div>
                            <div class="text">
                                <strong class="number" data-number="300">0</strong>
                                <span>Awards Won</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if (!empty($testimonial_content)) 
{
?>
<section class="ftco-section testimony-section bg-light">
    <div class="container">
        <div class="row justify-content-center mb-5 pb-2">
            <div class="col-md-8 text-center heading-section ftco-animate">
                <h2 class="mb-4"><span>What Parents</span> Says About Us</h2>
                <p>Separated they live in. A small river named Duden flows by their place and supplies it with the
                    necessary regelialia. It is a paradisematic country</p>
            </div>
        </div>
        <div class="row ftco-animate justify-content-center">
            <div class="col-md-12">
                <div class="carousel-testimony owl-carousel">
                 <?php
             	 foreach ($testimonial_content as $testimonial_content_key => $testimonial_content_value) {
				 ?>
                    <div class="item">
                        <div class="testimony-wrap d-flex">
                            <div class="user-img mr-4" style="background-image: url(<?php echo $testimonial_content_value['feature_image']; ?>)">
                            </div>
                            <div class="text ml-2 bg-light">
                                <span class="quote d-flex align-items-center justify-content-center">
                                    <i class="icon-quote-left"></i>
                                </span>
                                <p><?php echo $services_content_value['description']; ?></p>
                                <p class="name"><?php echo $services_content_value['director_name']; ?></p>
                                <span class="position"><?php echo $services_content_value['director_post']; ?></span>
                            </div>
                        </div>
                    </div><?php
				 }?>
                    
                </div>
            </div>
        </div>
    </div>
</section><?php
}?>



<section class="ftco-section ftco-consult ftco-no-pt ftco-no-pb" style="background-image: url(<?php echo $base_assets_url; ?>images/bg_5.jpg);"
    data-stellar-background-ratio="0.5">
    <div class="container">
        <div class="row justify-content-end">
            <div class="col-md-6 py-5 px-md-5 bg-primary">
                <div class="heading-section heading-section-white ftco-animate mb-5">
                    <h2 class="mb-4">Admission Enquiry</h2>
                    <p>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there
                        live the blind texts.</p>
                </div>
                <form action="#" class="appointment-form ftco-animate">
                    <div class="d-md-flex">
                        <div class="form-group">
                            <input type="text" class="form-control" placeholder="First Name">
                        </div>
                        <div class="form-group ml-md-4">
                            <input type="text" class="form-control" placeholder="Last Name">
                        </div>
                    </div>
                    <div class="d-md-flex">
                        <div class="form-group">
                            <div class="form-field">
                                <div class="select-wrap">
                                    <div class="icon"><span class="ion-ios-arrow-down"></span></div>
                                    <select name="" id="" class="form-control">
                                        <option value="">Select Your Course</option>
                                        <option value="">Art Lesson</option>
                                        <option value="">Language Lesson</option>
                                        <option value="">Music Lesson</option>
                                        <option value="">Sports</option>
                                        <option value="">Other Services</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group ml-md-4">
                            <input type="text" class="form-control" placeholder="Phone">
                        </div>
                    </div>
                    <div class="d-md-flex">
                        <div class="form-group">
                            <textarea name="" id="" cols="30" rows="2" class="form-control"
                                placeholder="Message"></textarea>
                        </div>
                        <div class="form-group ml-md-4">
                            <input type="submit" value="Submit Enquiry" class="btn btn-secondary py-3 px-4">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<?php if (!empty($blogs_content)) 
{
?>
<section class="ftco-section bg-light">
	<div class="container">
		<div class="row justify-content-center mb-5 pb-2">
        	<div class="col-md-8 text-center heading-section ftco-animate">
            	<h2 class="mb-4"><span>Recent</span> Blog</h2>
            	<p>Separated they live in. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country</p>
          	</div>
        </div>
		<div class="row">
        	<?php
			$d=0;
            foreach ($blogs_content as $blogs_content_key => $blogs_content_value) {
				
					?>
					<div class="col-md-6 col-lg-4 ftco-animate">
						<div class="blog-entry">
							<a href="blog-single.html" class="block-20 d-flex align-items-end" style="background-image: url('<?php echo $blogs_content_value['feature_image']; ?>');">
								<div class="meta-date text-center p-2">
									<?php $dt=explode("-",date("Y-M-d",strtotime($blogs_content_value['description']))); ?>
									<span class="day"><?php echo $dt[2]?></span>
									<span class="mos"><?php echo $dt[1]?></span>
									<span class="yr"><?php echo $dt[0]?></span>
								</div>
							</a>
							<div class="text bg-white p-4">
								<h3 class="heading"><a href="#"><?php echo $blogs_content_value['title']; ?></a></h3>
								<p><?php 
								$words = explode(' ', $blogs_content_value['description']);
								$firstWords = array_slice($words, 0, 20);
								
								echo implode(' ', $firstWords);
								//echo $blogs_content_value['description']; ?></p>
								<div class="d-flex align-items-center mt-4">
									<p class="mb-0"><a href="#" class="btn btn-secondary">Read More <span class="ion-ios-arrow-round-forward"></span></a></p>
									<p class="ml-auto mb-0">
										<a href="#" class="mr-2">Admin</a>
										<a href="#" class="meta-chat"><span class="icon-chat"></span> 3</a>
									</p>
								</div>
							</div>
						</div>
					</div><?php
				
			}?>
          	
        </div>
	</div>
</section><?php
}

}//is home page over
else
{
	//not home page
	?>
	
    <section class="hero-wrap hero-wrap-2" style="background-image: url('images/bg_2.jpg');">
      <div class="overlay"></div>
      <div class="container">
        <div class="row no-gutters slider-text align-items-center justify-content-center">
          <div class="col-md-9 ftco-animate text-center">
            <h1 class="mb-2 bread"><?php echo $page['title']?></h1>
            <p class="breadcrumbs"><span class="mr-2"><a href="../">Home <i class="ion-ios-arrow-forward"></i></a></span> <span><?php echo $page['title']?> <i class="ion-ios-arrow-forward"></i></span></p>
          </div>
        </div>
      </div>
    </section>
    <section class="ftco-section ftco-no-pt ftc-no-pb">
			<div class="container">
				<div class="row">
					 <div class="col-md-12 wrap-about py-5 pr-md-4 ftco-animate">
					 <?php echo $content; ?>
					 </div>
				</div>
			</div>
		</section>
	
	<?php
}?>

<?php echo $footer ?>

<script src="<?php echo $base_assets_url ?>js/jquery.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/jquery-migrate-3.0.1.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/popper.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/bootstrap.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/jquery.easing.1.3.js"></script>
  <script src="<?php echo $base_assets_url ?>js/jquery.waypoints.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/jquery.stellar.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/owl.carousel.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/jquery.magnific-popup.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/aos.js"></script>
  <script src="<?php echo $base_assets_url ?>js/jquery.animateNumber.min.js"></script>
  <script src="<?php echo $base_assets_url ?>js/scrollax.min.js"></script>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBVWaKrjvy3MaE7SQ74_uJiULgl1JY0H2s&sensor=false"></script>
  <script src="<?php echo $base_assets_url ?>js/google-map.js"></script>
  <script src="<?php echo $base_assets_url ?>js/main.js"></script>
    </body>
    
    
  </html>