<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Attendance Record</title>
  <style>
    @media print {
      body {
        margin: 0;
        padding: 0;
      }
      .container {
        box-shadow: none;
        border: none;
      }
    }

    body {
      font-family: Arial, sans-serif;
      background-color: #f8f9fa;
      margin: 0;
      padding: 10px;
      font-size: 11px;
    }

    .container {
      max-width: 700px;
      margin: 0 auto;
      padding: 15px;
      background-color: #fff;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
      border-radius: 8px;
    }

    .header {
      text-align: center;
      margin-bottom: 8px;
    }

    .header h2 {
      color: #e60000;
      margin: 3px 0;
      font-size: 16px;
    }

    .sub-header {
      font-size: 10px;
      display: flex;
      justify-content: space-between;
      margin-bottom: 5px;
    }

    .info-section {
      margin: 10px 0;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 8px;
    }

    th, td {
      border: 1px solid black;
      padding: 5px;
      text-align: center;
      font-size: 10px;
    }

    th {
      background-color: #f2f2f2;
    }

    .footer {
      font-weight: bold;
    }
  </style>
</head>
<body onload="window.print()">

  <div class="container">
    <div class="sub-header">
      <span>School Index No. 62.01.025</span>
      <span>UDISE NO. 2728120105</span>
      <span>School Registration No. OSM 374</span>
    </div>

    <div class="header">
      <h2>The Modern Education Society’s</h2>
      <h2>Baswanappa Wale New English Medium School</h2>
      <p>Latur - 413 531. Ph : 221905</p>
      <strong>Date: <?php echo date('d F Y'); ?></strong>
    </div>

    <h3 style="text-align: center; text-decoration: underline; margin: 5px 0; font-size: 14px;">ATTENDANCE RECORD</h3>

    <div class="info-section">
      <p><strong>Name:</strong> <?php echo $studentDetails['firstname'] . ' ' . $studentDetails['middlename'] . ' ' . $studentDetails['lastname']; ?></p>
      <p><strong>Class:</strong> <?php echo $studentDetails['class'] . ' (' . $studentDetails['section'] . ')'; ?></p>
      <p><strong>Year:</strong> <?php echo $currentSessionName ?></p>
    </div>

    <!-- ANIL -->
    <table border="1">
      <thead>
        <tr>
          <th>Month</th>
          <th>Days</th>
          <th>Working days</th>
          <th>Present days</th>
        </tr>
      </thead>
      <tbody>
        <?php
        $totalWorkingDays = 0;
        $totalPresentDays = 0;

        foreach ($attendaceDataByStudentID as $attendanceValue) {
          echo "<tr>";
          echo "<td>" . $attendanceValue['month_name'] . "</td>";
          echo "<td>" . $attendanceValue['total_month_days'] . "</td>";
          echo "<td>" . $attendanceValue['working_days'] . "</td>";
          echo "<td>" . $attendanceValue['present'] . "</td>";
          echo "</tr>";

          $totalWorkingDays += $attendanceValue['working_days'];
          $totalPresentDays += $attendanceValue['present'];
        }

        $presentPercentage = $totalWorkingDays > 0 ? ($totalPresentDays / $totalWorkingDays) * 100 : 0;
        ?>

        <tr>
          <td><strong>Total Present</strong></td>
          <td></td>
          <td></td>
          <td><strong><?= $totalPresentDays ?></strong></td>
        </tr>

        <tr>
          <td><strong>Present %</strong></td>
          <td colspan="3"><strong><?= number_format($presentPercentage, 2) ?>%</strong></td>
        </tr>
      </tbody>
    </table>
    <!-- ANIL -->
  </div>

</body>
</html>
