<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>

<link rel='stylesheet' href='https://foliotek.github.io/Croppie/croppie.css'>
<script type="text/javascript" src='https://foliotek.github.io/Croppie/croppie.js'></script>
<style>
    #upload-demo{
        width: 100%;
        height: 420px;
        padding-bottom:25px;
    }
</style>

<div class="content-wrapper">
    <section class="content-header">
         
    </section>
    <!-- Main content -->
    <section class="content">
         <div class="row">
    <div class="col-md-12">
        <div class="box box-primary border0 mb0 margesection">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-search"></i>  <?php echo $this->lang->line('attendance') . " " . $this->lang->line('report') ?></h3>

            </div>
            <div class="">
                <ul class="reportlists">
                    <?php
                    if (!is_subAttendence()) {


                        if ($this->rbac->hasPrivilege('attendance_report', 'can_view')) {
                            ?> 
                            <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendance/attendance_report'); ?>"><a href="<?php echo base_url(); ?>admin/stuattendence/classattendencereport"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('attendance_report'); ?></a></li>
                            <?php
                        }
                        if ($this->rbac->hasPrivilege('student_attendance_type_report', 'can_view')) {
                            ?>
                            <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendence/attendancereport'); ?>"><a href="<?php echo base_url() ?>report/attendancereport"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('student') . " " . $this->lang->line('attendance') . " " . $this->lang->line('type') . " " . $this->lang->line('report'); ?></a></li>
                            <?php
                        }
                    }
                    if ($this->rbac->hasPrivilege('staff_attendance_report', 'can_view')) {
                        ?>

                        <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendance/staff_attendance_report'); ?>"><a href="<?php echo base_url() ?>admin/staffattendance/attendancereport"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('staff_attendance_report'); ?></a></li>
                    <?php } ?>
                    <?php
                    if (is_subAttendence()) {
                        if (($this->rbac->hasPrivilege('student_period_attendance_report', 'can_view'))) {
                            ?>

                            <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_subSubmenu('Reports/attendence/reportbymonth'); ?>"><a href="<?php echo site_url('admin/subjectattendence/reportbymonth'); ?>"><i class="fa fa-file-text-o"></i> <?php ?> <?php echo $this->lang->line('period') . " " . $this->lang->line('attendance') . " " . $this->lang->line('report'); ?></a></li>
                            <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_subSubmenu('Reports/attendence/reportbymonthstudent'); ?>"><a href="<?php echo site_url('admin/subjectattendence/reportbymonthstudent'); ?>"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('student') . " " . $this->lang->line('period') . " " . $this->lang->line('attendance'); ?></a></li>
                            <?php
                        }
                    }
                    if ($this->customlib->is_biometricAttendence()) {
                        if ($this->rbac->hasPrivilege('biometric_attendance_log', 'can_view')) {
                            ?>
                            <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendence/biometric_attlog'); ?>"><a href="<?php echo site_url('report/biometric_attlog'); ?>"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('biometric') . " " . $this->lang->line('attendance') . " " . $this->lang->line('log'); ?></a></li>
                            <?php
                        }
                    } 
                    if ($this->rbac->hasPrivilege('daily_attendance_report', 'can_view')) {
                        ?>

                        <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendance/daily_attendance_report'); ?>"><a href="<?php echo site_url('report/daily_attendance_report'); ?>"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('daily_attendance_report'); ?></a></li>

                    <?php } 

                    if ($this->rbac->hasPrivilege('attendance_report_maharashtra', 'can_view')) {
                            ?> 
                            <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendance/attendance_report_maharashtra'); ?>"><a href="<?php echo base_url(); ?>attendencereports/classattendencereport_maharashtra"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('attendance_report'); ?> (Maharashtra)</a></li>
                            <?php
                        }

                        if ($this->rbac->hasPrivilege('attendance_report_english', 'can_view')) {
                            ?> 
                            <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendance/attendance_report_english'); ?>"><a href="<?php echo base_url(); ?>attendencereports/classattendencereport_english"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('attendance_report'); ?> (English)</a></li>
                            <?php
                        }
                        if ($this->rbac->hasPrivilege('staff_attendance_report_mh', 'can_view')) {
                        ?>

                        <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('Reports/attendance/staff_attendance_report_mh'); ?>"><a href="<?php echo base_url() ?>attendencereports/staffattendancereport_marathi"><i class="fa fa-file-text-o"></i> <?php echo $this->lang->line('staff_attendance_report'); ?>(Maharashtra)</a></li>
                    <?php } ?>

                    <li class="col-lg-4 col-md-4 col-sm-6 <?php echo set_SubSubmenu('student/montlyAttendence'); ?>"><a href="<?php echo base_url() ?>student/montlyAttendence"><i class="fa fa-file-text-o"></i> Monthly Attendance Summary</a></li>

                </ul>
            </div>
        </div>
    </div>
</div>
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="box box-primary">
                   
                    <div class="box-body">
                       
                        <?php if ($this->session->flashdata('msg')) {?> <div class="alert alert-success">  <?php echo $this->session->flashdata('msg'); $this->session->unset_userdata('msg'); ?> </div> <?php }?>
                        <div class="row">
                              <form role="form" action="<?php echo site_url('student/searchvalidation') ?>" method="post" class="class_search_form">
                            <div class="col-md-6">
                                <div class="row">
                                        <?php echo $this->customlib->getCSRF(); ?>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('class'); ?></label> <small class="req"> *</small>
                                                <select autofocus="" id="class_id" name="class_id" class="form-control" >
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                    <?php
$count = 0;
foreach ($classlist as $class) {
    ?>
                                                        <option value="<?php echo $class['id'] ?>" <?php if (set_value('class_id') == $class['id']) {
        echo "selected=selected";
    }
    ?>><?php echo $class['class'] ?></option>
                                                        <?php
$count++;
}
?>
                                                </select>
                                                  <span class="text-danger" id="error_class_id"></span>
                                            </div>
                                        </div> 
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('section'); ?></label>
                                                <select  id="section_id" name="section_id" class="form-control" >
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                </select>
                                                <span class="text-danger"><?php echo form_error('section_id'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm pull-right checkbox-toggle"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                            </div>
                                        </div>
                                </div>
                            </div><!--./col-md-6-->
                               
                            <div class="col-md-6">
                                <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('search_by_keyword'); ?></label>
                                        <input type="text" name="search_text" id="search_text" class="form-control" value="<?php echo set_value('search_text'); ?>"   placeholder="<?php echo $this->lang->line('search_by_student_name'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <button type="submit" name="search" value="search_full" class="btn btn-primary pull-right btn-sm checkbox-toggle"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                            </div>
                                        </div>                                 
                                </div>
                           </div><!--./col-md-6-->
                       </form>
                        </div><!--./row-->
                    </div>
                
                    <div class="nav-tabs-custom border0 navnoshadow">
                      <div class="box-header ptbnull"></div>
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#tab_1" data-toggle="tab" aria-expanded="true"><i class="fa fa-list"></i> <?php echo $this->lang->line('list_view'); ?></a></li>
                            <li class=""><a href="#tab_2" data-toggle="tab" aria-expanded="false"><i class="fa fa-newspaper-o"></i> <?php echo $this->lang->line('details_view'); ?></a></li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active table-responsive no-padding overflow-scroll-lg" id="tab_1">
                                <table class="table table-striped table-bordered table-hover student-list" data-export-title="<?php echo $this->lang->line('student_list'); ?>">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('admission_no'); ?></th>
                                            <th><?php echo $this->lang->line('roll_no'); ?></th>
                                            <th><?php echo $this->lang->line('student_name'); ?></th>
                                            <th><?php echo $this->lang->line('class'); ?></th>
                                             <?php if ($sch_setting->father_name) {?>
                                            <th><?php echo $this->lang->line('father_name'); ?></th>
                                            <?php }?>
                                            <?php if ($sch_setting->mother_name) {?>
                                            <th><?php echo $this->lang->line('mother_name'); ?></th>
                                            <?php }?>
                                            <th><?php echo $this->lang->line('date_of_birth'); ?></th>
                                            <th><?php echo $this->lang->line('gender'); ?></th>
                                            <?php if ($sch_setting->category) {  ?>
                                              <?php if ($sch_setting->category) {?>
                                            <th><?php echo $this->lang->line('category'); ?></th>
                                            <?php }
                                            }if ($sch_setting->mobile_no) {  ?>
                                            <th><?php echo $this->lang->line('mobile_number'); ?></th>
                                            <?php }
                                             if (!empty($fields)) {
                                               foreach ($fields as $fields_key => $fields_value) {    ?>
                                                    <th><?php echo $fields_value->name; ?></th>
                                            <?php }
                                            } ?>
                                            <th class="text-right noExport white-space-nowrap"><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                            <div class="tab-pane detail_view_tab" id="tab_2">
                                <?php if (empty($resultlist)) {
    ?>
                                    <div class="alert alert-info"><?php echo $this->lang->line('no_record_found'); ?></div>
                                    <?php
} else {
    $count = 1;
    foreach ($resultlist as $student) {

        if (empty($student["image"])) {
            if ($student['gender'] == 'Female') {
                $image = "uploads/student_images/default_female.jpg";
            } else {
                $image = "uploads/student_images/default_male.jpg";
            }
        } else {
            $image = $student['image'];
        }
        ?>
                                        <div class="carousel-row">
                                            <div class="slide-row">
                                                <div id="carousel-2" class="carousel slide slide-carousel" data-ride="carousel">
                                                    <div class="carousel-inner">
                                                        <div class="item active">
                                                            <a href="<?php echo base_url(); ?>student/view/<?php echo $student['id'] ?>">
                                                                <?php if ($sch_setting->student_photo) {?><img class="img-responsive img-thumbnail width150" alt="<?php echo $student["firstname"] . " " . $student["lastname"] ?>" src="<?php echo $this->media_storage->getImageURL($image); ?>" alt="Image"><?php }?></a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="slide-content">
                                                    <h4><a href="<?php echo base_url(); ?>student/view/<?php echo $student['id'] ?>"> <?php echo $this->customlib->getFullName($student['firstname'], $student['middlename'], $student['lastname'], $sch_setting->middlename, $sch_setting->lastname); ?></a></h4>
                                                    <div class="row">
                                                        <div class="col-xs-6 col-md-6">
                                                            <address>
                                                                <strong><b><?php echo $this->lang->line('class'); ?>: </b><?php echo $student['class'] . "(" . $student['section'] . ")" ?></strong><br>
                                                                <b><?php echo $this->lang->line('admission_no'); ?>: </b><?php echo $student['admission_no'] ?><br/>
                                                                <b><?php echo $this->lang->line('date_of_birth'); ?>:
            <?php if ($student["dob"] != null && $student["dob"] != '0000-00-00') {echo date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($student['dob']));}?><br>
                                                                    <b><?php echo $this->lang->line('gender'); ?>:&nbsp;</b><?php echo $this->lang->line(strtolower($student['gender'])) ?><br>
                                                                    </address>
                                                                    </div>
                                                                    <div class="col-xs-6 col-md-6">
                                                                        <b><?php echo $this->lang->line('local_identification_no'); ?>:&nbsp;</b><?php echo $student['samagra_id'] ?><br>
                                                                        <?php if ($sch_setting->guardian_name) {?>
                                                                        <b><?php echo $this->lang->line('guardian_name'); ?>:&nbsp;</b><?php echo $student['guardian_name'] ?><br>
                                                                    <?php }if ($sch_setting->guardian_name) {?>
                                                                        <b><?php echo $this->lang->line('guardian_phone'); ?>: </b> <abbr title="Phone"><i class="fa fa-phone-square"></i>&nbsp;</abbr> <?php echo $student['guardian_phone'] ?><br> <?php }?>
                                                                        <b><?php echo $this->lang->line('current_address'); ?>:&nbsp;</b><?php echo $student['current_address'] ?> <?php echo $student['city'] ?><br>
                                                                    </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="slide-footer">
                                                                        <span class="pull-right buttons">
                                                                            <a href="<?php echo base_url(); ?>student/view/<?php echo $student['id'] ?>" class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('view'); ?>" >
                                                                                <i class="fa fa-reorder"></i>
                                                                            </a>
                                                                            <?php
if ($this->rbac->hasPrivilege('student', 'can_edit')) {
            ?>
                                                                                <a href="<?php echo base_url(); ?>student/edit/<?php echo $student['id'] ?>" class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>">
                                                                                    <i class="fa fa-pencil"></i>
                                                                                </a>
                                                                                <?php
}
        if ($this->module_lib->hasActive('fees_collection') && $this->rbac->hasPrivilege('collect_fees', 'can_add')) {
            ?>
                                                                                <a href="<?php echo base_url(); ?>studentfee/addfee/<?php echo $student['id'] ?>" class="btn btn-default btn-xs" data-toggle="tooltip" title="" data-original-title="<?php echo $this->lang->line('add_fees'); ?>">
                                                                                <?php echo $currency_symbol; ?>
                                                                                </a>
            <?php }?>
                                                                        </span>
                                                                    </div>
                                                                    </div>
                                                                    </div>
                                                                    <?php
}
    $count++;
}
?>
                                                            </div>
                                                            </div>
                                                            </div>
                                                          </div><!--./box box-primary -->
                                                           
                                                        </div>
                                                        </div>
                                                        </section>
                                                        </div>
<div class="modal fade" id="studentcertificate" role="dialog">
    <div class="modal-dialog" style="width:80%;">       
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title title text-center modal_title"></h4>
            </div>
            <div class="modal-body">
                <div class="form-horizontal">
                    <div class="box-body">
                        <div class="cert-preview-section"></div>
                        <div class="row">
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-block leav-cert11 getCertificatePreviewdetail" data-stdid="" data-certtype="leaving" data-toggle="tooltip" title="Print Leaving Certificate" data-original-title="Show">
                                    Leaving Certificate
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-warning btn-sm btn-block bona-cert11 getCertificatePreviewdetail" data-stdid="" data-certtype="bonafide" data-toggle="tooltip" title="Print Bonafied Certificate" data-original-title="Show">
                                    Bonafied Certificate
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-success btn-sm entry-cert11 btn-block getCertificatePreviewdetail" data-stdid="" data-certtype="entry" data-toggle="tooltip" title="Print Entry Certificate" data-original-title="Show">
                                    Entry Certificate
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-sm adm-form-cert11 btn-block getCertificatePreviewdetail" data-stdid="" data-certtype="admissionform" data-toggle="tooltip" title="Print Addmission Form" data-original-title="Show" style="background-color: #0578a7;border-color: #16baf3;color: #fff;">
                                    Admission Form
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-danger btn-sm stdid-card-cert11 btn-block getCertificatePreviewdetail" data-stdid="" data-certtype="studentidcard" data-idtype="verticle" data-toggle="tooltip" title="Print Student Id Card" data-original-title="Show">
                                    Student ID (Verticle)
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-danger btn-sm stdid-card-cert11 btn-block getCertificatePreviewdetail" data-stdid="" data-certtype="studentidcard" data-idtype="horizontal" data-toggle="tooltip" title="Print Student Id Card" data-original-title="Show">
                                    Student ID (Horizontal)
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-flickr btn-sm parid-card-cert11 btn-block getCertificatePreviewdetail" data-stdid="" data-certtype="parentidcard" data-toggle="tooltip" title="Print Parent Id Card" data-original-title="Show">
                                    Parent Id Card
                                </a>
                            </div>
                        </div>

                    </div>                   
                </div>
            </div>
            <div class="modal-footer">&nbsp;</div>
        </div>
    </div>
</div>
<div class="modal fade" id="studentblankcertificate" role="dialog">
    <div class="modal-dialog" style="width:80%;">       
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title title text-center modal_title"></h4>
            </div>
            <div class="modal-body">
                <div class="form-horizontal">
                    <div class="box-body">
                        <div class="cert-preview-section"></div>
                        <div class="row">
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-primary btn-sm btn-block leav-cert11 getCertificatewithoutheaderPreviewdetail" data-stdid="" data-certtype="leaving" data-toggle="tooltip" title="Print Leaving Certificate" data-original-title="Show">
                                    Leaving Certificate
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-warning btn-sm btn-block bona-cert11 getCertificatewithoutheaderPreviewdetail" data-stdid="" data-certtype="bonafide" data-toggle="tooltip" title="Print Bonafied Certificate" data-original-title="Show">
                                    Bonafied Certificate
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-success btn-sm entry-cert11 btn-block getCertificatewithoutheaderPreviewdetail" data-stdid="" data-certtype="entry" data-toggle="tooltip" title="Print Entry Certificate" data-original-title="Show">
                                    Entry Certificate
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-sm adm-form-cert11 btn-block getCertificatewithoutheaderPreviewdetail" data-stdid="" data-certtype="admissionform" data-toggle="tooltip" title="Print Addmission Form" data-original-title="Show" style="background-color: #0578a7;border-color: #16baf3;color: #fff;">
                                    Admission Form
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-danger btn-sm stdid-card-cert11 btn-block getCertificatewithoutheaderPreviewdetail" data-stdid="" data-certtype="studentidcard" data-idtype="verticle" data-toggle="tooltip" title="Print Student Id Card" data-original-title="Show">
                                    Student ID (Verticle)
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-danger btn-sm stdid-card-cert11 btn-block getCertificatewithoutheaderPreviewdetail" data-stdid="" data-certtype="studentidcard" data-idtype="horizontal" data-toggle="tooltip" title="Print Student Id Card" data-original-title="Show">
                                    Student ID (Horizontal)
                                </a>
                            </div>
                            <div class="col-sm-2 col-xs-12 margin-bottom">
                                <a href="javascript:void(0);" class="btn btn-flickr btn-sm parid-card-cert11 btn-block getCertificatewithoutheaderPreviewdetail" data-stdid="" data-certtype="parentidcard" data-toggle="tooltip" title="Print Parent Id Card" data-original-title="Show">
                                    Parent Id Card
                                </a>
                            </div>
                        </div>

                    </div>                   
                </div>
            </div>
            <div class="modal-footer">&nbsp;</div>
        </div>
    </div>
</div>

<div class="modal fade" id="studentphotoupload" role="dialog">
    <div class="modal-dialog">       
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title title text-center">Upload Student Photo</h4>
            </div>
            <form id="student_photo_upload" method="post" class="ptt10" enctype="multipart/form-data">
                <div class="modal-body pt0 pb0">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="row">
                                <input type="hidden" id="student_photo_id" value="" name="student_photo_id">
                                <input type="hidden" id="image_data" value="" name="image_data">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd">Upload Photo</label>
                                        <!--<input type="file" id="file" name="studentphoto" class="form-control filestyle hide hidden">-->
                                    </div>
                                </div>
                            </div><!--./row-->
                            <!-- cropped photo  -->
                            <div class="row">
                                <div class="col-xs-12">
                                    <label class="cabinet center-block">
                                        <figure>
                                            <img src="" class="gambar img-responsive img-thumbnail" id="item-img-output" style="width:160px;height:180px;" />
                                            <figcaption><i class="fa fa-camera fa-2x"></i></figcaption>
                                        </figure>
                                        <input type="file" class="item-img file center-block" name="file_photo"/>
                                    </label>
                                </div>
                            </div>
                        </div><!--./col-md-12-->
                    </div><!--./row-->
                </div>
                <div class="modal-footer">
                    <div class="pull-right paddA10">
                        <button type="submit" class="btn btn-info pull-right" id="submit" data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please wait" value="">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="cropImagePop" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
                    <?= 'Edit/Crop Photo';//multiLanguage("Edit Foto", "Edit Photo") ?></h4>
            </div>
            <div class="modal-body">
                <div id="upload-demo" class="center-block"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" id="cropImageBtn" class="btn btn-primary" data-student_photo_id="">Crop</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function(){
        // Start upload preview image
       default_img = '../uploads/student_images/personnel_boy.png'; 
       $(".gambar").attr("src", default_img);
       var $uploadCrop,
               tempFilename,
               rawImg,
               imageId;
       function readFile(input) {
           if (input.files && input.files[0]) {
               var reader = new FileReader();
               reader.onload = function (e) {
                   $('.upload-demo').addClass('ready');
                   $('#cropImagePop').modal('show');
                   rawImg = e.target.result;
               }
               reader.readAsDataURL(input.files[0]);
           } else {
               swal("Sorry - you're browser doesn't support the FileReader API");
           }
       }

       $uploadCrop = $('#upload-demo').croppie({
           viewport: {
//                    width: 400,
//                    height: 100,
               width: 160,
               height: 180,
           },
           enforceBoundary: false,
           enableExif: true
       });
       $('#cropImagePop').on('shown.bs.modal', function () {
           // alert('Shown pop');
           $uploadCrop.croppie('bind', {
               url: rawImg
           }).then(function () {
               console.log('jQuery bind complete');
           });
       });

       $('.item-img').on('change', function () {
           imageId = $(this).data('id');
           tempFilename = $(this).val();
           $('#cancelCropBtn').data('id', imageId);
           readFile(this);
       });
       $('#cropImageBtn').on('click', function (ev) {
           $uploadCrop.croppie('result', {
               type: 'base64',
               format: 'jpeg',
//                    size: {width: 1680, height: 435}
               size: {width: 160, height: 180}
           }).then(function (resp) {
                var base64data = resp;
                $("#image_data").val(resp);
                $('#item-img-output').attr('src', resp);
                $('#cropImagePop').modal('hide');
                /**            
                $.ajax({
                       url:'',
//                          url: base_url + "/student/upload_student_photo",
                       method:'POST',
                       data:{image_data:base64data, student_photo_id : student_photo_id},
                       success:function(data)
                       {
                           $("#image_data").val(resp);
                           $('#item-img-output').attr('src', resp);
                           $('#cropImagePop').modal('hide');
                       },
                       error: function(xhr, status, error) {
                           console.error('Error occured while uploading image: ', error);
                       }
                });
                **/

           });
       });
       // End upload preview image
    });

</script>

<script type="text/javascript">

function getSectionByClass(class_id, section_id) {
    if (class_id != "" && section_id != "") {
        $('#section_id').html("");
        var base_url = '<?php echo base_url() ?>';
        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
        $.ajax({
            type: "GET",
            url: base_url + "sections/getByClass",
            data: {'class_id': class_id},
            dataType: "json",
            success: function (data) {
                $.each(data, function (i, obj)
                {
                    var sel = "";
                    if (section_id == obj.section_id) {
                        sel = "selected";
                    }
                    div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                });
                $('#section_id').append(div_data);
            }
        });
    }
}

$(document).ready(function () {
    var class_id = $('#class_id').val();
    var section_id = '<?php echo set_value('section_id') ?>';
    getSectionByClass(class_id, section_id);
    $(document).on('change', '#class_id', function (e) {
        $('#section_id').html("");
        var class_id = $(this).val();
        var base_url = '<?php echo base_url() ?>';
        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
        $.ajax({
            type: "GET",
            url: base_url + "sections/getByClass",
            data: {'class_id': class_id},
            dataType: "json",
            success: function (data) {
                $.each(data, function (i, obj)
                {
                    div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                });
                $('#section_id').append(div_data);
            }
        });
    });
});
</script>

 <script>
$(document).ready(function() {
     emptyDatatable('student-list','data');
});
</script>

<script type="text/javascript">
$(document).ready(function(){

$("form.class_search_form button[type=submit]").click(function() {
    $("button[type=submit]", $(this).parents("form")).removeAttr("clicked");
    $(this).attr("clicked", "true");
});

$(document).on('submit','.class_search_form',function(e){
   e.preventDefault(); // avoid to execute the actual submit of the form.
    var $this = $("button[type=submit][clicked=true]");
    var form = $(this);
    var url = form.attr('action');
    var form_data = form.serializeArray();
    form_data.push({name: 'search_type', value: $this.attr('value')});
    $.ajax({
           url: url,
           type: "POST",
           dataType:'JSON',
           data: form_data, // serializes the form's elements.
              beforeSend: function () {
                $('[id^=error]').html("");
                $this.button('loading');
                resetFields($this.attr('value'));
               },
              success: function(response) { // your success handler

                if(!response.status){
                    $.each(response.error, function(key, value) {
                    $('#error_' + key).html(value);
                    });
                }else{        

        if ($.fn.DataTable.isDataTable('.student-list')) { // if exist datatable it will destrory first
         $('.student-list').DataTable().destroy();
       }
        table= $('.student-list').DataTable({
        
        dom: 'Bfrtip',
          buttons: [
            {
                extend:    'copy',
                text:      '<i class="fa fa-files-o"></i>',
                titleAttr: 'Copy',
                 className: "btn-copy",
                title: $('.student-list').data("exportTitle"),
                  exportOptions: {
                    columns: ["thead th:not(.noExport)"]
                  }
            },
            {
                extend:    'excel',
                text:      '<i class="fa fa-file-excel-o"></i>',
                titleAttr: 'Excel',
                     className: "btn-excel",
                title: $('.student-list').data("exportTitle"),
                  exportOptions: {
                    columns: ["thead th:not(.noExport)"]
                  }
            },
            {
                extend:    'csv',
                text:      '<i class="fa fa-file-text-o"></i>',
                titleAttr: 'CSV',
                className: "btn-csv",
                title: $('.student-list').data("exportTitle"),
                  exportOptions: {
                    columns: ["thead th:not(.noExport)"]
                  }
            },
            {
                extend:    'pdf',
                text:      '<i class="fa fa-file-pdf-o"></i>',
                titleAttr: 'PDF',
                className: "btn-pdf",
                title: $('.student-list').data("exportTitle"),
                  exportOptions: {
                    columns: ["thead th:not(.noExport)"]
                  },

            },
            {
                extend:    'print',
                text:      '<i class="fa fa-print"></i>',
                titleAttr: 'Print',
                className: "btn-print",
                title: $('.student-list').data("exportTitle"),
                customize: function ( win ) {

                    $(win.document.body).find('th').addClass('display').css('text-align', 'center');
                    $(win.document.body).find('table').addClass('display').css('font-size', '14px');     
                    $(win.document.body).find('h1').css('text-align', 'center');
                },
                exportOptions: {
                    columns: ["thead th:not(.noExport)"]

                  }

            },

                {
                    extend: 'colvis',
                    text: '<i class="fa fa-columns"></i>',
                    titleAttr: 'Columns',
                    title: $('.download_label').html(),
                    postfixButtons: ['colvisRestore']
                },
        ],

        "columnDefs": [ {
        "targets": -1,
        "orderable": false
        } ],


           "language": {
            processing: '<i class="fa fa-spinner fa-spin fa-1x fa-fw"></i><span class="sr-only">Loading...</span> '},
        "pageLength": 100,
        "processing": true,
        "serverSide": true,
        "ajax":{
        "url": baseurl+"student/dtstudentlistforattendence",
        "dataSrc": 'data',
        "type": "POST",
        'data': response.params,

     },"drawCallback": function(settings) {

    $('.detail_view_tab').html("").html(settings.json.student_detail_view);
}

    });
            //=======================
                }
              },
             error: function() { // your error handler
                 $this.button('reset');
             },
             complete: function() {
             $this.button('reset');
             }
         });

});

    });
    function resetFields(search_type){

        if(search_type == "search_full"){
            $('#class_id').prop('selectedIndex',0);
            $('#section_id').find('option').not(':first').remove();
        }else if (search_type == "search_filter") {

             $('#search_text').val("");
        }
    }
</script>
<script type="text/javascript">
$(document).ready(function() {
    $(document).on('click', '.show-certificate-modal', function (e) {
        var linkurl = $(this).data('url');
        var stdid = $(this).data('stdid');
        $('.leav-cert').attr('href', linkurl + '/leaving_certificate/' + stdid);
        $('.leav-cert11').attr('data-stdid', stdid);
        $('.bona-cert').attr('href', linkurl + '/bonafied_certificate/' + stdid);
        $('.bona-cert11').attr('data-stdid', stdid);
        $('.entry-cert').attr('href', linkurl + '/entry_certificate/' + stdid);
        $('.entry-cert11').attr('data-stdid', stdid);
        $('.adm-form-cert').attr('href', linkurl + '/admission_form/' + stdid);
        $('.adm-form-cert11').attr('data-stdid', stdid);
        $('.stdid-card-cert').attr('href', linkurl + '/student_id_card/' + stdid);
        $('.stdid-card-cert11').attr('data-stdid', stdid);
        $('.parid-card-cert').attr('href', linkurl + '/parent_id_card/' + stdid);
        $('.parid-card-cert11').attr('data-stdid', stdid);
        $('.sibling_msg').html("");
        $('.cert-preview-section').html("");
        $('#studentcertificate .modal_title').html('<b><i class="fa fa-certificate"></i>&nbsp;&nbsp;' + "Print Certificates" + '</b>');
        $('#studentcertificate').modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });
    });
    $(document).on('click', '.show-blank_certificate-modal', function (e) {
        var linkurl = $(this).data('url');
        var stdid = $(this).data('stdid');
        $('.leav-cert').attr('href', linkurl + '/leaving_certificate_withoutheader/' + stdid);
        $('.leav-cert11').attr('data-stdid', stdid);
        $('.bona-cert').attr('href', linkurl + '/bonafied_certificate/' + stdid);
        $('.bona-cert11').attr('data-stdid', stdid);
        $('.entry-cert').attr('href', linkurl + '/entry_certificate/' + stdid);
        $('.entry-cert11').attr('data-stdid', stdid);
        $('.adm-form-cert').attr('href', linkurl + '/admission_form/' + stdid);
        $('.adm-form-cert11').attr('data-stdid', stdid);
        $('.stdid-card-cert').attr('href', linkurl + '/student_id_card/' + stdid);
        $('.stdid-card-cert11').attr('data-stdid', stdid);
        $('.parid-card-cert').attr('href', linkurl + '/parent_id_card/' + stdid);
        $('.parid-card-cert11').attr('data-stdid', stdid);
        $('.sibling_msg').html("");
        $('.cert-preview-section').html("");
        $('#studentblankcertificate .modal_title').html('<b><i class="fa fa-certificate"></i>&nbsp;&nbsp;' + "Print Certificates" + '</b>');
        $('#studentblankcertificate').modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });
    });
    $(document).on('click', '.clear-print-preview-content', function () {
        $('.cert-preview-section').html('');
    });
    $(document).on('click', '.getCertificatePreviewdetail', function () {
        var certType = $(this).data('certtype');
        var idType = $(this).data('idtype');
        $('.modal-title_logindetail').html("");
        $('.modal-title_logindetail').html("Print Preview");
        var base_url = '<?php echo base_url() ?>';
        //var student_id = '<?php //echo $student["id"] ?>';
//                                                                var student_id = $(this).data('stdid');
        var student_id = $(this).attr('data-stdid');
        var student_first_name = '<?php //echo $student["firstname"] ?>';
        var student_last_name = '<?php //echo $student["lastname"] ?>';
        $.ajax({
            type: "post",
            url: base_url + "student/getCertificatePreviewdetail/" + student_id,
            data: {'student_id': student_id, 'certType': certType, 'idcard_type': idType},
            dataType: "json",
            success: function (response) {
                $('.cert-preview-section').html(response.data);
                if (certType == 'admissionform') {
                    $('#studentcertificate .modal-dialog').css('width', '100%');
                } else {
                    $('#studentcertificate .modal-dialog').css('width', '80%');
                }
                //$('.modal-body_logindetail').html(response.data);
                //$("#scheduleModal").modal('show');
            }
        });
    });
});    
</script>
<script>
$(document).ready(function() {    
    $(document).on('click', '.preview-confirm-print', function (e) {
        e.preventDefault();
        var serial_no = $('#serial_number').val();
        var std_fullname = ($('#std_fullname').length && $('#std_fullname').val() !== '') ? $('#std_fullname').val().trim() : '';
        //window.open($(this).data('href') + '/' + serial_no + '/' + std_fullname, '_blank');
        window.open($(this).data('href') + '/' + serial_no, '_blank');
    });
    
    
    $(document).on('click','#download-id-card', function(){
        var idname = $(this).data('idname');
        html2canvas(document.querySelector('#id-card-preview')).then(function(canvas) {
            console.log(canvas);
            saveAs(canvas.toDataURL('image/jpeg',0.9), idname+'.jpeg');
        });
    });

    function saveAs(uri, filename) {

        var link = document.createElement('a');

        if (typeof link.download === 'string') {

            link.href = uri;
            link.download = filename;

            //Firefox requires the link to be in the body
            document.body.appendChild(link);

            //simulate click
            link.click();

            //remove the link when done
            document.body.removeChild(link);

        } else {

            window.open(uri);

        }
    }
    
    $(document).on('click', '.show-uploadphoto-modal', function (e) {
        var stdname = $(this).data('name');
        var stdid = $(this).data('stdid');
        $('#student_photo_id').val(stdid);
        $('#studentphotoupload .modal-title').html(stdname);
        $('#studentphotoupload').modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });
    });
    $("#student_photo_upload").on('submit', (function (e) {
        e.preventDefault();
        var $this = $(this).find("button[type=submit]:focus");
        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + "/student/upload_student_photo",
            type: "POST",
            data: new FormData(this),
            dataType: 'json',
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $this.button('loading');
            },
            success: function (res)
            {
                if (res.status == "fail") {
                    var message = "";
                    $.each(res.error, function (index, value) {
                        message += value;
                    });
                    errorMsg(message);
                } else {
                    successMsg(res.message);
                    $('#studentphotoupload').modal('hide');
                    //window.location.reload(true);
                }
            },
            error: function (xhr) { // if error occured
                alert("Error occured.please try again");
                $this.button('reset');
            },
            complete: function () {
                $this.button('reset');
            }
        });
    }));
    
    
});
</script>
detail_view_tab
<script type="text/javascript">
    
    $(document).on('click', '.print_student_details', function() {
    let $button_ = $(this);
    var student_id = $(this).attr('data-student_id');
    var admission_no = $(this).attr('data-admission_no');
    var student_name = $(this).attr('data-student_name');
    $.ajax({
        type: 'POST',
        url: baseurl + 'student/printStudentDetails',  // Assuming baseurl is defined elsewhere
        data: {'student_id':student_id},  // Add any data you need to send here
         
        beforeSend: function() {
            $button_.button('loading');  // Change button state to loading
        },
        xhr: function() {
            var xhr = new XMLHttpRequest();  // Fixed the typo here
            xhr.responseType = 'blob';  // Set response type to blob
            return xhr;
        },
        success: function(data, jqXHR, response) {
            // Create a Blob with the response data (PDF)
            var blob = new Blob([data], {type: 'application/pdf'});

            // Create an anchor element to trigger the file download
            var link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = student_name + '_' + admission_no + '.pdf';  // Assumes student_name and admission_no are defined
            document.body.appendChild(link);  // Append to body to trigger download
            link.click();
            document.body.removeChild(link);  // Clean up by removing the link

            $button_.button('reset');  // Reset the button to its original state
        },
        error: function(xhr, status, error) {
            // If an error occurs, reset the button
            console.error("Error occurred:", status, error);  // You can log errors for debugging
            $button_.button('reset');
        },
        complete: function() {
            // Reset the button regardless of success or failure
            $button_.button('reset');
        }
    });

    
});

    $(document).on('click', '.getCertificatewithoutheaderPreviewdetail', function () {
        var certType = $(this).data('certtype');
        var idType = $(this).data('idtype');
        $('.modal-title_logindetail').html("");
        $('.modal-title_logindetail').html("Print Preview");
        var base_url = '<?php echo base_url() ?>';
        //var student_id = '<?php //echo $student["id"] ?>';

        var student_id = $(this).attr('data-stdid');
        var student_first_name = '<?php //echo $student["firstname"] ?>';
        var student_last_name = '<?php //echo $student["lastname"] ?>';
        $.ajax({
            type: "post",
            url: base_url + "student/getCertificatePreviewdetailwithoutHeader/" + student_id,
            data: {'student_id': student_id, 'certType': certType, 'idcard_type': idType},
            dataType: "json",
            success: function (response) {
                //alert(response.data);
                $('.cert-preview-section').html(response.data);
                if (certType == 'admissionform') {
                    $('#studentblankcertificate .modal-dialog').css('width', '100%');
                } else {
                    $('#studentblankcertificate .modal-dialog').css('width', '80%');
                }
                //$('.modal-body_logindetail').html(response.data);
                //$("#scheduleModal").modal('show');
            }
        });
    });
</script>