<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>EXIT CERTIFICATE</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
      background-color: #f5f5f5;
    }

    .certificate-container {
      background: white;
      width: 210mm;
      height: 297mm;
      margin: auto;
      padding: 20mm 15mm;
      box-sizing: border-box;
      border-radius: 8px;
      box-shadow: 0 0 8px rgba(0, 0, 0, 0.15);
      position: relative;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }

    .header {
      text-align: center;
      margin-bottom: 12px;
    }

    .logo-title {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 12px;
      margin-bottom: 5px;
    }

    .logo-title img {
      height: 65px;
      width: auto;
    }

    .logo-title h2 {
      color: red;
      margin: 0;
      font-size: 22px;
    }

    .header h4,
    .header h3 {
      margin: 2px 0;
      font-size: 14px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 10px;
    }

    td {
      padding: 6px 4px;
      font-size: 13.5px;
      vertical-align: top;
      line-height: 1.4;
    }

    input[type="text"],
    input[type="date"] {
      width: 100%;
      font-size: 13.5px;
      border: none;
      border-bottom: 1px solid #000;
      background: transparent;
      padding: 2px 0;
      margin: 0;
      outline: none;
    }

    .row {
      display: flex;
      gap: 4px;
    }

    .row .col {
      flex: 1;
    }

    .text-center {
      text-align: center;
    }

    button {
      padding: 8px 18px;
      margin-top: 15px;
      border: none;
      border-radius: 4px;
      color: white;
      background-color: #007bff;
      font-size: 14px;
      cursor: pointer;
    }

    .footer-section {
      margin-top: auto;
    }

    /* Print Styles */
    @media print {
      body {
        background: white;
      }

      .certificate-container {
        width: 100%;
        height: auto;
        box-shadow: none;
        border-radius: 0;
        padding: 10mm;
        margin: 0;
      }

      input {
        display: none;
      }

      button {
        display: none;
      }

      .print-span {
        display: inline !important;
        font-size: 13.5px;
      }

      @page {
        size: A4;
        margin: 10mm;
      }

      table {
        margin-bottom: 6px;
      }

      td {
        padding: 4px 4px;
      }
    }
  </style>
</head>
<body>
  <div class="certificate-container">
    <div>
      <div class="header">
        <div class="logo-title">
          <img src="https://finalschool710.dolittletech.co.in/uploads/school_content/logo/cert-1.jpg" alt="School Logo">
          <h2>BASWANAPPA WALE NEW ENGLISH MEDIUM SCHOOL</h2>
        </div>
        <h4>Sambhaji Nagar, Khedgaon Road, Latur | Email: waleschool@gmail.com</h4>
        <h3 style="color:red;">EXIT CERTIFICATE</h3>
      </div>

      <form id="certificateForm">
        <table>
          <tr>
            <td>General Register No.:</td>
            <td>GR123456</td>
          </tr>
          <tr>
            <td>School Recognition No.:</td>
            <td>NAMASHA 2009/(152/09)/Secondary-1</td>
            <td>Medium:</td>
            <td>English</td>
          </tr>
          <tr>
            <td>UDISE No.:</td>
            <td colspan="3">27280700148</td>
          </tr>
        </table>

        <table>
          <tr><td>Register Number:</td><td><input type="text" name="register_no" value="<?= htmlspecialchars($student->register_no) ?>" readonly></td></tr>
          <tr>
            <td>Full Name of Student:</td>
            <td>
              <div class="row">
                <div class="col"><input type="text" name="first_name" value="<?= $student->first_name ?>" readonly></div>
                <div class="col"><input type="text" name="father_name" value="<?= $student->father_name ?>" readonly></div>
                <div class="col"><input type="text" name="last_name" value="<?= $student->last_name ?>" readonly></div>
              </div>
            </td>
          </tr>
          <tr><td>Mother Tongue:</td><td><input type="text" name="mother_tongue" value="<?= $student->mother_tongue ?>" readonly></td></tr>
          <tr><td>Religion:</td><td><input type="text" name="religion" value="<?= $student->religion ?>" readonly></td></tr>
          <tr><td>Caste:</td><td><input type="text" name="caste" value="<?= $student->caste ?>" readonly></td></tr>
          <tr><td>Place of Birth:</td><td><input type="text" name="place_of_birth" value="<?= $student->place_of_birth ?>" readonly></td></tr>
          <tr><td>Date of Birth:</td><td><input type="text" name="dob" value="<?= $student->dob ?>" readonly></td></tr>
          <tr><td>Name of Previous School and Standard:</td><td><input type="text" name="prev_school_name" value="<?= $student->prev_school_name ?>" readonly></td></tr>
          <tr><td>Date of Admission in this School:</td><td><input type="text" name="admission_date" value="<?= $student->admission_date ?>" readonly></td></tr>
          <tr><td>Standard & Class Into which admitted:</td><td><input type="text" name="admitted_class" value="<?= $student->admitted_class ?>" readonly></td></tr>
          <tr><td>Progress:</td><td><input type="text" name="academic_preference" value="<?= $student->admitted_class ?>" readonly></td></tr>
          <tr><td>Conduct:</td><td><input type="text" name="academic_conduct" value="<?= $student->academic_conduct ?>" readonly></td></tr>
          <tr><td>Date of Leaving School:</td><td><input type="text" name="date_of_leaving" value="<?= $student->date_of_leaving ?>" readonly></td></tr>
          <tr><td>Standard and Class from which left:</td><td><input type="text" name="left_class" value="<?= $student->left_class ?>" readonly></td></tr>
          <tr><td>Remark:</td><td><input type="text" name="remark" value="<?= $student->remark ?>" readonly></td></tr>
        </table>
      </form>
    </div>

    <div class="footer-section">
      <table>
        <tr>
          <td style="text-align: left; padding-top: 20px;">Date: <?= date('d-m-Y'); ?></td>
          <td style="text-align: right; padding-top: 20px;">Clerk Signature</td>
          <td style="text-align: right; padding-top: 20px;">Principal Signature</td>
        </tr>
      </table>

      <div class="text-center">
        <button type="button" onclick="handlePrint()">Print Certificate</button>
      </div>
    </div>
  </div>

  <script>
    function handlePrint() {
      const inputs = document.querySelectorAll('input[type="text"], input[type="date"]');
      inputs.forEach(input => {
        const span = document.createElement('span');
        span.className = 'print-span';
        span.textContent = input.type === 'date' && input.value
          ? new Date(input.value).toLocaleDateString('en-GB')
          : input.value;
        input.parentNode.insertBefore(span, input.nextSibling);
        input.style.display = 'none';
      });

      window.print();

      window.onafterprint = () => {
        inputs.forEach(input => {
          input.style.display = '';
          const next = input.nextSibling;
          if (next && next.className === 'print-span') {
            next.remove();
          }
        });
      };
    }
  </script>
</body>
</html>
