<div class="content-wrapper" style="min-height: 946px;">
    <section class="content-header">
        <h1>
            <i class="fa fa-user-plus"></i> <?php echo $this->lang->line('student_information'); ?> 
            <small><?php echo $this->lang->line('class1'); ?></small>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">

            <h3 class="text-center" style="margin-bottom: 20px; font-weight: bold;">
                Today's Certificate Counts (<?= date('d-m-Y') ?>)
            </h3>

            <!-- Info boxes -->
            <div class="row">
                <div class="col-md-4">
                    <div class="info-box bg-aqua">
                        <span class="info-box-icon"><i class="fa fa-certificate"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Leaving Certificate</span>
                            <span class="info-box-number"><?= $leaving_count ?? 0 ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="info-box bg-green">
                        <span class="info-box-icon"><i class="fa fa-certificate"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Bonafide Certificate</span>
                            <span class="info-box-number"><?= $bonafide_count ?? 0 ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="info-box bg-yellow">
                        <span class="info-box-icon"><i class="fa fa-certificate"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Entry Certificate</span>
                            <span class="info-box-number"><?= $entry_count ?? 0 ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filter Form -->
            <div class="box box-primary">
                <div class="box-header ptbnull">
                    <h3 class="box-title titlefix">Certificate Counts List</h3>
                </div>
                <div class="box-body">

                    <!-- Filter form -->
                    <form class="form-inline" style="margin-bottom:15px;">
                        <div class="form-group">
                            <label for="from_date">From Date:</label>
                            <input type="text" class="form-control datepicker" id="from_date" placeholder="dd-mm-yyyy">
                        </div>
                        <div class="form-group" style="margin-left:10px;">
                            <label for="to_date">To Date:</label>
                            <input type="text" class="form-control datepicker" id="to_date" placeholder="dd-mm-yyyy">
                        </div>
                        <button type="button" id="btnFilter" class="btn btn-primary" style="margin-left:10px;">Filter</button>
                        <button type="button" id="btnReset" class="btn btn-default" style="margin-left:5px;">Reset</button>
                    </form>

                    <div class="table-responsive mailbox-messages">
                        <table class="table table-striped table-bordered table-hover" id="certificateTable">
                            <thead>
                                <tr>
                                    <th>Sr No.</th>
                                    <th>Admission No</th>
                                    <th>Student Name</th>
                                    <th>Class</th>
                                    <th>Gender</th>
                                    <th>Date</th>
                                    <th>Certificate</th>
                                    <th>Staff Name</th>
                                    <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php 
                            if (!empty($certificatecounts)) { 
                                $sr = 1;
                                foreach ($certificatecounts as $req) { ?>
                                    <tr>
                                        <td><?= $sr++ ?></td>
                                        <td><?= htmlspecialchars($req->admission_no) ?></td>
                                        <td><?= htmlspecialchars($req->firstname . ' ' . $req->father_name . ' ' . $req->lastname) ?></td>
                                        <td><?= htmlspecialchars($req->class_name . ' (' . $req->section_name . ')') ?></td>
                                        <td><?= htmlspecialchars($req->gender) ?></td>
                                        <td><?= date("d-m-Y", strtotime($req->created_at)) ?></td>
                                        <td><?= htmlspecialchars($req->certificate) ?></td>
                                        <td><?= htmlspecialchars($req->staff_name) ?></td>
                                        <td class="text-right">
                                            <a href="<?= base_url('student/view/' . $req->student_id) ?>" class="btn btn-primary btn-sm">View</a>
                                        </td>
                                    </tr>
                            <?php } 
                            } else { ?>
                                <tr>
                                    <td colspan="9" class="text-center">No data available</td>
                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> 
    </section>
</div>

<!-- JS -->
<script type="text/javascript">
$(document).ready(function () {

    // Init datepicker
    $(".datepicker").datepicker({
        format: "dd-mm-yyyy",
        autoclose: true,
        todayHighlight: true
    });

    // Init DataTable
    var table = $('#certificateTable').DataTable();

    // Custom filter function for date range
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
        var min = $('#from_date').val();
        var max = $('#to_date').val();
        var dateCol = data[5]; // index of "Date" column

        if (!dateCol) return true;

        // Parse dateCol string "dd-mm-yyyy"
        var parts = dateCol.split("-");
        var d = new Date(parts[2], parts[1]-1, parts[0]);

        var start = min ? new Date(min.split("-")[2], min.split("-")[1]-1, min.split("-")[0]) : null;
        var end   = max ? new Date(max.split("-")[2], max.split("-")[1]-1, max.split("-")[0]) : null;

        if ((start === null && end === null) ||
            (start === null && d <= end) ||
            (end === null && d >= start) ||
            (d >= start && d <= end)) {
            return true;
        }
        return false;
    });

    // Filter button
    $('#btnFilter').on('click', function() {
        table.draw();
    });

    // Reset button
    $('#btnReset').on('click', function() {
        $('#from_date').val('');
        $('#to_date').val('');
        table.draw();
    });
});
</script>
