<link href="<?php echo base_url(); ?>backend/dist/css/token-input.css" rel="stylesheet">
<script src="<?php echo base_url(); ?>backend/dist/js/jquery.tokeninput.js"></script>
<script src="<?php echo base_url(); ?>backend/dist/js/bootstrap-multiselect.js"></script>
<div class="content-wrapper" style="min-height: 946px;">
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> Online Meeting App Setup<small><?php echo $this->lang->line('setting1'); ?></small>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                <?php if ($this->rbac->hasPrivilege('manage_meeting', 'can_add')) : ?>
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Create Online Meeting</h3>
                    </div><!-- /.box-header -->
                    <form role="form" id="zoom_meeting_setup" id="zoom_meeting_setup" action="<?php echo site_url('smsconfig/addmeeting') ?>" class="form-horizontal111" method="post">
                        <div class="box-body">
                            <div class="form-group">
                                <label for="exampleInputEmail1">Meeting App<small class="req required"> *</small></label>
                                <select autofocus="" id="meet_type" name="meet_type" class="form-control" required="" autocomplete="off">
                                    <option value="">Select</option>
                                    <option value="zoom">ZOOM App</option>
                                    <option value="google_hangout">Google Hangout/Google Meet App</option>
                                    <option value="microsoft_team">Microsoft Teams App</option>
                                </select>
                            </div>
                            <?php
//                                                $custom_result = check_in_array('custom', $smslist);
                            //$zoom = check_in_array('zoom', $smslist);
                            ?>
                            <div class="form-group">
                                <label class=""><?php echo 'Meeting Title'; ?><small class="req"> *</small>
                                </label>
                                <input type="text" class="form-control" id="name" name="name" required="" value="">
                                <span class="text text-danger name_error"></span>

                            </div>
                            <div class="form-group">
                                <label class=""><?php echo 'Meeting Date'; ?><small class="req"> *</small></label>
                                <input type="text" class="form-control datepicker date input-datepicker" name="meetdate" id="meetdate" required="" value="">

                            </div>
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="intime">From Time</label>
                                        <div class="bootstrap-timepicker">
                                            <div class="form-group1">
                                                <div class="input-group">
                                                    <input type="text" name="fromtime" class="form-control timepicker" id="fromtime" value="">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-clock-o"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="intime">To Time</label>
                                        <div class="bootstrap-timepicker">
                                            <div class="form-group1">
                                                <div class="input-group">
                                                    <input type="text" name="totime" class="form-control timepicker" id="totime" value="">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-clock-o"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class=""><?php echo 'Meeting ID'; ?>
                                </label>
                                <input type="text" class="form-control" id="senderid" name="senderid" value="">

                            </div>
                            <div class="form-group">
                                <label class=""><?php echo 'Passcode/Password'; ?></label>
                                <input type="text" class="form-control" id="authkey" name="authkey" value="">

                            </div>
                            <div class="form-group">
                                <label class=""><?php echo 'Meeting URL/Link'; ?><small class="req"> *</small></label>
                                <textarea class="form-control" id="url" name="url" required=""></textarea>

                            </div>
                            <div class="form-group">
                                <label class=""><?php echo 'Meeting Description'; ?></label>
                                <textarea class="form-control" id="note" name="note"></textarea>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Meeting Attendee/Participant<small class="req"> *</small></label>
                                <select autofocus="" id="meet_attendee" name="meet_attendee" class="form-control" required="" autocomplete="off">
                                    <option value="">Select</option>
                                    <option value="staff">Staff</option>
                                    <option value="student">Student</option>
                                </select>
                            </div>
                            <div class="form-group student-div col-sm-6 hidden">
                                <label for="exampleInputEmail1">Student Class</label>
                                <select  id="std_class_id" name="std_class_id" class="form-control"  >
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php
                                    $count=0;
                                    foreach ($classlist as $class)
                                    {
                                        ?>
                                        <option value="<?php echo $class['id'] ?>"><?php echo $class['class'] ?></option>
                                        <?php
                                        $count++;
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group student-div col-sm-6 hidden">
                                <label for="exampleInputEmail1">Student Section</label>
                                <select autofocus="" id="section_id" name="section_id[]" class="multiselect-ui form-control" multiple="multiple" autocomplete="off">
                                    <option value="">Select</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="">Add Excluded Students/Staff Members(Non Attendees)</label>
                                <input type="text" class="form-control" id="meet_excludes" name="meet_excludes" value="">
                            </div>
                            <div class="form-group">
                                <label class=""><?php echo $this->lang->line('status'); ?></label>
                                <select class="form-control" name="custom_status">
                                    <?php
                                    foreach ($statuslist as $s_key => $s_value)
                                    {
                                        ?>
                                        <option value="<?php echo $s_key; ?>"><?php echo $s_value; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                                <span class=" text text-danger clickatell_api_id_error"></span>

                            </div>
                            <button type="submit" class="btn btn-primary pull-right create-meeting-btn" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i> Processing"><?php echo $this->lang->line('save'); ?></button>&nbsp;&nbsp;<span class="custom_loader"></span>

                        </div><!-- /.box-header -->
                    </form>
                </div>
                <?php endif; ?>
            </div>
            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12">
                <?php if ($this->rbac->hasPrivilege('manage_meeting', 'can_view')) : ?>
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix">Online Meeting List</h3>
                        <div class="box-tools pull-right">
                        </div><!-- /.box-tools -->
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <?php echo $this->session->flashdata('msg') ?>
                        <div class="download_label">Online Meeting List</div>
                        <div class="table-responsive mailbox-messages">
                            <table class="table table-hover table-striped table-bordered example">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Meeting App</th>
                                        <th>Title</th>
                                        <th>Meeting Date</th>
                                        <th>Meeting Data</th>
                                        <th>Meeting Attendee</th>
                                        <th>Status</th>
                                        <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    if (empty($smslist))
                                    {
                                        ?>

                                        <?php
                                    }
                                    else
                                    {
                                        $cnt = 1;
                                        foreach ($smslist as $key => $value)
                                        {
                                            // print_r($value);
                                            ?>
                                            <tr>
                                                <td class="mailbox-name"><?php echo $cnt++; ?></td>
                                                <td class="mailbox-name"><?php echo $value->type; ?></td>
                                                <td class="mailbox-name">
                                                    <a href="#" data-toggle="popover" class="detail_popover"><?php echo $value->name; ?></a>

                                                    <div class="fee_detail_popover" style="display: none">
                                                        <?php
                                                        if ($value->note == "")
                                                        {
                                                            ?>
                                                            <p class="text text-danger"><?php echo $this->lang->line('no_description'); ?></p>
                                                            <?php
                                                        }
                                                        else
                                                        {
                                                            ?>
                                                            <p class="text text-info"><?php echo $value->note; ?></p>
                                                            <?php
                                                        }
                                                        ?>
                                                    </div>
                                                </td>
                                                <td class="mailbox-name">
                                                    <?php echo valid($value->meetdate) ? date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($value->meetdate)) : ''; ?>
                                                    <?php
                                                    $meettmfrm = '';
                                                    $meettmto = '';
                                                    if (isset($value->meettime) && valid($value->meettime)) :
                                                        $mtime = explode('-', $value->meettime);
                                                        if (isset($mtime[0]) && $mtime[0] != 'null')
                                                        {
                                                            $meettmfrm = trim($mtime[0]);
                                                        }
                                                        if (isset($mtime[1]) && $mtime[1] != 'null')
                                                        {
                                                            $meettmto = trim($mtime[1]);
                                                        }
                                                    endif;
                                                    ?><br>
                                                    <small class=""><?= $meettmfrm; ?><?= valid($meettmto) ? ' TO ' . $meettmto : ''; ?></small>
                                                </td>
                                                <td class="mailbox-name"> 
                                                    <?php echo '<small>ID:</small> ' . $value->senderid; ?>
                                                    <?php echo '<br><small>Password:</small> ' . $value->authkey; ?>
                                                    <?php echo '<br><small>Link:</small> ' . $value->url; ?>
                                                </td>
                                                <td class="mailbox-name"> 
                                                    <?php echo $value->meet_attendee; ?>
                                                    <?php
                                                    $clssssec = '';
                                                    if ($value->meet_attendee == 'student')
                                                    {
                                                        $clssssec = getclass_in_array($value->std_class_id, $classlist);
                                                        $secname = '';
                                                        if (valid($value->std_sec_id) && !empty($value->std_sec_id))
                                                        {
                                                            $secs = json_decode($value->std_sec_id, true);
                                                            if (is_array($secs) && !empty($secs))
                                                            {
                                                                foreach ($secs as $secn)
                                                                {
                                                                    $secname = $secname . ',' . getsection_in_array($secn, $sectionlist);
                                                                }
                                                            }
                                                        }
//                                                        $clssssec = $clssssec . ' - ' . getsection_in_array($value->std_sec_id, $sectionlist);
                                                        $clssssec = $clssssec . ' - ' . trim($secname ,',');
                                                        echo '<br>(' . $clssssec . ')';
                                                    }
                                                    ?>
                                                </td>
                                                <td class="mailbox-name"><?php echo ($value->is_active == 'enabled') ? '<a class="btn btn-success btn-xs">Enabled</a>' : '<a class="btn btn-danger btn-xs">Disabled</a>'; ?></td>
                                                <td class="mailbox-date pull-right">
                                                    <a  onclick="getRecord(<?php echo $value->id; ?>)" class="btn btn-default btn-xs" data-target="#visitordetails" data-toggle="modal" data-loading-text="<i class='fa fa-circle-o-notch fa-spin'></i> Processing" data-original-title="View"><i class="fa fa-reorder"></i></a> 
                                                    <a href="<?php echo base_url(); ?>smsconfig/editmeetingsetup/<?php echo $value->id; ?>" class="btn btn-default btn-xs" data-toggle="tooltip" title="" data-original-title="<?php echo $this->lang->line('edit'); ?>">
                                                        <i class="fa fa-pencil"></i>
                                                    </a>
                                                    <a href="<?php echo base_url(); ?>smsconfig/deletemeetingsetup/<?php echo $value->id; ?>" class="btn btn-default btn-xs" data-toggle="tooltip" title="" onclick="return confirm('<?php echo $this->lang->line('delete_confirm') ?>');" data-original-title="Delete">
                                                        <i class="fa fa-remove"></i>
                                                    </a>
                                                </td>

                                            </tr>
                                            <?php
                                        }
                                    }
                                    ?>

                                </tbody>
                            </table><!-- /.table -->
                        </div><!-- /.mail-box-messages -->
                    </div><!-- /.box-body -->
                </div>
                <?php endif; ?>
            </div>

        </div>  
    </section>
</div>
<link rel="stylesheet" href="<?php echo base_url(); ?>backend/plugins/timepicker/bootstrap-timepicker.min.css">
<script src="<?php echo base_url(); ?>backend/plugins/timepicker/bootstrap-timepicker.min.js"></script>
<?php

//echo '<pre>';print_r($sectionlist);exit;
function getclass_in_array($find, $array)
{
    //echo '<pre>';print_r($array);exit;
    if (valid($array) && !empty($array))
    {
        foreach ($array as $element)
        {
            if ($find == $element['id'])
            {
                //echo '<pre>';print_r($element);exit;
                return isset($element['class']) ? $element['class'] : '';
            }
        }
    }
    return '';
}

function getsection_in_array($find, $array)
{
    if (valid($array) && !empty($array))
    {
        foreach ($array as $element)
        {
            if ($find == $element['id'])
            {
                return isset($element['section']) ? $element['section'] : '';
            }
        }
    }
//    $object = new stdClass();
//    $object->section = "";
//    return $object;
    return '';
}

function check_in_array($find, $array)
{

    if (valid($array) && !empty($array))
    {
        foreach ($array as $element)
        {
            if ($find == $element->type)
            {
                return $element;
            }
        }
    }
    $object = new stdClass();
    $object->id = "";
    $object->type = "";
    $object->api_id = "";
    $object->username = "";
    $object->url = "";
    $object->name = "";
    $object->contact = "";
    $object->password = "";
    $object->authkey = "";
    $object->senderid = "";
    $object->meetdate = "";
    $object->meettime = "";
    $object->note = "";
    $object->is_active = "";
    return $object;
}
?>


<script type="text/javascript">
                                                        var img_path = "<?php echo base_url() . '/backend/images/loading.gif' ?>";
                                                        $("#zoom_meeting_setup").submit(function (e) {
                                                            //
                                                             $('.create-meeting-btn').button('loading');
                                                            $("[class$='_error']").html("");
                                                            $(".custom_loader").html('<img src="' + img_path + '">');
                                                            var url = $(this).attr('action'); // the script where you handle the form input.
                                                            $.ajax({
                                                                type: "POST",
                                                                dataType: 'JSON',
                                                                url: url,
                                                                data: $("#zoom_meeting_setup").serialize(), // serializes the form's elements.
                                                                success: function (data, textStatus, jqXHR)
                                                                {
                                                                    if (data.st === 1) {
                                                                        $.each(data.msg, function (key, value) {
                                                                            //$('.' + key + "_error").html(value);
                                                                            errorMsg(value);
                                                                        });
                                                                        $('.create-meeting-btn').button('reset');
                                                                    } else {
                                                                        successMsg(data.msg);
                                                                        $("#zoom_meeting_setup")[0].reset();
                                                                        window.location.reload();
                                                                    }
                                                                    $(".custom_loader").html("");

                                                                },
                                                                error: function (jqXHR, textStatus, errorThrown)
                                                                {
                                                                    $(".custom_loader").html("");
                                                                    //if fails      
                                                                }
                                                            });

                                                            e.preventDefault(); // avoid to execute the actual submit of the form.
                                                        });

                                                        $(document).ready(function () {
                                                            $('.detail_popover').popover({
                                                                placement: 'right',
                                                                trigger: 'hover',
                                                                container: 'body',
                                                                html: true,
                                                                content: function () {
                                                                    return $(this).closest('td').find('.fee_detail_popover').html();
                                                                }
                                                            });
                                                            if ($("#meet_excludes").length)
                                                            {
                                                                //var pincodes = $('#quick-add-form #meet_excludes').data('pincodes');
                                                                var targeturl = '<?php echo base_url(); ?>smsconfig/getmeetingmembers';
                                                                $("#meet_excludes").tokenInput(targeturl, {
                                                                    hintText: "Type to search members...",
                                                                    queryParam: 'search',
                                                                    //queryParam: 'attendee='+$('#meet_attendee').val(),
                                                                    noResultsText: "No result found",
                                                                    method: 'post',
                                                                    searchingText: "Searching...",
                                                                    querySubmit: "search-pincodeset",
                                                                    tokenLimit: null,
                                                                    preventDuplicates: true,
                                                                    onSend: function (param1) {
                                                                        // console.log($(this));
                                                                        // console.log(param1);
                                                                        param1.data.attendee = $('#meet_attendee').val();
                                                                    }
                                                                    //prePopulate: pincodes,
                                                                });
                                                            }
                                                            $('.input-datepicker').datepicker({
                                                                format: "dd-mm-yyyy",
                                                                autoclose: true
                                                            });
                                                            $(".timepicker").timepicker({
                                                                // showInputs: false,
                                                                // defaultTime: false,
                                                                // explicitMode: false,
                                                                // minuteStep: 1
                                                            });
                                                            $('.alert.alert-success').delay(5000).fadeOut('slow');
                                                        });
                                                        $(document).on('change', '#meet_attendee', function () {
                                                            $("#meet_excludes").tokenInput("clear");
                                                            if ($(this).val() == 'student') {
                                                                $('.student-div').removeClass('hidden');
                                                            } else {
                                                                $('.student-div').addClass('hidden');
                                                            }
                                                            //meet_attendee = $(this).val();
                                                        });
                                                        $(document).on('change', '#std_class_id', function (e) {
                                                            $('#section_id').html("");
                                                            var class_id = $(this).val();
                                                            getSectionByClass(class_id, 0);
                                                        });
                                                        function getSectionByClass(class_id, section_id) {

                                                            if (class_id != "") {
                                                                $('#section_id').html("");
                                                                var base_url = '<?php echo base_url() ?>';
                                                                //var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                                                                var div_data = '';
                                                                var url = "<?php
$userdata = $this->customlib->getUserData();
if (($userdata["role_id"] == 2))
{
    echo "getClassTeacherSection";
}
else
{
    echo "getByClass";
}
?>";

                                                                $.ajax({
                                                                    type: "GET",
                                                                    url: base_url + "sections/" + url,
                                                                    data: {'class_id': class_id},
                                                                    dataType: "json",
                                                                    beforeSend: function () {
                                                                        $('#section_id').addClass('dropdownloading');
                                                                    },
                                                                    success: function (data) {
                                                                        $.each(data, function (i, obj)
                                                                        {
                                                                            var sel = "";
                                                                            if (section_id == obj.section_id) {
                                                                                sel = "selected";
                                                                            }
                                                                            div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                                                                        });
                                                                        $('#section_id').append(div_data);
                                                                        $(function() {
                                                                            $('.multiselect-ui').multiselect('rebuild');
                                                                        });
//$('.multiselect-ui').multiselect('refresh');
                                                                    },
                                                                    complete: function () {
                                                                        $('#section_id').removeClass('dropdownloading');
                                                                    }
                                                                });
                                                            }
                                                            else{
                                                                $(function() {
                                                                    $('.multiselect-ui').multiselect('rebuild');
                                                                });
                                                            }
                                                        }
                                                        
$(function() {
    $('.multiselect-ui').multiselect({
        includeSelectAllOption: true
    });
});

</script>


