<?php
$panel_bg = array(
    'zoom' => 'bg-primary',
    'google_hangout' => 'bg-red-active',
    'microsoft_team' => 'bg-purple-active',
);
$panel_title = array(
    'zoom' => 'ZOOM App',
    'google_hangout' => 'Google Hangout/Meet App',
    'microsoft_team' => 'Microsoft Teams App',
);
$title_color = array(
    'zoom' => 'text-info',
    'google_hangout' => 'text-red',
    'microsoft_team' => 'text-purple',
);
$default_url = array(
    'zoom' => 'https://zoom.us/join',
    'google_hangout' => 'https://apps.google.com/meet/',
    'microsoft_team' => 'https://teams.microsoft.com/l/meetup-join',
);
?>
<div class="content-wrapper" style="min-height: 946px;">
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> <?php echo $this->lang->line('join_meeting'); ?><small><?php echo $this->lang->line('setting1'); ?></small>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs pull-right">
                        <li class="active pull-left header"><i class="fa fa-laptop"></i> <?php echo 'Online Meeting Apps'; ?></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab_1">
                            <div class="row">
                                <?php
                                if (valid($smslist) && !empty($smslist))
                                {
                                    foreach ($smslist as $meet)
                                    {
                                        if (valid($meet->meet_excludes) && !empty($meet->meet_excludes))
                                        {
                                            $excludes = explode(',', $meet->meet_excludes);
                                            if (in_array($userid, $excludes))
                                            {
                                                continue;
                                            }
                                        }
                                        if (valid($meet->std_sec_id) && !empty($meet->std_sec_id))
                                        {
                                            $secs = json_decode($meet->std_sec_id, true);
                                            if (!is_array($secs) || !in_array($section_id, $secs))
                                            {
                                                continue;
                                            }
                                        }
                                        ?>
                                        <div class="col-sm-4 col-md-4 col-xs-12 minheight170">
                                            <div class="panel panel-primary">
                                                <div class="panel-heading <?= @$panel_bg[$meet->type] ?>">
                                                    <h3 class="panel-title"><?= @$panel_title[$meet->type] ?></h3>
                                                </div>
                                                <div class="panel-body text-center">
                                                    <i class="fa fa-desktop fa-3x text-center"></i>
                                                    <h4 class="<?= @$title_color[$meet->type] ?>"><?= ucwords(trim($meet->name)) ?></h4>
                                                    <?php echo valid($meet->meetdate) ? '<small>ON</small><h4 class="no-margin">' . date('d M, Y', strtotime(trim($meet->meetdate))) . '</h4>' : ''; ?>
                                                    <?php
                                                    $meettmfrm = '';
                                                    $meettmto = '';
                                                    if (isset($meet->meettime) && valid($meet->meettime)) :
                                                        $mtime = explode('-', $meet->meettime);
                                                        if (isset($mtime[0]) && $mtime[0] != 'null')
                                                        {
                                                            $meettmfrm = trim($mtime[0]);
                                                        }
                                                        if (isset($mtime[1]) && $mtime[1] != 'null')
                                                        {
                                                            $meettmto = trim($mtime[1]);
                                                        }
                                                    endif;
                                                    ?>
                                                    <small class=""><?= $meettmfrm; ?><?= valid($meettmto) ? ' TO ' . $meettmto : ''; ?></small>
                                                    <p class="text-left no-margin"><label class="small no-margin">Meeting ID:&nbsp;&nbsp;</label><?php echo trim($meet->senderid); ?></p>
                                                    <p class="text-left no-margin"><label class="small no-margin">Meeting Passcode/Password:&nbsp;&nbsp;</label><?php echo trim($meet->authkey); ?></p>
                                                    <p class="text-left"><?php echo trim($meet->note); ?></p>
                                                </div>
                                                <div class="panel-footer">
                                                    <?php $currdate = strtotime(date('Y-m-d')); ?>
                                                    <?php if (valid($meet->meetdate) && !empty($meet->meetdate) && strtotime($meet->meetdate) >= $currdate): ?>
                                                        <a href="<?= (valid($meet->url) && !empty($meet->url)) ? $meet->url : @$default_url[$meet->type]; ?>" target="_blank" class="btn btn-lg btn-success btn-block">Join Meeting</a>
                                                    <?php else: ?>
                                                        <a href="#" class="btn btn-lg btn-info btn-block disabled">Disabled/Closed</a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                }
                                else
                                {
                                    ?>
                                    <div class="alert alert-danger">No Meeting Scheduled For You.</div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <!-- /.tab-pane -->
                        <!-- /.tab-pane -->
                    </div>
                    <!-- /.tab-content -->
                </div>
            </div>
        </div>  
    </section>
</div>
<!--<link rel="stylesheet" href="<?php echo base_url(); ?>backend/plugins/timepicker/bootstrap-timepicker.min.css">-->
<!--<script src="<?php echo base_url(); ?>backend/plugins/timepicker/bootstrap-timepicker.min.js"></script>-->
<?php

function check_in_array($find, $array)
{

    if (valid($array) && !empty($array))
    {
        foreach ($array as $element)
        {
            if ($find == $element->type)
            {
                return $element;
            }
        }
    }
    $object = new stdClass();
    $object->id = "";
    $object->type = "";
    $object->api_id = "";
    $object->username = "";
    $object->url = "";
    $object->name = "";
    $object->contact = "";
    $object->password = "";
    $object->authkey = "";
    $object->senderid = "";
    $object->meetdate = "";
    $object->meettime = "";
    $object->note = "";
    $object->is_active = "";
    return $object;
}
?>


<script type="text/javascript">
    var img_path = "<?php echo base_url() . '/backend/images/loading.gif' ?>";
</script>


