
<?php
preg_match('/\d+/', $student['class'], $matches);
$classNumber = isset($matches[0]) ? intval($matches[0]) : 0;

if ($classNumber < 8) {
    $schoolname = $settinglist[0]['sch_name_primary'];
    $UDISENumber = $settinglist[0]['sch_udise_primary'];
} elseif ($classNumber > 10) {
    $schoolname = $settinglist[0]['sch_name_high_secondary'];
    $UDISENumber = $settinglist[0]['sch_udise_high_secondary'];
} else {
    $schoolname = $settinglist[0]['sch_name_secondary'];
    $UDISENumber = $settinglist[0]['sch_udise_secondary'];
}
$schoolrecogno = $settinglist[0]['dise_code'];
?>

<?php
$adm_date = $student['admission_date'];
$month = (int) date('m', strtotime($adm_date));
$year = (int) date('Y', strtotime($adm_date));
$academicYear = ($month >= 6) ? $year . '-' . substr($year + 1, -2) : ($year - 1) . '-' . substr($year, -2);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Study Certificate</title>
</head>
<body style="width: 210mm; height: 297mm; margin: 0 auto; padding: 30px; font-family: sans-serif; border: 1px solid #ccc;">

    <!-- Header with Logo Left + Text Center -->
    <div style="width: 100%; margin-bottom: 10px; overflow: hidden;">
        <div style="float: left; width: 15%; text-align: left;">
            <img src="<?= base_url(); ?>/uploads/school_content/logo/logo/<?= $settinglist[0]['certificate_logo']; ?>" alt="School Logo" style="width: 100px; height: 80px;">
        </div>
        <div style="float: left; width: 85%; text-align: center;">
            <h4 style="margin: 0; font-size: 14px; font-weight: normal;"><?= $settinglist[0]['sch_soc_name']; ?></h4>
            <h2 style="margin: 5px 0; font-size: 22px;"><?php echo $schoolname?></h2>
            <p style="margin: 2px 0; font-size: 14px;">
                <?= $settinglist[0]['address'] ?><br>
                Email: <?= $settinglist[0]['email'] ?>, Phone:<?= $settinglist[0]['phone'] ?>
            </p>
        </div>
        <div style="clear: both;"></div>
    </div>

    <!-- Title -->
    <div style="text-align: center; margin: 20px 0;">
        <span style="border: 2px solid black; padding: 8px 20px; font-size: 18px; font-weight: bold;">
            STUDY CERTIFICATE
        </span>
    </div>

    <!-- Date -->
    <div style="text-align: right; margin: 15px 0; font-size: 14px;">
        Date: 24-09-2025
    </div>

    <!-- Body Content -->
    <div style="font-size: 15px; line-height: 1.8; text-align: justify;">
        <p>
            This is to certify that Master/Miss 
            <span style="font-weight: bold;"><?= ucwords($student['firstname']) ?></span> 
            <span style="font-weight: bold;"><?= ucwords($student['father_name']) ?><?= ucwords($student['lastname']) ?></span> 
            has studied from<?= $student['fillbyoffice_admittedto'] ?>standard to 
            <span style="font-weight: bold;"><?= $student['class'] ?></span> 
            standard in our institution.
        </p>

        <p>
            From academic year 
            <span style="font-weight: bold;"><?= $academicYear ?> To <?= $currentsession ?></span>, 
            the mother tongue of the candidate is 
            ____________________ 
            as per the Admission register of the institution. 
            The above details are true and correct to the best of my knowledge.
        </p>

        <p>Hence Certified.</p>
    </div>

    <!-- Footer (Signature Section) -->
    <div style="margin-top: 80px; width: 100%; font-size: 15px;">
     
        <div style="width: 50%; float: right; text-align: center;">
            <p style="font-weight: bold; margin-bottom: 5px;">Principal Signature</p>
        </div>
        <div style="clear: both;"></div>
    </div>

</body>
</html>
