<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Study Certificate</title>
    <style>
        .table-bordered td, .table-bordered th {
            border: 1px solid #ddd;
            vertical-align: middle;
        }

        @media print {
            body * {
                visibility: hidden;
            }

            #printable-certificate, #printable-certificate * {
                visibility: visible;
            }

            #printable-certificate {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                padding: 20px;
            }

            .no-print {
                display: none !important;
            }
        }

        .sch-data p {
            margin: 3px 0;
            font-family: sans-serif;
            font-size: 13px;
        }

        .main-title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 4px;
        }

        h2.school-name {
            font-family: serif;
            font-weight: 800;
            text-transform: uppercase;
            color: #e01010;
        }

        h1.certificate-title {
            font-size: 20pt;
            border-radius: 10pt;
            font-family: sans-serif;
            font-weight: bold;
            text-transform: uppercase;
            color: #000;
            border: 3px solid #000;
            display: inline-block;
            padding: 8pt 20pt;
            margin: 10px auto;
        }

        p {
            font-family: cursive;
            line-height: 1.8;
            margin: 10px 0;
        }

        span.inline-block {
            display: inline-block;
            min-width: 120px;
            border-bottom: 1px solid #000;
            padding: 0 5px;
        }

        .signature-block {
            margin-top: 50px;
            text-align: right;
            padding-right: 50px;
            font-family: sans-serif;
        }

        .signature-block strong {
            display: block;
            margin-top: 50px;
        }

        .editable-field input {
            display: inline-block;
            background: transparent;
            font-family: cursive;
        }

        .editable-field .print-value {
            display: none;
        }

        @media print {
            .editable-field input {
                display: none !important;
            }

            .editable-field .print-value {
                display: inline-block !important;
            }
        }
    </style>
</head>
<body>

<?php
$adm_date = $student['admission_date'];
$month = (int) date('m', strtotime($adm_date));
$year = (int) date('Y', strtotime($adm_date));
$academicYear = ($month >= 6) ? $year . '-' . substr($year + 1, -2) : ($year - 1) . '-' . substr($year, -2);
?>

<div id="printable-certificate">
<?php
preg_match('/\d+/', $student['class'], $matches);
$classNumber = isset($matches[0]) ? intval($matches[0]) : 0;

if ($classNumber < 8) {
    $schoolname = $settinglist[0]['sch_name_primary'];
    $UDISENumber = $settinglist[0]['sch_udise_primary'];
} elseif ($classNumber > 10) {
    $schoolname = $settinglist[0]['sch_name_high_secondary'];
    $UDISENumber = $settinglist[0]['sch_udise_high_secondary'];
} else {
    $schoolname = $settinglist[0]['sch_name_secondary'];
    $UDISENumber = $settinglist[0]['sch_udise_secondary'];
}
$schoolrecogno = $settinglist[0]['dise_code'];
?>

<div class="panel panel-default" style="width: 75%;">
    <div class="panel-heading">
        <h4 class="no-margin no-padding">Preview Study Certificate</h4>
    </div>
    <div class="panel-body">
        <table border='0' cellspacing="0" cellpadding="0" class="table table-bordered table-responsive no-margin" style="background-color: transparent;">
            <tr align="center">
                <td style="width:10%; border: 0;">
                    <img style="width:85px;" src="<?= base_url(); ?>/uploads/school_content/logo/logo/<?= $settinglist[0]['certificate_logo']; ?>">
                </td>
                <td style="width: 90%; border: 0;" class="sch-data">
                    <?= $settinglist[0]['sch_soc_name'] ?>
                    <h2><b><?= $schoolname ?></b></h2>
                  
                    <?php if (valid($settinglist[0]['address'])): ?>
                        <p><?= $settinglist[0]['address'] ?></p>
                    <?php endif; ?>
                    <?php if (valid($settinglist[0]['email'])): ?>
                        <p>Email: <?= $settinglist[0]['email'] ?>,Phone:<?= $settinglist[0]['phone'] ?></p>
                    <?php endif; ?>
                </td>
            </tr>
        </table>

        <div style="text-align:center;">
            <h1 class="certificate-title">Study Certificate</h1>
            <p style="font-family: sans-serif;">Date: <?= date('d-m-Y'); ?></p>
        </div>

        <?php
        $monthName = date("F", strtotime($student['admission_date'])) . ' ' . date('y', strtotime($student['admission_date']));
        $dobWord = '-';
        if (valid($student['dob'])) {
            $parts = explode('-', $student['dob']);
            $dobWord = ucwords(getIndianCurrencyInWord($parts[2], '', '') . ' ' . date('F', strtotime($student['dob'])) . ' ' . getIndianCurrencyInWord($parts[0], '', ''));
        }
        ?>

        <div style="padding: 0 30px;">
            <p>
                This is to certify that Master/Miss 
                <span class="inline-block editable-field">
                    <input type="text" id="firstname" value="<?= ucwords($student['firstname']) ?>" class="form-control" style="border: none; width: 100%;" />
                    <span class="print-value"><?= ucwords($student['firstname']) ?></span>
                    <input type="hidden" id="student_id" value="<?= $student['id'] ?>">
                </span>
                <span class="inline-block editable-field">
                    <input type="text" id="father_name" value="<?= ucwords($student['father_name']) ?>" class="form-control" style="border: none; width: 100%;" />
                    <span class="print-value"><?= ucwords($student['father_name']) ?></span>
                </span>
                <span class="inline-block editable-field">
                    <input type="text" id="lastname" value="<?= ucwords($student['lastname']) ?>" class="form-control" style="border: none; width: 100%;" />
                    <span class="print-value"><?= ucwords($student['lastname']) ?></span>
                </span>
                has studied from 
                <span class="inline-block editable-field">
                    <input type="text" id="fillbyoffice_admittedto" value="<?= $student['fillbyoffice_admittedto'] ?>" class="form-control" style="border: none; width: 100%;" />
                    <span class="print-value"><?= $student['fillbyoffice_admittedto'] ?></span>
                </span> standard to 
                <span class="inline-block editable-field">
                    <input type="text" value="<?= $student['class'] ?>" class="form-control" style="border: none; width: 100%;" />
                    <span class="print-value"><?= $student['class'] ?></span>
                </span> standard in our institution.
            </p>

            <p>
                From academic year 
                <span class="inline-block editable-field" style="min-width:250px;">
                    <input type="text" value="<?= $academicYear ?> To <?= $session ?>" class="form-control" style="border: none; width: 100%;" />
                    <span class="print-value"><?= $academicYear ?> To <?= $session ?></span>
                </span>,
                the mother tongue of the candidate is 
                <span class="inline-block editable-field">
                    <input type="text" id="mother_tongue" value="<?= $student['mother_tongue'] ?>" class="form-control" style="border: none; width: 100%;" />
                    <span class="print-value"><?= $student['mother_tongue'] ?></span>
                </span>. as per the Admission register of the institution. The above details are true and correct to the best of my knowledge.
            </p>

            <p>Hence Certified.</p>
        </div>

        <?php
        $school_settings = $this->db->get_where('sch_settings', array('id' => 1))->row();
        $principal_name = isset($school_settings->principalname) ? $school_settings->principalname : '';
        ?>

        <div class="signature-block">
            <strong>Principal Signature</strong><br>
          
        </div>
    </div>

   
    <div class="panel-footer text-right no-print">
        <a href="javascript:void(0);" class="btn btn-danger btn-sm updateStudentBtn" data-toggle="tooltip" title="Update">Update</a>
        <a href="javascript:void(0);" class="btn btn-danger btn-sm clear-print-preview-content" data-toggle="tooltip" title="Cancel">Cancel</a>
        <a href="<?= base_url(); ?>student/edit/<?= $student['id'] ?>" class="btn btn-warning btn-sm bona-cert" data-toggle="tooltip" title="Edit Student Details">Edit Details</a>
       <a data-href="<?php echo base_url(); ?>admin/admin/studyCertificate_form/<?php echo $student['id'] ?>" target="_blank" class="btn btn-success btn-sm entry-cert preview-confirm-print" data-toggle="tooltip" title="" data-original-title="Confirm Preview & Print">
Confirm & Print
</a>
    </div>
</div>
</body>
</html>

// <script>
//     $(document).ready(function() {
//         $('.updateStudentBtn').on('click', function() {
//             var data = {
//                 student_id: $('#student_id').val(),
//                 adhar_no: $('#adhar_no').val(),
//                 firstname: $('#firstname').val(),
//                 father_name: $('#father_name').val(),
//                 lastname: $('#lastname').val(),
//                 mother_name: $('#mother_name').val(),
//                 nationality: $('#nationality').val(),
//                 mother_tongue: $('#mother_tongue').val(),
//                 religion: $('#religion').val(),
//                 cast: $('#cast').val(),
//                 subcas: $('#subcas').val(),
//                 place_of_birth: $('#place_of_birth').val(),
//                 birth_taluka: $('#birth_taluka').val(),
//                 birth_district: $('#birth_district').val(),
//                 state: $('#state').val(),
//                 dob: $('#dob').val(),
//                 prev_school_name: $('#prev_school_name').val(),
//                 prev_school_standard_covered: $('#prev_school_standard_covered').val(),
//                 admission_date: $('#admission_date').val(),
//                 class_studing_since_when: $('#class_studing_since_when').val(),
//                 academic_preference: $('#academic_preference').val(),
//                 academic_conduct: $('#academic_conduct').val(),
//                 reason_of_leaving: $('#reason_of_leaving').val(),
//                 remarks: $('#remarks').val()
//             };

//             $.ajax({
//                 url: "<?= base_url('student/updateStudentDetails'); ?>", // Your controller/method
//                 type: "POST",
//                 data: data,
//                 dataType: "json",
//                 success: function(response) {
//                     if (response.status === 'success') {
//                         alert("Student details updated successfully.");
//                     } else {
//                         alert("Error: " + response.message);
//                     }
//                 },
//                 error: function(xhr, status, error) {
//                     console.error(error);
//                     alert("An error occurred while updating student data.");
//                 }
//             });
//         });
//     });
// </script>
