<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>

<style>
    .text-left{text-align: left !important;}
    body {
      background-color: #f8f9fa;
    }
    .report-card {
      border-radius: 12px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
      padding: 20px;
      background: #fff;
      margin-top: 30px;
    }
    .table thead {
      background-color: #0d6efd;
      color: #fff;
    }
    .report-header {
      border-bottom: 2px solid #0d6efd;
      margin-bottom: 20px;
      padding-bottom: 10px;
    }
    .summary-box {
      border: 1px solid #dee2e6;
      border-radius: 8px;
      padding: 15px;
      text-align: center;
      background: #f1f5f9;
      transition: 0.3s;
    }
    .summary-box:hover {
      background: #e7f1ff;
    }
    .summary-box h6 {
      margin-bottom: 10px;
      font-weight: bold;
    }
    .summary-box p {
      margin: 0;
    }
  </style>

  
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-bus"></i> <?php //echo $this->lang->line('transport'); ?></h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <?php $this->load->view('reports/_human_resource'); ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box removeboxmius">
                    <div class="box-header ptbnull"></div>
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('select_criteria'); ?></h3>
                    </div>
                    <form role="form" action="<?php echo site_url('report/staff_leave_report') ?>" method="post" class="">
                        <div class="box-body row">
                            <?php echo $this->customlib->getCSRF(); ?>
                            
                            <div class="col-sm-3 col-md-3">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('staff'); ?></label>
                                    <select class="form-control" name="staff_id" >
                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                        <?php foreach ($staff as $value) {
                                            ?>
                                            <option value="<?php echo $value['id'] ?>" <?php
                                            if ((isset($staff_details)) && ($staff_details['id'] == $value['id'])) {
                                                echo "selected";
                                            }
                                            ?>><?php echo $value['name'] . ' ' .  $value['surname'] .'(' . $value['user_type'] . ')'?></option>
                                                <?php } ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div id='date_result'>
                            </div>
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm checkbox-toggle pull-right"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                    <?php if(!empty($alloted_leaves)){?>
                    <div class="">
                        <div class="box-header ptbnull"></div>
                        <div class="box-header ptbnull">
                            <h3 class="box-title titlefix"><i class="fa fa-money"></i> <?php echo $this->lang->line('staff_leave_report'); ?></h3>
                            <button class="btn btn-primary btn-sm float-right" onclick="printReport()">
                                <i class="fa fa-print"></i> Print
                            </button>
                        </div>

                        <div class="report-card" id="reportCard">

                            <!-- Header -->
                            <div class="report-header text-center">
                              <h2>Staff Leave Report</h2>
                              <h5>Staff Name: <strong><?php echo $staff_details['name'] . ' ' .  $staff_details['surname'] .' (' . $staff_details['user_type'] . ')'; ?></strong></h5>
                            </div>

                            <!-- Leave Type Summary -->
                            <div class="row text-center mb-4">
                              <!-- Casual Leave -->
                              <?php foreach ($alloted_leaves as $key => $value) {?>
                                <div class="col-md-3 mb-3">
                                    <div class="summary-box">
                                      <h6><?=$value['type']?></h6>
                                      <p>Allocated: <strong><?=$value['allocated']?></strong></p>
                                      <p>Used: <span class="text-danger"><?=$value['used']?></span></p>
                                      <p>Remaining: <span class="text-success"><?=$value['remaining']?></span></p>
                                    </div>
                                  </div>
                              <?php }?>
                              
                              
                            </div>

                            <!-- Leave Applications Table -->
                            <div class="table-responsive">
                                  <table class="table table-bordered table-striped">
                                    <thead>
                                      <tr>
                                        <th>Sr No.</th>
                                        <th>Apply Date</th>
                                        <th>Full/Half Day</th>
                                        <th>Leave From</th>
                                        <th>Leave To</th>
                                        <th>Days</th>
                                        <th>Leave Type</th>
                                        <th>Status</th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                      <?php if (!empty($leave_requests)): ?>
                                        <?php $i=1; foreach ($leave_requests as $req): ?>
                                          <tr>
                                            <td><?= $i++; ?></td>
                                            <td><?= date('d-m-Y', strtotime($req['date'])); ?></td>
                                            <td><?= ucfirst($req['half_leave_status']); ?></td>
                                            <td><?= date('d-m-Y', strtotime($req['leave_from'])); ?></td>
                                            <td><?= date('d-m-Y', strtotime($req['leave_to'])); ?></td>
                                            <td><?= $req['leave_days']; ?></td>
                                            <td><?= $req['type']; ?></td>
                                            <td>
                                              <?php if ($req['status'] == 'approved'): ?>
                                                <span class="badge bg-success">Approved</span>
                                              <?php elseif ($req['status'] == 'pending'): ?>
                                                <span class="badge bg-warning text-dark">Pending</span>
                                              <?php else: ?>
                                                <span class="badge bg-danger">Rejected</span>
                                              <?php endif; ?>
                                            </td>
                                          </tr>
                                        <?php endforeach; ?>
                                      <?php else: ?>
                                        <tr>
                                          <td colspan="8" class="text-center text-muted">No Leave Records Found</td>
                                        </tr>
                                      <?php endif; ?>
                                    </tbody>
                                  </table>
                                </div>


                          </div>
                        
                    </div>
                <?php }?>
                </div>
            </div>
        </div>   
    </div>  
</section>
</div>

<script>
function printReport() {
  const srcEl = document.getElementById('reportCard');
  if (!srcEl) return;

  // 1) Create a hidden iframe
  const iframe = document.createElement('iframe');
  iframe.style.position = 'fixed';
  iframe.style.right = '0';
  iframe.style.bottom = '0';
  iframe.style.width = '0';
  iframe.style.height = '0';
  iframe.style.border = '0';
  document.body.appendChild(iframe);

  const doc = iframe.contentDocument || iframe.contentWindow.document;

  // 2) Basic HTML skeleton
  doc.open();
  doc.write('<!doctype html><html><head><title>Print</title></head><body></body></html>');
  doc.close();

  // 3) Copy ALL <link rel="stylesheet"> and <style> tags automatically
  const head = doc.head;
  const loadPromises = [];

  // Copy stylesheets
  document.querySelectorAll('link[rel="stylesheet"]').forEach(link => {
    const l = doc.createElement('link');
    for (const attr of link.attributes) l.setAttribute(attr.name, attr.value);
    // ensure they apply to print too
    l.setAttribute('media', 'all');
    head.appendChild(l);
    loadPromises.push(new Promise(res => {
      l.onload = res; l.onerror = res;  // continue even if a CSS fails
    }));
  });

  // Copy inline styles
  document.querySelectorAll('style').forEach(style => {
    head.appendChild(style.cloneNode(true));
  });

  // Add a tiny print helper (keeps colors/backgrounds)
  const helper = doc.createElement('style');
  helper.textContent = `
    @page { size: auto; margin: 12mm; }
    * { -webkit-print-color-adjust: exact !important; print-color-adjust: exact !important; }
  `;
  head.appendChild(helper);

  // 4) Clone the report content
  const wrapper = doc.createElement('div');
  wrapper.appendChild(srcEl.cloneNode(true));
  doc.body.appendChild(wrapper);

  // 5) Wait for CSS to load, then print
  Promise.all(loadPromises).then(() => {
    iframe.contentWindow.focus();
    iframe.contentWindow.print();
    setTimeout(() => document.body.removeChild(iframe), 500);
  });
}
</script>
