
<?php
preg_match('/\d+/', $student['class'], $matches);
$classNumber = isset($matches[0]) ? intval($matches[0]) : 0;

if ($classNumber < 8) {
    // Primary School
    $schoolname = $settinglist[0]['sch_name_primary'];
      $schoolrecogno = $settinglist[0]['sch_recog_primary'];
    $UDISENumber  = $settinglist[0]['sch_udise_primary'];
    
    
} elseif ($classNumber > 10) {
    // Higher Secondary School
    $schoolname = $settinglist[0]['sch_name_high_secondary'];
   $schoolrecogno = $settinglist[0]['sch_recog_high_secondary'];
    $UDISENumber  = $settinglist[0]['sch_udise_high_secondary'];
} else {
    // Secondary School (for class 8 to 10)
    $schoolname = $settinglist[0]['sch_name_secondary'];
    $schoolrecogno = $settinglist[0]['sch_recog_secondary'];
    
    $UDISENumber  = $settinglist[0]['sch_udise_secondary'];
}

$logo_filename = isset($settinglist[0]['certificate_logo']) ? $settinglist[0]['certificate_logo'] : 'default_logo.jpg';
$sch_logo_final = base_url('uploads/school_content/logo/logo/' . $logo_filename);
?>

<?php


$catName = '';
$isSCST = '';
if (isset($category_list) && !empty($category_list))
{
    foreach ($category_list as $value)
    {
        if ($student['category_id'] == $value['id'])
        {
            $catName = $value['category'];
            break;
        }
    }
}
if (strtolower($catName) == 'sc')
{
    $isSCST = 'SC';
}
if (strtolower($catName) == 'st')
{
    $isSCST = 'ST';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title></title>
</head>
<body style="font-family: Arial, sans-serif; font-size: 14px; margin: 0; padding: 20px;">
  <div style="border: 2px solid #000; padding: 20px;">

    <!-- Header -->
    <table style="width: 100%; border-collapse: collapse;">
      <tr>
        <td style="width: 30%; font-size: 13px; line-height: 1.4; vertical-align: top;">
          Established: <?php echo $settinglist[0]['sch_establish']?><br>
          UDISE No: <?php echo $UDISENumber?><br>
          <b>Year:</b> <?php echo $currentsession?>
        </td>
        <td style="width: 40%; text-align: center; vertical-align: top;">
          <img src="<?php echo $sch_logo_final;?>" 
               alt="School Logo" style="width: 150px; height: auto;">
        </td>
        <td style="width: 30%; font-size: 13px; line-height: 1.6; text-align: right; vertical-align: top; white-space: nowrap;">
          Reg.No:<?php echo $settinglist[0]['dise_code']?><br>
          Class: <b><?= $student['class']; ?></b><br>
          Father’s Mob: <u><?= $student['mobileno']; ?></u><br>
          Mother’s Mob: <u><?= $student['mother_phone']; ?></u>
        </td>
      </tr>
    </table>

    <!-- School Info -->
    <table style="width: 100%; margin-top: 5px; border-collapse: collapse;">
      <tr>
        <td style="text-align: center; padding: 5px;">
          <p style="font-weight: bold; margin: 0;"><?php echo $settinglist[0]['sch_soc_name']?></p>
          <p style="font-size: 20px; font-weight: bold; margin: 5px 0; text-transform: uppercase;">
            <?php echo $schoolname?>
          </p>
        </td>
      </tr>
    </table>

    <!-- Application Section -->
    <table style="width: 100%; margin-top: 10px; border-collapse: collapse;">
      <tr>
        <!-- Left Side -->
        <td style="width: 80%; padding: 10px; text-align: center; vertical-align: top;">
          <table style="width: 100%; border-collapse: collapse;">
            <tr>
              <td style="text-align: center; padding-bottom: 6px;">
                <span style="font-weight: bold; display: inline-block;">
                  APPLICATION FORM FOR ADMISSION
                </span>
              </td>
            </tr>
            <tr>
              <td style="text-align: center; font-size: 12px; padding: 4px 0;">
                <?php echo $settinglist[0]['address']?>
                       <span style="font-size: small;">
    <br>Email: <?= $settinglist[0]['email'] ?> | Phone: <?= $settinglist[0]['phone']?>
</span>
              </td>
            </tr>
            <tr>
              <td style="text-align: center; font-size: 12px; padding: 4px 0;">
                <b>Student ID No:</b> <u><?= $student['std_global_id']; ?></u>
              </td>
            </tr>
          </table>
        </td>

        <!-- Right Side (Photo) -->
        <td style="width: 20%; text-align: center; vertical-align: middle; padding: 10px;">
              <?php
                            $sIimage = $student['image'];
                            $image = $student['image'];
                            $imgurl = '';
                            if ($sIimage == null || $sIimage == "")
                            {
                                $imgurl = base_url() . '/uploads/student_images/no_image.png';
                            }
                            else
                            {
                                $imgurl = base_url() . $image;
                            }
                            ?>
          <img src="<?php echo $imgurl; ?>" 
               alt="Student Photo" 
               style="border: 1px solid #000; width: 100px; height: 120px;">
        </td>
      </tr>
    </table>

    <!-- Body Details -->
    <table style="width: 100%; margin-top: 20px; border: 1px solid #000; border-collapse: collapse;">
      <tr>
        <td colspan="2" style="padding: 10px; border: 1px solid #000;">
          To,<br>
          The Principal,<br>
          <?php echo $schoolname?>
        </td>
      </tr>
      <tr>
        <td style="width: 40%; border: 1px solid #000; padding: 6px;">1. Full Name of the Student (In Block letters):</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline; font-weight: bold;"><?= $student['firstname']; ?> <?= $student['father_name']; ?> <?= $student['lastname']; ?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">2. Gender (Boy or Girl):</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?= $student['gender']; ?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">3. Date of Birth:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?= $student['dob']; ?></span></td>
      </tr>
      <tr>
          <?php

                   $dobWord = '-';

if (valid($student['dob'])) {
    $dob = trim($student['dob']);

    // Detect format
    if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $dob)) {
        // Format: YYYY-MM-DD
        list($year, $month, $day) = explode('-', $dob);
    } elseif (preg_match('/^\d{2}-\d{2}-\d{4}$/', $dob)) {
        // Format: DD-MM-YYYY
        list($day, $month, $year) = explode('-', $dob);
    } else {
        $day = $month = $year = null;
    }

    if ($day && $month && $year) {
        // Convert month number → full month name
        $monthWord = date('F', strtotime($year . '-' . $month . '-' . $day));

        // Convert day and year to words
        $dayWord = ucwords(getIndianCurrencyInWord((int)$day, '', ''));
        $yearWord = ucwords(getIndianCurrencyInWord((int)$year, '', ''));

        $dobWord = $dayWord . ' ' . $monthWord . ' ' . $yearWord;
    }
}
?>
        <td style="border: 1px solid #000; padding: 6px;">4. Date of Birth (In Words):</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $dobWord?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">5. Place of Birth:</td>
        <td style="border: 1px solid #000; padding: 6px;">
          <span style="text-decoration: underline;"><?= $student['place_of_birth']; ?></span><br>
          Village: <?= $student['birth_village']; ?> &nbsp;&nbsp; Town: <?= $student['birth_town']; ?> <br>
          Taluka: <span style="text-decoration: underline;"><?= $student['birth_taluka']; ?></span> &nbsp;&nbsp; District: <span style="text-decoration: underline;"><?= $student['birth_district']; ?></span>
        </td>
      </tr>
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">6.Father Name:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?= $student['father_name']; ?> </span>&nbsp;&nbsp;
         Living/Not Living:<?php echo $student['if_pupil_living_with_parent']?></td>
      </tr>
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">7.Mother Name:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?= $student['mother_name']; ?> </span>&nbsp;&nbsp;
         Living/Not Living:<?php echo $student['if_pupil_living_with_parent']?></td>
      </tr>
      
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">8.Educational Qualification Parents:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;">Father Qualification: <?= $student['father_edu_qualification']; ?></span>&nbsp;&nbsp;
         Mother Qualification:<?= $student['mother_edu_qualification']; ?> </td>
      </tr>
      
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">9.Occupation of Parents:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;">Father's Occupation:<?= $student['father_occupation']; ?> </span>&nbsp;&nbsp;
         Mother's Occupation:<?= $student['mother_occupation']; ?></td>
      </tr>
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">10.Whether Student is Living with Parent's:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['if_pupil_living_with_parent']?></span></td>
      </tr>
      
        <tr>
        <td style="border: 1px solid #000; padding: 6px;">11.Guardian's Name & Address:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?= ($student['guardian_name']) ? ucwords($student['guardian_name'] . ', ' . $student['guardian_address']) : '&nbsp;'; ?></span></td>
      </tr>
      
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">12.Nationality:</td>
        <td style="border: 1px solid #000; padding: 6px;">
          <span style="text-decoration: underline;"><?php echo $student['nationality']?></span><br>
          Religion:<?php echo $student['religion']?> &nbsp;&nbsp; Caste:<?php echo $student['cast']?><br>
         
        </td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">13.Scheduled Caste/Tribe:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $isSCST?></span></td>
      </tr>
      
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">14.Mother Tongue:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['mother_tongue']?></span></td>
      </tr>
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">15.Any Other Language Spoken:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['other_language_spoken']?></span></td>
      </tr>
         <tr>
        <td style="border: 1px solid #000; padding: 6px;">16.Number Of Brother's</td>
        <td style="border: 1px solid #000; padding: 6px;">
          <span style="text-decoration: underline;"><?php echo $student['num_of_brother']?></span><br>
          Elder Brother's:<?php echo $student['elder_brother']?> &nbsp;&nbsp; Younger Brother's:<?php echo $student['younger_brother']?> <br>
        
        </td>
      </tr>
      
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">17.Number Of Sister's</td>
        <td style="border: 1px solid #000; padding: 6px;">
          <span style="text-decoration: underline;"><?php echo $student['num_of_sister']?></span><br>
          Elder Sister's: <?php echo $student['elder_sister']?> &nbsp;&nbsp; Younger Sister's: <?php echo $student['younger_sister']?> <br>
        
        </td>
      </tr>
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">18.Permanent Address Of Student:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['permanent_address']?></span></td>
      </tr>
        <tr>
        <td style="border: 1px solid #000; padding: 6px;">19.Present Address Of Student:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['current_address']?></span></td>
      </tr>
       <tr>
        <td colspan="2" style="padding: 10px; border: 1px solid #000; text-align: center;">
          <strong>Schools Attended Previously:</strong>
        </td>
      </tr>
      <tr>
        <td style="width: 40%; border: 1px solid #000; padding: 6px;">20.Name of the School Attended</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['prev_school_name']?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">21.Concession/Scholarship</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['prev_school_scholarship']?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">22.Standard Covered</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['prev_school_standard_covered']?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">23.Date of Leaving and Reasons</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['prev_school_dateofleaving']?> , <?php echo $student['prev_school_reasonofleaving']?></span></td>
      </tr>
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">24. Whether the Student has Produced the School Leaving Certificate from the Last School Attended: Yes/No, If Yes, Date:</td>
        
         <?php
                                    $dt = '';
                                    if (valid($student['date_produced_last_school_leaving_certificate'])):
                                        $dt = date('d-m-Y', strtotime($student['date_produced_last_school_leaving_certificate']));
                                    endif;
                                    ?>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?= $dt; ?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">25. Vaccinations:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['vaccinations']?></span></td>
      </tr>
         <tr>
        <td style="border: 1px solid #000; padding: 6px;">26.Fitness Certificate (Produce/Not Produce):</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['fitness_cert']?></span></td>
      </tr>
       <tr>
        <td style="border: 1px solid #000; padding: 6px;">27.Languages Studied:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['languages_studied']?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">28. Medium Of Instruction Student had taken in the Last School:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['medium_of_instruction_in_last_school']?></span></td>
      </tr>
      <tr>
        <td style="border: 1px solid #000; padding: 6px;">29. Parents Full Name:</td>
        <td style="border: 1px solid #000; padding: 6px;"><span style="text-decoration: underline;"><?php echo $student['father_name'] . ' ' . $student['lastname']?></span></td>
      </tr>
        
    </table>
 <!-- Signature Line -->
    <p style="text-align: right; margin-top: 40px;">Signature of Parents/Guardian</p>

    <!-- Divider Line -->
    <hr style="border: 1px solid #000;">

    <!-- New Section: To Be Filled By Office -->
    <div style="text-align: center; font-weight: bold; font-size: 16px; margin-bottom: 10px;">
      PARTICULARS TO BE FILLED BY OFFICE
    </div>

    <table style="width: 100%; border-collapse: collapse;">
      <tr>
        <td style="width: 25%; padding: 5px;">30. Admitted to</td>
        <td style="width: 75%; padding: 5px; border-bottom: 1px solid #000;"><?php echo $student['fillbyoffice_admittedto']?></td>
      </tr>
      <tr>
        <td style="padding: 5px;">31. Standard</td>
        <td style="padding: 5px;">
          <span style="text-decoration: underline;"><?= ucwords($student['class']); ?></span> &nbsp;
          Section <span style="text-decoration: underline;"><?= ucwords($student['section']); ?></span> &nbsp;
          on Payment Prescribed/ Fees: Rs <span style="text-decoration: underline;"><?= ucwords($student['fillbyoffice_onpaymentfees']); ?></span>
        </td>
      </tr>
      <tr>
           <?php
                                    $feeWord = '-';
                                    if (valid($student['fillbyoffice_onpaymentfees']))
                                    {
                                        $feeWord = ucwords(getIndianCurrencyInWord($student['fillbyoffice_onpaymentfees'], '', ''));
                                    }
                                    ?>
        <td style="padding: 5px;">32. In Words (Rupees)</td>
        <td style="padding: 5px; border-bottom: 1px solid #000;"><?= ucwords($feeWord); ?></td>
      </tr>
      <tr>
        <td style="padding: 5px;">33. Date of Admission:</td>
        <td style="padding: 5px;">
          <span style="text-decoration: underline;"><?= valid($student['admission_date']) ? date('d-m-Y', strtotime($student['admission_date'])) : ''; ?></span> &nbsp;&nbsp;
          Admission Number: <span style="text-decoration: underline;"><?= ucwords($student['admission_no']); ?></span>
        </td>
      </tr>
      <tr>
        <td style="padding: 5px;">34. Fee Receipt No:</td>
        <td style="padding: 5px;">
          <span style="text-decoration: underline;"><?= ucwords($student['fillbyoffice_paymentfeesreceiptno']); ?></span> &nbsp;&nbsp;
          Any Other Comments: <span style="text-decoration: underline;"><?= ucwords($student['fillbyoffice_anycomment']); ?></span>
        </td>
      </tr>
      <tr>
        <td style="padding: 5px;">35.Date:</td>
        <td style="padding: 5px;">
          <span style="text-decoration: underline;"><?= date('d-m-Y'); ?></span>
        </td>
      </tr>
    </table>

    <p style="text-align: right; margin-top: 40px;">Signature of the Principal</p>

  </div>
  </div>
</body>
</html>
