<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
if (!empty($student_list)) {

?>
<div class="row">
	<div class="col-md-12">
<div class="pull-right mb10">
<strong><?php echo $this->lang->line('collection_date'); ?>: </strong><?php echo $this->customlib->dateformat(date('Y-m-d',$date)); ?>
	</div>
</div>
</div>
<div class="table-responsive">
	<div class="download_label"><?php echo $this->lang->line('collection_list'); ?></div>	
     <table class="table table-striped table-bordered table-hover" id="ViewData" >
        <thead>
            <tr>            
                <th><?php echo $this->lang->line('admission_no') ?></th>              
                <th><?php echo $this->lang->line('name') ?></th>
                <th><?php echo $this->lang->line('father_name') ?> </th>
                <th><?php echo $this->lang->line('date') ?> </th>
                <th><?php echo $this->lang->line('class') ?></th>
                <th><?php echo $this->lang->line('payment_mode') ?></th>
                <th><?php echo $this->lang->line('fee_type') ?></th>
                <th><?php echo $this->lang->line('payment_id') ?></th>
                <th><?php echo $this->lang->line('collected_by') ?></th>
                <th class="text text-right"><?php echo $this->lang->line('fine') ?></th>
                <th class="text text-right"><?php echo $this->lang->line('amount') ?></th>
                <th><?php echo $this->lang->line('total') ?></th>                
            </tr>
            
        </thead>
        <tbody>
        <?php 
        $total_fine = 0;
        $total_amount = 0;
        $grouped_data = [];
        $feeGroupTotals = [];
        $feeGroupsubTotals = [];
        $feeGroupFine = [];
        
        // Group data by payment_mode
        foreach ($student_list as $student_value) {
            $group_name = $student_value->feetype;
            if (isJSON($student_value->amount_detail)) {
                $fees_details = json_decode($student_value->amount_detail);
                foreach ($fees_details as $fees_value) {
                    if (strtotime($fees_value->date) == $date) {
                        $payment_mode = strtolower($fees_value->payment_mode);
        
                        if (!isset($grouped_data[$payment_mode])) {
                            $grouped_data[$payment_mode] = [];
                        }
        
                        $grouped_data[$payment_mode][] = [
                            'student' => $student_value,
                            'fees' => $fees_value
                        ];
        
                        $total_fine += $fees_value->amount_fine;
                        $total_amount += $fees_value->amount;
                        
                        if (!isset($feeGroupTotals[$group_name])) {
                        $feeGroupsubTotals[$group_name] = 0;
                        $feeGroupFine[$group_name] = 0;
                        $feeGroupTotals[$group_name] = 0;
                    }
                    $feeGroupsubTotals[$group_name] += $fees_value->amount;
                    $feeGroupFine[$group_name] +=$fees_value->amount_fine;
                    $feeGroupTotals[$group_name] += $fees_value->amount + $fees_value->amount_fine;
                    }
                    
                    
                }
            }
        }
        
        

        

        
        // Loop through each payment_mode group
        foreach ($grouped_data as $payment_mode => $entries) {
            $sub_total_fine = 0;
            $sub_total_amount = 0;
        
            echo '<tr>
            <td><strong>' . $this->lang->line($payment_mode) . '</strong></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            </tr>';
        
            foreach ($entries as $entry) {
                $student = $entry['student'];
                $fees = $entry['fees'];
        
                $sub_total_fine += $fees->amount_fine;
                $sub_total_amount += $fees->amount;
                
                $fees_date = isset($fees->date) ? date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($fees->date)) : '';
                ?>
                <tr>
                    <td><?php echo $student->admission_no; ?></td>
                    <td><?php echo $this->customlib->getFullName($student->firstname, $student->middlename, $student->lastname, $sch_setting->middlename, $sch_setting->lastname); ?></td>
                    <td><?php echo $student->father_name; ?></td>
                    <td><?php echo $fees_date; ?></td>
                    <td><?php echo $student->class . " (" . $student->section . ")"; ?></td>
                    <td><?php echo $this->lang->line($payment_mode); ?></td>
                    <td><?php echo $student->feetype ?></td>
                    <td><?php echo $student->student_fees_deposite_id . "/" . $fees->inv_no; ?></td>
                    <td><?php echo property_exists($fees, 'collected_by') ? $fees->collected_by : ''; ?></td>
                    <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($fees->amount_fine); ?></strong></td>
                    <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($fees->amount); ?></strong></td>
                    <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($fees->amount + $fees->amount_fine); ?></strong></td>
                </tr>
                <?php
            }
        
            // Subtotal row
            ?>
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td><strong>Subtotal (<?php echo $this->lang->line($payment_mode); ?>):</strong></td>
                <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($sub_total_fine); ?></strong></td>
                <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($sub_total_amount); ?></strong></td>
                <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($sub_total_fine + $sub_total_amount); ?></strong></td>
            </tr>
            <?php
        }
        ?>
        
        <tr>
            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
            <td  class="text-right"><strong><?php echo $this->lang->line('grand_total'); ?>:</strong></td>
            <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($total_fine); ?></strong></td>
            <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($total_amount); ?></strong></td>
            <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($total_amount + $total_fine); ?></strong></td>
        </tr>
        
        <tr>
        <td><strong>Group Wise Fees</strong></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        <td></td>
        </tr>
        
        <?php foreach ($feeGroupTotals as $groupName => $groupTotal): ?>
        <tr>
            <td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
            <td  class="text-right"><strong><?php echo $groupName; ?> Total:</strong></td>
            <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($feeGroupFine[$groupName]); ?></strong></td>
            <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($feeGroupsubTotals[$groupName]); ?></strong></td>
            <td class="text text-right"><strong><?php echo $currency_symbol . amountFormat($groupTotal); ?></strong></td>
        </tr>
        <?php endforeach; ?>
    
        </tbody>
        		
        </table>
</div>
<?php 
	

} else {
    ?>
                                        <div class="alert alert-info">
                                            <?php echo $this->lang->line('no_record_found'); ?>
                                        </div>
                                        <?php
}
?>

<script type="text/javascript">
$(document).ready(function () {
        var table = $('#ViewData').DataTable({
            "aaSorting": [],
            rowReorder: {
                selector: 'td:nth-child(2)'
            },
            dom: "Bfrtip",
            buttons: [
                {
                    extend: 'copyHtml5',
                    text: '<i class="fa fa-files-o"></i>',
                    titleAttr: 'Copy',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible',
                        footer: true
                    }
                },
                {
                    extend: 'excelHtml5',
                    text: '<i class="fa fa-file-excel-o"></i>',
                    titleAttr: 'Excel',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible',
                        footer: true
                    }
                },
                {
                    extend: 'csvHtml5',
                    text: '<i class="fa fa-file-text-o"></i>',
                    titleAttr: 'CSV',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible',
                        footer: true
                    }
                },
                {
                    extend: 'pdfHtml5',
                    text: '<i class="fa fa-file-pdf-o"></i>',
                    titleAttr: 'PDF',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible',
                        footer: true
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="fa fa-print"></i>',
                    titleAttr: 'Print',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible',
                        footer: true
                    },
                    customize: function (win) {
                        $(win.document.body).css('font-size', '10pt');
        
                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
        
                        // Optional: Ensure the footer is visible
                        $(win.document.body).find('tfoot').css('display', 'table-footer-group');
                    }
                },
                {
                    extend: 'colvis',
                    text: '<i class="fa fa-columns"></i>',
                    titleAttr: 'Columns',
                    postfixButtons: ['colvisRestore']
                },
            ]
        });

    });




</script>