<div class="content-wrapper" style="min-height: 946px;">
    <section class="content-header">
        <h1>
            <i class="fa fa-user-plus"></i> <?php echo $this->lang->line('student_information'); ?> <small><?php echo $this->lang->line('class1'); ?></small></h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <?php
            if ($this->rbac->hasPrivilege('student_categories', 'can_add')) {
                ?>
                <div class="col-md-4">
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title">Cast</h3>
        </div>
        <form id="form1" action="<?php echo site_url('category/castcreate') ?>" name="employeeform" method="post" accept-charset="utf-8">
            <div class="box-body">
                <?php 
                    if ($this->session->flashdata('msg')) { 
                        echo $this->session->flashdata('msg');
                        $this->session->unset_userdata('msg');
                    } 
                ?>    
                <?php echo $this->customlib->getCSRF(); ?>

                <!-- Category Select -->
                <div class="form-group">
                    <label><?php echo $this->lang->line('category'); ?></label><small class="req"> *</small>
                    <select name="category" class="form-control" required>
                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                        <?php foreach ($categorylist as $category): ?>
                            <option value="<?php echo $category['id']; ?>">
                                <?php echo $category['category']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <span class="text-danger"><?php echo form_error('category'); ?></span>
                </div>

                <!-- Cast Input Fields -->
                <div class="form-group" id="cast-container">
                    <label><?php echo $this->lang->line('cast'); ?></label>
                    <div class="cast-input-group">
                        <div class="row mb-2">
                            <div class="col-xs-9">
                                <input type="text" name="cast[]" class="form-control" placeholder="Enter Cast">
                            </div>
                            <div class="col-xs-3">
                                <button type="button" class="btn btn-success btn-sm add-cast-btn btn-block" id="addCastBtn">
                                    <i class="fa fa-plus"></i>ADD
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="box-footer">
                <button type="submit" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
            </div>
        </form>
    </div>
</div>
 
            <?php } ?>
            <div class="col-md-<?php
            if ($this->rbac->hasPrivilege('student_categories', 'can_add')) {
                echo "8";
            } else {
                echo "12";
            }
            ?>">             
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix">Cast List</h3>           
                    </div>
                    <div class="box-body">
                        <div class="download_label"><?php echo $this->lang->line('category_list'); ?></div>
                        <div class="table-responsive mailbox-messages overflow-visible">

                            <?php 
                                if ($this->session->flashdata('msgdelete')) { 
                                    echo $this->session->flashdata('msgdelete');
                                    $this->session->unset_userdata('msgdelete');

                                } 
                            ?>

                            <table class="table table-striped table-bordered table-hover example">
    <thead>
        <tr>
            <th><?php echo $this->lang->line('category'); ?></th>
            <th>Cast Name</th>
            <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 1;
        foreach ($result as $row) {
        ?>
            <tr>
                <td class="mailbox-name"><?php echo $row['category_name']; ?></td>
                <td class="mailbox-name"><?php echo $row['castname']; ?></td>
                <td class="mailbox-date pull-right">
                    <?php if ($this->rbac->hasPrivilege('student_categories', 'can_edit')) { ?>
                        <a href="<?php echo base_url(); ?>category/editcast/<?php echo $row['id']; ?>" class="btn btn-default btn-xs" data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>">
                            <i class="fa fa-pencil"></i>
                        </a>
                    <?php } ?>
                    <?php if ($this->rbac->hasPrivilege('student_categories', 'can_delete')) { ?>
                        <a href="<?php echo base_url(); ?>category/deletecast/<?php echo $row['id']; ?>" class="btn btn-default btn-xs" data-toggle="tooltip" title="<?php echo $this->lang->line('delete'); ?>" onclick="return confirm('<?php echo $this->lang->line('delete_confirm') ?>');">
                            <i class="fa fa-remove"></i>
                        </a>
                    <?php } ?>
                </td>
            </tr>
        <?php
            $count++;
        }
        ?>
    </tbody>
</table>

                        </div>
                    </div>
                </div>
            </div>
        </div> 
    </section>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $("#btnreset").click(function () {
            $("#form1")[0].reset();
        });
    });
</script>
script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('#addCastBtn').click(function () {
            var castField = `
                <div class="row mb-2 cast-entry">
                    <div class="col-xs-9">
                        <input type="text" name="cast[]" class="form-control" placeholder="Enter Cast">
                    </div>
                    <div class="col-xs-3">
                        <button type="button" class="btn btn-danger btn-sm remove-cast-btn btn-block">
                            <i class="fa fa-minus"></i>
                        </button>
                    </div>
                </div>
            `;
            $('#cast-container .cast-input-group').append(castField);
        });

        $(document).on('click', '.remove-cast-btn', function () {
            $(this).closest('.cast-entry').remove();
        });
    });
</script>

<!-- Optional: spacing for older Bootstrap versions -->
<style>
    .mb-2 {
        margin-bottom: 10px;
    }
</style>