<div id="printArea">
    <div class="print-header">
    <div class="header-left">
        <img class="school-logo-print" src="<?= base_url('uploads/school_content/admin_logo/'.$this->setting_model->getAdminlogo()); ?>" alt="<?= $this->customlib->getAppName(); ?>">
    </div>
    <div class="header-center">
        <div class="report-title-print">
            Shri Marwadi Rajasthan Shikshan Sanstha's
        </div>
        <div class="school-name-print">
            <?= $this->setting_model->getCurrentSchoolName(); ?>
        </div>
        <div class="school-tagline">
            A Refined Creative CBSE English School
        </div>
        <div class="school-code">
            CBSE Affiliation Number 1130660 | School Code 30565
        </div>
    </div>
    <?php
        $class_id_val = isset($data['class_id']) ? $data['class_id'] : (isset($_POST['class_id']) ? $_POST['class_id'] : '');
        $section_id_val = isset($data['section_id']) ? $data['section_id'] : (isset($_POST['section_id']) ? $_POST['section_id'] : '');
        $class_name = '';
        $section_name = '';
        if (!empty($class_id_val) && !empty($classlist)) {
            foreach ($classlist as $class) {
                if ($class['id'] == $class_id_val) {
                    $class_name = $class['class'];
                    break;
                }
            }
        }
        if (!empty($section_id_val) && !empty($sectionList)) {
            foreach ($sectionList as $section) {
                if ($section['id'] == $section_id_val) {
                    $section_name = $section['section'];
                    break;
                }
            }
        }
        if ($class_name || $section_name) {
            echo '<div class="class-section" style="text-align:center;font-size:16px;font-weight:normal;margin:8px 0 12px 0;">';
            if ($class_name) echo 'Class: <b>' . htmlspecialchars($class_name) . '</b> ';
            echo '&nbsp; | &nbsp; Section: <b>' . htmlspecialchars($section_name) . '</b>';
            echo '</div>';
        }
    ?>
    <div class="header-right">
        <img class="cbsc-logo-print"
             src="<?= base_url('uploads/school_content/admin_logo/cbsc-logo.png'); ?>"
             alt="CBSE Logo">
    </div>
</div>
    <table id="full-print-timetable" class="table table-striped table-bordered" style="width:100%;">
        <thead>
            <tr>
                <th>Period</th>
                <?php
                $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
                $max_periods = 10;
                foreach ($days as $day): ?>
                    <th><?= $day ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <?php
            for ($period = 1; $period <= $max_periods; $period++) {
                $time_from = '';
                $time_to   = '';
                foreach ($days as $day_for_time) {
                    if (isset($timetable[$day_for_time][$period])) {
                        $time_from = $timetable[$day_for_time][$period]['time_from'];
                        $time_from = str_replace([' AM', ' PM'], '', $time_from);
                        $time_to   = $timetable[$day_for_time][$period]['time_to'];
                        $time_to = str_replace([' AM', ' PM'], '', $time_to);
                        break;
                    }
                }
                // Label: Period number, with special names for lunch/short break and remap 5→4, 9→7
                if ($period == 4) {
                    // Lunch Break row, merged
                    echo "<tr><td colspan=" . (count($days)+1) . " style='text-align:center;font-weight:bold;'>Lunch Break";
                    if ($time_from && $time_to) echo " ({$time_from} - {$time_to})";
                    echo "</td></tr>";
                    continue;
                } elseif ($period == 8) {
                    // Short Break row, merged
                    echo "<tr><td colspan=" . (count($days)+1) . " style='text-align:center;font-weight:bold;'>Short Break";
                    if ($time_from && $time_to) echo " ({$time_from} - {$time_to})";
                    echo "</td></tr>";
                    continue;
                }
                // Remap period number for display
                $display_period = $period;
                if ($period == 4) {
                    $period_label = "Lunch Break";
                } elseif ($period == 8) {
                    $period_label = "Short Break";
                } else {
                    if ($period == 5) $display_period = 4;
                    if ($period == 6) $display_period = 5;
                    if ($period == 7) $display_period = 6;
                    if ($period == 9) $display_period = 7;
                    if ($period == 10) $display_period = 8;
                    $period_label = "Period $display_period";
                }
                echo "<tr>";
                echo "<td style='min-width:110px;'><b>{$period_label}</b>";
                if ($time_from && $time_to) echo "<br><span style='font-size:11px;color:#555;'>{$time_from} - {$time_to}</span>";
                echo "</td>";
                foreach ($days as $day) {
                    if (isset($timetable) && isset($timetable[$day][$period])) {
                        $entry = $timetable[$day][$period];
                        $subject_name = $entry['subject_id'] == -1 ? 'Short Break' : ($entry['subject_id'] == -2 ? 'Lunch Break' : $entry['subject_name']);
                        $teacher_name = ($entry['subject_id'] > 0) ? $entry['teacher_name'] : '';
                        echo "<td><div class='period-box'><b>Subject: $subject_name</b>";
                        if ($teacher_name) echo "<br>Teacher: <span style='font-weight:normal;'>$teacher_name</span>";
                        echo "</div></td>";
                    } else {
                        echo "<td class='not-scheduled'>Not Scheduled</td>";
                    }
                }
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>
</div>
    <title>School Timetable</title>
    <style type="text/css">
        #printArea {
            display: none;
        }

        .school-name-print {
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            margin-top: 10px;
            line-height: 1.4;
            width: 100%;
            white-space: normal;
            word-break: break-word;
        }

        .school-name-print .school-tagline {
            font-size: 14px;
            font-weight: normal;
        }

        .school-name-print .school-code {
            font-size: 13px;
            font-weight: normal;
        }

        /* Print specific */
        @media print {
            .school-name-print {
                font-size: 18px;
                margin-bottom: 10px;
            }
        }
        @media print {
            #printArea {
                display: block !important;
            }
        }
        .printbody {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 20px;
        }

        /* Header Styling */
        .header {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 10px;
            padding: 10px;
            border-bottom: 2px solid black;
        }

        .school-name {
            font-size: 22px;
            font-weight: bold;
            margin-top: 5px;
        }

        .class-details {
            font-size: 16px;
            margin-top: 5px;
        }

        /* Timetable Styling */
        .timetable {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        .timetable th,
        .timetable td {
            border: 1px solid black;
            padding: 5px;
            text-align: center;
        }

        .timetable th {
            background-color: #f2f2f2;
            font-weight: bold;
            font-size: 14px;
        }

        .subject {
            font-weight: bold;
            display: block;
            margin-bottom: 5px;
            font-size: 12px;
        }

        .time-name {
            display: block;
            padding-top: 5px;
            font-size: 10px;
            color: #555;
        }

        .teacher-name {
            display: block;
            padding-top: 5px;
            font-size: 12px;
            color: #555;
        }

        .break-column {
            background-color: #e0e0e0;
            font-weight: bold;
            vertical-align: middle;
        }

        /* Signature Section */
        .footer {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
            font-weight: bold;
            text-align: center;
        }

        .signature {
            width: 30%;
            border-top: 1px solid black;
            padding-top: 10px;
        }

        .reporting-time {
            margin-top: 10px;
        }

        /* Print Section */
        #printSection {
            display: none;
        }

        @media print {
            #printSection {
                display: block !important;
            }

            .subject-select,
            .editable-cell {
                display: none !important;
            }
        
        }
        .print-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 15px;
}

.header-left,
.header-right {
    width: 120px;
}

.header-left img,
.header-right img {
    width: 90px;
}

.header-center {
    flex: 1;
    text-align: center;
    line-height: 1.4;
}

.school-name-print {
    font-size: 20px;
    font-weight: bold;
}

.school-tagline {
    font-size: 14px;
}

.school-code {
    font-size: 13px;
    color: #555;
}

@media print {
    .print-header {
        margin-bottom: 10px;
    }
}

    </style>
</head>

<div class="content-wrapper" style="min-height: 946px;">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-mortar-board"></i> <?php echo $this->lang->line('academics'); ?>
            <small><?php echo $this->lang->line('student_fees1'); ?></small>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <!-- Horizontal Form -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <?= $top_menu_option; ?>
                    </div><!-- /.box-header -->
                </div><!-- /.box-header -->
            </div><!-- /.box-header -->
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i><?php echo $this->lang->line('select_criteria'); ?></h3>
                        <div class="box-tools pull-right">
                            <a href="<?php echo site_url('admin/timetable/create') ?>" type="button" class="btn btn-sm btn-primary" autocomplete="off"><i class="fa fa-plus"></i><?php echo $this->lang->line('add'); ?></a>
                        </div>
                    </div>
                    <form action="<?php echo site_url('admin/timetable/show_timetable') ?>" method="post"
                        accept-charset="utf-8">
                        <div class="box-body">
                            <?php echo $this->customlib->getCSRF(); ?>
                            <div class="row">
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1"><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
                                        <select autofocus="" id="class_id" name="class_id" class="form-control">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                            <?php
                                            foreach ($classlist as $class) {
                                                ?>
                                                <option value="<?php echo $class['id'] ?>" <?php
                                                   if (set_value('class_id') == $class['id']) {
                                                       echo "selected=selected";
                                                   }
                                                   ?>><?php echo $class['class'] ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select>
                                        <span class="text-danger"><?php echo form_error('class_id'); ?></span>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label
                                            for="exampleInputEmail1"><?php echo $this->lang->line('section'); ?></label><small
                                            class="req"> *</small>
                                        <select id="section_id" name="section_id" class="form-control">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        </select>
                                        <span class="text-danger"><?php echo form_error('section_id'); ?></span>
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <label for="exampleInputEmail1"></label>
                                    <div class="box-footer">
                                        <button type="submit" class="btn btn-primary pull-right btn-sm"
                                            name="search"><?php echo $this->lang->line('search'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <?php   
                    if (isset($timetable)) {
                        ?>
                        <div class="box-header ptbnull"></div>
                        <div class="" style="margin-bottom: 10px;">
                            <?php if (isset($is_generated) && $is_generated): ?>
                                <button onclick="printTimetable()" class="btn btn-primary btn-sm">Print Timetable</button>
                            <?php else: ?>
                                <button onclick="generateTimetable()" class="btn btn-success btn-sm"><i class="fa fa-magic"></i>
                                    Generate Timetable</button>
                            <?php endif; ?>
                        </div>
                        <div class="box-body">
                            <?php
                            if (!empty($timetable)) {
                                ?>
                                <div class="table-responsive">
                                    <table class="table table-striped table-bordered table-hover example">
                                        <thead>
                                            <tr>
                                                <th width="7% !important">Period</th>
                                                <?php
                                                $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                                                $max_periods = 10; // Adjust as per your requirement
                                                // Determine active days (at least one assigned subject with subject_id > 0)
                                                $active_days = [];
                                                foreach ($days as $day_name) {
                                                    $has_subject = false;
                                                    for ($p = 1; $p <= $max_periods; $p++) {
                                                        if (isset($timetable[$day_name][$p]) && $timetable[$day_name][$p]['subject_id'] > 0) {
                                                            $has_subject = true;
                                                            break;
                                                        }
                                                    }
                                                    if ($has_subject) {
                                                        $active_days[] = $day_name;
                                                    }
                                                }
                                                // If no active day found, keep original list to avoid empty table
                                                if (empty($active_days)) {
                                                    $active_days = $days;
                                                }
                                                foreach ($active_days as $day): ?>
                                                    <th><?= $day ?></th>
                                                <?php endforeach; ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            // Build a subject map for each active day and period for highlight
                                            $subject_map = [];
                                            for ($period2 = 1; $period2 <= $max_periods; $period2++) {
                                                foreach ($active_days as $day2) {
                                                    if (isset($timetable[$day2][$period2]) && $timetable[$day2][$period2]['subject_id'] > 0) {
                                                        $subject2 = $timetable[$day2][$period2]['subject_name'];
                                                        if (!isset($subject_map[$day2]))
                                                            $subject_map[$day2] = [];
                                                        if (!isset($subject_map[$day2][$subject2]))
                                                            $subject_map[$day2][$subject2] = [];
                                                        $subject_map[$day2][$subject2][] = $period2;
                                                    }
                                                }
                                            }
                                            for ($period = 1; $period <= $max_periods; $period++) {
                                                $time_from = '';
                                                $time_to = '';
                                                foreach ($active_days as $day_for_time) {
                                                    if (isset($timetable[$day_for_time][$period])) {
                                                        $time_from = $timetable[$day_for_time][$period]['time_from'];
                                                        $time_from = str_replace([' AM', ' PM'], '', $time_from);
                                                        $time_to = $timetable[$day_for_time][$period]['time_to'];
                                                        $time_to = str_replace([' AM', ' PM'], '', $time_to);
                                                        break;
                                                    }
                                                }
                                                // Label: Period number, with special names for lunch/short break and remap 5→4, 9→7
                                                if ($period == 4) {
                                                    $period_label = "Lunch Break";
                                                } elseif ($period == 8) {
                                                    $period_label = "Short Break";
                                                } else {
                                                    $display_period = $period;
                                                    if ($period == 5) $display_period = 4;
                                                    if ($period == 6) $display_period = 5;
                                                    if ($period == 7) $display_period = 6;
                                                    if ($period == 9) $display_period = 7;
                                                    if ($period == 10) $display_period = 8;
                                                    $period_label = "Period $display_period";
                                                }
                                                echo "<tr>";
                                                echo "<td>{$period_label}" ;
                                                if ($time_from !== '' && $time_to !== '') {
                                                    echo "<br>{$time_from} -  {$time_to}";
                                                }
                                                echo "</td>";
                                                if($period != 4 && $period != 8 ){
                                                    foreach ($active_days as $day) {
                                                        $highlight = '';
                                                        $is_editable = isset($is_generated) && $is_generated;
                                                        if (isset($timetable[$day][$period])) {
                                                            $entry = $timetable[$day][$period];
                                                            $subject_name = $entry['subject_id'] == -1 ? 'Short Break' : ($entry['subject_id'] == -2 ? 'Lunch Break' : "Subject: {$entry['subject_name']}");
                                                            $teacher_name = $subject_name;
    
                                                            if ($entry['subject_id'] > 0) {
                                                                $subject = $entry['subject_name'];
                                                                if (isset($subject_map[$day][$subject]) && count($subject_map[$day][$subject]) > 1) {
                                                                    $highlight = " style='background-color:#ffcccc'";
                                                                }
                                                                $subject_name = "Subject: " . $entry['subject_name'];
                                                                $teacher_name = "Teacher: " . $entry['teacher_name'];
                                                            }
                                                            if (isset($timetable[$day][$period])) {
                                                                $entry = $timetable[$day][$period];
                                                                $subject_name = $entry['subject_id'] == -1 ? 'Short Break' : ($entry['subject_id'] == -2 ? 'Lunch Break' : "Subject: {$entry['subject_name']}");
                                                                $teacher_name = $subject_name;
    
                                                                if ($entry['subject_id'] > 0) {
                                                                    $subject = $entry['subject_name'];
                                                                    // If this subject appears more than once in this day, highlight
                                                                    if (isset($subject_map[$day][$subject]) && count($subject_map[$day][$subject]) > 1) {
                                                                        $highlight = " style='background-color:#ffcccc'";
                                                                    }
                                                                    $subject_name = "Subject: " . $entry['subject_name'];
                                                                    $teacher_name = "Teacher: " . $entry['teacher_name'];
                                                                }
                                                                $timetable_id = isset($entry['id']) ? $entry['id'] : '';
                                                                $current_subject_id = $entry['subject_id'];
                                                                $class_id_val = isset($data['class_id']) ? $data['class_id'] : '';
                                                                $section_id_val = isset($data['section_id']) ? $data['section_id'] : '';
                                                                echo "<td$highlight data-timetable-id='$timetable_id' data-day='$day' data-period='$period' data-class-id='$class_id_val' data-section-id='$section_id_val' class='editable-cell' style='cursor: pointer; position: relative;'>";
                                                                echo "<div class='period-box'>";
                                                                echo "<select class='form-control subject-select' style='width: 100%; margin-bottom: 5px;' data-timetable-id='$timetable_id' data-day='$day' data-period='$period' data-class-id='$class_id_val' data-section-id='$section_id_val'>";
                                                                echo "<option value=''>Select Subject</option>";
                                                                $available_subjects = isset($subjects) ? $subjects : array();
                                                                if (!empty($available_subjects)) {
                                                                    foreach ($available_subjects as $subj) {
                                                                        $subj_id = is_object($subj) ? $subj->id : (isset($subj['id']) ? $subj['id'] : '');
                                                                        $subj_name = is_object($subj) ? $subj->name : (isset($subj['name']) ? $subj['name'] : '');
                                                                        $subj_code = is_object($subj) ? (isset($subj->code) ? $subj->code : '') : (isset($subj['code']) ? $subj['code'] : '');
                                                                        $selected = ($current_subject_id == $subj_id) ? 'selected' : '';
                                                                        $code_display = ($subj_code != "") ? " (" . $subj_code . ")" : "";
                                                                        echo "<option value='{$subj_id}' $selected>{$subj_name}{$code_display}</option>";
                                                                    }
                                                                } else {
                                                                    echo "<option value='{$current_subject_id}' selected>{$subject_name}</option>";
                                                                }
                                                                echo "</select>";
                                                                echo "<strong>$subject_name</strong><br>";
                                                                echo "<small>$teacher_name</small>";
                                                                echo "</div>";
                                                                echo "</td>";
                                                            }
                                                        } else {
                                                            echo "<td class='not-scheduled'>Not Scheduled</td>";
                                                        }
                                                    }
                                                }else{
                                                    echo "<td colspan='".count($active_days)."' style='text-align:center;'>".$period_label."</td>";
                                                }
                                                echo "</tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php
                            }
                            ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </section>
        </div>
        
<script type="text/javascript">
    $(document).on('focus', '.time', function () {
        var $this = $(this);
        $this.datetimepicker({
            format: 'LT'
        });
    });
    var tot_count = 0;
    var class_id = $('#class_id').val();
    var section_id = <?php echo json_encode(set_value('section_id', [])) ?>;
    var subject_group_id = '<?php echo set_value('subject_group_id') ?>';
    $(document).ready(function () {
        $('#myTabs a:first').tab('show'); // Select first tab
        if (class_id) {
            getSectionByClass(class_id, section_id);
        }
        if (class_id && section_id) {
            getGroupByClassandSection(class_id, section_id, subject_group_id);
        }
        // When class changes, update section dropdown immediately
        $(document).on('change', '#class_id', function (e) {
            var class_id = $(this).val();
            $('#section_id').html('<option value="">Select</option>').prop('disabled', false);
            if (class_id) {
                var base_url = '<?php echo base_url(); ?>';
                $.ajax({
                    type: "GET",
                    url: base_url + "sections/getByClass",
                    data: { 'class_id': class_id },
                    dataType: "json",
                    success: function (data) {
                        var div_data = '<option value="">Select</option>';
                        $.each(data, function (i, obj) {
                            div_data += '<option value="' + obj.id + '">' + obj.section + '</option>';
                        });
                        $('#section_id').html(div_data).prop('disabled', false);
                    }
                });
            } else {
                $('#section_id').html('<option value="">Select</option>').prop('disabled', true);
            }
        });

        // When section changes, auto-submit the form to view timetable
        $(document).on('change', '#section_id', function (e) {
            var section_id = $(this).val();
            if (section_id) {
                $(this).closest('form').submit();
            }
        });

        $(document).on('change', '#class_id', function (e) {
            var class_id = $(this).val();
            $('#section_id').html('<option value="">Select</option>').prop('disabled', true);
            if (class_id) {
                var base_url = '<?php echo base_url(); ?>';
                $.ajax({
                    type: "GET",
                    url: base_url + "sections/getByClass",
                    data: { 'class_id': class_id },
                    dataType: "json",
                    success: function (data) {
                        var div_data = '<option value="">Select</option>';
                        $.each(data, function (i, obj) {
                            div_data += '<option value="' + obj.id + '">' + obj.section + '</option>';
                        });
                        $('#section_id').html(div_data).prop('disabled', false);
                    }
                });
            }
        });

        $(document).on('change', '#section_id', function (e) {
            $('#subject_group_id').html("");
            var section_id = $(this).val();
            var class_id = $('#class_id').val();
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "POST",
                url: base_url + "admin/subjectgroup/getGroupByClassandSection",
                data: { 'class_id': class_id, 'section_id': section_id },
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj) {
                        div_data += "<option value=" + obj.subject_group_id + ">" + obj.name + "</option>";
                    });
                    $('#subject_group_id').append(div_data);
                }
            });
        });
    });

    function getSectionByClass(class_id, section_id) {
        if (class_id !== "" && section_id !== "") {
            var base_url = '<?php echo base_url(); ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: { 'class_id': class_id },
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj) {
                        var selected = (section_id == obj.id) ? ' selected' : '';
                        div_data += '<option value="' + obj.id + '"' + selected + '>' + obj.section + '</option>';
                    });
                    $('#section_id').html(div_data).val(section_id).trigger('change.select2');
                }
            });
        }
    }

    function getGroupByClassandSection(class_id, section_id, subject_group_id) {
        if (class_id != "" && section_id != "" && subject_group_id != "") {
            $('#subject_group_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "POST",
                url: base_url + "admin/subjectgroup/getGroupByClassandSection",
                data: { 'class_id': class_id, 'section_id': section_id },
                dataType: "json",
                success: function (data) {
                    console.log(subject_group_id);
                    $.each(data, function (i, obj) {
                        var sel = "";
                        if (subject_group_id == obj.subject_group_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.subject_group_id + " " + sel + ">" + obj.name + "</option>";
                    });
                    $('#subject_group_id').append(div_data);
                }
            });
        }
    }

    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var target = $(e.target).attr("href"); // activated tab
        var target_id = $(e.target).attr("id"); // activated tab
        var ajax_data = $(e.target).data(); // activated tab
        $(target).html("");
        getGroupdata(target, target_id, ajax_data);
    })

    function getGroupdata(target, target_id, ajax_data) {
        $.ajax({
            type: 'POST',
            url: base_url + "admin/timetable/getBydategroupclasssection",
            data: { 'day': ajax_data.day, 'class_id': ajax_data.c, 'section_id': ajax_data.s, 'subject_group_id': ajax_data.group },
            dataType: 'json',
            beforeSend: function () {
                $(target).addClass('show');
            },
            success: function (data) {
                $(target).html(data.html);

                $('.staff', target).select2({
                    dropdownAutoWidth: true,
                    width: '100%'
                });
                $('.subject', target).select2({
                    dropdownAutoWidth: true,
                    width: '100%'
                });
                tot_count = data.total_count + 1;
            },
            error: function (xhr) { // if error occured
                alert("Error occured.please try again");
            },
            complete: function () {
                $(target).removeClass('show');
            }
        });
    }


    $(document).ready(function () {
        var counter = 0;
        $(document).on("click", ".addrow", function () {
            var newRow = $("<tr>");
            var cols = "";
            cols += '<td><input type="hidden" name="total_row[]" value="' + tot_count + '"><input type="hidden" name="prev_id_' + tot_count + '" value="0"><select class="form-control subject" id="subject_id_' + tot_count + '" name="subject_' + tot_count + '">' + $("#subject_dropdown").text() + '</select></td>';
            cols += '<td><select class="form-control staff" id="staff_id_' + tot_count + '" name="staff_' + tot_count + '">' + $("#staff_dropdown").text() + '</select></td>';
            cols += '<td><div class="input-group"><input type="text" name="time_from_' + tot_count + '" class="form-control time_from time" id="time_from_' + tot_count + '"  aria-invalid="false"><div class="input-group-addon"><span class="glyphicon glyphicon-dashboard"></span></div></div></td>';
            cols += '<td><div class="input-group"><input type="text" name="time_to_' + tot_count + '" class="form-control time_to time" id="time_to_' + tot_count + '"  aria-invalid="false"><div class="input-group-addon"><span class="glyphicon glyphicon-dashboard"></span></div></div></td>';
            cols += '<td><input type="text" class="form-control room_no" name="room_no_' + tot_count + '" id="room_no_' + tot_count + '"/></td>';
            cols += '<td><button type="button" class="ibtnDel btn btn-danger btn-sm btn-danger"><i class="fa fa-trash"></i></button></td>';
            newRow.append(cols);
            $("table.order-list").append(newRow);
            $('.staff', newRow).select2({
                dropdownAutoWidth: true,
                width: '100%'
            });
            $('.subject', newRow).select2({
                dropdownAutoWidth: true,
                width: '100%'
            });
            tot_count++;
        });

        $(document).on("click", ".ibtnDel", function (event) {
            $(this).closest("tr").remove();
            counter -= 1
        });

        $(document).on('click', '.submit_subject_group', function () {
            var form_id = $(this).closest("form").attr('id');
            var target = $('.nav-tabs .active a').attr("href"); // activated tab
            var target_id = $('.nav-tabs .active a').attr("id"); // activated tab
            var ajax_data = $('.nav-tabs .active a').data(); // activated tab
        });
    });

    $(document).ready(function () {
        $('#section_id').select({
            // placeholder: "Please Select Caste Category",
            allowClear: true,
            closeOnSelect: false
        });
    });

   function printTimetable() {
    var printWindow = window.open('', '_blank');

    // Existing styles copy
    var styles = document.querySelectorAll('link[rel="stylesheet"], style');
    var stylesHTML = '';
    styles.forEach(function (style) {
        if (style.tagName === 'LINK') {
            stylesHTML += '<link rel="stylesheet" href="' + style.href + '">';
        } else {
            stylesHTML += '<style>' + style.innerHTML + '</style>';
        }
    });

    var fullTable = document.getElementById('full-print-timetable');
    if (!fullTable) {
        alert('Full timetable data not found for printing');
        return;
    }

    // Clone table so original page affect na ho
    var tableClone = fullTable.cloneNode(true);

    // ❌ Sunday remove (header + data)
    removeSunday(tableClone);

    // ✅ Print specific CSS (BORDER FIX)
    var printCSS = `
        <style>
            table {
                width: 100%;
                border-collapse: collapse !important;
                font-size: 12px;
            }
            th, td {
                border: 1px solid #000 !important;
                padding: 6px;
                text-align: center;
            }
            th {
                background: #f2f2f2;
            }
            .print-header {
                text-align: center;
                margin-bottom: 10px;
            }
            .print-logo {
                max-height: 70px;
                margin-bottom: 5px;
            }
            .print-school-name {
                font-size: 22px;
                font-weight: bold;
                margin-bottom: 5px;
            }
        </style>
    `;

    // Get school logo and name from DOM (or fallback)
    var logoUrl = '';
    var logoImg = document.querySelector('.school-logo-print') || document.querySelector('.school-logo') || document.querySelector('img.logo');
    if (logoImg) {
        logoUrl = logoImg.src;
    }
    var cbscLogoUrl = '';
    var cbscLogoImg = document.querySelector('.cbsc-logo-print') || document.querySelector('.cbsc-logo') || document.querySelector('img.logo');
    if (cbscLogoImg) {
        cbscLogoUrl = cbscLogoImg.src;
    }
    var className = '';
    var classNameElem = document.querySelector('.class-details-print') || document.querySelector('.class-details') || document.querySelector('div.class-details');
    if (classNameElem) {
        className = classNameElem.textContent.trim();
    }
    var schoolName = '';
    var schoolNameElem = document.querySelector('.school-name-print') || document.querySelector('.school-name') || document.querySelector('h1.school-name');
    if (schoolNameElem) {
        schoolName = schoolNameElem.textContent.trim();
    } else {
        schoolName = (typeof SCHOOL_NAME !== 'undefined') ? SCHOOL_NAME : 'School Name';
    }

    var classSection = '';
    var classSectionElem = document.querySelector('.class-section-print') || document.querySelector('.class-section') || document.querySelector('div.class-section');
    if (classSectionElem) {
        classSection = classSectionElem.textContent.trim();
    } else {
        classSection = (typeof CLASS_SECTION !== 'undefined') ? CLASS_SECTION : 'Class Section';
    }
var printHeader = `
<div class="print-header">
    <div class="header-left">
        <img src="${logoUrl}" style="width:90px;">
    </div>

    <div class="header-center">
        <div class="report-title-print">Shri Marwadi Rajasthan Shikshan Sanstha's</div>
        <div class="school-name-print">${schoolName}</div>
        <div class="school-tagline">A Refined Creative CBSE English School</div>
        <div class="school-code">CBSE Affiliation Number 1130660 | School Code 30565</div>
        <div class="class-section-print">${classSection}</div>
    </div>

    <div class="header-right">
        <img src="${cbscLogoUrl}" style="width:90px;">
    </div>
</div>
`;


    printWindow.document.open();
    printWindow.document.write(`
        <html>
            <head>
                <title>Print Timetable</title>
                ${stylesHTML}
                ${printCSS}
            </head>
            <body>
                ${printHeader}
                ${tableClone.outerHTML}
            </body>
        </html>
    `);
    printWindow.document.close();

    printWindow.onload = function () {
        setTimeout(function () {
            printWindow.print();
            printWindow.close();
        }, 500);
    };
}
function removeSunday(table) {
    var rows = table.querySelectorAll('tr');

    rows.forEach(function (row) {
        var cells = row.querySelectorAll('th, td');

        cells.forEach(function (cell, index) {
            if (cell.innerText.trim().toLowerCase() === 'sunday') {
                // Remove Sunday column from all rows
                rows.forEach(function (r) {
                    if (r.children[index]) {
                        r.children[index].remove();
                    }
                });
            }
        });
    });
}




    function generateTimetable() {
        var class_id = '<?php echo isset($data['class_id']) ? $data['class_id'] : ''; ?>';
        var section_id = '<?php echo isset($data['section_id']) ? $data['section_id'] : ''; ?>';
        if (!class_id || !section_id) {
            alert('Please select Class and Section first.');
            return;
        }
        if (!confirm('This will generate a new timetable. Existing timetable will be replaced. Continue?')) {
            return;
        }
        var base_url = '<?php echo base_url(); ?>';
        $.ajax({
            type: 'POST',
            url: base_url + 'admin/teacher/savetimeline',
            data: {
                class_id: class_id,
                section_id: section_id
            },
            beforeSend: function () {
                $('body').append('<div id="loading-overlay" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:9999;display:flex;align-items:center;justify-content:center;"><div style="color:white;font-size:18px;">Generating timetable...</div></div>');
            },
            success: function (response) {
                $('#loading-overlay').remove();
                location.reload();
            },
            error: function () {
                $('#loading-overlay').remove();
                alert('Error generating timetable. Please try again.');
            }
        });
    }

    // Drag and drop functionality for timetable cells
    $(document).ready(function () {
        var draggedElement = null;
        $('.subject-select').each(function () {
            var $select = $(this);
            if ($select.find('option').length <= 1) {
                loadSubjectsForDropdown($select);
            }
        });

        $(document).on('mousedown', '.editable-cell', function (e) {
            if ($(e.target).is('select')) return; // Don't drag if clicking on select
            draggedElement = $(this);
            $(this).css('opacity', '0.5');
        });

        $(document).on('mouseup', function () {
            if (draggedElement) {
                draggedElement.css('opacity', '1');
                draggedElement = null;
            } 
        });

        // Handle drop
        $(document).on('mouseenter', '.editable-cell', function () {
            if (draggedElement && draggedElement[0] !== this) {
                $(this).css('background-color', '#e3f2fd');
            }
        }).on('mouseleave', '.editable-cell', function () {
            $(this).css('background-color', '');
        });

        $(document).on('mouseup', '.editable-cell', function (e) {
            if (draggedElement && draggedElement[0] !== this && !$(e.target).is('select')) {
                var sourceSelect = draggedElement.find('.subject-select');
                var targetSelect = $(this).find('.subject-select');
                if (sourceSelect.length && targetSelect.length) {
                    var sourceValue = sourceSelect.val();
                    var targetValue = targetSelect.val();
                    sourceSelect.val(targetValue).trigger('change');
                    targetSelect.val(sourceValue).trigger('change');
                }
                draggedElement.css('opacity', '1');
                draggedElement = null;
                $(this).css('background-color', '');
            }
        });

        // Load subjects dynamically if dropdown is empty
        function loadSubjectsForDropdown($select) {
            var class_id = $select.data('class-id');
            var section_id = $select.data('section-id');
            if (!class_id || !section_id) {
                return;
            }
            // Check if dropdown already has options (more than just "Select Subject")
            if ($select.find('option').length <= 1) {
                var base_url = '<?php echo base_url(); ?>';
                $.ajax({
                    type: 'POST',
                    url: base_url + 'admin/timetable/get_subjects_for_class_section',
                    data: {
                        class_id: class_id,
                        section_id: section_id
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.status == '1' && response.subjects && response.subjects.length > 0) {
                            // Clear existing options except first
                            $select.find('option:not(:first)').remove();
                            // Add subjects
                            $.each(response.subjects, function (index, subj) {
                                var subj_id = subj.id || subj.subject_group_subject_id;
                                var subj_name = subj.name || '';
                                var subj_code = subj.code ? ' (' + subj.code + ')' : '';
                                var option = $('<option></option>').attr('value', subj_id).text(subj_name + subj_code);
                                $select.append(option);
                            });
                            // Restore selected value if it was set
                            var currentValue = $select.data('current-value');
                            if (currentValue) {
                                $select.val(currentValue);
                            }
                        }
                    },
                    error: function () {
                        console.error('Error loading subjects');
                    }
                });
            }
        }

        // Load subjects when dropdown is clicked/focused
        $(document).on('focus click', '.subject-select', function () {
            var $select = $(this);
            $(this).data('previous-value', $(this).val());
            $(this).data('current-value', $(this).val());
            loadSubjectsForDropdown($select);
        });

        // Add highlight class on duplicate subject in a day, remove only on period change
        function updateHighlights() {
            // Remove all highlights first
            $('.editable-cell').removeClass('highlight-duplicate');
            // For each day, check for duplicate subjects
            var daySubjects = {};
            $('.editable-cell').each(function () {
                var day = $(this).data('day');
                var subj = $(this).find('.subject-select').val();
                if (!subj) return;
                if (!daySubjects[day]) daySubjects[day] = {};
                if (!daySubjects[day][subj]) daySubjects[day][subj] = [];
                daySubjects[day][subj].push(this);
            });
            // Highlight duplicates
            $.each(daySubjects, function (day, subjMap) {
                $.each(subjMap, function (subj, cells) {
                    if (cells.length > 1) {
                        $(cells).addClass('highlight-duplicate');
                    }
                });
            });
        }

        // Initial highlight
        updateHighlights();

        // Only update highlight on subject change
        $(document).on('change', '.subject-select', function () {
            var subject_id = $(this).val();
            var timetable_id = $(this).data('timetable-id');
            var day = $(this).data('day');
            var period_id = $(this).data('period');
            var class_id = $(this).data('class-id') || $('#class_id').val();
            var section_id = $(this).data('section-id') || $('#section_id').val();
            if (!class_id || !section_id) {
                alert('Class and Section are required.');
                return;
            }
            $.ajax({
                url: '<?= base_url("admin/timetable/update_timetable_subject") ?>',
                type: 'POST',
                data: {
                    subject_id: subject_id,
                    timetable_id: timetable_id,
                    day: day,
                    period_id: period_id,
                    class_id: class_id,
                    section_id: section_id
                },
                success: function (response) {
                    if (response.status == '1') {
                        updateHighlights();
                        location.reload();
                    } else {
                        alert(response.error);
                    }
                }
            });
        });
        // Add highlight-duplicate CSS
        var style = document.createElement('style');
        style.innerHTML = `.highlight-duplicate { background-color: #ffcccc !important; }`;
        document.head.appendChild(style);
    });

</script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.print/1.6.3/jQuery.print.min.js"></script>
<script type="text/template" id="staff_dropdown">
    <option value=""><?php echo $this->lang->line('select') ?></option>
    <?php
    foreach ($staff as $staff_key => $staff_value) {
        ?>
            <option value="<?php echo $staff_value['id']; ?>"><?php echo $staff_value['name'] . " " . $staff_value['surname'] . " (" . $staff_value['employee_id'] . ")"; ?></option>
            <?php
    }
    ?>
</script>
<script type="text/template" id="subject_dropdown">
    <option value=""><?php echo $this->lang->line('select') ?></option>
    <?php
    foreach ($subject as $subject_key => $subject_value) {
        ?>
            <option value="<?php echo $subject_value->id; ?>" ><?php echo $subject_value->name . " (" . $subject_value->code . ")"; ?></option>
            <?php
    }
    ?>
</script>