<div class="content-wrapper" style="min-height: 946px;">
    <section class="content-header">
        <h1>
            <i class="fa fa-mortar-board"></i> <?php echo $this->lang->line('academics'); ?></h1>
    </section>
    <!-- Main content -->
    <section class="content">
    <div class="row">
            <div class="col-md-12 col-sm-12">
                    <!-- Horizontal Form -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <?= $top_menu_option; ?>
                    </div><!-- /.box-header -->
                </div><!-- /.box-header -->
            </div><!-- /.box-header -->

        </div>       
        
       
        <div class="box box-info" id="box_display">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-users"> </i> School Timings </h3>

                
            </div>
            <div class="box-body">
                            <form action="#" method="post" accept-charset="utf-8" class="promote_form">
                               

                
                                <div class="table-responsive">    
                                    <table class="table table-striped">
                                        <tbody>
                                            <tr>
                                                <th>School Start Time</th>
                                                <th>School End Time</th>
                                                <th>Lunch Break Start Time</th>
                                                <th>Lunch Break End Time</th>
                                                <th>Short Break Start Time</th>
                                                <th>Short Break End Time</th>
                                            </tr>

                                            
                                            
                                                
                                                    <tr class="subject_periods_row">
                                                        <td><input type="text" name="school_start_time" class="form-control time_from time" id="school_start_time" aria-invalid="false" value="<?php echo isset($periods_data['school_start_time']) ? $periods_data['school_start_time'] : ''; ?>"></td>
                                                        <td><input type="text" name="school_end_time" class="form-control time_from time" id="school_end_time" aria-invalid="false" value="<?php echo isset($periods_data['school_end_time']) ? $periods_data['school_end_time'] : ''; ?>"></td>
                                                        <td><input type="text" name="lunch_break_start_time" class="form-control time_from time" id="lunch_break_start_time" aria-invalid="false" value="<?php echo isset($periods_data['lunch_break_start_time']) ? $periods_data['lunch_break_start_time'] : ''; ?>"></td>
                                                        <td><input type="text" name="lunch_break_end_time" class="form-control time_from time" id="lunch_break_end_time" aria-invalid="false" value="<?php echo isset($periods_data['lunch_break_end_time']) ? $periods_data['lunch_break_end_time'] : ''; ?>"></td>
                                                        <td><input type="text" name="short_break_start_time" class="form-control time_from time" id="short_break_start_time" aria-invalid="false" value="<?php echo isset($periods_data['short_break_start_time']) ? $periods_data['short_break_start_time'] : ''; ?>"></td>
                                                        <td><input type="text" name="short_break_end_time" class="form-control time_from time" id="short_break_end_time" aria-invalid="false" value="<?php echo isset($periods_data['short_break_end_time']) ? $periods_data['short_break_end_time'] : ''; ?>"></td>
                                                    </tr>

                                                    <tr class="subject_periods_row">
                                                        <td>1st Period Timing:<input type="text" name="first_period" class="form-control time_from " id="first_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['first_period']) ? $periods_data['first_period'] : ''; ?>"></td>
                                                        <td>2nd Period Timing:<input type="text" name="second_period" class="form-control time_from " id="second_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['second_period']) ? $periods_data['second_period'] : ''; ?>"></td>
                                                        <td>3rd Period Timing:<input type="text" name="third_period" class="form-control time_from " id="third_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['third_period']) ? $periods_data['third_period'] : ''; ?>"></td>
                                                        <td>4th Period Timing:<input type="text" name="fourth_period" class="form-control time_from " id="fourth_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['fourth_period']) ? $periods_data['fourth_period'] : ''; ?>"></td>
                                                        <td>5th Period Timing:<input type="text" name="fifth_period" class="form-control time_from " id="fifth_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['fifth_period']) ? $periods_data['fifth_period'] : ''; ?>"></td>
                                                        <td>6th Period Timing:<input type="text" name="sixth_period" class="form-control time_from " id="sixth_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['sixth_period']) ? $periods_data['sixth_period'] : ''; ?>"></td>
                                                        
                                                    </tr>

                                                    <tr>
                                                        <td>7th Period Timing:<input type="text" name="seventh_period" class="form-control time_from " id="seventh_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['seventh_period']) ? $periods_data['seventh_period'] : ''; ?>"></td>
                                                        <td>8th Period Timing:<input type="text" name="eighth_period" class="form-control time_from " id="eighth_period" aria-invalid="false" placeholder="In Minutes" value="<?php echo isset($periods_data['eight_period']) ? $periods_data['eight_period'] : ''; ?>"></td>
                                                    </tr>                                                    

                                           
                                        
                                        </tbody>
                                    </table>
                                </div>    
                            </form>
                        </div>

                        <div class="box-footer clearfix" >
                            

                                <a class="btn btn-sm btn-primary pull-right" id="save_btn" ><?php echo $this->lang->line('save'); ?></a>
                               
                        </div>
                    </div>
                    
                </div>  
               
        </div>       
    </section>
</div>

<script type="text/javascript">

    $(document).on('focus', '.time', function () {
                    var $this = $(this);
                    $this.datetimepicker({
                        format: 'LT'
                    });
                });
    $(document).ready(function () {
        $('#btnAdd').hide();
        var class_id = $('#class_id').val();
        var section_id = '<?php echo set_value('section_id') ?>';
        var subject_group_id = '<?php echo set_value('subject_group_id') ?>';

        getSectionByClass(class_id,section_id);
        getGroupByClassandSections(class_id, section_id, subject_group_id);
        
        

        $(document).on('change', '#class_id', function (e) {
            $('#section_id').html("");
            // resetForm();
            var class_id = $(this).val();
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        });

        function getSectionByClass(class_id, section_id) {
        if (class_id != "" && section_id != "") {
            $('#section_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            var url = "<?php
            $userdata = $this->customlib->getUserData();
            if (($userdata["role_id"] == 2)) {
                echo "getClassTeacherSection";
            } else {
                echo "getByClass";
            }
            ?>";

            $.ajax({
                type: "GET",
                url: base_url + "sections/" + url,
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        }
    }

        $(document).on('change', '#section_id', function (e) {
                        $('#subject_group_id').html("");
                        var section_id = $(this).val();
                        var class_id = $('#class_id').val();
                        var base_url = '<?php echo base_url() ?>';
                        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                        $.ajax({
                            type: "POST",
                            url: base_url + "admin/subjectgroup/getGroupByClassandSections",
                            data: {'class_id': class_id, 'section_id': section_id},
                            dataType: "json",
                            success: function (data) {
                                $.each(data, function (i, obj)
                                {
                                    div_data += "<option value=" + obj.subject_group_id + ">" + obj.name + "</option>";
                                });

                                $('#subject_group_id').append(div_data);
                            }
                        });
                    });
    });


 



    



    function getGroupByClassandSections(class_id, section_id, subject_group_id) {
                    if (class_id != "" && section_id != "" && subject_group_id != "") {
                        $('#subject_group_id').html("");

                        var base_url = '<?php echo base_url() ?>';
                        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                        $.ajax({
                            type: "POST",
                            url: base_url + "admin/subjectgroup/getGroupByClassandSections",
                            data: {'class_id': class_id, 'section_id': section_id},
                            dataType: "json",
                            success: function (data) {
                                console.log(subject_group_id);
                                $.each(data, function (i, obj)
                                {
                                    var sel = "";
                                    if (subject_group_id == obj.subject_group_id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + obj.subject_group_id + " " + sel + ">" + obj.name + "</option>";
                                });

                                $('#subject_group_id').append(div_data);
                            }
                        });
                    }
                }


$(document).ready(function () {
    $("#save_btn").click(function () {
        let isValid = true;
        let errorMessage = "Please fill all fields before saving.";

        // Function to convert time to minutes
        function timeToMinutes(time) {
            if (!time) return null; // Ensure time is not empty

            let match = time.match(/^(\d{1,2}):(\d{2})\s?(AM|PM)?$/i);
            if (!match) return null; // Return null if the format is incorrect

            let hours = parseInt(match[1], 10);
            let minutes = parseInt(match[2], 10);
            let period = match[3] ? match[3].toUpperCase() : null;

            // Convert 12-hour format to 24-hour format
            if (period === "PM" && hours !== 12) {
                hours += 12;
            } else if (period === "AM" && hours === 12) {
                hours = 0;
            }

            return hours * 60 + minutes;
        }


        // Get school start and end times
        let schoolStartTime = $("#school_start_time").val();
        let schoolEndTime = $("#school_end_time").val();
        let lunchStartTime = $("#lunch_break_start_time").val();
        let lunchEndTime = $("#lunch_break_end_time").val();
        let shortBreakStartTime = $("#short_break_start_time").val();
        let shortBreakEndTime = $("#short_break_end_time").val();
        var base_url = '<?php echo base_url() ?>';

        // Check if any time field is empty
        if (!schoolStartTime || !schoolEndTime || !lunchStartTime || !lunchEndTime || !shortBreakStartTime || !shortBreakEndTime) {
            alert(errorMessage);
            return;
        }

        let schoolTime = timeToMinutes(schoolEndTime) - timeToMinutes(schoolStartTime);
        let lunchTime = timeToMinutes(lunchEndTime) - timeToMinutes(lunchStartTime);
        let shortBreakTime = timeToMinutes(shortBreakEndTime) - timeToMinutes(shortBreakStartTime);

        // Get all period times and check if they are empty
        let totalPeriodsTime = 0;
        $(".subject_periods_row input").each(function () {
            let periodTime = $(this).val();
            if (!periodTime) {
                isValid = false;
            } else {
                totalPeriodsTime += parseInt(periodTime);
            }
        });

        if (!isValid) {
            alert(errorMessage);
            return;
        }

        let totalBreaksTime = lunchTime + shortBreakTime;
        let totalTimeUsed = totalPeriodsTime + totalBreaksTime;
        

        // Validation
        if (totalTimeUsed > schoolTime) {
            alert("Total period time + break time should not exceed school time.");
            return;
        }

        // Prepare data for saving
        let formData = $(".promote_form").serialize();

        // AJAX request to save data
        $.ajax({
            url: base_url + "admin/teacher/periods_time", // Change to your actual save URL
            type: "POST",
            data: formData,
            success: function (response) {
                alert("Data saved successfully!");
            },
            error: function () {
                alert("Error saving data.");
            }
        });
    });
});


</script>