<div class="content-wrapper" style="min-height: 946px;">
    <section class="content-header">
        <h1>
            <i class="fa fa-mortar-board"></i> <?php echo $this->lang->line('academics'); ?></h1>
    </section>
    <!-- Main content -->
    <section class="content">
    <div class="row">
            <div class="col-md-12 col-sm-12">
                    <!-- Horizontal Form -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <?= $top_menu_option; ?>
                    </div><!-- /.box-header -->
                </div><!-- /.box-header -->
            </div><!-- /.box-header -->

        </div>        
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('select_criteria'); ?></h3>
            </div>
            <form  class="assign_teacher_form" action="<?php echo base_url(); ?>admin/teacher/getSubjectTeachers" method="post" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if ($this->session->flashdata('msg')) { ?>
                                <?php echo $this->session->flashdata('msg') ?>
                            <?php } ?>
                            <?php echo $this->customlib->getCSRF(); ?>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
                                <select autofocus="" id="class_id" name="class_id" class="form-control" >
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php
                                    foreach ($classlist as $class) {
                                        ?>
                                        <option value="<?php echo $class['id'] ?>"><?php echo $class['class'] ?></option>
                                        <?php
                                        $count++;
                                    }
                                    ?>
                                </select>
                                <span class="class_id_error text-danger"></span>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('section'); ?></label><small class="req"> *</small>
                                <select  id="section_id" name="section_id[]" class="form-control" multiple="">
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                </select>
                                <span class="section_id_error text-danger"></span>
                            </div>
                        </div>

                        <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo $this->lang->line('subject') . " " . $this->lang->line('group'); ?><small class="req"> *</small></label>
                                        <select  id="subject_group_id" name="subject_group_id" class="form-control" >
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        </select>
                                        <span class="text-danger"><?php echo form_error('subject_group_id'); ?></span>
                                    </div>
                                </div>
                    </div>
                    <button type="submit" id="search_filter" name="search" value="search_filter" class="btn btn-primary btn-sm checkbox-toggle pull-right"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>                 
                </div>
            </form>
        </div>
        <div class="box box-info" id="box_display" style="display:none">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-users"> </i> <?php echo $this->lang->line('assign_subject'); ?></h3>

                <div class="box-tools pull-right">
                    <button id="btnAdd"  class="btn btn-primary btn-sm checkbox-toggle pull-right" type="button"><i class="fa fa-plus"></i> <?php echo $this->lang->line('add'); ?></button>
                </div>
            </div>
            <form action="<?php echo base_url() ?>admin/teacher/cbse_assignteacher" method="POST" id="formSubjectTeacher">
                <?php echo $this->customlib->getCSRF(); ?>
                <br/>
                <input type="hidden" value="0" id="post_class_id" name="class_id">
                <input type="hidden" value="0" id="post_section_id" name="section_id">
                <input type="hidden" value="0" id="post_subject_group_id" name="subject_group_id">
                <div class="form-horizontal" id="TextBoxContainer" role="form">
                </div>
                <div class="box-footer">
                    <button type="submit" class="btn btn-primary btn-sm btn pull-right save_button" style="display: none;"><?php echo $this->lang->line('save'); ?></button>
                </div>
            </form>
        </div>       
    </section>
</div>



<script type="text/javascript">
    var globalSubjects = [];
    $(document).ready(function () {
        $('#btnAdd').hide();
        var class_id = $('#class_id').val();
        var section_id = '<?php echo set_value('section_id') ?>';
        var subject_group_id = $('#subject_group_id').val();
        getGroupByClassandSections(class_id, section_id, subject_group_id);
        
        $(".assign_teacher_form").submit(function (e)
        {
            $("#TextBoxContainer").html("");
            $("input[class$='_error']").html("");
            var class_id = $('#class_id').val();
            var section_id = $('#section_id').val();
            var subject_group_id = $('#subject_group_id').val();
            var postData = $(this).serializeArray();
            var formURL = $(this).attr("action");
            
            
            $.ajax(
                    {
                        url: formURL,
                        type: "POST",
                        data: postData,
                        dataType: 'json',
                        success: function (data, textStatus, jqXHR)
                        {
                            if (data.st === 1) {
                                $.each(data.msg, function (key, value) {
                                    $('.' + key + "_error").html(value);
                                });
                            } else {

                                var response = data.msg;
                                var subjects = data.subjects;
                                var subjectlist = data.subject_list;
                                globalSubjects = subjectlist || [];

                                var class_teacher = data.class_teacher;

                                if (response && response.length > 0) {
                                    for (i = 0; i < response.length; ++i) {
                                        var subject_id = response[i].subject_id;
                                        var teacher_id = response[i].teacher_id;
                                        var row_id = response[i].id;
                                        appendRow(subject_id, teacher_id, row_id,'',subjectlist);
                                    }
                                }else if (subjects && subjects.length > 0) {
                                    for (i = 0; i < subjects.length; ++i) {
                                        var subject_id = subjects[i].subject_id;
                                        var teacher_id = subjects[i].teacher_id;


                                        // var row_id = subjects[i].id;
                                        appendRow(subject_id, teacher_id, 0,class_teacher,subjectlist);
                                    } 
                                }
                                    else {
                                    appendRow(0, 0, 0,'',subjectlist);
                                }

                                setTimeout(function () {
                                    $('.select_teacher').select2({
                                        allowClear: true,
                                        closeOnSelect: false
                                    });
                                }, 100);
                                
                                $('#post_class_id').val(class_id);
                                $('#post_section_id').val(section_id);
                                $('#post_subject_group_id').val(subject_group_id);
                                $('#btnAdd').show();
                                $('#box_display').show();
                                $('.save_button').show();
                            }
                        },
                        error: function (jqXHR, textStatus, errorThrown)
                        {
                        }
                    });

            e.preventDefault();

        });

        $(document).on('change', '#class_id', function (e) {
            $('#section_id').html("");
            resetForm();
            var class_id = $(this).val();
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        });

        $(document).on('change', '#section_id', function (e) {
                        $('#subject_group_id').html("");
                        var section_id = $(this).val();
                        var class_id = $('#class_id').val();
                        var base_url = '<?php echo base_url() ?>';
                        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                        $.ajax({
                            type: "POST",
                            url: base_url + "admin/subjectgroup/getGroupByClassandSection",
                            data: {'class_id': class_id, 'section_id': section_id},
                            dataType: "json",
                            success: function (data) {
                                $.each(data, function (i, obj)
                                {
                                    div_data += "<option value=" + obj.subject_group_id + ">" + obj.name + "</option>";
                                });

                                $('#subject_group_id').append(div_data);
                            }
                        });
                    });
    });



    function getGroupByClassandSections(class_id, section_id, subject_group_id) {
                    if (class_id != "" && section_id != "" && subject_group_id != "") {
                        $('#subject_group_id').html("");

                        var base_url = '<?php echo base_url() ?>';
                        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
                        $.ajax({
                            type: "POST",
                            url: base_url + "admin/subjectgroup/getGroupByClassandSection",
                            data: {'class_id': class_id, 'section_id': section_id},
                            dataType: "json",
                            success: function (data) {
                                console.log(subject_group_id);
                                $.each(data, function (i, obj)
                                {
                                    var sel = "";
                                    if (subject_group_id == obj.subject_group_id) {
                                        sel = "selected";
                                    }
                                    div_data += "<option value=" + obj.subject_group_id + " " + sel + ">" + obj.name + "</option>";
                                });

                                $('#subject_group_id').append(div_data);
                            }
                        });
                    }
                }

    function appendRow(subject_id, teacher_id, row_id, class_teacher_id = null,subjectlist = []) {
    // Get the list of already assigned subjects
    
    var assignedSubjects = [];
    $('select[name^="subject_id_"]').each(function () {
        var selectedValue = $(this).val();
        if (selectedValue) {
            assignedSubjects.push(selectedValue);
        }
    });

    var value = $('#TextBoxContainer .app').length;
    var row = "";
    row += '<div class="form-group app">';
    row += '<input type="hidden" name="i[]" value="' + value + '"/>';
    row += '<input type="hidden" name="row_id_' + value + '" value="' + row_id + '"/>';
    row += '<div class="col-md-12">';
    row += '<div class="form-group row">';
    row += '<label for="inputValue" class="col-md-1 control-label">Subject</label>';
    row += '<div class="col-md-4">';
    row += '<select id="subject_id_' + value + '" name="subject_id_' + value + '" class="form-control">';
    row += '<option value=""><?php echo $this->lang->line("select"); ?></option>';

    subjectlist.forEach(function (subject) {
        var selected = "";
        if ((value === 3 && subject.id == 7) || (value === 7 && subject.id == 8)) {
            selected = "selected";
        } else if (subject_id == subject.id) {
            selected = "selected";
        }
        // var disabled = (assignedSubjects.includes(subject.id)) ? "disabled" : "";
        var disabled = '';
        row += '<option value="' + subject.id + '" ' + selected + ' ' + disabled + '>' + subject.name + ' (' + subject.type + ')</option>';
    });

    row += '</select>';
    row += '</div>';
    row += '<label for="inputKey" class="col-md-1 control-label">Teacher</label>';
    row += '<div class="col-md-4">';
    row += '<select id="teacher_id_' + value + '" name="teacher_id_' + value + '" class="form-control select_teacher" >';
    row += '<option value=""><?php echo $this->lang->line("select"); ?></option>';

    <?php foreach ($teacherlist as $teacher) { ?>
        var selected = "";
        if ((value === 3 && '<?php echo $teacher["id"]; ?>' == 12) || (value === 7 && '<?php echo $teacher["id"]; ?>' == 13)) {
            selected = "selected";
        } 
        // Auto-select class teacher for first row (index 0)
        else if (value === 0 && class_teacher_id === '<?php echo $teacher["id"]; ?>') {
            selected = "selected";
        }
        else if (teacher_id == '<?php echo $teacher["id"]; ?>') {
            selected = "selected";
        }
        row += '<option value="<?php echo $teacher["id"]; ?>" ' + selected + '><?php echo str_replace("'", "\\'", $teacher["name"] . " " . $teacher["surname"] . "(" . $teacher["employee_id"] . ")"); ?></option>';
    <?php } ?>

    row += '</select>';
    row += '</div>';
    row += '<div class="col-md-2"><button id="btnRemove" style="" class="btn btn-sm btn-danger" type="button"><i class="fa fa-trash"></i></button></div>';
    row += '</div>';
    row += '</div>';
    row += '</div>';

    $("#TextBoxContainer").append(row);
}



    $(document).on('change', '#section_id', function (e) {
        resetForm();
    });

    function resetForm() {
        $('#TextBoxContainer').html("");
        $('#btnAdd').hide();
        $('.save_button').hide();
    }

    $(document).on('click', '#btnRemove', function () {
        $(this).parents('.form-group').remove();
    });

    $(document).ready(function() {
    $('#section_id').select2({
        // placeholder: "Please Select Caste Category",
        allowClear: true,
        closeOnSelect: false
    });

   
});

    $(document).ready(function() {
    function initSelect2() {
        $('.select_teacher').select2({
            allowClear: true,
            closeOnSelect: false
        });
    }

   
});


     $(function () {
        $(document).on("click", "#btnAdd", function () {
            var lenght_div = $('#TextBoxContainer .app').length;
            var div = GetDynamicTextBox(lenght_div);
            $("#TextBoxContainer").append(div);
            setTimeout(function () {
            $('.select_teacher').select2({
                allowClear: true,
                closeOnSelect: false
            });
        }, 100);
        });
        $(document).on("click", "#btnGet", function () {
            var values = "";
            $("input[name=DynamicTextBox]").each(function () {
                values += $(this).val() + "\n";
            });
        });
        $("body").on("click", ".remove", function () {
            $(this).closest("div").remove();
        });
    });
    function GetDynamicTextBox(value) {
    // Get the list of already assigned subjects
    var assignedSubjects = [];
    $('select[name^="subject_id_"]').each(function () {
        var selectedValue = $(this).val();

        if (selectedValue) {
            assignedSubjects.push(selectedValue);
        }
    });
    

    var row = "";
    row += '<div class="form-group app">';
    row += '<input type="hidden" name="i[]" value="' + value + '"/>';
    row += '<input type="hidden" name="row_id_' + value + '" value="0"/>';
    row += '<div class="col-md-12">';
    row += '<div class="form-group row">';
    row += '<label for="inputValue" class="col-md-1 control-label">Subject</label>';
    row += '<div class="col-md-4">';
    row += '<select id="subject_id_' + value + '" name="subject_id_' + value + '" class="form-control">';
    row += '<option value=""><?php echo $this->lang->line("select"); ?></option>';

    globalSubjects.forEach(function (subject) {
        // var disabled = assignedSubjects.includes(subject.subject_id.toString()) ? "disabled" : "";
        var disabled = "";
        row += '<option value="' + subject.subject_id + '" ' + disabled + '>' + subject.name + ' (' + subject.type + ')</option>';
    });

    row += '</select>';
    row += '</div>';
    row += '<label for="inputKey" class="col-md-1 control-label">Teacher</label>';
    row += '<div class="col-md-4">';
    row += '<select id="teacher_id_' + value + '" name="teacher_id_' + value + '" class="form-control select_teacher" >';
    row += '<option value=""><?php echo $this->lang->line("select"); ?></option>';

    <?php foreach ($teacherlist as $teacher) { ?>
        row += '<option value="<?php echo $teacher["id"]; ?>"><?php echo str_replace("'", "\\'", $teacher["name"] . " " . $teacher["surname"] . "(" . $teacher["employee_id"] . ")"); ?></option>';
    <?php } ?>

    row += '</select>';
    row += '</div>';
    row += '<div class="col-md-2"><button id="btnRemove" style="" class="btn btn-sm btn-danger" type="button"><i class="fa fa-trash"></i></button></div>';
    row += '</div>';
    row += '</div>';
    row += '</div>';
    return row;
}
</script>