<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
$language = $this->customlib->getLanguage();
$language_name = $language["short_code"];
?>
<style type="text/css">

     @media print {
               .no-print {
                 visibility: hidden !important;
                  display:none !important;
               }
            }
</style>


<style type="text/css">
    body {
    font-family: Arial, sans-serif;
    margin: 20px;
}

.voucher {
    border: 1px solid #000;
    padding: 20px;
    
    margin: 0 auto;
}

.header, .details, .account, .particulars, .total, .signature {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.header .debit-credit {
    flex: 1;
}

.header .title {
    flex: 1;
    text-align: center;
    font-weight: bold;
}

.header .date {
    flex: 1;
    text-align: right;
}

.details {
    padding: 2px;
    border: 2px solid black;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
}

.details .name-address, .details .voucher-file {
    flex: 1;
}

.details .name-address p, .details .voucher-file p {
    margin: 5px 0;
}

.account {
    text-align: center;
}

.particulars table {
    width: 100%;
    border-collapse: collapse;
}

.particulars th, .particulars td {
    border: 1px solid #000;
    padding: 5px;
    text-align: center;
}

.total {
    text-align: left;
    margin-top: 20px;
}

.total p {
    margin: 5px 0;
}

.signature {
    justify-content: space-evenly;
    margin-top: 20px;
}

.signature p {
    margin: 0 10px;
}

button {
    display: block;
    margin: 20px auto;
    padding: 10px 20px;
    font-size: 16px;
    cursor: pointer;
}
.rupees-in-words {
    font-family: "Times New Roman", Times, serif;
    font-style: italic;
    text-align: left;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">

    <section class="content-header">
        <h1>
            <i class="fa fa-usd"></i> Student Checkup</h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            
                <div class="col-md-4">
                    <!-- Horizontal Form -->
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Edit Student Checkup</h3>
                        </div><!-- /.box-header -->

                        <form id="form1" action="<?php echo base_url() ?>admin/Students_medical_checkup/edit/<?=$editData->id?>"  id="employeeform" name="employeeform" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                            <div class="box-body">
                                <?php if ($this->session->flashdata('msg')) { ?>
                                    <?php echo $this->session->flashdata('msg') ?>
                                <?php } ?>
                                <?php
                                if (isset($error_message)) {
                                    echo "<div class='alert alert-danger'>" . $error_message . "</div>";
                                }
                                ?>
                                <?php echo $this->customlib->getCSRF(); ?>

                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>

                                    <select autofocus="" id="class_id" name="class_id" class="form-control" >
                                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                                                                                        <?php
                                                    $count = 0;
                                                    foreach ($classlist as $class) {
                                                        ?>
                                                        <option value="<?php echo $class['id'] ?>" <?php if ($editData->class_id == $class['id']) {
                                                            echo "selected=selected";
                                                        }
                                                        ?>><?php echo $class['class'] ?></option>
                                                                                                            <?php
                                                    $count++;
                                                    }
                                                    ?>
                                     </select>
                                     <span class="text-danger" id="error_class_id"></span>
                                </div>


                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('section'); ?></label><small class="req"> *</small>

                                    <select  id="section_id" name="section_id" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('section_id'); ?></span>

                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('student'); ?> <?php echo $this->lang->line('name'); ?></label><small class="req"> *</small>
                                    
                                    <select id="student_session_id" name="student_session_id" class="form-control" >
                                        <option value="">Please Select student name</option>
                                
                                   </select>
                                    
                                    <span class="text-danger"><?php echo form_error('student_session_id'); ?></span>
                                </div>


                                

                               
                                
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('weight'); ?><small class="req"> *</small></label>
                                    <input id="weight" name="weight" placeholder="" type="number" class="form-control"  value="<?php echo $editData->weight; ?>"  />
                                    <span class="text-danger"><?php echo form_error('weight'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Temprature(°C)<small class="req"> *</small></label>
                                    <input id="temprature" name="temprature" placeholder="" type="text" class="form-control"  value="<?php echo $editData->temprature; ?>"  />
                                    <span class="text-danger"><?php echo form_error('temprature'); ?></span>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1">B.P.<small class="req"> *</small></label>
                                    <input id="bp" name="bp" placeholder="" type="text" class="form-control"  value="<?php echo $editData->bp; ?>"  />
                                    <span class="text-danger"><?php echo form_error('bp'); ?></span>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1">SPO2<small class="req"> *</small></label>
                                    <input id="spo2" name="spo2" placeholder="" type="text" class="form-control"  value="<?php echo $editData->spo2; ?>"  />
                                    <span class="text-danger"><?php echo form_error('spo2'); ?></span>
                                </div>

                                <div class="form-group" id="TextBoxContainer">
								    <label for="symptoms">Symptoms<small class="req"> *</small></label>

								    
								    <?php
								    $symptoms = $editData->symptoms;
								    $symptomArray = explode(',', $symptoms);
								    foreach ($symptomArray as $index => $symptom) {
								        $value = trim($symptom); // Clean up any extra spaces
								        ?>
								        <div class="input-grp mb-3">
								            <input type="text" class="form-control" name="symptoms[]" placeholder="Enter symptom" value="<?php echo htmlspecialchars($value); ?>" />
								            <div class="input-group-append">
								                <button class="btn btn-sm btn-danger btnRemove pull-right" type="button"><i class="fa fa-trash"></i></button>
								            </div>
								        </div>
								        <?php
								    }
								    ?>
								</div>

								<!-- Add Button Outside the Input Group -->
								<div class="form-group">
								    <button id="btnAdd" class="btn btn-primary btn-sm" type="button">
								        <i class="fa fa-plus"></i> <?php echo $this->lang->line('add'); ?>
								    </button>
								</div>

								<div class="form-group">
								    <label for="exampleInputEmail1">Diagnosis:<small class="req"> *</small></label>
								    <textarea id="diagnosis" name="diagnosis" placeholder=""  class="form-control"  ><?=$editData->diagnosis;?></textarea>
								    <span class="text-danger"><?php echo form_error('diagnosis'); ?></span>
								</div>

								<div class="form-group" id="prescriptionContainer">
								    <label for="prescription">Prescription:<small class="req"> *</small></label>

								    <!-- Initial Symptom Input -->
								    <?php
								    $prescription = $editData->prescription;
								    $prescriptionArray = explode(',', $prescription);
								    foreach ($prescriptionArray as $index => $prescription) {
								        $value = trim($prescription); // Clean up any extra spaces
								        ?>
								        <div class="input-grop mb-3">
								            <input id="prescription" name="prescription[]"  type="text" class="form-control" placeholder="Enter prescription" value="<?php echo htmlspecialchars($value); ?>" />
								        	<div class="input-group-append">
								                <button class="btn btn-sm btn-danger btnprescriptionRemove pull-right" type="button"><i class="fa fa-trash"></i></button>
								            </div>
								        </div>
								        <?php
								    }
								    ?>
								    
								        
								        
								    

								   
								</div>

								<!-- Add Button Outside the Input Group -->
								<div class="form-group">
								    <button id="prescriptionAdd" class="btn btn-primary btn-sm" type="button">
								        <i class="fa fa-plus"></i> <?php echo $this->lang->line('add'); ?>
								    </button>
								</div>

                                
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('remark'); ?></label>
                                    <textarea class="form-control" id="remark" name="remark" placeholder="" rows="3" placeholder="Enter ..."><?php echo $editData->remark; ?></textarea>
                                    <span class="text-danger"></span>
                                </div>
                            </div><!-- /.box-body -->

                            <div class="box-footer">
                                <button type="submit" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                            </div>
                        </form>
                    </div>

                </div>
                <!--/.col (right) -->
                <!-- left column -->
            
            <div class="col-md-8">
                <!-- general form elements -->
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix"> Student Medical Checkup</h3>
                        <div class="box-tools pull-right">
                        </div><!-- /.box-tools -->
                    </div><!-- /.box-header -->
                    <div class="box-body">
                       
                        <div class="table-responsive mailbox-messages">
                                 <table class="table table-striped table-bordered table-hover" data-export-title="Student Medical Checkup">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('student'); ?> <?php echo $this->lang->line('name'); ?>
                                        </th>
                                         <th><?php echo $this->lang->line('class'); ?>
                                        </th>
                                        <th><?php echo $this->lang->line('section'); ?>
                                        </th>
                                        <th><?php echo $this->lang->line('weight'); ?>
                                        </th>
                                        <th>Temprature
                                        </th>
                                        <th>Bp(Blood Pressure)
                                        </th>
                                        <th>Symptoms
                                        </th>
                                        <th>Diagnosis
                                        </th>
                                        <th>Prescription
                                        </th>
                                        <th>Remark
                                        </th>
                                        <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                	<?php foreach($resultlist as $row){

                                		$fullName=$row['firstname'] . " " . $row['middlename'] . " " . $row['lastname'];
                                		$symptoms=explode(',', $row['symptoms']);

                                		?>

                                	
                                	<tr>
                                		<td class="mailbox-date"><?=$fullName?></td>
                                		<td class="mailbox-date"><?=$row['class']?></td>
                                		<td class="mailbox-date"><?=$row['section']?></td>
                                		<td class="mailbox-date"><?=$row['weight']?></td>
                                		<td class="mailbox-date"><?=$row['temprature']?></td>
                                		<td class="mailbox-date"><?=$row['bp']?></td>
                                		<td class="mailbox-date"><?=$row['symptoms']?></td>
                                		<td class="mailbox-date"><?=$row['diagnosis']?></td>
                                		<td class="mailbox-date"><?=$row['prescription']?></td>
                                		<td class="mailbox-date"><?=$row['remark']?></td>
                                		<td class="mailbox-date pull-right no-print">
                                                    
                                                        <a data-placement="left" href="<?php echo base_url(); ?>admin/Students_medical_checkup/edit/<?php echo $row['id'] ?>" class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>">
                                                            <i class="fa fa-pencil"></i>
                                                        </a>
                                                   
                                                        <a data-placement="left" href="<?php echo base_url(); ?>admin/Students_medical_checkup/delete/<?php echo $row['id'] ?>"class="btn btn-default btn-xs"  data-toggle="tooltip" title="<?php echo $this->lang->line('delete'); ?>" onclick="return confirm('<?php echo $this->lang->line('delete_confirm') ?>');">
                                                            <i class="fa fa-remove"></i>
                                                        </a>
                                                    
                                                </td>
                                		
                                	</tr>
                                	<?php } ?>
                                </tbody>
                            </table><!-- /.table -->
                        </div><!-- /.mail-box-messages -->
                    </div><!-- /.box-body -->
                </div>
            </div><!--/.col (left) -->
            <!-- right column -->

        </div>

    </section><!-- /.content -->
</div><!-- /.content-wrapper -->

<div class="modal" id="voucher_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Credit Voucher</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Voucher</title>
    <!-- <link rel="stylesheet" href="styles.css"> -->
</head>
<body>
    <div class="voucherModule">
        <div class="header">
            <div class="debit-credit">
                <p style="line-height: 1px;font-weight: bold;">CREDIT</p>
            </div>
            <div class="title" style="
    margin-left: 110px;
    background-color: black;
    color: white;
    border-radius: 25px;
    font-size: 20px;
">
                <p>VOUCHER</p>
            </div>
            <div class="date" style="
    margin-right: 136px;
">
                <p>Date :<label id="voucher_date"></label></p>
            </div>
        </div>
        <div class="details">
            <div class="name-address">
                <p>Name : <label id="voucher_name"></label></p>
                <p>Address : <input type="text" name="address" id="address" class="form-control"></p>
            </div>
            <div class="voucher-file">
                <p>Voucher No. : <span id="voucher_no" name="voucher_no"></span></p>
                <p>File No. : <input type="text" name="file_no" id="file_no" class="form-control"></p>
            </div>
        </div>
        <div class="account">
            <p>Credit A/c: <div class="col-md-12"><textarea class="form-control" id="ac_no" readonly></textarea></div> </p>
        </div>
        <div class="particulars">
            <table>
                <thead>
                    <tr>
                        <th style="height: 35px;">PARTICULARS</th>
                        <th>Amount <hr> <b style="margin-left: -55px;margin-right: 40px;">RS</b> &nbsp; <b style="margin-right: -55px;margin-left: 30px;">P</b></th>
                       
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="text-align: left;">Cheque/Cash Paid:<label id="voucher_description"></label></td>
                        <td id="voucher_amount"></td>
                    </tr>
                    
                    <tr>
                        <td>
                              <p class="rupees-in-words">Rupees in words : <label id="wordsAmount"></label> <label>Rupees Only</label><b style="margin-right: -223px;margin-left: 20px;text-align:right;">Total</b></p> 
                               
                        </td>
                        <td id="TotalAmt"></td>
                        <input type="hidden" name="" id="voucher_type" value="credit">
                      
                        
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="signature">
            <p>Prepared by</p>
            <p>Passed by</p>
            <p>Payee’s Signature</p>
        </div>
    </div>
    
</body>
</html>

      </div>
      <div class="modal-footer">
        <button  id="printbtn">Print</button>
      </div>
    </div>
  </div>
</div>
<script>

   $(function () {
    // Add dynamic symptom input field
    
    $(document).on("click", "#prescriptionAdd", function () {
        var inputField = GetDynamicprescriptionBox();
        $("#prescriptionContainer").append(inputField); // Append the input field
    });
    $(document).on("click", "#btnAdd", function () {
        var inputField = GetDynamicTextBox();
        $("#TextBoxContainer").append(inputField); // Append the input field
    });

    // Remove dynamic input field
    $(document).on('click', '.btnRemove', function () {
        $(this).closest('.input-grp').remove(); // Remove the closest input group
    });

    $(document).on('click', '.btnprescriptionRemove', function () {
        $(this).closest('.input-grop').remove(); // Remove the closest input group
    });

    // Function to generate a new dynamic input field
    function GetDynamicTextBox() {
        return '<div class="input-grp mb-3">' + 
            '<input type="text" class="form-control" name="symptoms[]" placeholder="Enter symptom">' +
            '<div class="input-group-append">' +
            '<button class="btn btn-sm btn-danger btnRemove pull-right" type="button"><i class="fa fa-trash"></i></button>' +
            '</div>' +
            '</div>';
    }

    $(document).ready(function() {
    $('#student_session_id').select2({
        // placeholder: "Please Select Caste Category",
        allowClear: true,
        closeOnSelect: false
    });
});


    function GetDynamicprescriptionBox() {
        return '<div class="input-grop mb-3">' + 
            '<input type="text" class="form-control" name="prescription[]" placeholder="Enter prescription">' +
            '<div class="input-group-append">' +
            '<button class="btn btn-sm btn-danger btnprescriptionRemove pull-right" type="button"><i class="fa fa-trash"></i></button>' +
            '</div>' +
            '</div>';
    }
});




	function getSectionByClass(class_id, section_id) {
    if (class_id != "" && section_id != "") {
        $('#section_id').html("");
        var base_url = '<?php echo base_url() ?>';
        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
        $.ajax({
            type: "GET",
            url: base_url + "sections/getByClass",
            data: {'class_id': class_id},
            dataType: "json",
            success: function (data) {
            	getStudentByClassSection(class_id,section_id);
                $.each(data, function (i, obj)
                {
                    var sel = "";
                    if (section_id == obj.section_id) {
                        sel = "selected";
                    }
                    div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                });
                $('#section_id').append(div_data);
            }
        });
    }
}
$(document).ready(function () {
    var class_id = $('#class_id').val();
    var section_id = '<?php echo $editData->section_id ?>';
    getSectionByClass(class_id, section_id);
    $(document).on('change', '#class_id', function (e) {
        $('#section_id').html("");
        var class_id = $(this).val();
        var base_url = '<?php echo base_url() ?>';
        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
        $.ajax({
            type: "GET",
            url: base_url + "sections/getByClass",
            data: {'class_id': class_id},
            dataType: "json",
            success: function (data) {
                $.each(data, function (i, obj)
                {
                	
                    div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                });
                $('#section_id').append(div_data);
            }
        });
    });


    $(document).on('change', '#section_id', function (e) {
        $('#student_session_id').html("");
        var class_id = $('#class_id').val();
        var section_id = $(this).val();
        var base_url = '<?php echo base_url() ?>';
        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
        $.ajax({
            type: "POST",
            url: base_url + "admin/Students_medical_checkup/getStudentByClassSection",
            data: {'class_id': class_id,'section_id':section_id},
            dataType: "json",
            success: function (data) {
                $.each(data, function (i, obj)
                {
                	var fullName = obj.firstname + " ";
    
				    // Check if the middle name exists and is not empty
				    if (obj.middlename && obj.middlename.trim() !== "") {
				        fullName += obj.middlename + " ";
				    }

				    if (obj.lastname && obj.lastname.trim() !== "") {
				        fullName += obj.lastname + " ";
				    }
    
				    
                    div_data += "<option value=" + obj.student_session_id + ">" + fullName + "</option>";
                });
                $('#student_session_id').append(div_data);
            }
        });
    });


});

function getStudentByClassSection(class_id, section_id) {

	    var base_url = '<?php echo base_url() ?>';
        var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
        var student_session_id='<?= $editData->student_session_id?>';
        $.ajax({
            type: "POST",
            url: base_url + "admin/Students_medical_checkup/getStudentByClassSection",
            data: {'class_id': class_id,'section_id':section_id},
            dataType: "json",
            success: function (data) {
                $.each(data, function (i, obj)
                {
                	var fullName = obj.firstname + " ";
    
				    // Check if the middle name exists and is not empty
				    if (obj.middlename && obj.middlename.trim() !== "") {
				        fullName += obj.middlename + " ";
				    }

				    if (obj.lastname && obj.lastname.trim() !== "") {
				        fullName += obj.lastname + " ";
				    }

				    var sel="";
				    if (student_session_id==obj.student_session_id) {
				    	sel="selected";
				    }
    
				    
                    div_data += "<option value=" + obj.student_session_id + " " + sel + ">" + fullName + "</option>";
                });
                $('#student_session_id').empty().append(div_data).trigger('change');
                // $('#student_session_id').append(div_data);
            }
        });

}



    $(document).on('click','.voucher_btn',function(){
        var voucher_no =$('#voucher_no').val('');
        var ac_no =$('#ac_no').val('');
        var file_no =$('#file_no').val('');
        var address =$('#address').val('');
        var id=$(this).attr('data-id');
        var voucher_no = padNumber(id, 5);
        $('#voucher_no').html(voucher_no);
        $.ajax({
    url: '<?=base_url()?>Admin/Income/getIncomeData', // URL of the server-side script
    type: 'POST',
    dataType: 'json', // Ensure the response is parsed as JSON
    data: { 
        id: id,
        voucher_no:voucher_no
     }, // Data to be sent to the server

    success: function(response) {
        // Handle the server's response
        
        $('#wordsAmount').html(response.wordsAmount);
        $('#voucher_name').html(response.name);
        $('#voucher_amount').html(response.amount);
        $('#voucher_date').html(response.date);
        $('#voucher_description').html(response.note);
        $('#TotalAmt').html(response.amount);
        $('#address').val(response.voucher_data.address);
        $('#file_no').val(response.voucher_data.file_no);
        $('#ac_no').val(response.account_number);

        $('#voucher_modal').modal('show');

    },
    error: function(jqXHR, textStatus, errorThrown) {
        // Handle errors
        $('#response').html('An error occurred: ' + textStatus + ' - ' + errorThrown);
    }
});

        
    });

    function padNumber(num, length) {
                return String(num).padStart(length, '0');
            }

    $('#printbtn').on('click', function() {


        var printContents = $('.voucherModule').clone();

// Replace input elements with their values
printContents.find('input, textarea').each(function() {
    var $input = $(this);
    $input.replaceWith($('<span>').text($input.val()));
});

var printWindow = window.open('', '', 'height=600,width=800');
printWindow.document.write('<html><head><title>Print</title>');
printWindow.document.write('<link rel="stylesheet" href="styles.css" type="text/css" />'); // Link to your CSS file
printWindow.document.write('<style>' +
    'body { font-family: Arial, sans-serif; margin: 20px; }' +
    '.voucher { border: 1px solid #000; padding: 20px; margin: 0 auto; }' +
    '.header, .details, .account, .particulars, .total, .signature { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }' +
    '.header .debit-credit { flex: 1; }' +
    '.header .title { flex: 1; text-align: center; font-weight: bold; }' +
    '.header .date { flex: 1; text-align: right; }' +
    '.details { padding: 2px; border: 2px solid black; display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 20px; }' +
    '.details .name-address, .details .voucher-file { flex: 1; }' +
    '.details .name-address p, .details .voucher-file p { margin: 5px 0; }' +
    '.account { text-align: center; }' +
    '.particulars table { width: 100%; border-collapse: collapse; }' +
    '.particulars th, .particulars td { border: 1px solid #000; padding: 5px; text-align: center; }' +
    '.total { text-align: left; margin-top: 20px; }' +
    '.total p { margin: 5px 0; }' +
    '.signature { justify-content: space-evenly; margin-top: 20px; }' +
    '.signature p { margin: 0 10px; }' +
    '.rupees-in-words { font-family: "Times New Roman", Times, serif; font-style: italic; text-align: left; }' +
    'button { display: block; margin: 20px auto; padding: 10px 20px; font-size: 16px; cursor: pointer; }' +
    '</style>'); // Add any inline styles here
printWindow.document.write('</head><body >');
printWindow.document.write(printContents.html());
printWindow.document.write('</body></html>');
printWindow.document.close();
printWindow.print();




        var voucher_name=$('#voucher_name').html();
        var voucher_date=$('#voucher_date').html();
        var voucher_amount=$('#voucher_amount').html();
        var description=$('#voucher_description').html();
        var voucher_no =$('#voucher_no').html();
        var ac_no =$('#ac_no').val();
        var file_no =$('#file_no').val();
        var voucher_type =$('#voucher_type').val();
        var address =$('#address').val();


        $.ajax({
    url: '<?=base_url()?>Admin/Income/createVoucher', // URL of the server-side script
    type: 'POST',
    dataType: 'json', // Ensure the response is parsed as JSON
    data: { 
        voucher_name: voucher_name,
        voucher_date: voucher_date,
        voucher_amount: voucher_amount,
        voucher_type: voucher_type,
        description: description,
        voucher_no: voucher_no,
        ac_no: ac_no,
        file_no: file_no,
        address: address

     }, // Data to be sent to the server

    success: function(response) {
        

    },
    error: function(jqXHR, textStatus, errorThrown) {
        // Handle errors
        $('#response').html('An error occurred: ' + textStatus + ' - ' + errorThrown);
    }
});
        
        
    });

    
</script>