<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
$language = $this->customlib->getLanguage();
$language_name = $language["short_code"];
?>
<style type="text/css">

     @media print {
               .no-print {
                 visibility: hidden !important;
                  display:none !important;
               }
            }
</style>


<style type="text/css">
    body {
    font-family: Arial, sans-serif;
    margin: 20px;
}

.voucher {
    border: 1px solid #000;
    padding: 20px;
    
    margin: 0 auto;
}

.header, .details, .account, .particulars, .total, .signature {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.header .debit-credit {
    flex: 1;
}

.header .title {
    flex: 1;
    text-align: center;
    font-weight: bold;
}

.header .date {
    flex: 1;
    text-align: right;
}

.details {
    padding: 2px;
    border: 2px solid black;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
}

.details .name-address, .details .voucher-file {
    flex: 1;
}

.details .name-address p, .details .voucher-file p {
    margin: 5px 0;
}

.account {
    text-align: center;
}

.particulars table {
    width: 100%;
    border-collapse: collapse;
}

.particulars th, .particulars td {
    border: 1px solid #000;
    padding: 5px;
    text-align: center;
}

.total {
    text-align: left;
    margin-top: 20px;
}

.total p {
    margin: 5px 0;
}

.signature {
    justify-content: space-evenly;
    margin-top: 20px;
}

.signature p {
    margin: 0 10px;
}

button {
    display: block;
    margin: 20px auto;
    padding: 10px 20px;
    font-size: 16px;
    cursor: pointer;
}
.rupees-in-words {
    font-family: "Times New Roman", Times, serif;
    font-style: italic;
    text-align: left;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">

    <section class="content-header">
        <h1>
            <i class="fa fa-usd"></i> <?php echo $this->lang->line('income'); ?></h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <?php
            if ($this->rbac->hasPrivilege('income', 'can_add')) {
                ?>
                <div class="col-md-4">
                    <!-- Horizontal Form -->
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo $this->lang->line('add'); ?> Loan</h3>
                        </div><!-- /.box-header -->

                        <form id="form1" action="<?php echo base_url() . "admin/Staff_loan/edit/" . $id; ?>"  id="employeeform" name="employeeform" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                            <div class="box-body">
                                <?php if ($this->session->flashdata('msg')) { ?>
                                    <?php echo $this->session->flashdata('msg') ?>
                                <?php } ?>
                                <?php
                                if (isset($error_message)) {
                                    echo "<div class='alert alert-danger'>" . $error_message . "</div>";
                                }
                                ?>
                                <?php echo $this->customlib->getCSRF(); ?>

                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('staff'); ?></label><small class="req"> *</small>

                                    <select autofocus="" id="staff_id" name="staff_id" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($stafflist as $staff) {
                                            ?>
                                            <option value="<?php echo $staff['id'] ?>"<?php
                                            if ($loan['staff_id'] == $staff['id']) {
                                                echo "selected = selected";
                                            }
                                            ?>><?php echo $staff['name'].' '. $staff['surname'].'('.$staff['user_type'].')'?></option>

                                            <?php
                                            //$count++;
                                        }
                                        ?>
                                    </select><span class="text-danger"><?php echo form_error('staff_id'); ?></span>

                                </div>

                                
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Loan <?php echo $this->lang->line('amount'); ?><small class="req"> *</small></label>
                                    <input id="loan_amount" name="loan_amount" placeholder="" type="text" class="form-control"  value="<?php echo $loan['loan_amount']; ?>" />
                                    <span class="text-danger"><?php echo form_error('loan_amount'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Loan Emi<small class="req"> *</small></label>
                                    <input id="emi_amount" name="emi_amount" placeholder="" type="text" class="form-control"  value="<?php echo $loan['emi_amount']; ?>" />
                                    <span class="text-danger"><?php echo form_error('emi_amount'); ?></span>
                                </div>
                                
                            </div><!-- /.box-body -->

                            <div class="box-footer">
                                <button type="submit" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                            </div>
                        </form>
                    </div>

                </div><!--/.col (right) -->
                <!-- left column -->
            <?php } ?>
            <div class="col-md-<?php
            if ($this->rbac->hasPrivilege('income', 'can_add')) {
                echo "8";
            } else {
                echo "12";
            }
            ?>">
                <!-- general form elements -->
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix">Loan List</h3>
                        <div class="box-tools pull-right">
                        </div><!-- /.box-tools -->
                    </div><!-- /.box-header -->
                    <div class="box-body">
                       
                        <div class="table-responsive mailbox-messages">
                                 <table class="table table-striped table-bordered table-hover loan-list" data-export-title="Loan List">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('staff'); ?>
                                        
                                        </th>
                                         <th>Loan Amount
                                        </th>
                                        <th>Remaining Amount
                                        </th>
                                        <th>EMI Amount
                                        </th>
                                        
                                        <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table><!-- /.table -->
                        </div><!-- /.mail-box-messages -->
                    </div><!-- /.box-body -->
                </div>
            </div><!--/.col (left) -->
            <!-- right column -->

        </div>

    </section><!-- /.content -->
</div><!-- /.content-wrapper -->

<div class="modal" id="voucher_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Credit Voucher</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Voucher</title>
    <!-- <link rel="stylesheet" href="styles.css"> -->
</head>
<body>
    <div class="voucherModule">
        <div class="header">
            <div class="debit-credit">
                <p style="line-height: 1px;font-weight: bold;">CREDIT</p>
            </div>
            <div class="title" style="
    margin-left: 110px;
    background-color: black;
    color: white;
    border-radius: 25px;
    font-size: 20px;
">
                <p>VOUCHER</p>
            </div>
            <div class="date" style="
    margin-right: 136px;
">
                <p>Date :<label id="voucher_date"></label></p>
            </div>
        </div>
        <div class="details">
            <div class="name-address">
                <p>Name : <label id="voucher_name"></label></p>
                <p>Address : <input type="text" name="address" id="address" class="form-control"></p>
            </div>
            <div class="voucher-file">
                <p>Voucher No. : <span id="voucher_no" name="voucher_no"></span></p>
                <p>File No. : <input type="text" name="file_no" id="file_no" class="form-control"></p>
            </div>
        </div>
        <div class="account">
            <p>Credit A/c: <div class="col-md-12"><textarea class="form-control" id="ac_no" readonly></textarea></div> </p>
        </div>
        <div class="particulars">
            <table>
                <thead>
                    <tr>
                        <th style="height: 35px;">PARTICULARS</th>
                        <th>Amount <hr> <b style="margin-left: -55px;margin-right: 40px;">RS</b> &nbsp; <b style="margin-right: -55px;margin-left: 30px;">P</b></th>
                       
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="text-align: left;">Cheque/Cash Paid:<label id="voucher_description"></label></td>
                        <td id="voucher_amount"></td>
                    </tr>
                    
                    <tr>
                        <td>
                              <p class="rupees-in-words">Rupees in words : <label id="wordsAmount"></label> <label>Rupees Only</label><b style="margin-right: -223px;margin-left: 20px;text-align:right;">Total</b></p> 
                               
                        </td>
                        <td id="TotalAmt"></td>
                        <input type="hidden" name="" id="voucher_type" value="credit">
                      
                        
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="signature">
            <p>Prepared by</p>
            <p>Passed by</p>
            <p>Payee’s Signature</p>
        </div>
    </div>
    
</body>
</html>

      </div>
      <div class="modal-footer">
        <button  id="printbtn">Print</button>
      </div>
    </div>
  </div>
</div>
<script>
    
    $(document).on('click','.voucher_btn',function(){
        var voucher_no =$('#voucher_no').val('');
        var ac_no =$('#ac_no').val('');
        var file_no =$('#file_no').val('');
        var address =$('#address').val('');
        var id=$(this).attr('data-id');
        var voucher_no = padNumber(id, 5);
        $('#voucher_no').html(voucher_no);
        $.ajax({
    url: '<?=base_url()?>Admin/Income/getIncomeData', // URL of the server-side script
    type: 'POST',
    dataType: 'json', // Ensure the response is parsed as JSON
    data: { 
        id: id,
        voucher_no:voucher_no
     }, // Data to be sent to the server

    success: function(response) {
        // Handle the server's response
        
        $('#wordsAmount').html(response.wordsAmount);
        $('#voucher_name').html(response.name);
        $('#voucher_amount').html(response.amount);
        $('#voucher_date').html(response.date);
        $('#voucher_description').html(response.note);
        $('#TotalAmt').html(response.amount);
        $('#address').val(response.voucher_data.address);
        $('#file_no').val(response.voucher_data.file_no);
        $('#ac_no').val(response.account_number);

        $('#voucher_modal').modal('show');

    },
    error: function(jqXHR, textStatus, errorThrown) {
        // Handle errors
        $('#response').html('An error occurred: ' + textStatus + ' - ' + errorThrown);
    }
});

        
    });

    function padNumber(num, length) {
                return String(num).padStart(length, '0');
            }

    $('#printbtn').on('click', function() {


        var printContents = $('.voucherModule').clone();

// Replace input elements with their values
printContents.find('input, textarea').each(function() {
    var $input = $(this);
    $input.replaceWith($('<span>').text($input.val()));
});

var printWindow = window.open('', '', 'height=600,width=800');
printWindow.document.write('<html><head><title>Print</title>');
printWindow.document.write('<link rel="stylesheet" href="styles.css" type="text/css" />'); // Link to your CSS file
printWindow.document.write('<style>' +
    'body { font-family: Arial, sans-serif; margin: 20px; }' +
    '.voucher { border: 1px solid #000; padding: 20px; margin: 0 auto; }' +
    '.header, .details, .account, .particulars, .total, .signature { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }' +
    '.header .debit-credit { flex: 1; }' +
    '.header .title { flex: 1; text-align: center; font-weight: bold; }' +
    '.header .date { flex: 1; text-align: right; }' +
    '.details { padding: 2px; border: 2px solid black; display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 20px; }' +
    '.details .name-address, .details .voucher-file { flex: 1; }' +
    '.details .name-address p, .details .voucher-file p { margin: 5px 0; }' +
    '.account { text-align: center; }' +
    '.particulars table { width: 100%; border-collapse: collapse; }' +
    '.particulars th, .particulars td { border: 1px solid #000; padding: 5px; text-align: center; }' +
    '.total { text-align: left; margin-top: 20px; }' +
    '.total p { margin: 5px 0; }' +
    '.signature { justify-content: space-evenly; margin-top: 20px; }' +
    '.signature p { margin: 0 10px; }' +
    '.rupees-in-words { font-family: "Times New Roman", Times, serif; font-style: italic; text-align: left; }' +
    'button { display: block; margin: 20px auto; padding: 10px 20px; font-size: 16px; cursor: pointer; }' +
    '</style>'); // Add any inline styles here
printWindow.document.write('</head><body >');
printWindow.document.write(printContents.html());
printWindow.document.write('</body></html>');
printWindow.document.close();
printWindow.print();




        var voucher_name=$('#voucher_name').html();
        var voucher_date=$('#voucher_date').html();
        var voucher_amount=$('#voucher_amount').html();
        var description=$('#voucher_description').html();
        var voucher_no =$('#voucher_no').html();
        var ac_no =$('#ac_no').val();
        var file_no =$('#file_no').val();
        var voucher_type =$('#voucher_type').val();
        var address =$('#address').val();


        $.ajax({
    url: '<?=base_url()?>Admin/Income/createVoucher', // URL of the server-side script
    type: 'POST',
    dataType: 'json', // Ensure the response is parsed as JSON
    data: { 
        voucher_name: voucher_name,
        voucher_date: voucher_date,
        voucher_amount: voucher_amount,
        voucher_type: voucher_type,
        description: description,
        voucher_no: voucher_no,
        ac_no: ac_no,
        file_no: file_no,
        address: address

     }, // Data to be sent to the server

    success: function(response) {
        

    },
    error: function(jqXHR, textStatus, errorThrown) {
        // Handle errors
        $('#response').html('An error occurred: ' + textStatus + ' - ' + errorThrown);
    }
});
        
        
    });

    ( function ( $ ) {
    'use strict';
    $(document).ready(function () {
        initDatatable('loan-list','admin/Staff_loan/getloanlist',[],[],100);
    });
} ( jQuery ) )
</script>