<style type="text/css">
    .table .pull-right {
        text-align: initial;
        width: auto;
        margin-bottom: 3px
    }
</style>

<?php
$language      = $this->customlib->getLanguage();
$language_name = $language["short_code"];
?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-flask"></i> <?php echo $this->lang->line('manage_lesson_plan'); ?>
        </h1>
    </section>
    <section class="content">
        <div class="box box-primary">
            <div class="box-header">
                <h3 class="box-title"><i class="fa fa-search"></i>Your Current Session is 19 </h3>
            </div>
            <form class="assign_teacher_form" action="<?php echo site_url('admin/SessionCopy/transferModule'); ?>" method="post" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if ($this->session->flashdata('msg')) {
                            ?>
                                <?php echo $this->session->flashdata('msg');
                                $this->session->unset_userdata('msg');
                                ?>
                            <?php
                            }
                            ?>
                            <?php echo $this->customlib->getCSRF(); ?>
                        </div>
                        <!-- Select Module -->
                        <div class="col-md-4 col-lg-4 col-sm-6">
                            <div class="form-group">
                                <label>Select Module</label><small class="req"> *</small>
                                <select id="module_name" name="module_name" class="form-control">
                                        <option value="AcademicModule">1. Academic module needs to be copied as old session.</option>
                                        <option value=" LessonPlan">2.  Lesson Plan</option>
                                        <option value=" ExaminationModule">3.  Examination Needs to be carry forward but not the marks</option>
                                        <option value=" MaharashtraModule">4.  Maharashtra Pattern Examination Needs to be carry forward but not the marks</option>
                                        <option value=" CertificateModule">5.  Certificate Setting Needs to be updated as per session.</option>
                                        <option value=" FeesModule">6.  Fees Modules needs to be copied as Master Fees (Carry Forward)</option>
                                </select>
                                <span class="module_name_error text-danger"><?php echo form_error('module_name'); ?></span>
                            </div>
                        </div>

                         <!-- Select old session -->
                        <div class="col-md-3 col-lg-3 col-sm-6">
                            <div class="form-group">
                                <label>Select Old Session</label><small class="req"> *</small>
                                <select id="old_session_id" name="old_session_id" class="form-control">
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php
                                    foreach ($sessionlist as $session) {
                                    ?>
                                        <option value="<?php echo $session['id'] ?>" <?php echo set_select('old_session_id', $session['id']); ?>>
                                            <?php echo $session['session'] ?>

                                        </option>
                                    <?php
                                    }
                                    ?>

                                </select>
                                <span class="old_session_id_error text-danger"><?php echo form_error('old_session_id'); ?></span>
                            </div>
                        </div>
                        <!-- Select New session -->
                        <div class="col-md-3 col-lg-3 col-sm-6">
                            <div class="form-group">
                                <label>Select New Session</label><small class="req"> *</small>
                                <select id="new_session_id" name="new_session_id" class="form-control">
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php
                                    foreach ($sessionlist as $session) {
                                    ?>
                                        <option value="<?php echo $session['id'] ?>" <?php echo set_select('new_session_id', $session['id']); ?>>
                                            <?php echo $session['session'] ?>

                                        </option>
                                    <?php
                                    }
                                    ?>

                                </select>
                                <span class="new_session_id_error text-danger"><?php echo form_error('new_session_id'); ?></span>
                            </div>
                        </div> <!-- Select New session -->
                        <div class="col-md-2 col-lg-2 col-sm-6 m-t-5" style="text-align: center;position: absolute;top: 10vh;right: 0;">
                              <button type="submit" id="transfer" name="transfer" value="transfer" class="btn btn-primary btn-sm checkbox-toggle pull-right"><i class="fa fa-exchange"></i> Transfer</button>
                        </div>
                    </div>
                </div>  
            </form>
                </div>
  <div class="col-md-12">            
                <div class="box box-primary" id="sublist">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix">Transfer Logs</h3>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive mailbox-messages">
                            <div class="download_label"><?php echo $this->lang->line('subject_list'); ?></div>
                            <table class="table table-striped table-bordered table-hover example">
                                <thead>
                                    <tr>
                                        <th>Module Name</th>
                                        <th>Old Session Year</th>
                                        <th>Created Year</th>
                                        <th>Created At</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $count = 1;
                                    foreach ($getLogsData as $getValue) {
                                        ?>
                                        <tr>
                                            <td class="mailbox-name"><?php echo $getValue['module_name']?></td>
                                            <td class="mailbox-name"><?php echo $getValue['old_session_name']?></td>
                                            <td class="mailbox-name"><?php echo $getValue['new_session_name']?></td>
                                            <td class="mailbox-name"><?php echo $getValue['created_at']?></td>
                                        </tr>
                                        <?php
                                    }
                                    $count++;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div> 
  </section>
</div>

<script>
    $(document).ready(function(e) {

        var session_id = $('#old_session_id').val();
        var class_id = $('#old_class_id').val();
        var section_id = '<?php echo set_value('old_section_id', 0) ?>';
        var subject_group_id = '<?php echo set_value('old_subject_group_id', 0) ?>';
        var subject_id = '<?php echo set_value('old_subject_id', 0) ?>';

        getSectionByClass(class_id, section_id, 'old_section_id');
        getSubjectGroup(class_id, section_id, subject_group_id, 'old_subject_group_id', session_id);
        getsubjectBySubjectGroup(class_id, section_id, subject_group_id, subject_id, 'old_subject_id', session_id);
    });

    $(document).on('change', '#class_id', function(e) {
        $('#section_id').html("");
        var class_id = $(this).val();
        getSectionByClass(class_id, 0, 'section_id');
    });

    $(document).on('change', '#section_id', function() {
        let class_id = $('#class_id').val();
        let section_id = $(this).val();
        getSubjectGroup(class_id, section_id, 0, 'subject_group_id');
    });

    $(document).on('change', '#subject_group_id', function() {
        let class_id = $('#class_id').val();
        let section_id = $('#section_id').val();
        let subject_group_id = $(this).val();
        getsubjectBySubjectGroup(class_id, section_id, subject_group_id, 0, 'subject_id');
    });

    $(document).on('change', '#old_class_id', function(e) {
        $('#old_section_id').html("");
        var class_id = $(this).val();
        getSectionByClass(class_id, 0, 'old_section_id');
    });

    function getSectionByClass(class_id, section_id, select_control) {
        if (class_id != "") {
            $('#' + select_control).html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {
                    'class_id': class_id
                },
                dataType: "json",
                beforeSend: function() {
                    $('#' + select_control).addClass('dropdownloading');
                },
                success: function(data) {
                    $.each(data, function(i, obj) {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                    });
                    $('#' + select_control).append(div_data);
                },
                complete: function() {
                    $('#' + select_control).removeClass('dropdownloading');
                }
            });
        }
    }

    $(document).on('change', '#old_section_id', function() {
        let session_id = $('#old_session_id').val();
        let class_id = $('#old_class_id').val();
        let section_id = $(this).val();
        getSubjectGroup(class_id, section_id, 0, 'old_subject_group_id', session_id);
    });

    function getSubjectGroup(class_id, section_id, subjectgroup_id, subject_group_target, session_id = null) {
        console.log(class_id);
        console.log(section_id);
        if (class_id != "" && section_id != "") {
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: 'POST',
                url: base_url + 'admin/subjectgroup/getGroupByClassandSection',
                data: {
                    'class_id': class_id,
                    'section_id': section_id,
                    'session_id': session_id
                },
                dataType: 'JSON',
                beforeSend: function() {
                    // setting a timeout
                    $('#' + subject_group_target).html("").addClass('dropdownloading');
                },
                success: function(data) {
                    $.each(data, function(i, obj) {
                        var sel = "";
                        if (subjectgroup_id == obj.subject_group_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.subject_group_id + " " + sel + ">" + obj.name + "</option>";
                    });
                    $('#' + subject_group_target).append(div_data);
                },
                error: function(xhr) { // if error occured
                    alert("<?php echo $this->lang->line('error_occurred_please_try_again'); ?>");

                },
                complete: function() {
                    $('#' + subject_group_target).removeClass('dropdownloading');
                }
            });
        }
    }

    $(document).on('change', '#old_subject_group_id', function() {
        let session_id = $('#old_session_id').val();
        let class_id = $('#old_class_id').val();
        let section_id = $('#old_section_id').val();
        let subject_group_id = $(this).val();
        getsubjectBySubjectGroup(class_id, section_id, subject_group_id, 0, 'old_subject_id', session_id);
    });

    function getsubjectBySubjectGroup(class_id, section_id, subject_group_id, subject_group_subject_id, subject_target, session_id = null) {
        if (class_id != "" && section_id != "" && subject_group_id != "") {
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';

            $.ajax({
                type: 'POST',
                url: base_url + 'admin/subjectgroup/getGroupsubjects',
                data: {
                    'subject_group_id': subject_group_id,
                    "session_id": session_id
                },
                dataType: 'JSON',
                beforeSend: function() {
                    // setting a timeout
                    $('#' + subject_target).html("").addClass('dropdownloading');
                },
                success: function(data) {
                    console.log(data);
                    $.each(data, function(i, obj) {
                        var sel = "";
                        if (subject_group_subject_id == obj.id) {
                            sel = "selected";
                        }

                        code = '';
                        if (obj.code) {
                            code = " (" + obj.code + ") ";
                        }

                        div_data += "<option value=" + obj.id + " " + sel + ">" + obj.name + code + "</option>";
                    });
                    $('#' + subject_target).append(div_data);
                },
                error: function(xhr) { // if error occured
                    alert("<?php echo $this->lang->line('error_occurred_please_try_again'); ?>");

                },
                complete: function() {
                    $('#' + subject_target).removeClass('dropdownloading');
                }
            });
        }
    }
</script>

<script type="text/javascript">
    $("#save_lesson").on('submit', (function(e) {
        e.preventDefault();
        var form = $(this);
        var $this = form.find("button[type=submit]:focus");
        $this.button('loading');
        $.ajax({
            url: form.attr('action'),
            type: "POST",
            data: form.serialize(),
            dataType: 'json',
            beforeSend: function() {
                $this.button('loading');

            },
            success: function(res) {

                if (res.status == 0) {

                    var message = "";
                    $.each(res.error, function(index, value) {
                        message += value;
                    });
                    errorMsg(message);

                } else {

                    successMsg(res.message);
                    window.location.href = res.redirect_url;

                }
            },
            error: function(xhr) { // if error occured
                alert("<?php echo $this->lang->line('error_occurred_please_try_again'); ?>");
                $this.button('reset');
            },
            complete: function() {
                $this.button('reset');
            }

        });
    }));
</script>