<?php $currency_symbol = $this->customlib->getSchoolCurrencyFormat(); ?>
<!-- Content Wrapper. Contains page content -->
<style type="text/css">
    body {
    font-family: Arial, sans-serif;
    margin: 20px;
}

.voucher {
    border: 1px solid #000;
    padding: 20px;
    
    margin: 0 auto;
}

.header, .details, .account, .particulars, .total, .signature {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
}

.header .debit-credit {
    flex: 1;
}

.header .title {
    flex: 1;
    text-align: center;
    font-weight: bold;
}

.header .date {
    flex: 1;
    text-align: right;
}

.details {
    padding: 2px;
    border: 2px solid black;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 20px;
}

.details .name-address, .details .voucher-file {
    flex: 1;
}

.details .name-address p, .details .voucher-file p {
    margin: 5px 0;
}

.account {
    text-align: center;
}

.particulars table {
    width: 100%;
    border-collapse: collapse;
}

.particulars th, .particulars td {
    border: 1px solid #000;
    padding: 5px;
    text-align: center;
}

.total {
    text-align: left;
    margin-top: 20px;
}

.total p {
    margin: 5px 0;
}

.signature {
    justify-content: space-evenly;
    margin-top: 20px;
}

.signature p {
    margin: 0 10px;
}

button {
    display: block;
    margin: 20px auto;
    padding: 10px 20px;
    font-size: 16px;
    cursor: pointer;
}
.rupees-in-words {
    font-family: "Times New Roman", Times, serif;
    font-style: italic;
    text-align: left;
}
</style>
<div class="content-wrapper">

    <section class="content-header">
        <h1>
            <i class="fa fa-credit-card"></i> <?php echo $this->lang->line('expenses'); ?> <small><?php echo $this->lang->line('student_fee'); ?></small></h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <?php
            if ($this->rbac->hasPrivilege('expense', 'can_add')) {
                ?>
                <div class="col-md-4">
                    <!-- Horizontal Form -->
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo $this->lang->line('add_expense'); ?></h3>
                        </div><!-- /.box-header -->
                        <form id="form1" action="<?php echo base_url() ?>admin/expense"  id="employeeform" name="employeeform" method="post" accept-charset="utf-8" enctype="multipart/form-data">
                            <div class="box-body">
                                <?php if ($this->session->flashdata('msg')) { ?>
                                    <?php echo $this->session->flashdata('msg') ?>
                                <?php } ?>
                                <?php
                                if (isset($error_message)) {
                                    echo "<div class='alert alert-danger'>" . $error_message . "</div>";
                                }
                                ?>
                                <?php echo $this->customlib->getCSRF(); ?>
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('income_head'); ?></label> 
                                    <select autofocus="" id="inc_head_id" name="inc_head_id" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($incomeheadlist as $inchead) {
                                            $incomeHeadAmt          = $this->expense_model->getIncomeHeadAmount($inchead['id']);
                                            $count=count($incomeHeadAmt); 
                                            $totalamt=$incomeHeadAmt[0]['amount']*$count;
                                            ?>
                                            <option value="<?php echo $inchead['id'] ?>"<?php
                                            if (set_value('exp_head_id') == $inchead['id']) {
                                                echo "selected =selected";
                                            }
                                            ?>><?php echo $inchead['type'] ?> (₹<?=$totalamt?>)</option>

                                            <?php
                                            $count++;
                                        }
                                        ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('exp_head_id'); ?></span>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('expense_head'); ?></label> <small class="req">*</small>

                                    <select autofocus="" id="exp_head_id" name="exp_head_id" class="form-control" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($expheadlist as $exphead) {
                                            ?>
                                            <option value="<?php echo $exphead['id'] ?>"<?php
                                            if (set_value('exp_head_id') == $exphead['id']) {
                                                echo "selected =selected";
                                            }
                                            ?>><?php echo $exphead['type'] ?></option>

                                            <?php
                                            $count++;
                                        }
                                        ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('exp_head_id'); ?></span>
                                </div>

                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('name'); ?></label> <small class="req">*</small>
                                    <input id="name" name="name" placeholder="" type="text" class="form-control"  value="<?php echo set_value('name'); ?>" />
                                    <span class="text-danger"><?php echo form_error('name'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('invoice_no'); ?></label>
                                    <input id="invoice_no" name="invoice_no" placeholder="" type="text" class="form-control"  value="<?php echo set_value('invoice_no'); ?>" />
                                    <span class="text-danger"><?php echo form_error('invoice_no'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('date'); ?></label> <small class="req">*</small>
                                    <input id="date" name="date" placeholder="" type="text" class="form-control date"  value="<?php echo set_value('date', date($this->customlib->getSchoolDateFormat())); ?>" readonly="readonly" />
                                    <span class="text-danger"><?php echo form_error('date'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('amount'); ?></label> <small class="req">*</small>
                                    <input id="amount" name="amount" placeholder="" type="text" class="form-control"  value="<?php echo set_value('amount'); ?>" />
                                    <span class="text-danger"><?php echo form_error('amount'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('attach_document'); ?></label>
                                    <input id="documents" name="documents" placeholder="" type="file" class="filestyle form-control"  value="<?php echo set_value('documents'); ?>" />
                                    <span class="text-danger"><?php echo form_error('documents'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('description'); ?></label>
                                    <textarea class="form-control" id="description" name="description" placeholder="" rows="3" placeholder="Enter ..."><?php echo set_value('description'); ?></textarea>
                                    <span class="text-danger"></span>
                                </div>
                            </div><!-- /.box-body -->

                            <div class="box-footer">
                                <button type="submit" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                            </div>
                        </form>
                    </div>

                </div><!--/.col (right) -->
                <!-- left column -->
            <?php } ?>
            <div class="col-md-<?php
            if ($this->rbac->hasPrivilege('expense', 'can_add')) {
                echo "8";
            } else {
                echo "12";
            }
            ?>">
                <!-- general form elements -->
                <div class="box box-primary">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix"><?php echo $this->lang->line('expense_list'); ?></h3>
                        <div class="box-tools pull-right">
                        </div><!-- /.box-tools -->
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <div class="mailbox-messages table-responsive">
                            <div class="download_label"><?php echo $this->lang->line('expense_list'); ?></div>
                            <div class="table-responsive"> 
                                <table class="table table-striped table-bordered table-hover expense-list" data-export-title="<?php echo $this->lang->line('expense_list'); ?>">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('name'); ?>
                                            </th>
                                             <th><?php echo $this->lang->line('description'); ?>
                                            </th>
                                            <th><?php echo $this->lang->line('invoice_no'); ?>
                                            </th>
                                            <th><?php echo $this->lang->line('date'); ?>
                                            </th>
                                            <th><?php echo $this->lang->line('expense_head'); ?>
                                            </th>
                                            <th><?php echo $this->lang->line('income_head'); ?>
                                            </th>
                                            <th><?php echo $this->lang->line('amount'); ?>
                                            </th>
                                            <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table><!-- /.table -->

                            </div>  

                        </div><!-- /.mail-box-messages -->
                    </div><!-- /.box-body -->
                </div>
            </div><!--/.col (left) -->

        </div>
        <div class="row">
            <!-- left column -->

            <!-- right column -->
            <div class="col-md-12">

            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->

<div class="modal" id="voucher_modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Debit Voucher</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Voucher</title>
    <!-- <link rel="stylesheet" href="styles.css"> -->
</head>
<body>
    <div class="voucherModule">
        <div class="header">
            <div class="debit-credit">
                <p style="line-height: 1px;font-weight: bold;">Debit</p>
            </div>
            <div class="title" style="
    margin-left: 110px;
    background-color: black;
    color: white;
    border-radius: 25px;
    font-size: 20px;
">
                <p>VOUCHER</p>
            </div>
            <div class="date" style="
    margin-right: 136px;
">
                <p>Date :<label id="voucher_date"></label></p>
            </div>
        </div>
        <div class="details">
            <div class="name-address">
                <p>Name : <label id="voucher_name"></label></p>
                <p>Address : <input type="text" name="address" id="address" class="form-control"></p>
            </div>
            <div class="voucher-file">
                <p>Voucher No. : <span name="voucher_no" id="voucher_no" ></span></p>
                <p>File No. : <input type="text" name="file_no" id="file_no" class="form-control"></p>
            </div>
        </div>
        <div class="account">
            <p>Debit A/c: <div class="col-md-12"><textarea class="form-control" id="ac_no" readonly></textarea></div> </p>
        </div>
        <div class="particulars">
            <table>
                <thead>
                    <tr>
                        <th style="height: 35px;">PARTICULARS</th>
                        <th>Amount <hr> <b style="margin-left: -55px;margin-right: 40px;">RS</b> &nbsp; <b style="margin-right: -55px;margin-left: 30px;">P</b></th>
                       
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="text-align: left;">Cheque/Cash Paid:<label id="voucher_description"></label></td>
                        <td id="voucher_amount"></td>
                    </tr>
                    
                    <tr>
                        <td>
                              <p class="rupees-in-words">Rupees in words : <label id="wordsAmount"></label> <label>Rupees Only</label><b style="margin-right: -223px;margin-left: 20px;text-align:right;">Total</b></p> 
                               
                        </td>
                        <td id="TotalAmt"></td>
                        <input type="hidden" name="" id="voucher_type" value="debit">
                        <input type="hidden" name="" id="income_head_id" >
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="signature">
            <p>Prepared by</p>
            <p>Passed by</p>
            <p>Payee’s Signature</p>
        </div>
    </div>
    
</body>
</html>

      </div>
      <div class="modal-footer">
        <button  id="printbtn">Print</button>
      </div>
    </div>
  </div>
</div>

<script>

    $(document).on('click','.voucher_btn',function(){
        
        var ac_no =$('#ac_no').val('');
        var file_no =$('#file_no').val('');
        var address =$('#address').val('');
        var id=$(this).attr('data-id');
        var voucher_no = padNumber(id, 5);
        $('#voucher_no').html(voucher_no);
        $.ajax({
    url: '<?=base_url()?>admin/Expense/getExpenseData', // URL of the server-side script
    type: 'POST',
    dataType: 'json', // Ensure the response is parsed as JSON
    data: { 
         id: id, 
         voucher_no:voucher_no
    }, // Data to be sent to the server

    success: function(response) {
        // Handle the server's response
        
        $('#wordsAmount').html(response.wordsAmount);
        $('#voucher_name').html(response.name);
        $('#voucher_amount').html(response.amount);
        $('#voucher_date').html(response.date);
        $('#voucher_description').html(response.note);
        $('#income_head_id').val(response.inc_head_id);
        $('#TotalAmt').html(response.amount);
        $('#address').val(response.voucher_data.address);
        $('#file_no').val(response.voucher_data.file_no);
        $('#ac_no').val(response.account_number);

        $('#voucher_modal').modal('show');

    },
    error: function(jqXHR, textStatus, errorThrown) {
        // Handle errors
        $('#response').html('An error occurred: ' + textStatus + ' - ' + errorThrown);
    }
});

        
    });


    function padNumber(num, length) {
                return String(num).padStart(length, '0');
            }

    $('#printbtn').on('click', function() {


        var printContents = $('.voucherModule').clone();

// Replace input elements with their values
printContents.find('input, textarea').each(function() {
    var $input = $(this);
    $input.replaceWith($('<span>').text($input.val()));
});

var printWindow = window.open('', '', 'height=600,width=800');
printWindow.document.write('<html><head><title>Print</title>');
printWindow.document.write('<link rel="stylesheet" href="styles.css" type="text/css" />'); // Link to your CSS file
printWindow.document.write('<style>' +
    'body { font-family: Arial, sans-serif; margin: 20px; }' +
    '.voucher { border: 1px solid #000; padding: 20px; margin: 0 auto; }' +
    '.header, .details, .account, .particulars, .total, .signature { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }' +
    '.header .debit-credit { flex: 1; }' +
    '.header .title { flex: 1; text-align: center; font-weight: bold; }' +
    '.header .date { flex: 1; text-align: right; }' +
    '.details { padding: 2px; border: 2px solid black; display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 20px; }' +
    '.details .name-address, .details .voucher-file { flex: 1; }' +
    '.details .name-address p, .details .voucher-file p { margin: 5px 0; }' +
    '.account { text-align: center; }' +
    '.particulars table { width: 100%; border-collapse: collapse; }' +
    '.particulars th, .particulars td { border: 1px solid #000; padding: 5px; text-align: center; }' +
    '.total { text-align: left; margin-top: 20px; }' +
    '.total p { margin: 5px 0; }' +
    '.signature { justify-content: space-evenly; margin-top: 20px; }' +
    '.signature p { margin: 0 10px; }' +
    '.rupees-in-words { font-family: "Times New Roman", Times, serif; font-style: italic; text-align: left; }' +
    'button { display: block; margin: 20px auto; padding: 10px 20px; font-size: 16px; cursor: pointer; }' +
    '</style>'); // Add any inline styles here
printWindow.document.write('</head><body >');
printWindow.document.write(printContents.html());
printWindow.document.write('</body></html>');
printWindow.document.close();
printWindow.print();




        var voucher_name=$('#voucher_name').html();
        var voucher_date=$('#voucher_date').html();
        var voucher_amount=$('#voucher_amount').html();
        var description=$('#voucher_description').html();
        var voucher_no =$('#voucher_no').html();
        var ac_no =$('#ac_no').val();
        var file_no =$('#file_no').val();
        var voucher_type =$('#voucher_type').val();
        var address =$('#address').val();
        var income_head_id =$('#income_head_id').val();

        $.ajax({
    url: '<?=base_url()?>admin/Income/createVoucher', // URL of the server-side script
    type: 'POST',
    dataType: 'json', // Ensure the response is parsed as JSON
    data: { 
        voucher_name: voucher_name,
        voucher_date: voucher_date,
        voucher_amount: voucher_amount,
        voucher_type: voucher_type,
        description: description,
        voucher_no: voucher_no,
        ac_no: ac_no,
        file_no: file_no,
        address: address,
        income_head_id:income_head_id
     }, // Data to be sent to the server

    success: function(response) {
      $('#voucher_modal').modal('hide');

    },
    error: function(jqXHR, textStatus, errorThrown) {
        // Handle errors
        $('#response').html('An error occurred: ' + textStatus + ' - ' + errorThrown);
    }
});
        
        
    });

    ( function ( $ ) {
    'use strict';
    $(document).ready(function () {
        initDatatable('expense-list','admin/expense/getexpenselist',[],[],100);
    });
} ( jQuery ) )
</script>