<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-money"></i> <?php echo $this->lang->line('fees_collection'); ?>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <?php $this->load->view('reports/_maharashtra_examination'); ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('select_criteria'); ?></h3>
                    </div>
                    <div class="box-body">

                        <form role="form" action="<?php echo site_url('admin/exampattern/student_rank_report') ?>" method="post" class="row">

                            <?php echo $this->customlib->getCSRF(); ?>
                            <div class="col-sm-6 col-lg-3 col-md-3">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('exam') . " " . $this->lang->line('group'); ?></label><small class="req"> *</small>
                                    <select autofocus="" id="exam_group_id" name="exam_group_id[]" class="form-control select2" multiple="">
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        $selected_exam_groups = set_value('exam_group_id', []);
                                        foreach ($examgrouplist as $ex_group_key => $ex_group_value) {
                                            $selected = in_array($ex_group_value->id, (array)$selected_exam_groups) ? 'selected="selected"' : '';
                                        ?>
                                            <option value="<?php echo $ex_group_value->id ?>" <?php echo $selected
                                                                                                ?>><?php echo $ex_group_value->name; ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('exam_group_id'); ?></span>
                                </div>
                            </div>
                            <!--./col-md-3
                           <div class="col-sm-6 col-lg-4 col-md-4">
                                <div class="form-group">   
                                    <label><?php echo $this->lang->line('exam'); ?></label><small class="req"> *</small>
                                    <select  id="exam_id" name="exam_id" class="form-control select2" 12multiple="" >
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('exam_id'); ?></span>
                                </div>  
                            </div> --><!--./col-md-3-->
                            <div class="col-sm-6 col-lg-3 col-md-3">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
                                    <select id="class_id" name="class_id" class="form-control">
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($classlist as $class) {
                                        ?>
                                            <option value="<?php echo $class['id'] ?>" <?php
                                                                                        if (set_value('class_id') == $class['id']) {
                                                                                            echo "selected=selected";
                                                                                        }
                                                                                        ?>><?php echo $class['class'] ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('class_id'); ?></span>
                                </div>
                            </div>

                            <div class="col-sm-6 col-lg-3 col-md-3">
                                <div class="form-group">
                                    <label for="exampleInputEmail1"><?php echo $this->lang->line('section'); ?></label><small class="req"> *</small>
                                    <select id="section_id" name="section_id" class="form-control">
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('section_id'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-lg-3 col-md-3">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('session'); ?></label><small class="req"> *</small>
                                    <select id="session_id" name="session_id" class="form-control">
                                        <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        <?php
                                        foreach ($sessionlist as $session) {
                                        ?>
                                            <option value="<?php echo $session['id'] ?>" <?php
                                                                                            if (set_value('session_id') == $session['id']) {
                                                                                                echo "selected=selected";
                                                                                            }
                                                                                            ?>><?php echo $session['session'] ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <span class="text-danger"><?php echo form_error('session_id'); ?></span>
                                </div>
                            </div>



                            <div class="col-sm-12">
                                <div class="form-group">
                                    <button type="submit" name="search" value="search_filter" class="btn btn-primary pull-right btn-sm checkbox-toggle"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                                </div>
                            </div>
                        </form>

                    </div>

                    <?php
                    if (isset($studentList)) {
                    ?>
                        <form method="post" action="<?php echo base_url('admin/exampattern/print_final_report') ?>" id="printMarksheet">
                            <!-- <input type="hidden" name="marksheet_template" value="<?php echo $marksheet_template; ?>"> -->


                            <div class="box-header ptbnull"></div>
                            <div class="box-header ptbnull">
                                <h3 class="box-title titlefix"><i class="fa fa-users"></i> <?php echo $this->lang->line('student'); ?> <?php echo $this->lang->line('list'); ?></h3>
                                
                            </div>
                            <div class="box-body">
                                

                                
                                <div class="tab-pane active table-responsive no-padding" id="tab_1">
                                    <?php
                                // Step 1: Extract all unique exam names and their subjects
                                $all_exams = [];
                                $all_subjects = [];

                                foreach ($studentList as $student) {
                                    if (isset($student['exams'])) {
                                        foreach ($student['exams'] as $exam_id => $exam_data) {
                                            if (!isset($all_exams[$exam_id])) {
                                                    $all_exams[$exam_id] = $exam_data['exam_name'];
                                                }
                                            foreach ($exam_data['subjects'] as $subject_name => $subject_data) {
                                                $all_subjects[$exam_id][$subject_name] = $subject_name;
                                            }
                                        }
                                    }
                                }
                                ?>

                                <style>
                                    th.exam-header {
                                        border-left: 2px solid #000;
                                    }
                                    td.exam-border {
                                        border-left: 2px solid #000;
                                    }
                                </style>

                                <table class="table table-striped table-bordered table-hover example" cellspacing="0" width="100%">
                                    <thead>
                                        <!-- First header row: Exam Names -->
                                        <tr>
                                            <th rowspan="2">Class Rank</th>
                                            <th rowspan="2">Admission No</th>
                                            <th rowspan="2">Student Name</th>
                                            <?php 
                                            $exam_index = 0;
                                            foreach ($all_exams as $exam_id => $exam_name): 
                                                
                                                $colspan = count($all_subjects[$exam_id]);
                                            ?>
                                                <th colspan="<?= $colspan + 2 ?>" class="<?= $exam_index > 0 ? 'exam-header' : '' ?>">
                                                    <?= $exam_name ?>
                                                </th>
                                            <?php 
                                                $exam_index++;
                                            endforeach; ?>
                                        </tr>

                                        <!-- Second header row: Subject Names -->
                                        <tr>
                                            <?php 
                                            $exam_index = 0;
                                            foreach ($all_exams as $exam_id => $exam_name): 
                                                $subjects = $all_subjects[$exam_id];
                                            ?>
                                                <?php foreach ($subjects as $subject_name): ?>
                                                    <th class="<?= $exam_index > 0 ? 'exam-header' : '' ?>"><?= $subject_name ?></th>
                                                <?php endforeach; ?>
                                                <!-- <th class="<?= $exam_index > 0 ? 'exam-header' : '' ?>">Total</th>
                                                <th class="<?= $exam_index > 0 ? 'exam-header' : '' ?>">%</th> -->
                                            <?php 
                                                $exam_index++;
                                            endforeach; ?>
                                            <th>Grand Total</th>
                                            <th>Grand %</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php foreach ($studentList as $student): ?>
                                        <tr>
                                            <td><?= $student['final_rank']; ?></td>
                                            <td><?= $student['admission_no']; ?></td>
                                            <td>
                                                <a href="<?= base_url(); ?>student/view/<?= $student['student_id'] ?>">
                                                    <?= $student['name']; ?>
                                                </a>
                                            </td>
                                            <?php 
                                            $grand_total = 0;
                                            $grand_max = 0;
                                            $exam_index = 0;

                                            foreach ($all_exams as $exam_id => $exam_name): 
                                                $exam_subjects = $all_subjects[$exam_id];
                                                $marks_data = isset($student['exams'][$exam_id]) ? $student['exams'][$exam_id]['subjects'] : [];
                                            ?>
                                                <?php foreach ($exam_subjects as $subject_name): ?>
                                                    <td class="<?= $exam_index > 0 ? 'exam-border' : '' ?>">
                                                        <?php
                                                        if (isset($marks_data[$subject_name])) {
                                                            $marks = (float)$marks_data[$subject_name]['marks'];
                                                            $max = (float)$marks_data[$subject_name]['max_marks'];
                                                            $grand_total += $marks;
                                                            $grand_max += $max;
                                                            echo $marks . " (" . findGrade($exam_grades, ($marks / $max) * 100) . ")";
                                                        } else {
                                                            echo '-';
                                                        }
                                                        ?>
                                                    </td>
                                                <?php endforeach; ?>
                                                <?php 
                                                    $exam_total = 0;
                                                    $exam_max = 0;
                                                    foreach ($exam_subjects as $subject_name) {
                                                        if (isset($marks_data[$subject_name])) {
                                                            $exam_total += (float)$marks_data[$subject_name]['marks'];
                                                            $exam_max += (float)$marks_data[$subject_name]['max_marks'];
                                                        }
                                                    }
                                                ?>
                                                <!-- <td class="<?= $exam_index > 0 ? 'exam-border' : '' ?>"><strong><?= $exam_total; ?></strong></td>
                                                <td class="<?= $exam_index > 0 ? 'exam-border' : '' ?>">
                                                    <strong><?= $exam_max > 0 ? round(($exam_total / $exam_max) * 100, 2) . '%' . " (" . findGrade($exam_grades, ($exam_total / $exam_max) * 100) . ")" : '0%' ?></strong>
                                                </td> -->
                                            <?php 
                                                $exam_index++;
                                            endforeach; ?>

                                            <!-- ✅ Append Grand Total and Percentage -->
                                            <td><strong><?= $grand_total; ?></strong></td>
                                            <td>
                                                <strong>
                                                    <?= $grand_max > 0 ? round(($grand_total / $grand_max) * 100, 2) . '%' . " (" . findGrade($exam_grades, ($grand_total / $grand_max) * 100) . ")" : '0%' ?>
                                                </strong>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>

                                    </tbody>
                                </table>


                                </div>
                            </div>

                        </form>
                </div>
            <?php
                    }
            ?>
            </div>
        </div>
    </section>
</div>



<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2();

    });
    var date_format = '<?php echo $result = strtr($this->customlib->getSchoolDateFormat(), ['d' => 'dd', 'm' => 'mm', 'Y' => 'yyyy']) ?>';
    var class_id = '<?php echo set_value('class_id') ?>';
    var section_id = '<?php echo set_value('section_id') ?>';
    var session_id = '<?php echo set_value('session_id') ?>';
    var exam_group_id = <?php echo json_encode(set_value('exam_group_id', [])); ?>;
    var exam_id = '<?php echo set_value('exam_id') ?>';
    getSectionByClass(class_id, section_id);
    // getExamByExamgroup(exam_group_id, exam_id);
    $(document).on('change', '#exam_group_id', function(e) {
        $('#exam_id').html("");
        var exam_group_id = $(this).val();
        getExamByExamgroup(exam_group_id, 0);
    });

    $(document).on('change', '#class_id', function(e) {
        $('#section_id').html("");
        var class_id = $(this).val();
        getSectionByClass(class_id, 0);
    });

    function getSectionByClass(class_id, section_id) {
        if (class_id != "") {
            $('#section_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';

            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {
                    'class_id': class_id
                },
                dataType: "json",
                beforeSend: function() {
                    $('#section_id').addClass('dropdownloading');
                },
                success: function(data) {
                    $.each(data, function(i, obj) {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                },
                complete: function() {
                    $('#section_id').removeClass('dropdownloading');
                }
            });
        }
    }

    function getExamByExamgroup(exam_group_id, exam_id) {

        if (exam_group_id !== "") {
            $('#exam_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            var is_termexam = 'yes';


            $.ajax({
                type: "POST",
                url: base_url + "admin/exampattern/getExamByExamgroup",
                data: {
                    'exam_group_id': exam_group_id,
                    'is_termexam': is_termexam
                },
                dataType: "json",
                beforeSend: function() {
                    $('#exam_id').addClass('dropdownloading');
                },
                success: function(data) {
                    $.each(data, function(i, obj) {
                        var sel = "";
                        if (exam_id === obj.id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.id + " " + sel + ">" + obj.exam + "</option>";
                    });

                    $('#exam_id').append(div_data);
                    $('#exam_id').trigger('change');
                },
                complete: function() {
                    $('#exam_id').removeClass('dropdownloading');
                }
            });
        }
    }
</script>
<script>
    $(document).on('submit', 'form#printMarksheet', function(e) {

        e.preventDefault();
        var form = $(this);
        var subsubmit_button = $(this).find(':submit');
        var formdata = form.serializeArray();

        var list_selected = $('form#printMarksheet input[name="exam_group_class_batch_exam_student_id[]"]:checked').length;
        if (list_selected > 0) {
            $.ajax({
                type: "POST",
                url: form.attr('action'),
                data: formdata, // serializes the form's elements.
                dataType: "JSON", // serializes the form's elements.
                beforeSend: function() {
                    subsubmit_button.button('loading');
                },
                success: function(response) {
                    Popup(response.page);
                },
                error: function(xhr) { // if error occured

                    alert("Error occured.please try again");
                    subsubmit_button.button('reset');
                },
                complete: function() {
                    subsubmit_button.button('reset');
                }
            });
        } else {
            confirm("<?php echo $this->lang->line('please_select_student'); ?>");
        }
    });


    $(document).on('click', '#select_all', function() {
        $(this).closest('table').find('td input:checkbox').prop('checked', this.checked);
    });
</script>
<script type="text/javascript">
    var base_url = '<?php echo base_url() ?>';

    function Popup(data) {

        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title></title>');
        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
        }, 500);
        return true;
    }
</script>


<?php







function findGrade($exam_grades, $percentage) {







    if (!empty($exam_grades)) {



        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {







            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {



                return $exam_grade_value->name;



            }



        }



    }



    



    return "-";



}



function findGradeRemark($exam_grade = '') {



    $grade_remark = '';



    switch (strtoupper($exam_grade))



    {



        case 'A+':



            $grade_remark = 'Excellent';



            break;



        case 'A':



            $grade_remark = 'Very Good';



            break;



        case 'B+':



            $grade_remark = 'Good';



            break;



        case 'B':



            $grade_remark = 'Satisfactory';



            break;



        case 'C+':



            $grade_remark = 'Need to Improve';



            break;



        case 'C':



            $grade_remark = 'Below Standard';



            break;



        default:



            $grade_remark = 'Satisfactory';



            break;



    }



    return $grade_remark;



}



function findGradePoints($exam_grades, $percentage) {







    if (!empty($exam_grades)) {



        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {







            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {



                return $exam_grade_value->point;



            }



        }



    }







    return 0;



}







function examTotalResult($array) {



    $return_array = array('max_marks' => 0, 'min_marks' => 0, 'credit_hours' => 0, 'get_marks' => 0, 'exam_result' => true);



    if (!empty($array)) {



        $max_marks = 0;



        $min_marks = 0;



        $credit_hours = 0;



        $get_marks = 0;



        $exam_result = true;



        foreach ($array as $array_key => $array_value) {



            if ($array_value->attendence == "absent") {



                $exam_result = false;



            }



            $max_marks = $max_marks + $array_value->max_marks;



            $min_marks = $min_marks + $array_value->min_marks;



            $credit_hours = $credit_hours + $array_value->credit_hours;



            $get_marks = $get_marks + $array_value->get_marks;



        }



        $return_array = array('max_marks' => $max_marks, 'min_marks' => $min_marks, 'credit_hours' => $credit_hours, 'get_marks' => $get_marks, 'exam_result' => $exam_result);



    }



    return json_encode($return_array);



}







function getWeightageExam($exam_connection_list, $examid, $get_marks) {







    foreach ($exam_connection_list as $exam_connection_key => $exam_connection_value) {



        if ($exam_connection_value->exam_group_class_batch_exams_id == $examid) {



            return ($get_marks * $exam_connection_value->exam_weightage) / 100;



        }



    }



    return "";



}



?>