<?php

if (empty($marksheet)) {

    ?>

    <div class="alert alter-info">

        <?php echo $this->lang->line('no_record_found'); ?>

    </div>

    <?php

} else {

    if (!empty($marksheet['students'])) {

        ?>



        <!DOCTYPE html>

        <html lang="en">



        <head>

            <meta charset="UTF-8">

            <meta name="viewport" content="width=device-width, initial-scale=1.0">

            <title>Evaluation Mark List - First Term</title>

            <style>

                body {

                    font-family: Arial, sans-serif;

                    margin-left: -25px;

                }



                table {

                    width: 105%;

                    border-collapse: collapse;

                }



                td {

                    border: 1px solid black;

                    padding: 3px;

                    text-align: center;

                    font-size: 12px

                }



                .header {

                    text-align: center !important;

                    font-weight: bold;

                    font-size: 18px;

                }



                .vertical-word {

                    writing-mode: vertical-rl

                }



                .subject {

                    text-align: left;

                }



                @media print {

                    * {

                        -webkit-print-color-adjust: exact !important;

                        color-adjust: exact !important;

                        page-break-after: avoid !important;

                    }



                    .student-record {

                        page-break-before: always;

                        margin: 1cm;

                        display: block;

                        position: relative;

                        min-height: 100vh;

                        box-sizing: border-box;

                    }



                    table,

                    .header,

                    h1,

                    h3,

                    h6,

                    .descriptive-entries,

                    .remarks-section {

                        page-break-inside: avoid;

                        text-align: left;

                    }



                    .remarks-section span {

                        text-align: left;

                        display: block;

                    }



                    .signature-section {

                        page-break-inside: avoid;

                        position: absolute;

                        bottom: 2cm;

                        left: 0;

                        right: 0;

                        width: calc(100% - 4cm);

                        margin: 0 2cm;

                    }



                    .no-print {

                        display: none !important;

                    }



                    @page {

                        size: A4;

                        margin: 1cm;

                    }

                }

            </style>

        </head>



        <body>

            <?php

            foreach ($marksheet['students'] as $student_key => $student_value) {

                $roll_no = ($exam->use_exam_roll_no) ? $student_value['student_roll_no'] : $student_value['student_roll_no'];

                ?>

                <div class="student-record">

                    <h1 class="header"><?= $sch_setting->name; ?></h1>

                    <h3 class="header"><?= $sch_setting->address; ?></h3>

                    <h3 class="header">Evaluation Mark List</h3>



                    <p>Student

                        Name:<?php echo $this->customlib->getFullName($student_value['firstname'], $student_value['middlename'], $student_value['lastname'], $sch_setting->middlename, $sch_setting->lastname); ?>

                        Class:<?= $class_data['class']; ?> Division:<?= $section_data['section']; ?> Roll No:<?= $roll_no; ?> Year:

                        <?= $year; ?>

                    </p>

                    <table>

                        <tr>

                            <td colspan="3"> </td>

                            <?php foreach ($marks_distribution_type as $mdtype) { ?>

                                <?php

                                $component_count = 0; // Count components for the current Marks Distribution Type

                

                                foreach ($mark_dist_components as $comp) {

                                    if ($comp->mdtid == $mdtype->id) {

                                        $component_count++; // Count the number of components

                                    }

                                }



                                $total_colspan = $component_count + 1; // Add 1 for the "Subtotal" column

                                ?>

                                <td colspan="<?= $total_colspan ?>" class="basic-evaluation"><?= $mdtype->name ?></td>

                            <?php } ?>

                            <td colspan="4"> </td>



                        </tr>

                        <tr>

                            <td>Sr. No</td>

                            <td width=10%>Subject</td>

                            <td></td>

                            <?php

                            $firstType = true; // Flag to track the first type

                            $totalColumns = 0; // Variable to store total component columns

                

                            foreach ($marks_distribution_type as $mdtype) {

                                $component_names = []; // To store unique component names for this marks_distribution_type

                

                                foreach ($mark_subject_components as $examgroup) {

                                    if (!empty($examgroup->mdcid)) {

                                        $dist_marks = json_decode($examgroup->mdcid, true);



                                        foreach ($dist_marks as $dmrk) {

                                            if ($dmrk['mdtid'] == $mdtype->id) { // Match with current marks_distribution_type

                                                foreach ($mark_dist_components as $distcomp) {

                                                    if ($distcomp->id == $dmrk['mdcid'] && !in_array($distcomp->name, $component_names)) {

                                                        $component_names[] = $distcomp->name; // Add to unique list

                                                        echo "<td class='vertical-word'>" . $distcomp->name . "</td>"; // Display unique component

                                                    }

                                                }

                                            }

                                        }

                                    }

                                }



                                // Add Subtotal Column for this Marks Distribution Type

                                echo "<td class='vertical-word'>Subtotal</td>";



                                // Update total columns count (number of components + subtotal column)

                                $totalColumns += count($component_names) + 1;



                            }

                            ?>

                            <td class="vertical-word">(A+B) Total</td>

                            <td class="vertical-word">Category Class</td>

                            <td class="vertical-word">Remark</td>

                        </tr>



                        <tr>

                            <td></td>

                            <td></td>

                            <td></td>



                            <?php

                            if ($firstType) {

                                // Show numbers only for the first type

                                for ($i = 1; $i <= $totalColumns; $i++) {

                                    echo "<td>$i</td>";

                                }

                                $firstType = false; // Set flag to false after the first type

                            } else {

                                // Leave blank for other types

                                for ($i = 1; $i <= $totalColumns; $i++) {

                                    echo "<td></td>";

                                }

                            }

                            ?>



                            <td></td>

                            <td></td>

                            <td></td>



                        </tr>







                        <?php

                        $count = 1;



                        $subject_order = [

                            'ENGLISH',

                            'MARATHI',

                            'HINDI / SAN',

                            'HINDI/SANSKRIT',

                            'SANKRIT 27/2',

                            'MATHEMATICS',

                            'ALGEBRA',

                            'GEOMETRY',

                            'SCIENCE',

                            'SCIENCE-1',

                            'SCIENCE-2',

                            'Social Science',

                            'EVS',

                            'EVS PART 1',

                            'EVS PART 2',

                            'G.K',

                            'ARTS',

                            'DRAWING',

                            'COMPUTER',

                            'WORK EXPERIENCE',

                            'PHYSICAL EDUCATION',

                            'HISTORY',

                            'HISTORY AND CIVICS',

                            'GEOMETRY',

                            'RHYMES',

                            'MUSIC',

                            'ENGLISH GARAMER',

                            ''

                        ];



                        $subject_order_map = array_flip(array_map('strtoupper', $subject_order));





                        usort($student_value['exam_result'], function ($a, $b) use ($subject_order_map) {

                            $a_name = strtoupper($a->name);

                            $b_name = strtoupper($b->name);



                            $a_index = $subject_order_map[$a_name] ?? PHP_INT_MAX; // Put unmatched at the end

                            $b_index = $subject_order_map[$b_name] ?? PHP_INT_MAX;



                            return $a_index <=> $b_index;

                        });







                        foreach ($student_value['exam_result'] as $exam_result_key => $exam_result_value) {



                            $comp_data = json_decode($exam_result_value->comp_marks, true);



                            ?>

                            <tr>

                                <td rowspan="2"><?= $count; ?></td>

                                <td class="subject" rowspan="2"><?php echo $exam_result_value->name; ?></td>

                                <td>out of</td>



                                <?php $total_max_marks = 0; ?>

                                <!-- Loop through Marks Distribution Type -->

                                <?php foreach ($marks_distribution_type as $mdtype) { ?>



                                    <?php

                                    $component_names = []; // To store unique component names for this marks_distribution_type

                                    $subtotal = 0;



                                    foreach ($mark_subject_components as $examgroup) {

                                        if (!empty($examgroup->mdcid) && $exam_result_value->subject_id == $examgroup->subject_id) {

                                            $dist_marks = json_decode($examgroup->mdcid, true);



                                            foreach ($dist_marks as $dmrk) {

                                                if ($dmrk['mdtid'] == $mdtype->id) { // Match with current marks_distribution_type

                                                    foreach ($mark_dist_components as $distcomp) {

                                                        if ($distcomp->id == $dmrk['mdcid'] && !in_array($distcomp->name, $component_names)) {

                                                            // $component_names[] = $distcomp->name; // Add to unique list

                                                            echo "<td>" . ($dmrk['mark'] !== "" ? $dmrk['mark'] : "-") . "</td>"; // Display unique component

                                                            $subtotal += ($dmrk['mark'] !== "" ? (int) $dmrk['mark'] : 0);

                                                        }

                                                    }

                                                }

                                            }

                                        }

                                    }

                                    ?>



                                    <td><?= $subtotal ?></td>



                                    <?php

                                    $total_max_marks += ($subtotal !== "" ? (int) $subtotal : 0);

                                } ?>



                                <td><?= $total_max_marks ?></td>

                                <td></td>

                                <td rowspan="2"><?= $exam_result_value->remark_name ?></td>

                            </tr>





                            <tr>

                                <td>Marks</td>

                                <?php

                                $subtotal = [];

                                $total_get_marks = 0; ?>

                                <!-- Loop through Marks Distribution Type -->

                                <?php foreach ($marks_distribution_type as $mdtype) { ?>

                                    <!-- Loop through Components under this Type -->

                                    <?php

                                    $subtotal[$mdtype->id] = 0; // Initialize subtotal for this mdtid

                                    ?>

                                    <?php foreach ($mark_dist_components as $distcomp) { ?>

                                        <?php if ($distcomp->mdtid == $mdtype->id) { ?>

                                            <td>

                                                <?php

                                                // Check if this subject has marks for this component

                                                $found = false;

                                                foreach ($comp_data as $comp) {

                                                    if ($comp['mdtid'] == $mdtype->id && $comp['mdcid'] == $distcomp->id) {

                                                        echo $comp['mark']; // Display the mark

                                                        $subtotal[$mdtype->id] = ($subtotal[$mdtype->id] ?? 0) + $comp['mark']; // Add to subtotal

                                                        $found = true;

                                                        break;

                                                    }

                                                }

                                                if (!$found) {

                                                    echo "-"; // If no mark found, show "-"

                                                }

                                                ?>

                                            </td>

                                        <?php } ?>

                                        <?php



                                    } ?>

                                    <td style="font-weight: bold;"><?= $subtotal[$mdtype->id] ?></td>

                                    <?php

                                    $total_get_marks += ($subtotal[$mdtype->id] !== "" ? (int) $subtotal[$mdtype->id] : 0);

                                } ?>

                                <td><?= $total_get_marks ?></td>

                                <td><?php $percentage_grade = ($exam_result_value->get_marks * 100) / $exam_result_value->max_marks;

                                echo findGrade($exam_grades, $percentage_grade); ?>

                                </td>



                            </tr>

                            <?php $count++;

                        } ?>





                    </table>



                    <div class="descriptive-entries">

                        <h6>Descriptive Entries - First Term</h6>

                        <table>

                            <tr>

                                <td>1st Language: </td>

                                <td>Math's: </td>

                                <td>Arts: </td>

                            </tr>

                            <tr>

                                <td>2nd Language: </td>

                                <td>G. Science & E.V.S. - 1: </td>

                                <td>Work Experience: </td>

                            </tr>

                            <tr>

                                <td>3rd Language: </td>

                                <td>Social Science & E.V.S. - 2: </td>

                                <td>Physical Education: </td>

                            </tr>

                        </table>

                    </div>

                    <br />



                    <div class="remarks-section">

                        <span style="font-weight: bold">Remarks &nbsp; &nbsp;</span>

                        <br /><br />

                        <span>Special Programs: ____________Remarks: ___________Interests & Verses: ________</span>

                    </div>



                    <div class="signature-section">

                        <div style="display: flex; justify-content: space-around;">

                            <span>Class Teacher</span>

                            <span>Principal (HM)</span>

                            <span>Signature</span>

                        </div>

                    </div>

                </div>

            <?php } ?>

        </body>



        </html>



    <?php }

}

?>





<?php



function findGrade($exam_grades, $percentage)

{



    if (!empty($exam_grades)) {

        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {



            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {

                return $exam_grade_value->name;

            }

        }

    }



    return "-";

}

function findGradeRemark($exam_grade = '')

{

    $grade_remark = '';

    switch (strtoupper($exam_grade)) {

        case 'A+':

            $grade_remark = 'Excellent';

            break;

        case 'A':

            $grade_remark = 'Very Good';

            break;

        case 'B+':

            $grade_remark = 'Good';

            break;

        case 'B':

            $grade_remark = 'Satisfactory';

            break;

        case 'C+':

            $grade_remark = 'Need to Improve';

            break;

        case 'C':

            $grade_remark = 'Below Standard';

            break;

        default:

            $grade_remark = 'Satisfactory';

            break;

    }

    return $grade_remark;

}

function findGradePoints($exam_grades, $percentage)

{



    if (!empty($exam_grades)) {

        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {



            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {

                return $exam_grade_value->point;

            }

        }

    }



    return 0;

}



function examTotalResult($array)

{

    $return_array = array('max_marks' => 0, 'min_marks' => 0, 'credit_hours' => 0, 'get_marks' => 0, 'exam_result' => true);

    if (!empty($array)) {

        $max_marks = 0;

        $min_marks = 0;

        $credit_hours = 0;

        $get_marks = 0;

        $exam_result = true;

        foreach ($array as $array_key => $array_value) {

            if ($array_value->attendence == "absent") {

                $exam_result = false;

            }

            $max_marks = $max_marks + $array_value->max_marks;

            $min_marks = $min_marks + $array_value->min_marks;

            $credit_hours = $credit_hours + $array_value->credit_hours;

            $get_marks = $get_marks + $array_value->get_marks;

        }

        $return_array = array('max_marks' => $max_marks, 'min_marks' => $min_marks, 'credit_hours' => $credit_hours, 'get_marks' => $get_marks, 'exam_result' => $exam_result);

    }

    return json_encode($return_array);

}



function getWeightageExam($exam_connection_list, $examid, $get_marks)

{



    foreach ($exam_connection_list as $exam_connection_key => $exam_connection_value) {

        if ($exam_connection_value->exam_group_class_batch_exams_id == $examid) {

            return ($get_marks * $exam_connection_value->exam_weightage) / 100;

        }

    }

    return "";

}

?>