<!DOCTYPE html>
<html lang="en">

<head>
    <title>A4 Size Student Marksheet</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        @page {
            size: A4;
            margin: 10mm;
        }

        body {
            margin: 0;
            padding: 0;
        }

        .a4-container {
            width: 793px;
            /* A4 width */
            height: 1122px;
            /* A4 height */
            padding: 10px;
            box-sizing: border-box;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border: 2px solid #dc3545;
            text-align: center;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #dc3545;
            padding: 4px;
        }

        th {
            background-color: #f8d7da;
            color: #dc3545;
        }

        td {
            height: 25px;
        }

        .student-name {
            min-width: 180px;
            text-align: left;
            padding-left: 5px;
        }

        h4,
        h5 {
            margin: 5px 0;
            text-align: center;
            color: #dc3545;
        }
    </style>
</head>

<body>

    <div class="a4-container">
        <h4 style="text-align: right;"><?=$sch_setting->name?></h4>
        <h5 style="text-align: right;"><?=$sch_setting->address?></h5>
        <h4 style="text-align: right;">The Complete Students Subjectwise Collection And Grading </h4>
        <h5 style="text-align: right;">Exam Name:-<?= $exam->exam ?> Class:- <?= $class_data['class'] ?> Section:- <?= $section_data['section'] ?> Year:- <?=$year;?></h5>
        

        <table>
            <thead>
                <tr>
                    <th rowspan="2">Sr. No.</th>
                    <th rowspan="2" class="student-name">Student Name<br>विद्यार्थ्यांचे नाव</th>
                    <?php foreach ($exam_subjects as $subject) { ?>
                        <th colspan="2"><?= $subject['subject_name'] ?></th>
                    <?php } ?>
                    <th>Subtotal</th>
                    <th>Percentage(%)</th>
                </tr>
                <tr>
                    <?php foreach ($exam_subjects as $subject) { ?>
                        <th>Marks</th>
                        <th>Grade</th>
                    <?php } ?>
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $count = 1;
                if (!empty($marksheet['students'])) {
                    foreach ($marksheet['students'] as $student_key => $student_value) {
                ?>
                        <tr>
                            <td><?= $count ?></td>
                            <td class="student-name">
                                <?php 
                                echo $this->customlib->getFullName(
                                    $student_value['firstname'],
                                    $student_value['middlename'],
                                    $student_value['lastname'],
                                    $sch_setting->middlename,
                                    $sch_setting->lastname
                                );  
                                ?>
                            </td>

                            <?php 
                            $subtotal = 0;
                            $total_max_marks = 0;
                            foreach ($exam_subjects as $subject) { 
                                $marks = "-"; // Default value if subject not found
                                $grade = "-";
                                
                                
                                if (!empty($student_value['exam_result'])) {
                                    foreach ($student_value['exam_result'] as $exam) {
                                        if ($exam->subject_id == $subject['subject_id']) {
                                            $subtotal += $marks = $exam->get_marks;
                                            $total_max_marks += $exam->max_marks;
                                            $grade = !empty($exam->get_grade) ? $exam->get_grade : "-";

                                            $percentage_grade = ($exam->get_marks * 100) / $exam->max_marks;
                                            $grade = findGrade($exam_grades, $percentage_grade);
                                                            
                                            break;
                                        }
                                    }
                                }
                            ?>
                                <td><?= $marks ?></td>
                                <td><?= $grade ?></td>
                            <?php } ?>
                                <td><?=$subtotal?></td>
                                <td><?= number_format(($subtotal / $total_max_marks) * 100, 2) ?></td>

                        </tr>
                <?php 
                        $count++;
                    }
                } 
                ?>
            </tbody>
        </table>

    </div>

</body>

</html>

<?php
function findGrade($exam_grades, $percentage) {

    if (!empty($exam_grades)) {
        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {

            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {
                return $exam_grade_value->name;
            }
        }
    }
    
    return "-";
}
?>