

<?php 
if (empty($marksheet)) {
    ?>
    <div class="alert alter-info">
        <?php echo $this->lang->line('no_record_found'); ?>
    </div>
    <?php
} else {
    if (!empty($marksheet['students'])) {
            foreach ($marksheet['students'] as $student_key => $student_value) {
                // print_r($student_value);
    ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Score Sheet</title>
    <!-- <link rel="stylesheet" href="styles.css"> -->
    <style type="text/css">
        * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'roboto', sans-serif;
}

header {
    background-color: #d4ffd4;
    padding: 10px;
    height: 4rem;
    text-align: left;
    font-size: 1em;
}

header h2 {
    font-weight: 400;
    font-size: 1.8rem;
}

.container {
    display: flex;
    gap: 20px;
    padding: 20px;
    align-items: flex-start; /* Aligns both columns at the top for parallelism */
}

.left-column, .right-column {
    flex: 1;
}

.school-info {
    display: flex;
    text-align: center;
    margin-bottom: 20px;
}

.school-info img {
    width: 100px;
    margin-bottom: 10px;
}

.student-info {
    margin-bottom: 20px;
}

.student-info table {
    width: 100%;
    border-collapse: collapse;
}

.student-info th, .student-info td {
    padding: 5px;
    text-align: left;
    border: 1px solid #000; /* Added border for consistency with the image */
}

.attendance-report {
    margin-top: 20px;
    text-align: center;
}

.attendance-report table {
    width: 100%;
    margin-top: 1rem;
    border-collapse: collapse;
}

.attendance-report th, .attendance-report td {
    border: 1px solid #000;
    padding: 5px;
    text-align: center;
}

.right-column table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 10px; /* Reduced margin for tighter vertical alignment */
}

.right-column th, .right-column td {
    border: 1px solid #000;
    padding: 5px;
    text-align: left;
}

.grade-system {
    margin-bottom: 10px; /* Reduced margin for parallelism */
}

.subjects-container {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px; /* Reduced margin for parallelism */
    border: 1px solid #000; /* Added border to match the image */
}

.subjects-box {
    width: 50%;
    padding: 10px;
}

.subjects-box h4 {
    text-align: center;
    margin-bottom: 5px;
}

.subjects-list {
    padding-left: 20px;
}

.subjects-list li {
    margin-bottom: 5px;
}

.subjects-list li:before {
    /*content: "• ";*/
    margin-left: 3rem;
}

.signatures {
    margin-top: 10px; /* Reduced margin for parallelism */
}

.buttons {
    display: flex;
    gap: 10px;
    justify-content: center;
    margin-top: 20px;
}

.button {
    background-color: #007bff;
    color: white;
    padding: 10px 20px;
    text-align: center;
    border-radius: 4px;
    cursor: pointer;
}

.button:hover {
    background-color: #0056b3;
}
    </style>
</head>
<?php
$clsname = (int) filter_var(trim($class_data['class']), FILTER_SANITIZE_NUMBER_INT);
if ($clsname < 8)
{
    $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';
    $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';
    $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';
}
elseif ($clsname >= 8 && $clsname <= 10)
{
    $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';
    $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';
    $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';
}
else
{
    $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';
    $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';
    $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';
//    $schoolname = 'TIMES PUBLIC SCHOOL';
//    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';
//    $UDISENumber = getSecondaryUDISENumber();
}
?>
<body>
    <header>
    </header>

    <div class="container">
        <div class="left-column">
            <div class="school-info">
                <span>
                <img src="https://via.placeholder.com/100" alt="School Logo">
                </span>
                <span>
                <h3><?= $schoolname; ?></h3>
                <p><?= $settinglist[0]['sch_society_name']?></p>
                <?php echo valid($settinglist[0]['sch_city']) ? '<p class="no-margin no-padding text-center">'. $settinglist[0]['sch_city'].'</p>' : ''; ?>    
                    <?php echo valid($settinglist[0]['address']) ? '<p class="no-margin no-padding text-center">'. $settinglist[0]['address'].'</p>' : ''; ?>    
                    <?php echo valid($settinglist[0]['email']) ? '<p class="no-margin no-padding text-center">Email: '. $settinglist[0]['email'].'</p>' : ''; ?>
                <p>School Code: <?= $UDISENumber ?></p>
                <p> <?=$class_data['class'];?> DIV: <?=$section_data['section']?></p>
                <h4>प्रगतीपत्रक</h4>
                <p>Year: <?=$year?></p>
                </span>
            </div>

            <div class="student-info">
                    <tr>
                        <p>स्टूडेंट आयडी: <?=$student_value['std_global_id'];?></p>
                    
                      <?php  $roll_no=($exam->use_exam_roll_no) ? $student_value['roll_no']:$student_value['roll_no'];
                      ?>
                        <p>रोल नं.
                        : <?php echo $roll_no;?></p>
                    </tr>
                    <tr>
                        <p>सेक्शन
                        : SEMI</p>
                    </tr>
                    <tr>
                        <p>हेरी क.
                        : 0</p>
                    </tr>
                    <tr>
                        <p>परीक्षा क.
                        : 610<br></p>
                    </tr>
                    <tr>
                        <p>विद्यार्थीचे नाव
                        : <?php echo $this->customlib->getFullName($student_value['firstname'],$student_value['middlename'],$student_value['lastname'],$sch_setting->middlename,$sch_setting->lastname);  ?><br></td>
                    </tr>
                    <tr>
                        <p>बालक/बालिका
                        : <?php echo $student_value['father_name']; ?><br></p>
                    </tr>
                    <tr>
                        <p>आईसाहेबाचे नाव
                        : <?php echo $student_value['mother_name']; ?><br></p>
                    </tr>
                    <tr>
                        <p>जन्मतारीख
                        : <?php echo $student_value['dob']; ?><br></p>
                    </tr>
                    <tr>
                        <p>वय 
                        <?php
                        $dob = $student_value['dob']; // Example: '2005-06-15'
                        $dobDate = new DateTime($dob);
                        $today = new DateTime();
                        $diff = $today->diff($dobDate);

                        $age_years = $diff->y;
                        $age_months = $diff->m;





                        ?>
                        : <?php echo "$age_years Y, $age_months M"; ?><br> </p>
                        <p>पत्ता: <?=$student_value['permanent_address'];?></p>
            </div>

<div class="attendance-report">
    <h4>Attendance Report</h4>
    <table border="1">
        <thead>
            <tr>
                <th>Month</th>
                <th>Jun</th>
                <th>Jul</th>
                <th>Aug</th>
                <th>Sep</th>
                <th>Oct</th>
                <th>Nov</th>
                <th>Dec</th>
                <th>Jan</th>
                <th>Feb</th>
                <th>Mar</th>
                <th>Apr</th>
                <th>May</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $months = ["June", "July", "August", "September", "October", "November", "December", "January", "February", "March", "April", "May"];
            
            // Initialize totals
            $totalAttendance = array_fill_keys($months, 0);
            $totalPresent = array_fill_keys($months, 0);

            foreach ($monthAttendanceCount as $month => $studentData) {
                foreach ($studentData as $studentId => $attendance) {
                    foreach ($attendance as $values) {
                        // Sum total attendance (present + late_with_excuse + absent + half_day + late)
                        $totalAttendance[$month] += $values['present'] + $values['late_with_excuse'] + $values['absent'] + $values['half_day'] + $values['late'];

                        // Sum only present attendance
                        $totalPresent[$month] += $values['present'];
                    }
                }
            }
            ?>

            <!-- Total Row -->
            <tr>
                <td>Total</td>
                <?php foreach ($months as $month): ?>
                    <td><?= $totalAttendance[$month] ?></td>
                <?php endforeach; ?>
            </tr>

            <!-- Present Row -->
            <tr>
                <td>Present</td>
                <?php foreach ($months as $month): ?>
                    <td><?= $totalPresent[$month] ?></td>
                <?php endforeach; ?>
            </tr>
        </tbody>
    </table>
</div>

        </div>

        <div class="right-column">
            <div class="grade-system">
                <table>
                    <tr>
                        <th colspan="8" style="text-align: center; font-size: 1.3rem;">GRADE SYSTEM (In %)</th>
                    </tr>
                    <tr>
                        <th>Marks</th>
                        <td>91-100</td>
                        <td>81-90</td>
                        <td>71-80</td>
                        <td>61-70</td>
                        <td>51-60</td>
                        <td>41-50</td>
                        <td>33-40</td>
                    </tr>
                    <tr>
                        <th>Grade</th>
                        <td>A-1</td>
                        <td>A-2</td>
                        <td>B-1</td>
                        <td>B-2</td>
                        <td>C-1</td>
                        <td>C-2</td>
                        <td>D</td>
                    </tr>
                </table>
            </div>

            <div class="subject-grades">
                <table>
                    <tr>
                        <th>SN</th>
                        <th>SUBJECT</th>
                        <th>GRADE</th>
                        <th>विषयज्ञ सी.नं.</th>
                    </tr>

                    <?php
                                            $total_max_marks = 0;
                                            $total_obtain_marks = 0;
                                            $total_points = 0;
                                            $total_hours = 0;
                                            $total_quality_point = 0;
                                            $count = 1;
                                            foreach ($student_value['exam_result'] as $exam_result_key => $exam_result_value) {
                                                $total_max_marks = $total_max_marks + $exam_result_value->max_marks;
                                                $total_obtain_marks = $total_obtain_marks + $exam_result_value->get_marks;
                                                ?>
                                                <tr>
                                                    <td>
                                                        <?php echo $count;  ?>
                                                    </td>
                                                    <?php
                                                    if ($exam->exam_group_type != "gpa") {
                                                        ?>
                                                        <td>
                                                            <?php echo $exam_result_value->name . "(" . $exam_result_value->code . ")"; ?>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            $percentage_grade = ($exam_result_value->get_marks * 100) / $exam_result_value->max_marks;
                                                            echo findGrade($exam_grades, $percentage_grade);
                                                            ?>
                                                        </td>
                                                        <td>
                                                            <?php
                                                            echo $exam_result_value->get_marks;
                                                            if ($exam_result_value->attendence == "absent") {
                                                                echo "&nbsp;" . $this->lang->line('exam_absent');
                                                                $absent_status = true;
                                                            }
                                                            if ($exam_result_value->get_marks < $exam_result_value->min_marks) {
                                                                $result_status = 0;
                                                            }
                                                            ?>
                                                        </td>
                                                        <?php
                                                    } else if ($exam->exam_group_type == "gpa") {
                                                        ?>
                                                        <td class="text-center">
                                                            <?php
                                                            $percentage_grade = ($exam_result_value->get_marks * 100) / $exam_result_value->max_marks;
                                                            $point = findGradePoints($exam_grades, $percentage_grade);

                                                            $total_points = $total_points + $point;
                                                            echo $point;
                                                            ?>
                                                        </td>
                                                        <td class="text-center">
                                                            <?php
                                                            $total_hours = $total_hours + $exam_result_value->credit_hours;
                                                            echo ($exam_result_value->credit_hours);
                                                            ?>
                                                        </td>
                                                        <td class="text-center">
                                                            <?php
                                                            echo ($exam_result_value->credit_hours * $point);
                                                            $total_quality_point = $total_quality_point + ($exam_result_value->credit_hours * $point);
                                                            ?>
                                                        </td>
                                                        <?php
                                                    }

                                                    if ($exam->exam_group_type == "school_grade_system" || $exam->exam_group_type == "coll_grade_system") {
                                                        ?>
                                                        <td style="border-right:0">
                                                            <?php
                                                            $percentage_grade = ($exam_result_value->get_marks * 100) / $exam_result_value->max_marks;
                                                            echo findGrade($exam_grades, $percentage_grade);
                                                            ?>
                                                        </td>
                                                        <?php
                                                    }
                                                    ?>
                                                    
                                                </tr>
                                                <?php
                                                $count++;
                                            }
                                            ?>
                    
                </table>
            </div>

            <div class="overall-grade">
                <table>
                    <tr>
                        <th>GRADE</th>
                        <td>---</td>
                    </tr>
                    </table>
                    <table>
                    <tr>
                        <th><h4>आवडते</h4> </th>  
                        <th><h4>विशेष प्रगती</th>
                        <th><h4>सुधारणा आवश्यक</h4></th>
                    </tr>
                    <tr>
                        <th></th>
                        <th>
                            <div class="">
                                <ul class="subjects-list">
                                    <li>HINDI</li>
                                    <li>SOCIAL SCIENCE</li>
                                    <li>MARATHI</li>
                                    <li>ENGLISH</li>
                                </ul>
                            </div>
                        </th>
                        <th>
                            <div class="">
                    
                                <ul class="subjects-list">
                                    <li>MATHEMATICS</li>
                                    <li>SCIENCE</li>
                                </ul>
                            </div>
                        </th>
                    </tr>
                </table>
            </div>

            <div class="subjects-container">
                
            </div>

            <div class="signatures">
                        <p><br><br><br><br></p>
                        <span>Class Teacher &nbsp; &nbsp; &nbsp; &nbsp;</span>
                        <span>COE &nbsp; &nbsp; &nbsp; &nbsp;</span>
                        <span>Supervisor &nbsp; &nbsp; &nbsp; &nbsp;</span>
                        <span>Vice-Principal &nbsp; &nbsp; &nbsp; &nbsp;</span>
                        <span>Principal &nbsp; &nbsp; &nbsp; &nbsp;</span>
                   
            </div>
        </div>
    </div>

    <!-- <div class="buttons">
        <button class="button">🖨 Print</button>
        <button class="button">✖ Close</button>
    </div> -->
</body>
</html>
<?php }
}
}
?>

<?php

function findGrade($exam_grades, $percentage) {

    if (!empty($exam_grades)) {
        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {

            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {
                return $exam_grade_value->name;
            }
        }
    }
    
    return "-";
}
function findGradeRemark($exam_grade = '') {
    $grade_remark = '';
    switch (strtoupper($exam_grade))
    {
        case 'A+':
            $grade_remark = 'Excellent';
            break;
        case 'A':
            $grade_remark = 'Very Good';
            break;
        case 'B+':
            $grade_remark = 'Good';
            break;
        case 'B':
            $grade_remark = 'Satisfactory';
            break;
        case 'C+':
            $grade_remark = 'Need to Improve';
            break;
        case 'C':
            $grade_remark = 'Below Standard';
            break;
        default:
            $grade_remark = 'Satisfactory';
            break;
    }
    return $grade_remark;
}
function findGradePoints($exam_grades, $percentage) {

    if (!empty($exam_grades)) {
        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {

            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {
                return $exam_grade_value->point;
            }
        }
    }

    return 0;
}

function examTotalResult($array) {
    $return_array = array('max_marks' => 0, 'min_marks' => 0, 'credit_hours' => 0, 'get_marks' => 0, 'exam_result' => true);
    if (!empty($array)) {
        $max_marks = 0;
        $min_marks = 0;
        $credit_hours = 0;
        $get_marks = 0;
        $exam_result = true;
        foreach ($array as $array_key => $array_value) {
            if ($array_value->attendence == "absent") {
                $exam_result = false;
            }
            $max_marks = $max_marks + $array_value->max_marks;
            $min_marks = $min_marks + $array_value->min_marks;
            $credit_hours = $credit_hours + $array_value->credit_hours;
            $get_marks = $get_marks + $array_value->get_marks;
        }
        $return_array = array('max_marks' => $max_marks, 'min_marks' => $min_marks, 'credit_hours' => $credit_hours, 'get_marks' => $get_marks, 'exam_result' => $exam_result);
    }
    return json_encode($return_array);
}

function getWeightageExam($exam_connection_list, $examid, $get_marks) {

    foreach ($exam_connection_list as $exam_connection_key => $exam_connection_value) {
        if ($exam_connection_value->exam_group_class_batch_exams_id == $examid) {
            return ($get_marks * $exam_connection_value->exam_weightage) / 100;
        }
    }
    return "";
}
?>