<?php 

if (empty($marksheet)) {

    ?>

    <div class="alert alter-info">

        <?php echo $this->lang->line('no_record_found'); ?>

    </div>

    <?php

} else {

    if (!empty($marksheet['students'])) {

            foreach ($marksheet['students'] as $student_key => $student_value) {

                // print_r($student_value);

    ?>



<!DOCTYPE html>

<html lang="en">

<head>

  <meta charset="UTF-8">

  <title>Score Sheet</title>

  <style>

    * {

      box-sizing: border-box;

    }



    @page {

      size: A4 landscape;

      margin: 10mm;

    }



    body {

      font-family: Arial, sans-serif;

      margin: 0;

      padding: 0;

    }



    .green-bar {

      background-color: #d4edda;

      padding: 8px 15px;

      font-weight: bold;

      font-size: 16px;

      border-bottom: 1px solid #ccc;

    }



    .container {

      display: flex;

      flex-wrap: nowrap;

      padding: 10px;

      max-width: 277mm;

      min-height: 100mm; /* Usable height for A4 landscape */

      margin-top: 10px;

    }



    .left-section {

      width: calc(60% - 15px);

      padding-right: 15px;

    }



    .right-section {

      width: 40%;

      display: flex;

      flex-direction: column;

      flex: 1; /* Stretch to fill available height */

    }



    .header {

      text-align: center;

      margin-bottom: 8px;

    }



    .header img {

      float: left;

      width: 60px;

      margin-right: 10px;

    }



    .header h2 {

      margin: 0;

      font-size: 16px;

    }



    .header h3 {

      margin: 0;

      font-size: 14px;

      font-weight: normal;

    }



    .header .title {

      margin-top: 8px;

      font-size: 18px;

      font-weight: bold;

    }



    .details {

      font-size: 13px;

      line-height: 1.4; /* Reduced line height */

      display: flex;

      flex-wrap: wrap;

      margin-top: 5px; /* Reduced margin */

    }



    .details div {

      width: 50%;

      margin: 1px 0; /* Reduced margin */

    }



    .attendance-section {

      margin-top: 10px;



    }



    table {

      width: 100%;

      border-collapse: collapse;

      font-size: 12px;

    }



    th, td {

      border: 1px solid #000;

      padding: 8px 8px; /* Reduced padding */

      text-align: center;

    }



    .grade-system,

    .subject-grades {

      margin-bottom: 10px; /* Reduced margin */

    }



    .remarks-section {

      font-size: 12px;

      flex: 1; /* Allow remarks to stretch if needed */

    }



    .remarks-section td {

      width: 33.33%;

      text-align: center;  /* Changed from left to center */

      padding: 4px 8px;

    }



    .remarks-section td[colspan="2"] {

      width: 66.66%;

      text-align: left;  /* Keep left alignment only for colspan cells */

    }



    .remarks-section td:first-child {

      font-weight: bold;  

    }



    .remarks-section tr:last-child td {

    height: 80px;

    vertical-align: left;

}



    .signatures {

      display: flex;

      justify-content: space-around;

      font-size: 12px;

      margin-top: 15px; /* Reduced margin */

    }



    .signatures div {

      text-align: center;

      width: 18%;

    }



    .footer-buttons {

      display: none;

    }



    .bold {

      font-weight: bold;

    }

  </style>

</head>



<?php

$clsname = (int) filter_var(trim($class_data['class']), FILTER_SANITIZE_NUMBER_INT);

if ($clsname < 8)

{

    $schoolname = valid($settinglist[0]['sch_name_primary']) ? $settinglist[0]['sch_name_primary'] : '-';

    $schoolrecogno = valid($settinglist[0]['sch_recog_primary']) ? $settinglist[0]['sch_recog_primary'] : '-';

    $UDISENumber = valid($settinglist[0]['sch_udise_primary']) ? $settinglist[0]['sch_udise_primary'] : '-';

}

elseif ($clsname >= 8 && $clsname <= 10)

{

    $schoolname = valid($settinglist[0]['sch_name_secondary']) ? $settinglist[0]['sch_name_secondary'] : '-';

    $schoolrecogno = valid($settinglist[0]['sch_recog_secondary']) ? $settinglist[0]['sch_recog_secondary'] : '-';

    $UDISENumber = valid($settinglist[0]['sch_udise_secondary']) ? $settinglist[0]['sch_udise_secondary'] : '-';

}

else

{

    $schoolname = valid($settinglist[0]['sch_name_high_secondary']) ? $settinglist[0]['sch_name_high_secondary'] : '-';

    $schoolrecogno = valid($settinglist[0]['sch_recog_high_secondary']) ? $settinglist[0]['sch_recog_high_secondary'] : '-';

    $UDISENumber = valid($settinglist[0]['sch_udise_high_secondary']) ? $settinglist[0]['sch_udise_high_secondary'] : '-';

//    $schoolname = 'TIMES PUBLIC SCHOOL';

//    $schoolrecogno = 'NAMASHA 2009/(152/09)/Secondary-1';

//    $UDISENumber = getSecondaryUDISENumber();

}

?>



<body>



<header>

</header>

  <div class="green-bar">Basic Details for Score Sheet</div>



  <div class="container">

    <!-- Left Section -->

    <div class="left-section">

      <div class="header">

        <img src="	https://bwale.dolittletech.com/uploads/school_content/admin_logo/1.jpg" alt="School Logo">

        <span>

                <h3><?= $schoolname; ?></h3>

                <p><?= $settinglist[0]['sch_society_name']?></p>

                <?php echo valid($settinglist[0]['sch_city']) ? '<p class="no-margin no-padding text-center">'. $settinglist[0]['sch_city'].'</p>' : ''; ?>    

                    <?php echo valid($settinglist[0]['address']) ? '<p class="no-margin no-padding text-center">'. $settinglist[0]['address'].'</p>' : ''; ?>    

                    <?php echo valid($settinglist[0]['email']) ? '<p class="no-margin no-padding text-center">Email: '. $settinglist[0]['email'].'</p>' : ''; ?>

                <p>School Code: <?= $UDISENumber ?></p>

                <p> <?=$class_data['class'];?> DIV: <?=$section_data['section']?></p>

                <h4>Report Card</h4>

                <p>Year: <?=$year?></p>

                </span>

      </div>



      <div class="details">

        <div>Student ID: <?=$student_value['std_global_id'];?></div>

		<?php  $roll_no=($exam->use_exam_roll_no) ? $student_value['student_roll_no']:$student_value['student_roll_no'];

                      ?>

        <div>Roll No. : <?php echo $roll_no;?></div>

        <div>Section : English</div>

        <div>Admission No. : <?=$student_value['admission_no'];?></div>

        <div>Exam Seat No. : <?=$student_value['exam_seat_no']?></div>

        <div>Student Name

                        : <?php echo $this->customlib->getFullName($student_value['firstname'],$student_value['middlename'],$student_value['lastname'],$sch_setting->middlename,$sch_setting->lastname);  ?></div>

        <div>Student F/M

                        : <?php echo $student_value['father_name']; ?></div>

        <div>Mother's Name

                        : <?php echo $student_value['mother_name']; ?></div>

        <div>DOB

                        : <?php echo $student_value['dob']; ?></div>

        <div>Age 

                        <?php

                        $dob = $student_value['dob']; // Example: '2005-06-15'

                        $dobDate = new DateTime($dob);

                        $today = new DateTime();

                        $diff = $today->diff($dobDate);



                        $age_years = $diff->y;

                        $age_months = $diff->m;

						?>

                        : <?php echo "$age_years Y, $age_months M"; ?>

		</div>

		<div>Address: <?=$student_value['current_address'];?></div>

      </div>



      <hr style="border-top: 1px solid #000; padding: 0;margin-top: 5px; width: 30%;">

      <h3 style="margin: 1px; text-align: center;"> Attendance </h3>

      <hr style="border-bottom: 1px solid #000; padding: 0; width: 30%;">



      <hr style="border-top: 1px solid #000; margin-top: 10px; width: 30%;">

      <h3 style="margin: 1px; text-align: center;"> Attendance Report</h3>

      <hr style="border-bottom: 1px solid #000; padding: 0; width: 30%;">



      <div class="attendance-section">

        <table border="1">

        <thead>

            <tr>

                <th>Month</th>

                <th>Jun</th>

                <th>Jul</th>

                <th>Aug</th>

                <th>Sep</th>

                <th>Oct</th>

                <th>Nov</th>

                <th>Dec</th>

                <th>Jan</th>

                <th>Feb</th>

                <th>Mar</th>

                <th>Apr</th>

                <th>May</th>

            </tr>

        </thead>

        <tbody>

            <?php



            



            $months = ["June", "July", "August", "September", "October", "November", "December", "January", "February", "March", "April", "May"];







            // Initialize per student totals



            $totalAttendance = [];



            $totalPresent = [];







            foreach ($monthAttendanceCount as $studentId => $studentData) {



                foreach ($months as $month) {



                    







                    if (isset($studentData[$month])) {



                        $attendance = $studentData[$month];







                        $totalAttendance[$studentId][$month] += 



                            ($attendance['present'] ?? 0) + 



                            ($attendance['late_with_excuse'] ?? 0) + 



                            ($attendance['absent'] ?? 0) + 



                            ($attendance['half_day'] ?? 0) + 



                            ($attendance['late'] ?? 0);







                        $totalPresent[$studentId][$month] += ($attendance['present'] ?? 0) + 



                            ($attendance['late_with_excuse'] ?? 0) + 



                            ($attendance['half_day'] ?? 0) + 



                            ($attendance['late'] ?? 0);



                    }



                }



            }



            ?>



            <!-- Total Row -->

            <tr>

                <td>Total</td>

                <?php foreach ($months as $month): ?>



                <th><?= $totalAttendance[$student_value['student_session_id']][$month] ?? 0 ?></th>



                <?php endforeach; ?>

            </tr>



            <!-- Present Row -->

            <tr>

                <td>Present</td>

                <?php foreach ($months as $month): ?>



                    <th><?= $totalPresent[$student_value['student_session_id']][$month] ?></th>



                    <?php endforeach; ?>

            </tr>

        </tbody>

    </table>

      </div>

    </div>



    <!-- Right Section -->

    <div class="right-section">

      <div class="grade-system">

        <table>

          <tr>

            <th colspan="8">GRADE SYSTEM (In %)</th>

          </tr>

          <tr>

            <td>Marks</td>

            <td>91-100</td><td>81-90</td><td>71-80</td><td>61-70</td><td>51-60</td><td>41-50</td><td>33-40</td>

          </tr>

          <tr>

            <td>Grade</td>

            <td>A1</td><td>A2</td><td>B1</td><td>B2</td><td>C1</td><td>C2</td><td>D</td>

          </tr>

        </table>

      </div>



      <div class="subject-grades">

        <table>

                    <tr>

                        <th>SN</th>

                        <th>SUBJECT</th>

                        <th>GRADE</th>

                        <th>विषयज्ञ सी.नं.</th>

                    </tr>



                    <?php

                                            $total_max_marks = 0;

                                            $total_obtain_marks = 0;

                                            $total_points = 0;

                                            $total_hours = 0;

                                            $total_quality_point = 0;

                                            $count = 1;

                                            foreach ($student_value['exam_result'] as $exam_result_key => $exam_result_value) {

                                                $total_max_marks = $total_max_marks + $exam_result_value->max_marks;

                                                $total_obtain_marks = $total_obtain_marks + $exam_result_value->get_marks;

                                                ?>

                                                <tr>

                                                    <td>

                                                        <?php echo $count;  ?>

                                                    </td>

                                                    <?php

                                                    if ($exam->exam_group_type != "gpa") {

                                                        ?>

                                                        <td>

                                                            <?php echo $exam_result_value->name . "(" . $exam_result_value->code . ")"; ?>

                                                        </td>

                                                        <td>

                                                            <?php

                                                            $percentage_grade = ($exam_result_value->get_marks * 100) / $exam_result_value->max_marks;

                                                            echo findGrade($exam_grades, $percentage_grade);

                                                            ?>

                                                        </td>

                                                        <td>

                                                            <?php

                                                            echo $exam_result_value->get_marks;

                                                            if ($exam_result_value->attendence == "absent") {

                                                                echo "&nbsp;" . $this->lang->line('exam_absent');

                                                                $absent_status = true;

                                                            }

                                                            if ($exam_result_value->get_marks < $exam_result_value->min_marks) {

                                                                $result_status = 0;

                                                            }

                                                            ?>

                                                        </td>

                                                        <?php

                                                    } else if ($exam->exam_group_type == "gpa") {

                                                        ?>

                                                        <td class="text-center">

                                                            <?php

                                                            $percentage_grade = ($exam_result_value->get_marks * 100) / $exam_result_value->max_marks;

                                                            $point = findGradePoints($exam_grades, $percentage_grade);



                                                            $total_points = $total_points + $point;

                                                            echo $point;

                                                            ?>

                                                        </td>

                                                        <td class="text-center">

                                                            <?php

                                                            $total_hours = $total_hours + $exam_result_value->credit_hours;

                                                            echo ($exam_result_value->credit_hours);

                                                            ?>

                                                        </td>

                                                        <td class="text-center">

                                                            <?php

                                                            echo ($exam_result_value->credit_hours * $point);

                                                            $total_quality_point = $total_quality_point + ($exam_result_value->credit_hours * $point);

                                                            ?>

                                                        </td>

                                                        <?php

                                                    }



                                                    if ($exam->exam_group_type == "school_grade_system" || $exam->exam_group_type == "coll_grade_system") {

                                                        ?>

                                                        <td style="border-right:0">

                                                            <?php

                                                            $percentage_grade = ($exam_result_value->get_marks * 100) / $exam_result_value->max_marks;

                                                            echo findGrade($exam_grades, $percentage_grade);

                                                            ?>

                                                        </td>

                                                        <?php

                                                    }

                                                    ?>

                                                    

                                                </tr>

                                                <?php

                                                $count++;

                                            }

                                            ?>

                    

                </table>

      </div>



      <div class="remarks-section">

        <table>

          <tr>

            <td>Grade</td>

            <td colspan="2">---</td>

        </tr>

            <tr>

                        <th><h4>Enjoys/Prefers</h4> </th>  

                        <th><h4>Special Progress</th>

                        <th><h4>Improvement Required</h4></th>

            </tr>

            <tr>

                        <th></th>

                        <th>

                            <div class="">

                                <ul class="subjects-list">

                                    <li>HINDI</li>

                                    <li>SOCIAL SCIENCE</li>

                                    <li>MARATHI</li>

                                    <li>ENGLISH</li>

                                </ul>

                            </div>

                        </th>

                        <th>

                            <div class="">

                    

                                <ul class="subjects-list">

                                    <li>MATHEMATICS</li>

                                    <li>SCIENCE</li>

                                </ul>

                            </div>

                        </th>

                    </tr>

        </table>

      </div>



      <div class="signatures">

        <div>Class Teacher</div>

        <div>COE</div>

        <div>Supervisor</div>

        <div>Vice-Principal</div>

        <div>Principal</div>

      </div>

    </div>

  </div>

  

  <!-- <div class="buttons">

        <button class="button">🖨 Print</button>

        <button class="button">✖ Close</button>

    </div> -->

</body>

</html>

<?php }

}

}

?>



<?php



function findGrade($exam_grades, $percentage) {



    if (!empty($exam_grades)) {

        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {



            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {

                return $exam_grade_value->name;

            }

        }

    }

    

    return "-";

}

function findGradeRemark($exam_grade = '') {

    $grade_remark = '';

    switch (strtoupper($exam_grade))

    {

        case 'A+':

            $grade_remark = 'Excellent';

            break;

        case 'A':

            $grade_remark = 'Very Good';

            break;

        case 'B+':

            $grade_remark = 'Good';

            break;

        case 'B':

            $grade_remark = 'Satisfactory';

            break;

        case 'C+':

            $grade_remark = 'Need to Improve';

            break;

        case 'C':

            $grade_remark = 'Below Standard';

            break;

        default:

            $grade_remark = 'Satisfactory';

            break;

    }

    return $grade_remark;

}

function findGradePoints($exam_grades, $percentage) {



    if (!empty($exam_grades)) {

        foreach ($exam_grades as $exam_grade_key => $exam_grade_value) {



            if ($exam_grade_value->mark_from >= $percentage && $exam_grade_value->mark_upto <= $percentage) {

                return $exam_grade_value->point;

            }

        }

    }



    return 0;

}



function examTotalResult($array) {

    $return_array = array('max_marks' => 0, 'min_marks' => 0, 'credit_hours' => 0, 'get_marks' => 0, 'exam_result' => true);

    if (!empty($array)) {

        $max_marks = 0;

        $min_marks = 0;

        $credit_hours = 0;

        $get_marks = 0;

        $exam_result = true;

        foreach ($array as $array_key => $array_value) {

            if ($array_value->attendence == "absent") {

                $exam_result = false;

            }

            $max_marks = $max_marks + $array_value->max_marks;

            $min_marks = $min_marks + $array_value->min_marks;

            $credit_hours = $credit_hours + $array_value->credit_hours;

            $get_marks = $get_marks + $array_value->get_marks;

        }

        $return_array = array('max_marks' => $max_marks, 'min_marks' => $min_marks, 'credit_hours' => $credit_hours, 'get_marks' => $get_marks, 'exam_result' => $exam_result);

    }

    return json_encode($return_array);

}



function getWeightageExam($exam_connection_list, $examid, $get_marks) {



    foreach ($exam_connection_list as $exam_connection_key => $exam_connection_value) {

        if ($exam_connection_value->exam_group_class_batch_exams_id == $examid) {

            return ($get_marks * $exam_connection_value->exam_weightage) / 100;

        }

    }

    return "";

}

?>