<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<title></title>

<style type="text/css">
  @media print {
    .page-break {
      page-break-after: always;
    }
  }
  body {
    font-family: Arial, sans-serif;
    font-size: 13px;
  }
  table {
    border-collapse: collapse;
    width: 100%;
    text-align: center;
  }
  td {
    border: 1px solid #000;
    padding: 6px;
  }
</style>
</head>
<body>

<table border="1" cellpadding="6" cellspacing="0" style="width:100%; border-collapse:collapse; font-family:Arial, sans-serif; font-size:13px; text-align:center;">
<?php 
$count = 1;
$total_students = count($exam_result['results']);
foreach ($exam_result['results'] as $student_id => $student) {
?>

  <!-- School Header -->
   <tr>
    <td colspan="11" style="font-size:16px; font-weight:bold; text-align:center; padding:10px 0;">
      <?=$sch_setting->sch_soc_name;?>
    </td>
  <tr>
    <td colspan="11" style="font-size:16px; font-weight:bold; text-align:center; padding:10px 0;">
      <?=$sch_setting->name;?>
    </td>
  </tr>

  <!-- Exam Name -->
  <tr>
    <td colspan="11" style="font-size:14px; text-align:center; padding:6px 0;">
      <?=$exam_name?> (<?=$session_name?>)
    </td>
  </tr>

  <!-- Class and Section -->
  <tr>
    <td colspan="11" style="font-size:13px; text-align:center; padding:4px 0; border-bottom:2px solid #000;">
      <?=$class_name?> &nbsp;<?=$section_name?>
    </td>
  </tr>

  <!-- Table Header -->
  <tr style="background-color:#f2f2f2; font-weight:bold;">
    <td>Roll No</td>
    <td>Name</td>
    <?php foreach ($exam_result['subjects'] as $subject): ?>
      <td><?= $subject['subject_name'] ?></td>
    <?php endforeach ?>
    <td>Total</td>
    <td>%</td>
  </tr>

  <!-- Maximum Marks Row -->
  <tr style="background-color:#fafafa;">
    <td></td>
    <td>Max Marks</td>
    <?php 
      $total_max_marks = 0;
      foreach ($exam_result['subjects'] as $subject): 
        $total_max_marks += $subject['subject_max_marks'];
    ?>
      <td><?= $subject['subject_max_marks'] ?></td>
    <?php endforeach ?>
    <td style="font-weight:bold;"><?=$total_max_marks?></td>
    <td></td>
  </tr>

  <!-- Student Marks -->
  <tr>
    <td><?=$student['roll_no']?></td>
    <td style="text-align:left;"><?=$student['name']?></td>
    <?php 
      $total_marks = 0;
      foreach ($exam_result['subjects'] as $subject): 
          $subject_name = $subject['subject_name'];
          $marks_data = isset($student['marks'][$subject_name]) ? $student['marks'][$subject_name] : ['marks' => '-', 'attendance' => '-'];
          $marks = $marks_data['marks'];
          if ($marks !== '-' && is_numeric($marks)) {
              $total_marks += $marks;
          }
    ?>
      <td><?= $marks; ?></td>
    <?php endforeach; ?>
    <td style="font-weight:bold;"><?=$total_marks;?></td>
    <?php 
      $percentage = 0;
      if (!empty($total_max_marks) && $total_max_marks != 0) {
          $percentage = ($total_marks * 100) / $total_max_marks;
      }
    ?>
    <td><?=number_format($percentage,2)?>%</td>
  </tr>

  <!-- Signature Row -->
  <tr>
    <td colspan="11" style="border:none; padding-top:25px; text-align:center;">
      <table style="width:100%; border-collapse:collapse; font-size:12px;">
        <tr>
          <td style="text-align:center;">Class Teacher</td>
          <td style="text-align:center;">Parent</td>
          <td style="text-align:center;">Vice-Principal</td>
          <td style="text-align:center;">Principal</td>
        </tr>
      </table>
    </td>
  </tr>

  <!-- Spacing Between Students -->
  <tr><td colspan="11" style="border:none; height:30px;"></td></tr>

<?php 
    // Add page break after every 3 students except for the last one
    if ($count % 3 == 0 && $count < $total_students) {
        echo '<tr class="page-break"><td colspan="11" style="border:none;"></td></tr>';
    }
    $count++;
} 
?>
</table>

</body>
</html>
