<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<title>

</title>

<style>
    .flxmain_bordered_table {
        border-collapse: collapse;
        width: 100%;
        font-family: Arial, sans-serif;
        text-align: center;
    }

    .flxmain_bordered_table td {
        border: 1px solid #000;
        padding: 6px;
    }

    /* Section heading styles */
    .section-title {
        font-weight: bold;
        text-align: center;
        background-color: #f2f2f2;
        padding: 8px 0;
    }

    /* Add spacing between sections */
    .section-space {
        height: 20px;
        border: none;
    }

    /* Signature styling */
    .signature-row td {
        border: none;
        text-align: center;
        padding-top: 15px;
    }

    .name-cell {
        border-top: 1px solid #000;
    }
</style>



</head>
<body>
    <table class='flxmain_bordered_table' border='1' cellpadding='0' cellspacing='0' style='width:776.64pt' summary="Excel Sheet: IX T PT-I">

<tr style='height:14.57pt;'>
  <td class='flx1' colspan='10' rowspan='1'><?=$sch_setting->sch_soc_name?></td>
</tr>

<tr style='height:18.21pt;'>
  <td class='flx2' colspan='10' rowspan='1'><?=$sch_setting->name?></td>
</tr>

<tr style='height:18.21pt;'>
  <td class='flx2' colspan='10' rowspan='1'>
    <?=$session_name?> &nbsp;&nbsp;<?=$exam_name;?> &nbsp;Class :<?=$class_name;?> Division: <?=$section_name;?>&nbsp;
  </td>
</tr>

<tr style='height:17.48pt;'>
  <td class='flx3' style='border:1px solid black;'>RN</td>
  <td class='flx3' style='border:1px solid black; width:220pt;'>Name of Students</td> <!-- ✅ Increased width here -->
  <?php foreach ($exam_result['subjects'] as $subject): ?>
    <td class='flx4' style='border:1px solid black;'><?= $subject['subject_name'] ?></td>
  <?php endforeach; ?>
  <td class='flx4' style='border:1px solid black;'>Total</td>
  <td class='flx4' style='border:1px solid black;'>Percentage</td>
</tr>

<tr style='height:17.48pt;'>
  <td class='flx3' style='border:1px solid black;'></td>
  <td class='flx3' style='border:1px solid black; width:220pt;'></td> <!-- ✅ Matching width for name cell -->
  <?php 
    $total_max_marks = 0;
    foreach ($exam_result['subjects'] as $subject): 
      $total_max_marks += $subject['subject_max_marks'];
  ?>
    <td class='flx4' style='border:1px solid black;'><?= $subject['subject_max_marks'] ?></td>
  <?php endforeach; ?>
  <td class='flx4' style='border:1px solid black;'><?=$total_max_marks?></td>
  <td class='flx4' style='border:1px solid black;'>100%</td>
</tr>

<?php 
$count = 1;
foreach ($exam_result['results'] as $student_id => $student): ?>
<tr style='height:17.48pt;'>
  <td class='flx5' style='border:1px solid black;'><?=$count?></td>
  <td class='flx6' style='border:1px solid black; width:220pt;'><?=$student['name']?>&nbsp;</td> <!-- ✅ Increased width -->
  
  <?php 
    $total_marks = 0;
    foreach ($exam_result['subjects'] as $subject): 
      $subject_name = $subject['subject_name'];
      $marks_data = isset($student['marks'][$subject_name]) ? $student['marks'][$subject_name] : ['marks' => '-', 'attendance' => '-'];
      $marks = $marks_data['marks'];
      if ($marks !== '-' && is_numeric($marks)) {
        $total_marks += $marks;
      }
  ?>
  <td class='flx5' style='border:1px solid black;'><?= $marks ?></td>
  <?php endforeach; ?>

  <td class='flx5' style='border:1px solid black;'><?=$total_marks;?></td>
  <?php 
    $percentage = !empty($total_max_marks) ? ($total_marks * 100 / $total_max_marks) : 0;
  ?>
  <td class='flx5' style='border:1px solid black;'><?=number_format($percentage,2)?></td>
</tr>
<?php $count++; endforeach; ?>

<tr style='height:18.21pt;'>
  <td class='flx0' style='border-top:1px none black;'></td>
  <td class='flx0' style='border-top:1px none black;'></td>
  <?php foreach ($exam_result['subjects'] as $subject): ?>
    <td class='flx8' style='border-top:1px none black;'></td>
  <?php endforeach ?>
  <td class='flx0' style='border-top:1px none black;'></td>
  <td class='flx0' style='border-top:1px none black;'></td>
</tr>

<tr style='height:18.21pt;'>
  <td class='flx0'></td>
  <td class='flx0'></td>
  <?php foreach ($exam_result['subjects'] as $subject): ?>
    <td class='flx0'></td>
  <?php endforeach ?>
  <td class='flx0'></td>
  <td class='flx0'></td>
</tr>

<tr style='height:18.21pt;'>
  <td class='flx0'></td>
  <td class='flx9'></td>
  <?php foreach ($exam_result['subjects'] as $subject): ?>
    <td class='flx9'></td>
  <?php endforeach ?>
  <td class='flx9'></td>
  <td class='flx9'></td>
</tr>

<tr style='height:18.21pt;'>
  <td class='flx0'></td>
  <td class='flx9'>Class Teacher</td>
  <td class='flx10'></td>
  <td class='flx10'></td>
  <td class='flx9'></td>
  <td class='flx9' colspan='2'>Vice-Principal</td>
  <td class='flx10'></td>
  <td class='flx10'></td>
  <td class='flx9'>Principal</td>
</tr>

</table>


<br>
<br>
<br>



<div class="report-container">
    <table class='flxmain_bordered_table' summary="Excel Sheet: IX T PT-I">
        <!-- Header Section -->
        <tr>
            <td colspan='10'><?=$sch_setting->sch_soc_name?></td>
        </tr>
        <tr>
            <td colspan='10'><?=$sch_setting->name?></td>
        </tr>
        <tr>
            <td colspan='10'><?=$exam_name?> Result &nbsp;<?=$class_name?> [<?=$session_name?>]</td>
        </tr>
        <tr>
            <td colspan='10'><b>Result Analysis</b></td>
        </tr>

        <!-- Subject Headers -->
        <tr>
            <td colspan='2' style='font-weight:bold;'>Details</td>
            <?php 
            $total_max_marks = 0;
            foreach ($exam_result['subjects'] as $subject): 
                $total_max_marks += $subject['subject_max_marks']; ?>
                <td><?= $subject['subject_name'] ?></td>
            <?php endforeach; ?>
        </tr>

        <?php
        // Subject-wise stats calculation
        $subject_wise_stats = [];

        foreach ($exam_result['subjects'] as $subject) {
            $subject_name = $subject['subject_name'];
            $subject_min_marks = $subject['subject_min_marks'];
            $total_subject_marks = 0;
            $total_students_appeared = 0;
            $max_marks = $subject['subject_max_marks'];

            $subject_wise_stats[$subject_name] = [
                'appeared' => 0,
                'passed' => 0,
                'failed' => 0,
                'not_attempted' => 0,
                'total_marks' => 0,
            ];

            foreach ($exam_result['results'] as $student) {
                $marks_data = isset($student['marks'][$subject_name]) ? $student['marks'][$subject_name] : ['marks' => '-', 'attendance' => '-'];
                $marks = $marks_data['marks'];
                $attendance = $marks_data['attendance'];

                if ($attendance === 'absent' || $marks === '-') {
                    $subject_wise_stats[$subject_name]['not_attempted']++;
                } else {
                    $subject_wise_stats[$subject_name]['appeared']++;
                    $subject_wise_stats[$subject_name]['total_marks'] += $marks;
                    $total_subject_marks += $marks;
                    $total_students_appeared++;

                    if ($marks >= $subject_min_marks) {
                        $subject_wise_stats[$subject_name]['passed']++;
                    } else {
                        $subject_wise_stats[$subject_name]['failed']++;
                    }
                }
            }

            $subject_wise_stats[$subject_name]['average_marks'] =
                $subject_wise_stats[$subject_name]['appeared'] > 0
                ? round($subject_wise_stats[$subject_name]['total_marks'] / $subject_wise_stats[$subject_name]['appeared'], 2)
                : 0;

            $subject_avg_percentage = ($total_students_appeared > 0)
                ? round(($total_subject_marks / ($total_students_appeared * $max_marks)) * 100, 2)
                : 0;

            $subject_wise_stats[$subject_name]['avg_percentage'] = $subject_avg_percentage;
        }
        ?>

        <!-- Data Rows -->
        <tr><td colspan='2'>No. of Students Appeared</td>
            <?php foreach ($exam_result['subjects'] as $subject): ?>
                <td><?= $subject_wise_stats[$subject['subject_name']]['appeared'] ?></td>
            <?php endforeach; ?>
        </tr>
        <tr><td colspan='2'>No. of Students Passed</td>
            <?php foreach ($exam_result['subjects'] as $subject): ?>
                <td><?= $subject_wise_stats[$subject['subject_name']]['passed'] ?></td>
            <?php endforeach; ?>
        </tr>
        <tr><td colspan='2'>No. of Students Failed</td>
            <?php foreach ($exam_result['subjects'] as $subject): ?>
                <td><?= $subject_wise_stats[$subject['subject_name']]['failed'] ?></td>
            <?php endforeach; ?>
        </tr>
        <tr><td colspan='2'>No. of Students Not Attempted</td>
            <?php foreach ($exam_result['subjects'] as $subject): ?>
                <td><?= $subject_wise_stats[$subject['subject_name']]['not_attempted'] ?></td>
            <?php endforeach; ?>
        </tr>
        <tr><td colspan='2'>Total Marks in Subject</td>
            <?php foreach ($exam_result['subjects'] as $subject): ?>
                <td><?= $subject_wise_stats[$subject['subject_name']]['total_marks'] ?></td>
            <?php endforeach; ?>
        </tr>
        <tr><td colspan='2'>Average Marks of Subject</td>
            <?php foreach ($exam_result['subjects'] as $subject): ?>
                <td><?= $subject_wise_stats[$subject['subject_name']]['average_marks'] ?></td>
            <?php endforeach; ?>
        </tr>
        <tr><td colspan='2'>Result in Percentage (%)</td>
            <?php foreach ($exam_result['subjects'] as $subject): ?>
                <td><?= $subject_wise_stats[$subject['subject_name']]['avg_percentage'] ?>%</td>
            <?php endforeach; ?>
        </tr>

        <!-- Spacer -->
        <tr class="section-space"><td colspan="10"></td></tr>

        <!-- Subject Wise Topper -->
        <tr><td colspan='10' class="section-title">Subject Wise Topper</td></tr>
        <tr>
            <td colspan='2'><b>Subject</b></td>
            <td colspan='7'><b>Student Name</b></td>
            <td><b>Marks</b></td>
        </tr>

        <?php 
        $subject_toppers = [];
        foreach ($exam_result['subjects'] as $subject) {
            $subject_name = $subject['subject_name'];
            $highest_marks = 0;
            $toppers = [];

            foreach ($exam_result['results'] as $student) {
                $marks_data = $student['marks'][$subject_name] ?? ['marks' => '-', 'attendance' => '-'];
                $marks = $marks_data['marks'];

                if ($marks !== '-' && $marks_data['attendance'] !== 'absent') {
                    if ($marks > $highest_marks) {
                        $highest_marks = $marks;
                        $toppers = [$student['name']];
                    } elseif ($marks == $highest_marks) {
                        $toppers[] = $student['name'];
                    }
                }
            }

            $subject_toppers[$subject_name] = [
                'toppers' => implode(', ', $toppers),
                'marks' => $highest_marks
            ];
        }

        foreach ($subject_toppers as $subject_name => $topper_data) { ?>
            <tr>
                <td colspan='2'><?= $subject_name ?></td>
                <td colspan='7'><?= $topper_data['toppers'] ?></td>
                <td><?= $topper_data['marks'] ?></td>
            </tr>
        <?php } ?>

        <!-- Spacer -->
        <tr class="section-space"><td colspan="10"></td></tr>

        <!-- Class Topper -->
        <tr><td colspan='10' class="section-title">Class Topper</td></tr>
        <tr>
            <td colspan='7'><b>Name</b></td>
            <td colspan='3'><b>Percentage</b></td>
        </tr>

        <?php 
        $class_toppers = [];
        foreach ($exam_result['results'] as $student) {
            $total_marks = 0;
            $max_total_marks = 0;

            foreach ($exam_result['subjects'] as $subject) {
                $subject_name = $subject['subject_name'];
                $max_marks = $subject['subject_max_marks'];
                $marks_data = $student['marks'][$subject_name] ?? ['marks' => '-', 'attendance' => '-'];
                $marks = $marks_data['marks'];

                if ($marks !== '-' && $marks_data['attendance'] !== 'A') {
                    $total_marks += $marks;
                    $max_total_marks += $max_marks;
                }
            }

            $percentage = ($max_total_marks > 0) ? round(($total_marks / $max_total_marks) * 100, 2) : 0;
            $class_toppers[] = [
                'name' => $student['name'],
                'percentage' => $percentage
            ];
        }

        usort($class_toppers, fn($a, $b) => $b['percentage'] <=> $a['percentage']);
        $class_toppers = array_slice($class_toppers, 0, 3);

        foreach ($class_toppers as $topper) { ?>
            <tr>
                <td colspan='7'><?= $topper['name'] ?></td>
                <td colspan='3'><?= $topper['percentage'] ?>%</td>
            </tr>
        <?php } ?>

        <!-- Spacer -->
        <tr class="section-space"><td colspan="10"></td></tr>

        <!-- Signature Section -->
        <tr class="signature-row">
            <td colspan='3'></td>
            <td colspan='3'>Class Teacher</td>
            <td colspan='2'>Vice-Principal</td>
            <td colspan='2'>Principal</td>
        </tr>
        <tr class="signature-row">
            <td colspan='3'></td>
            <td colspan='3' class='name-cell'><?=$class_teacher->name . ' ' . $class_teacher->surname?></td>
            <td colspan='2' class='name-cell'></td>
            <td colspan='2' class='name-cell'></td>
        </tr>
    </table>
</div>
</body>
</html>
