<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>EXIT CERTIFICATE</title>
  <style>
    body{
      font-family:'Segoe UI',Tahoma,Geneva,Verdana,sans-serif;
      margin:0;padding:0;background:#f5f5f5;
    }

    /*==========  SHEET  ==========*/
    .certificate-container{
      background:#fff;
      width:210mm;height:297mm;
      margin:10mm auto;
      padding:20mm 15mm;
      box-sizing:border-box;
      border-radius:8px;
      box-shadow:0 0 6px rgba(0,0,0,.1);
      display:flex;flex-direction:column;justify-content:space-between;
      position:relative;
    }

    /*==========  HEADER  ==========*/
    .header{
      display:flex;align-items:center;justify-content:center;
      gap:12px;margin-bottom:20px;text-align:center;
    }
    .header .logo{
      width:65px; /* adjust as needed */
      height:auto;
    }
    .header-text h2{color:red;font-size:22px;margin:0;}
    .header-text h4,
    .header-text h3{margin:4px 0;font-size:14px;}

    /*==========  TABLES  ==========*/
    table{width:100%;border-collapse:collapse;margin-bottom:15px;}
    td{padding:6px 4px;font-size:13.5px;vertical-align:top;}
    input[type="text"],input[type="date"]{
      width:100%;font-size:13.5px;border:none;border-bottom:1px solid #000;
      background:transparent;padding:2px 0;margin:0;outline:none;
    }
    .row{display:flex;gap:6px;}
    .row .col{flex:1;}
    .text-center{text-align:center;}

    /*==========  BUTTON  ==========*/
    button{
      padding:8px 18px;margin-top:15px;border:none;border-radius:4px;
      background:#007bff;color:#fff;font-size:14px;cursor:pointer;
    }

    /*==========  PRINT  ==========*/
    @media print{
      body{background:#fff;margin:0;padding:0;}
      .certificate-container{width:100%;height:auto;box-shadow:none;border-radius:0;padding:15mm;margin:0;}
      input,button{display:none;}
      .print-span{display:inline!important;font-size:13.5px;}
      @page{size:A4;margin:10mm;}
      table{margin-bottom:12px;}
      td{padding:5px 3px;}
    }
  </style>
</head>
<body>
  <div class="certificate-container">

    <!-- =========  HEADER  ========= -->
    <div class="header">
      <!-- logo -->
      <img src="https://finalschool710.dolittletech.co.in/uploads/school_content/logo/cert-1.jpg" alt="School Logo" class="logo">
      <!-- text -->
      <div class="header-text">
        <h2><?= $setting_result[0]['name']; ?></h2>
        <h4>Sambhaji Nagar, Khedgaon Road, Latur | Email: waleschool@gmail.com</h4>
        <h3 style="color:red;">EXIT CERTIFICATE</h3>
      </div>
    </div>

    <!-- =========  BODY  ========= -->
    <form id="certificateForm">
      <table>
        <tr><td>General Register No.:</td><td>GR123456</td></tr>
        <tr><td>School Recognition No.:</td><td>NAMASHA 2009/(152/09)/Secondary-1</td><td>Medium:</td><td>English</td></tr>
        <tr><td>UDISE No.:</td><td colspan="3">27280700148</td></tr>
      </table>

      <table>
        <tr><td>Register Number:</td><td><input type="text" name="register_no"></td></tr>
        <tr>
          <td>Full Name of Student:</td>
          <td>
            <div class="row">
              <div class="col"><input type="text" name="first_name" placeholder="First"></div>
              <div class="col"><input type="text" name="father_name" placeholder="Father's"></div>
              <div class="col"><input type="text" name="last_name" placeholder="Surname"></div>
            </div>
          </td>
        </tr>
        <tr><td>Mother Tongue:</td><td><input type="text" name="mother_tongue"></td></tr>
        <tr><td>Religion:</td><td><input type="text" name="religion"></td></tr>
        <tr><td>Caste:</td><td><input type="text" name="caste"></td></tr>
        <tr><td>Place of Birth:</td><td><input type="text" name="place_of_birth"></td></tr>
        <tr><td>Date of Birth:</td><td><input type="date" name="dob"></td></tr>
        <tr><td>Name of Previous School and Standard:</td><td><input type="text" name="prev_school_name"></td></tr>
        <tr><td>Date of Admission in this School:</td><td><input type="date" name="admission_date"></td></tr>
        <tr><td>Standard & Class Into which admitted:</td><td><input type="text" name="admitted_class"></td></tr>
        <tr><td>Progress:</td><td><input type="text" name="academic_preference"></td></tr>
        <tr><td>Conduct:</td><td><input type="text" name="academic_conduct"></td></tr>
        <tr><td>Date of Leaving School:</td><td><input type="date" name="date_of_leaving"></td></tr>
        <tr><td>Standard and Class from which left:</td><td><input type="text" name="left_class"></td></tr>
        <tr><td>Remark:</td><td><input type="text" name="remark"></td></tr>
      </table>
        <input  type="text" name="type" value="Exit">
    </form>

    <!-- =========  FOOTER  ========= -->
    <div>
      <table>
        <tr>
          <td style="padding-top:20px;text-align:left;">Date: <?= date('d-m-Y'); ?></td>
          <td style="padding-top:20px;text-align:right;">Clerk Signature</td>
          <td style="padding-top:20px;text-align:right;">Principal Signature</td>
        </tr>
      </table>

      <div class="text-center">
        <button type="button" onclick="handlePrint()">Print Certificate</button>
      </div>
    </div>

  </div>

  <script>
        function handlePrint() {
            const form = document.getElementById('certificateForm');
            const formData = new FormData(form);
            const jsonData = {};

            formData.forEach((value, key) => {
                jsonData[key] = value;
            });

            fetch('<?php echo base_url("admin/Certificate/save_genralCertificate"); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify(jsonData)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const inputs = document.querySelectorAll('input[type="text"], input[type="date"]');
                        inputs.forEach(input => {
                            const span = document.createElement('span');
                            span.className = 'print-span';
                            span.textContent = input.type === 'date' && input.value ?
                                new Date(input.value).toLocaleDateString('en-GB') :
                                input.value;

                            input.parentNode.insertBefore(span, input.nextSibling);
                        });

                        window.print();
                    } else {
                        alert("Failed to save data. Please try again.");
                    }
                })
                .catch(error => {
                    console.error("Error:", error);
                    alert("An error occurred while saving the certificate.");
                });
        }
    </script>
</body>
</html>
