<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-newspaper-o"></i> <?php //echo $this->lang->line('certificate'); ?></h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <?php if ($this->session->flashdata('msg')) {?>
            <?php 
                echo $this->session->flashdata('msg');
                $this->session->unset_userdata('msg');
            ?>
        <?php }?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('select_criteria'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                         <form role="form" action="<?php echo site_url('admin/generatecertificate/search') ?>" method="post">
    <?php echo $this->customlib->getCSRF(); ?>

    <div class="col-sm-4">
        <div class="form-group">
            <label><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
            <select id="class_id" name="class_id" class="form-control">
                <option value=""><?php echo $this->lang->line('select'); ?></option>
                <?php foreach ($classlist as $class): ?>
                    <option value="<?php echo $class['id']; ?>" <?php echo set_value('class_id') == $class['id'] ? 'selected' : ''; ?>>
                        <?php echo $class['class']; ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <span class="text-danger"><?php echo form_error('class_id'); ?></span>
        </div>
    </div>

    <div class="col-sm-4">
        <div class="form-group">
            <label><?php echo $this->lang->line('section'); ?></label>
            <select id="section_id" name="section_id" class="form-control">
                <option value=""><?php echo $this->lang->line('select'); ?></option>
            </select>
            <span class="text-danger"><?php echo form_error('section_id'); ?></span>
        </div>
    </div>

    <div class="col-sm-4">
        <div class="form-group">
            <label>Event Name</label><small class="req"> *</small>
            <select name="event_name" class="form-control">
                <option value=""><?php echo $this->lang->line('select'); ?></option>
                <?php foreach ($eventlist as $event): ?>
                    <option value="<?php echo $event['event_name']; ?>" <?php echo set_value('event_name') == $event['event_name'] ? 'selected' : ''; ?>>
                        <?php echo $event['event_name']; ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <span class="text-danger"><?php echo form_error('event_name'); ?></span>
        </div>
    </div>

    <div class="col-sm-12">
        <div class="form-group">
            <button type="submit" name="search" value="search_filter" class="btn btn-primary btn-sm pull-right">
                <i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?>
            </button>
        </div>
    </div>
</form>

                        </div>
                    </div>

                    <?php
if (isset($resultlist)) {
    ?>
                        <form method="post" action="<?php echo base_url('admin/generatecertificate/generatemultiple') ?>">
                            <div  class="" id="duefee">
                                <div class="box-header ptbnull"></div>
                                <div class="box-header ptbnull">
                                    <h3 class="box-title titlefix pt6"><i class="fa fa-users"></i> <?php echo $this->lang->line('student_list'); ?></h3>
                                    <button  class="btn btn-info btn-sm printSelected pull-right" type="button" name="generate" title="generate multiple certificate"><?php echo $this->lang->line('generate'); ?></button>
                                </div>
                                <div class="box-body table-responsive">
                                    <div class="download_label"><?php echo $this->lang->line('student_list'); ?></div>
                                    <div class="tab-pane active table-responsive no-padding" id="tab_1">
                                      <table class="table table-striped table-bordered table-hover example" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th><input type="checkbox" id="select_all" /></th>
            <th><?php echo $this->lang->line('admission_no'); ?></th>
            <th><?php echo $this->lang->line('student_name'); ?></th>
            <th><?php echo $this->lang->line('class'); ?>/Section</th>
            <th>Certificate Name</th>
            <th>Event Name</th>
            <th>Position</th>
            <th><?php echo $this->lang->line('gender'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php if (empty($resultlist)): ?>
            <tr><td colspan="8" class="text-center">No records found</td></tr>
        <?php else: 
            foreach ($resultlist as $student): ?>
            <tr>
                <td class="text-center">
                    <input type="checkbox" class="checkbox" name="check" data-student_id="<?php echo $student['id']; ?>" value="<?php echo $student['id']; ?>">
                </td>
                <td><?php echo $student['admission_no']; ?></td>
                <td>
                    <a href="<?php echo base_url('student/view/'.$student['id']); ?>">
                        <?php echo $this->customlib->getFullName($student['firstname'], $student['middlename'], $student['lastname'], $sch_setting->middlename, $sch_setting->lastname); ?>
                    </a>
                </td>
                <td><?php echo $student['class'].'('.$student['section'].')'; ?></td>
                <td><?php echo $student['certificate_name']; ?></td>
                <td><?php echo $student['event_name']; ?></td>
                <td><?php echo $student['position']; ?></td>
                <td><?php echo $this->lang->line(strtolower($student['gender'])); ?></td>
            </tr>
        <?php endforeach; endif; ?>
    </tbody>
</table>


                                    </div>
                                </div>
                            </div>
                        </form>
                        <?php
}
?>
                </div>
            </div>
        </div>
    </section>
</div>
<script type="text/javascript">
    function getSectionByClass(class_id, section_id) {
        if (class_id != "" && section_id != "") {
            $('#section_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        }
    }
    $(document).ready(function () {
        var class_id = $('#class_id').val();
        var section_id = '<?php echo set_value('section_id') ?>';
        getSectionByClass(class_id, section_id);
        $(document).on('change', '#class_id', function (e) {
            $('#section_id').html("");
            var class_id = $(this).val();
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        div_data += "<option value=" + obj.section_id + ">" + obj.section + "</option>";
                    });
                    $('#section_id').append(div_data);
                }
            });
        });
    });
</script>
<script>
$(document).ready(function() {

    // Select all checkbox toggle
    $('#select_all').on('click', function() {
        $('.checkbox').prop('checked', this.checked);
    });

    // Generate selected certificates
    $('.printSelected').on('click', function() {
        var selectedIds = [];
        $('.checkbox:checked').each(function() {
            selectedIds.push($(this).val());
        });

        if (selectedIds.length === 0) {
            alert('Please select at least one student.');
            return;
        }

        // Open PDF generation in a new tab
        var url = "<?php echo base_url('admin/generatecertificate/generateMultipleCertificates'); ?>";
        var form = $('<form>', {
            'method': 'POST',
            'action': url,
            'target': '_blank' // open in new tab
        });

        $('<input>').attr({
            type: 'hidden',
            name: 'student_ids',
            value: JSON.stringify(selectedIds)
        }).appendTo(form);

        $('body').append(form);
        form.submit();
        form.remove();
    });
});
</script>