<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><i class="fa fa-newspaper-o"></i> <?php //echo $this->lang->line('certificate'); ?></h1>
    </section>
    <section class="content">
        <div class="row">
         

                <div class="col-md-4">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title"><?php echo $this->lang->line('add_student_certificate'); ?></h3>
                        </div><!-- /.box-header -->
                        <form id="form1" enctype="multipart/form-data" action="<?php echo site_url('admin/certificate/saveEventCertificates') ?>"  id="certificateform" name="certificateform" method="post" accept-charset="utf-8">
                            <div class="box-body">
                                <?php if ($this->session->flashdata('msg')) {?>
                                    <?php 
                                        echo $this->session->flashdata('msg'); 
                                        $this->session->unset_userdata('msg'); 
                                    ?>
                                <?php }?>
                                <?php
if (isset($error_message)) {
        echo "<div class='alert alert-danger'>" . $error_message . "</div>";
    }
    ?>
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('certificate_name'); ?></label><small class="req"> *</small>
                                    <input autofocus="" id="certificate_name" name="certificate_name"  type="text" class="form-control" />
                                    <span class="text-danger"><?php echo form_error('certificate_name'); ?></span>
                                </div>
                                <div class="form-group">
                                    <label>Event Name</label>
                                    <input id="" name="event_name"  type="text" class="form-control" />
                                </div>
                                
                                 <div class="form-group">
                                    <label>Secure Position</label>
                                    <input id="" name="position"type="text" class="form-control" />
                                </div>
                                 <div class="form-group">
                                    <label>Date</label>
                                    <input id="" name="date"type="text" class="form-control date" />
                                </div>
                                <div class="form-group">
                                    <label>Student Name</label>
          <select name="student_id[]" class="form-control select2 studentid" id="student_staff_id" multiple="multiple" required>
    <option value=""><?php echo $this->lang->line('please_select'); ?></option>
    <?php if (!empty($students)) {
        foreach ($students as $student) {
            $fullname = $student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname'];
            $classSection = $student['class'] . ' - ' . $student['section'];
            $admission_no = $student['admission_no'];
            ?>
            <option value="<?php echo $student['id']; ?>">
                <?php echo $fullname . ' (' . $admission_no . ') - ' . $classSection; ?>
            </option>
        <?php }
    } ?>
</select>
                                </div>
                              
                              
                               
                            </div><!-- /.box-body -->
                            <div class="box-footer">
                                <button type="submit" id="submitbtn" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                            </div>
                        </form>
                    </div>
                </div><!--/.col (right) -->
                <!-- left column -->
          
            <div class="col-md-<?php
if ($this->rbac->hasPrivilege('student_certificate', 'can_add')) {
    echo "8";
} else {
    echo "12";
}
?>">
                <!-- general form elements -->
                <div class="box box-primary" id="hroom">
                    <div class="box-header ptbnull">
                        <h3 class="box-title titlefix"><?php echo $this->lang->line('student_certificate_list'); ?></h3>
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <div class="table-responsive mailbox-messages">
                            <div class="download_label"><?php echo $this->lang->line('student_certificate_list'); ?></div>
                        <table class="table table-striped table-bordered table-hover example">
    <thead>
        <tr>
            <th><?php echo $this->lang->line('certificate_name'); ?></th>
            <th>Event Name</th>
            <th>Secure Position</th>
            <th>Class</th>
            <th>Section</th>
            <th>Date</th>
            <th>Student Name</th>
            <th class="text-right noExport"><?php echo $this->lang->line('action'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($studentslist)) { 
            foreach ($studentslist as $student) { ?>
                <tr>
                    <td><?php echo htmlspecialchars($student['certificate_name']); ?></td>
                    <td><?php echo htmlspecialchars($student['event_name']); ?></td>
                    <td><?php echo htmlspecialchars($student['position']); ?></td>
                    <td><?php echo htmlspecialchars($student['class']); ?></td>
                    <td><?php echo htmlspecialchars($student['section']); ?></td>
                    <td><?php echo htmlspecialchars($student['date']); ?></td>
                    <td>
                        <?php echo htmlspecialchars($student['firstname'] . ' ' . $student['father_name'] . ' ' . $student['lastname']); ?>
                    </td>
                    <td class="text-right">
                       <a href="<?php echo base_url('admin/certificate/eventCertificate_pdf/' . $student['id']); ?>" 
   class="btn btn-xs btn-primary" target="_blank">
   <i class="fa fa-print"></i> Print
</a>
                       <a href="<?php echo base_url('admin/certificate/deleteeventcertificate/' . $student['id']); ?>" 
   class="btn btn-xs btn-danger" 
   onclick="return confirm('Are you sure you want to delete this certificate?');">
   <i class="fa fa-trash"></i> Delete
</a>
                    </td>
                </tr>
        <?php } } else { ?>
                <tr>
                    <td colspan="8" class="text-center">No certificate records found.</td>
                </tr>
        <?php } ?>
    </tbody>
</table>

                        </div><!-- /.mail-box-messages -->
                    </div><!-- /.box-body -->
                </div>
            </div><!--/.col (left) -->
            <!-- right column -->
        </div>
        <div class="row">
            <div class="col-md-12">
            </div><!--/.col (right) -->
        </div>   <!-- /.row -->
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->
<!-- Modal -->


<script>
$(document).ready(function() {
    $('.select2').select2({
      
        allowClear: true,
        width: '100%'
    });
});
</script>