<link rel="stylesheet" href="<?php echo base_url(); ?>backend/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
<script src="<?php echo base_url(); ?>backend/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Google Fonts Link -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700&display=swap" rel="stylesheet">

<!-- Your CSS with print styles -->
<style>
/* Existing Styles */
.cert-preview-section {
    padding: 20px;
    background-color: #f9f9f9;
}

.card-body {
    width: 100%;
    border: 3px double rgb(207, 99, 99);
    color: black;
    padding: 30px;
    background-color: white;
    font-family: "Lato", sans-serif;
    font-weight: 700;
    text-align: justify;
    position: relative;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.card-title {
    text-align: center;
    font-size: 24px;
    padding-top: 20px;
    font-weight: 800;
    margin-bottom: 20px;
}

.card-h6, .cards-h6 {
    line-height: 1.8;
    font-weight: 800;
    font-size: 18px;
}

.card-text {
    font-size: 16px;
    line-height: 1.8;
    margin-top: 20px;
    word-spacing: 1px;
}

.img-container {
    text-align: center;
    margin-top: 15px;
}

.img-container.first-image {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: -1; /* Background Image */
    overflow: hidden;
}

.img-container.first-image img {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 100%;
    height: 100%;
    object-fit: cover;
    opacity: 0.2;
}

.img-container.second-image {
    position: absolute;
    bottom: 0;
    right: 0;
    padding: 10px;
    z-index: 1; /* Footer Image */
}

.subject, .date, .greeting {
    font-weight: 600;
    margin-top: 10px;
    font-size: 16px;
}

.modal-content {
    position: relative;
}

/* Background image styling to appear behind the content */
.img-container.first-image {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: -1; /* Keep image behind the content */
    overflow: hidden; /* Hide overflow to ensure it fits within the container */
}

.img-container.first-image img {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 100%; /* Adjust width as needed */
    height: 100%; /* Adjust height as needed */
    object-fit: cover; /* Cover the entire container */
    opacity: 0.2; /* Adjust opacity to keep it subtle */
}

/* Content should stay in front of the background */
.card-body {
    position: relative; /* Ensure the content is placed relative to the background */
    z-index: 1; /* Ensure the content stays above the background image */
}

/* Print Styles */
@media print {
    .modal-header, .modal-footer, .close {
        display: none;
    }

    .card-body {
        box-shadow: none; /* Remove box-shadow for print */
        border: none; /* Remove border for print */
        padding: 10px; /* Adjust padding for print */
        position: relative; /* Ensure content positioning is maintained */
        z-index: 1; /* Keep the content above the image */
    }

    .img-container.first-image img {
        opacity: 0.2; /* Maintain background-like effect */
        z-index: -1; /* Ensure background image stays behind the content */
    }

    .img-container {
        text-align: center; /* Ensure images are centered */
    }

    .modal-dialog {
        width: 100% !important; /* Full width for print */
    }

    .card-title, .card-h6, .cards-h6, .card-text, .subject, .date, .greeting {
        font-size: 14px; /* Adjust font size for print */
    }
}
</style>


<!-- Content Wrapper. Contains page content -->

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-flask"></i> <?php echo $this->lang->line('approve') . " " . $this->lang->line('leave'); ?>
        </h1>
    </section>
    <section class="content">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-search"></i> <?php echo $this->lang->line('select_criteria'); ?></h3>

            </div>
            <form  class="assign_teacher_form" action="<?php echo base_url(); ?>admin/approve_leave" method="post" enctype="multipart/form-data">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if ($this->session->flashdata('msg')) { ?>
                                <?php echo $this->session->flashdata('msg') ?>
                            <?php } ?>
                            <?php echo $this->customlib->getCSRF(); ?>
                        </div>
                        <div class="col-md-3 col-lg-3 col-sm-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
                                <select autofocus="" id="searchclassid" name="class_id" onchange="getSectionByClass(this.value)"  class="form-control" >
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                    <?php
                                    foreach ($classlist as $class) {
                                        ?>
                                        <option <?php
                                        if ($class_id == $class["id"]) {
                                            echo "selected";
                                        }
                                        ?> value="<?php echo $class['id'] ?>"><?php echo $class['class'] ?></option>
                                            <?php
                                        }
                                        ?>
                                </select>
                                <span class="class_id_error text-danger"><?php echo form_error('class_id'); ?></span>
                            </div>
                        </div>
                        <div class="col-md-3 col-lg-3 col-sm-6">
                            <div class="form-group">
                                <label><?php echo $this->lang->line('section'); ?></label><small class="req"> *</small>
                                <select  id="secid" name="section_id" class="form-control" >
                                    <option value=""><?php echo $this->lang->line('select'); ?></option>
                                </select>
                                <span class="class_id_error text-danger"><?php echo form_error('section_id'); ?></span>
                            </div>
                        </div>

                    </div>
                    <button type="submit" id="search_filter" name="search" value="search_filter" class="btn btn-primary btn-sm checkbox-toggle pull-right"><i class="fa fa-search"></i> <?php echo $this->lang->line('search'); ?></button>
                </div>
            </form>
            <div class="row">
                <div class="col-md-12">


                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-users"></i> <?php echo $this->lang->line('approve') . " " . $this->lang->line('leave') . " " . $this->lang->line('list'); ?></h3>

                        <div class="box-tools pull-right">
                            <button type="button" onclick="add_leave()" class="btn btn-sm btn-primary " data-toggle="tooltip" data-placement="left" ><i class="fa fa-plus"></i> <?php echo $this->lang->line('add'); ?></button>
                        </div>

                    </div>
 

                    <div class="box-body table-responsive">
                        <div class="download_label"> <?php echo $this->lang->line('approve') . " " . $this->lang->line('leave') . " " . $this->lang->line('list'); ?> </div>
                        <div >
                            <table class="table table-hover table-striped table-bordered example">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('student_name') ?></th>
                                        <th><?php echo $this->lang->line('class'); ?></th>
                                        <th><?php echo $this->lang->line('section'); ?></th>
                                        <th><?php echo $this->lang->line('apply') . " " . $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('from') . " " . $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('to') . " " . $this->lang->line('date'); ?></th>

                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        
                                        <th><?php echo $this->lang->line('approve') . " " . $this->lang->line('by') . " " . $this->lang->line('teacher'); ?></th>
                                        <th><?php echo $this->lang->line('approve') . " " . $this->lang->line('by'); ?></th>
                                        <th><?php echo $this->lang->line('hostel') . " " . "Checkout" . " " . $this->lang->line('by'); ?></th>
                                        <th><?php echo $this->lang->line('hostel') . " " . "Checkout" . " " . $this->lang->line('date') . " & " .$this->lang->line('time'); ?></th>
                                        <th><?php echo $this->lang->line('hostel') . " " . "Checkin" . " " . $this->lang->line('by'); ?></th>
                                        <th><?php echo $this->lang->line('hostel') . " " . "CheckIn" . " " . $this->lang->line('date') . " & " . $this->lang->line('time'); ?></th>
                                        
                                        
                                        <th class="text-right"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    foreach ($results as $value) {
                                        $date
                                        ?>
                                        <tr>
                                            <td><?php echo $this->customlib->getFullName($value['firstname'],$value['middlename'],$value['lastname'],$sch_setting->middlename,$sch_setting->lastname); ?></td>
                                            <td><?php echo $value['class']; ?></td>
                                            <td><?php echo $value['section']; ?></td>
                                            <td><?php echo date($this->customlib->getSchoolDateFormat(), strtotime($value['apply_date'])); ?></td>
                                            <td><?php echo date($this->customlib->getSchoolDateFormat(), strtotime($value['from_date'])); ?></td>
                                            <td><?php echo date($this->customlib->getSchoolDateFormat(), strtotime($value['to_date'])); ?></td>


                                            <td ><?php
                                                if ($value['status'] == 0) {
                                                    echo $this->lang->line('pending');
                                                } else {
                                                    echo $this->lang->line('approve');
                                                }
                                                ?>
                                            </td>
                                            
                                            <td><?php echo $value['teacher_name'] . " " . $value['teacher_surname']; ?></td>
                                            <td><?php echo $value['staff_name'] . " " . $value['surname']; ?></td>
                                            <td><?php  echo $value['hostel_manager_name'] . " " . $value['hostel_manager_surname']; ?></td>

                                            <td><?php if($value['hostel_checkout_date']!=''){ echo date('d-m-Y', strtotime($value['hostel_checkout_date'])) ." & ". date('h:i A', strtotime($value['hostel_checkout_date']));  }?>    </td>

                                            <td><?php  echo $value['checkin_name'] . " " . $value['checkin_surname']; ?></td>

                                            <td><?php if($value['checkin_date_time']!=''){ echo date('d-m-Y', strtotime($value['checkin_date_time'])) ." & ". date('h:i A', strtotime($value['checkin_date_time'])); }?></td>
                                            

                                            <td class="text-right white-space-nowrap">
                                                <?php
                                                if ($role_id==2) {

                                                if ($value['hostel_manager'] == 0) {
                                                        
                                                    

                                                    if ($value['approved_by_teacher'] != 0) {
                                                    ?>
                                                    <a data-placement="left"  onclick="approve_leave('<?php echo $value['id']; ?>', '0', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>')"  class="btn btn-default btn-xs" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('disapprove') ?>"> <i class="fa fa-times"  aria-hidden="true"></i></a>
                                                    <?php
                                                    } else {
                                                        ?>
                                                        <a data-placement="left"  onclick="approve_leave('<?php echo $value['id']; ?>', '1', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('approve') ?>"><i class="fa fa-check" aria-hidden="true"></i></a>
                                                        <?php
                                                    }
                                                }
                                                    
                                                }else if($role_id==8 || $role_id==9){

                                                    if ($value['hostel_manager'] != 0 && $value['check_in_by'] == 0) {
                                                    ?>
                                                    <!-- <a data-placement="left"  onclick="approve_leave('<?php echo $value['id']; ?>', '0', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>')"  class="btn btn-default btn-xs" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('disapprove') ?>"> <i class="fa fa-times"  aria-hidden="true"></i></a> -->
                                                    <a data-placement="left" onclick="student_check_in('<?php echo $value['id']; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" title="" data-original-title="Check In">Check In</a>
                                                    <?php
                                                }else if ($value['check_in_by'] != 0) {

                                                    echo 'checked in';
                                                   
                                                } else {
                                                    ?>
                                                    <a data-placement="left"  data-target="#hostel_approval_model" data-id="<?php echo $value['id']; ?>" id="Approve_btn" class="btn btn-default btn-xs" data-toggle="modal" data-original-title="<?php echo $this->lang->line('approve') ?>"><i class="fa fa-check" aria-hidden="true"></i></a>
                                                    <?php
                                                }


                                            }else{
                                                if ($value['hostel_manager'] == 0) {
                                                       
                                                    
                                                    if ($value['status'] == 1) {
                                                    ?>
                                                    <a data-placement="left"  onclick="approve_leave('<?php echo $value['id']; ?>', '0', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>')"  class="btn btn-default btn-xs" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('disapprove') ?>"> <i class="fa fa-times"  aria-hidden="true"></i></a>
                                                    <?php
                                                    } else {
                                                        ?>
                                                        <a data-placement="left"  onclick="approve_leave('<?php echo $value['id']; ?>', '1', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('approve') ?>"><i class="fa fa-check" aria-hidden="true"></i></a>
                                                        <?php
                                                    }?>
                                                    <a data-placement="left" onclick="get('<?php echo $value['id']; ?>', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('edit') ?>"><i class="fa fa-pencil"></i> </a>

                                                    <a data-placement="left" onclick="delete_leave('<?php echo $value['id']; ?>', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>');"  data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('delete') ?>" class="btn btn-default btn-xs"><i class="fa fa-trash" ></i> </a>
                                                    <?php 
                                                }
                                            }
                                                
                                                ?>
                                                <?php
                                                if ($value['docs'] != '') {
                                                    ?>
                                                    <a data-placement="left" href="<?php echo base_url(); ?>admin/approve_leave/download/<?php echo $value['docs'] ?>" class="btn btn-default btn-xs" data-toggle="tooltip" title="" data-original-title="<?php echo $this->lang->line('download'); ?>">
                                                        <i class="fa fa-download"></i>
                                                    </a>
                                                    <?php
                                                }
                                                ?>

                                                <!-- <a data-placement="left" data-id="<?php echo $value['id']; ?>" data-target="#studentcertificate" class="btn btn-default btn-xs show_certificate" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('certificate') ?>"><i class="fa fa-certificate"></i></a>

                                                <a data-placement="left" onclick="get('<?php echo $value['id']; ?>', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>')" class="btn btn-default btn-xs" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('edit') ?>"><i class="fa fa-pencil"></i> </a>

                                                <a data-placement="left" onclick="delete_leave('<?php echo $value['id']; ?>', '<?php echo $value['class_id']; ?>', '<?php echo $value['section_id']; ?>');"  data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('delete') ?>" class="btn btn-default btn-xs"><i class="fa fa-trash" ></i> </a> -->
                                                



                                            </td>
                                        </tr>
                                        <?php
                                    }
                                    ?>

                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div></section>
</div>


<div class="modal fade" id="studentcertificate" role="dialog">
    <div class="modal-dialog" style="width:80%;">       
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title title text-center modal_title">Leave Letter</h4>
            </div>
            <div class="modal-body">
                <div class="form-horizontal">
                    <div class="box-body">
                        <div class="cert-preview-section" id="printArea">
                            <div class="card-body text-black">
                                <h5 class="card-title">Leave Letter</h5>

                                <h6 class="card-h6">
                                    To,<br>
                                    The Principal,<br>
                                    <span class="school-name">(School Name)</span>,<br>
                                    <span class="school-address">(School Address)</span><br>
                                </h6>

                                <!-- Background-like image container -->
                                <!-- <div class="img-container first-image">
                                    <img class="school-image" src="https://kcgcollege.ac.in/wp-content/uploads/2018/11/hfgc-logoimg.png" alt="school logo" style="opacity: 0.09;">
                                </div> -->

                                <h6 class="subject">Subject: Application For Leave</h6>
                                <h6 class="date">Date: <span class="ap_date"></span></h6>
                                <h6 class="greeting">Dear Sir/Madam,</h6>

                                <p class="card-text">
                                    I am <span class="your-name">(Your Name)</span>, a student of <span class="class-section">(Class and Section)</span>.
                                    I want to bring to your kind attention that due to <span class="reason">(Mention your reason)</span>, I will be unable to come to school from <span class="from-date">(date)</span> to <span class="to-date">(date)</span>.
                                </p>

                                <p class="card-text">
                                    I request you to kindly grant me leave for the dates mentioned above. I assure you that I will catch up with my studies after returning. I shall be grateful for your understanding.
                                </p>
                                <p class="card-text">Thanking you.</p>

                                <h6 class="cards-h6">Yours faithfully,<br><span class="your-name">(Your Name)</span></h6>

                                <!-- Footer image container -->
                                <div class="img-container second-image">
                                    <img class="school-image" src="https://kcgcollege.ac.in/wp-content/uploads/2018/11/hfgc-logoimg.png" alt="footer logo" style="opacity: 0.09;">
                                </div>
                            </div>
                        </div>

                        <div class="text-center" style="margin-top: 20px;">
                            <button type="button" class="btn btn-primary" onclick="printDiv('printArea')">Print</button>
                        </div>
                    </div>                   
                </div>
            </div>
            <div class="modal-footer">&nbsp;</div>
        </div>
    </div>
</div>




<div class="modal fade" id="homework_docs" tabindex="-1" role="dialog" aria-labelledby="evaluation" style="padding-left: 0 !important">
    <div class="modal-dialog " role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="box-title" id="title"></h4>
            </div>
            <form role="form" id="addleave_form" method="post" enctype="multipart/form-data" action="">

                <div class="modal-body pb0">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="row">
                                <!-- <input type="hidden" id="leave_id"  name="leave_id"> -->
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('class'); ?></label><small class="req"> *</small>
                                        <select type="text" onchange="get_section(this.value)" name="class" id="class" class="form-control ">
                                            <option value="" ><?php echo $this->lang->line('select'); ?></option>
                                            <?php foreach ($classlist as $value) {
                                                ?>
                                                <option value="<?php echo $value['id']; ?>"><?php echo $value['class']; ?></option>
        <?php }
        ?>



                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('section'); ?></label><small class="req"> *</small>
                                        <select type="text" name="section" id="section_id" onchange="get_student(this.value)" class="form-control ">

                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('student'); ?></label><small class="req"> *</small>
                                        <select type="text" name="student" id="student" class="form-control ">
                                            <option value=""><?php echo $this->lang->line('select'); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('apply') . " " . $this->lang->line('date'); ?></label><small class="req"> *</small>
                                        <input type="text" name="apply_date" id="apply_date" class="form-control date">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('from') . " " . $this->lang->line('date'); ?></label><small class="req"> *</small>
                                        <input type="text" name="from_date" id="from_date" class="form-control date">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('to') . " " . $this->lang->line('date'); ?></label><small class="req"> *</small>
                                        <input type="text" name="to_date" id="to_date"  class="form-control date">
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('reason'); ?></label>
                                        <input type="hidden" name="leave_id" id="leave_id">
                                        <textarea type="text" id="message" name="message" class="form-control "></textarea>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('attach_document'); ?></label>
                                        <input type="file" id="file" name="userfile" class="filestyle form-control" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box-footer">

                    <div class="pull-right paddA10">
                        <button class="btn btn-info pull-right"  data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please wait" value=""><?php echo $this->lang->line('save'); ?></button>

                    </div>
            </form>
        </div>
    </div>
</div>


</div>

<div class="modal fade" id="hostel_approval_model"   tabindex="-1" role="dialog" aria-labelledby="evaluation" aria-hidden="true" style="padding-left: 0 !important">
    <div class="modal-dialog " role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="box-title" id="title"></h4>
            </div>
            <form role="form" id="hostel_approval_form" method="post" enctype="multipart/form-data" action="">

                <div class="modal-body pb0">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="row">
                                <input type="hidden" id="leave_request_id"  name="leave_request_id">
                                
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd">Check Out with</label><small class="req"> *</small>
                                        <select type="text" name="check_out_with" id="check_out_with"  class="form-control">
                                            <option value="">Select</option>

                                            <option value="self">Self</option>
                                            <option value="family_member">Family Member</option>

                                        </select>
                                        <span id="check_out_with_error" style="color: red;"></span>
                                    </div>
                                </div>
                                <div class="family_memeber_details hidden" >
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd">Name of family member</label><small class="req"> *</small>
                                        
                                       <input type="text" name="family_member" id="family_member" class="form-control">
                                       <span id="family_member_error" style="color: red;"></span>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd">Relation With family member</label><small class="req"> *</small>
                                        
                                       <input type="text" name="relation_with_family_member" id="relation_with_family_member" class="form-control" placeholder="father/mother/brother...">
                                       <span id="relation_with_family_member_error" style="color: red;"></span>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd">Contact Number</label><small class="req"> *</small>
                                        <input type="number" name="family_member_contact" id="family_member_contact" class="form-control">
                                        <span id="family_member_contact_error" style="color: red;"></span>
                                    </div>
                                </div>
                                </div>
                                
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="pwd"><?php echo $this->lang->line('reason'); ?></label>
                                        
                                        <textarea type="text" id="hostel_reason" name="hostel_reason" class="form-control "></textarea>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>

                <div class="box-footer">

                    <div class="pull-right paddA10">
                        <button class="btn btn-info pull-right"   data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please wait" value=""><?php echo $this->lang->line('approve'); ?></button>

                    </div>
            </form>
        </div>
    </div>
</div>

<!-- -->
<script type="text/javascript">

    function student_check_in(id) {

        var confirmation = confirm('Are You Sure? you want to Check In student!');

        if (confirmation==true) {

            $.ajax({
            url: "<?php echo site_url("admin/approve_leave/student_check_in") ?>/" + id,
            type: "POST",
            dataType: 'json',
            contentType: false,
            cache: false,
            processData: false,

            success: function (res)
            {

                if (res.status==1) {
                    successMsg(res.success);
                    location.reload();
                }

                
            }
        });

        }

        

    }


    $('#homework_docs').on('hidden.bs.modal', function () {

        $(this).find("input,textarea,select")
                .val('')
                .end()
                .find("input[type=checkbox], input[type=radio]")
                .prop("checked", "")
                .end();
        $('#section_id').find('option').not(':first').remove();
        $('#student').find('option').not(':first').remove();
    });

    $(document).ready(function (e) {

        getSectionByClass("<?php echo $class_id ?>", "<?php echo $section_id; ?>");



    });

    function approve_leave(id, status, class_id, section_id) {
        $.ajax({
            url: "<?php echo site_url("admin/approve_leave/status") ?>",
            type: "POST",
            data: {'class_id': class_id, 'section_id': section_id, 'id': id, 'status': status},
            dataType: "json",

            success: function (res)
            {
                if (res.status == 0) {
                    errorMsg(res.error);
                } else {
                    successMsg(res.success);
                    window.location.reload(true);
                }


            }
        });

    }

    function getSectionByClass(class_id, section_id) {
        if (class_id != "") {
            $('#secid').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                beforeSend: function () {
                    $('#secid').addClass('dropdownloading');
                },
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";
                    });
                    $('#secid').append(div_data);
                },
                complete: function () {
                    $('#secid').removeClass('dropdownloading');
                }
            });
        }
        if (section_id != "") {

            $('#secid').val(section_id);

        }
    }
    function get_section(class_id, section_id = null) {
        if (class_id != "") {
            $('#section_id').html("");
            var base_url = '<?php echo base_url() ?>';
            var div_data = '<option value=""><?php echo $this->lang->line('select'); ?></option>';
            $.ajax({
                type: "GET",
                url: base_url + "sections/getByClass",
                data: {'class_id': class_id},
                dataType: "json",
                success: function (data) {
                    $.each(data, function (i, obj)
                    {
                        var sel = "";
                        if (section_id == obj.section_id) {
                            sel = "selected";
                        }
                        div_data += "<option value=" + obj.section_id + " " + sel + ">" + obj.section + "</option>";

                    });




                    $('#section_id').append(div_data);

                }

            });
    }
    }



    function delete_leave(leave_id, class_id, section_id) {
        var confirmation = confirm('<?php echo $this->lang->line('delete_confirm') ?>');
        if (confirmation == true) {


            $.ajax({
                url: "<?php echo site_url("admin/approve_leave/remove_leave") ?>",
                type: "POST",
                data: {'class_id': class_id, 'section_id': section_id, 'id': leave_id},
                dataType: "json",
                success: function (res)
                {
                    if (res.status == 0) {
                        errorMsg(res.error);
                    } else {
                        successMsg(res.success);
                        window.location.reload(true);
                    }


                }
            });
        }
    }

    function get(id, class_id, section_id) {

        $.ajax({
            url: "<?php echo site_url("admin/approve_leave/get_details") ?>",
            type: "POST",
            data: {'class_id': class_id, 'section_id': section_id, 'id': id},
            dataType: 'json',

            success: function (res)
            {
                if (res.status == 0) {
                    errorMsg(res.error)
                } else {
                    $('#apply_date').val(res.apply_date);
                    $('#from_date').val(res.from_date);
                    $('#to_date').val(res.to_date);
                    $('#message').html(res.reason);
                    $('#leave_id').val(res.id);
                    $('#class').val(res.class_id);
                    $('#title').html('<?php echo $this->lang->line('edit') . " " . $this->lang->line('leave'); ?>');
                    get_section(res.class_id, res.section_id);
                    get_student(res.section_id, res.stud_id);
                    $('#homework_docs').modal({
                        backdrop: 'static',
                        keyboard: false,
                        show: true
                    });
                }

            }
        });

    }

    function get_student(id, student_id = null, section_id = null) {

        $('#student').html("");
        var class_id = $('#class').val();

        $.ajax({
            url: "<?php echo site_url("admin/approve_leave/searchByClassSection") ?>/" + class_id + "/" + student_id,
            type: "POST",
            data: {section_id: id},
            success: function (res)
            {

                $('#student').html(res);
            }
        });
    }

    function add_leave() {
        $('#title').html('<?php echo $this->lang->line('add') . " " . $this->lang->line('leave'); ?>');
        $('#homework_docs').modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });

    }

    $(document).ready(function () {
        $('#myModal').modal({
            backdrop: 'static',
            keyboard: false,
            show: false
        });
    });

    $("#addleave_form").on('submit', (function (e) {
        e.preventDefault();

        var $this = $(this).find("button[type=submit]:focus");

        $.ajax({
            url: "<?php echo site_url("admin/approve_leave/add") ?>",
            type: "POST",
            data: new FormData(this),
            dataType: 'json',
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function () {
                $this.button('loading');

            },
            success: function (res)
            {

                if (res.status == "fail") {

                    var message = "";
                    $.each(res.error, function (index, value) {

                        message += value;
                    });
                    errorMsg(message);

                } else {

                    successMsg(res.message);

                    window.location.reload(true);
                }
            },
            error: function (xhr) { // if error occured
                alert("Error occured.please try again");
                $this.button('reset');
            },
            complete: function () {
                $this.button('reset');
            }

        });
    }));

    $(document).on('click','.show_certificate',function () {
        var leaveId=$(this).attr('data-id');

         $.ajax({
            url: "<?php echo site_url("admin/approve_leave/getLeaveData") ?>",
            type: "POST",
            data: {leaveId:leaveId},
            dataType: 'json',

            beforeSend: function () {


            },
            success: function (res)
            {

                if (res.status == "fail") {

                    var message = "";
                    $.each(res.error, function (index, value) {

                        message += value;
                    });
                    errorMsg(message);

                } else {
                    console.log(res.schoolData);

                    var FullName = res.leaveData.firstname + 
               (res.leaveData.middlename ? " " + res.leaveData.middlename : "") + 
               (res.leaveData.lastname ? " " + res.leaveData.lastname : "");
               var class_section= res.leaveData.class + " " + res.leaveData.section;

                var imageUrl = "<?= site_url('uploads/school_content/admin_logo') ?>" + "/" + res.schoolData.image;


                    $('.school-image').attr('src', imageUrl);



                    $('.school-name').html(res.schoolData.name);
                    $('.school-address').html(res.schoolData.address);
                    $('.your-name').html(FullName);
                    $('.class-section').html(class_section);
                    $('.reason').html(res.leaveData.reason);
                    $('.from-date').html(res.leaveData.from_date);
                    $('.to-date').html(res.leaveData.to_date);
                    $('.school-address').html(res.schoolData.address);
                    $('.ap_date').html(res.leaveData.apply_date);



                    // window.location.reload(true);
                    $('#studentcertificate').modal('show');
                }
            },
            error: function (xhr) { // if error occured
                alert("Error occured.please try again");
                $this.button('reset');
            },
            complete: function () {
                $this.button('reset');
            }

        });        
    })


    function printDiv(divId) {
    // Get the content of the div to print
    var printContents = document.getElementById(divId).innerHTML;

    // Create a new window
    var printWindow = window.open('', '', 'height=600,width=800');

    // Write HTML to the new window including the content and styles
    printWindow.document.write('<html><head><title>Print</title>');

    // Include the styles from the current page
    var styles = document.querySelectorAll('link[rel="stylesheet"], style');
    for (var i = 0; i < styles.length; i++) {
        printWindow.document.write(styles[i].outerHTML);
    }

    printWindow.document.write('</head><body>');

    // Write the contents of the div
    printWindow.document.write(printContents);
    printWindow.document.write('</body></html>');

    // Close the document so that it is ready for printing
    printWindow.document.close();

    // Wait for the content to load and then print
    printWindow.onload = function () {
        printWindow.focus();  // Ensure the window is in focus
        printWindow.print();
        printWindow.close();  // Close the print window after printing
    };
}


    $("#hostel_approval_form").on('submit', (function (e) {
        e.preventDefault();

        var $this = $(this).find("button[type=submit]:focus");
        var id=$('#leave_request_id').val();

        var check_out_with=$('#check_out_with').val();
        var family_member =$('#family_member').val();
        var relation_with_family_member=$('#relation_with_family_member').val();
        var family_member_contact=$('#family_member_contact').val();

        if (check_out_with=='') {
            $('#check_out_with_error').html('please select check out with');
            return false;
        }else{
            $('#check_out_with_error').html('');
        }

        if (check_out_with=='family_member') {

            if (family_member=='') {
                
                $('#family_member_error').html('please enter family member name');
                return false;
            }else{
                $('#family_member_error').html('');
            }
            if (relation_with_family_member=='') {
                
                $('#relation_with_family_member_error').html('please enter Relation with family member name');
                return false;
            }else{
                $('#relation_with_family_member_error').html('');
            }
            if (family_member_contact=='') {
             
                $('#family_member_contact_error').html('please enter family member Contact Number');
                return false;
            }else{
                $('#family_member_contact_error').html('');
            }
        }



        $.ajax({
            url: "<?php echo site_url("admin/approve_leave/status") ?>",
            type: "POST",
            data: {'check_out_with': check_out_with , 'family_member': family_member ,'relation_with_family_member': relation_with_family_member ,'family_member_contact': family_member_contact , 'id': id, 'status': 1},
            dataType: 'json',
            
            beforeSend: function () {
                $this.button('loading');

            },
            success: function (res)
            {

                if (res.status == "fail") {

                    var message = "";
                    $.each(res.error, function (index, value) {

                        message += value;
                    });
                    errorMsg(message);

                } else {
                    if (res.status==1) {

                        successMsg(res.success);

                    window.location.reload(true);

                    }

                    
                }
            },
            error: function (xhr) { // if error occured
                alert("Error occured.please try again");
                $this.button('reset');
            },
            complete: function () {
                $this.button('reset');
            }

        });        
    }));


    function printDiv(divId) {
    // Get the content of the div to print
    var printContents = document.getElementById(divId).innerHTML;
    
    // Create a new window
    var printWindow = window.open('', '', 'height=600,width=800');
    
    // Write HTML to the new window including the content and styles
    printWindow.document.write('<html><head><title>Print</title>');
    
    // Include the styles from the current page
    var styles = document.querySelectorAll('link[rel="stylesheet"], style');
    for (var i = 0; i < styles.length; i++) {
        printWindow.document.write(styles[i].outerHTML);
    }
    
    printWindow.document.write('</head><body>');
    
    // Write the contents of the div
    printWindow.document.write(printContents);
    printWindow.document.write('</body></html>');
    
    // Close the document so that it is ready for printing
    printWindow.document.close();
    
    // Wait for the content to load and then print
    printWindow.onload = function () {
        printWindow.focus();  // Ensure the window is in focus
        printWindow.print();
        printWindow.close();  // Close the print window after printing
    };
}


    $(document).on('change','#check_out_with',function () {
        var value=$(this).val();

        if (value=='family_member') {
            $('.family_memeber_details').removeClass('hidden');
        }else{
            $('.family_memeber_details').addClass('hidden');
        }
    });


    $(document).on('click','#Approve_btn',function () {
        var value=$(this).attr('data-id');

        $('#leave_request_id').val(value);
    });
    


    

    

</script>