<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
class Substitute_model extends MY_Model
{
    public function __construct() {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
    }
    public function get_substitute_assignments_report($filters = array()) {
        $this->db->select('
            sta.id,
            sta.date,
            sta.day,
            sta.class_id,
            sta.section_id,
            sta.subject_group_subject_id,
            sta.period_start,
            sta.period_end,
            leave_teacher.name as leave_teacher_name,
            leave_teacher.surname as leave_teacher_surname,
            substitute_teacher.name as substitute_teacher_name,
            substitute_teacher.surname as substitute_teacher_surname,
            classes.class,
            sections.section,
            subjects.name as subject_name,
            sta.created_at
        ');
        $this->db->from('substitute_teacher_assignments as sta');
        $this->db->join('staff as leave_teacher', 'leave_teacher.id = sta.leave_staff_id', 'left');
        $this->db->join('classes', 'classes.id = sta.class_id');
        $this->db->join('sections', 'sections.id = sta.section_id');
        $this->db->join('subject_group_subjects', 'subject_group_subjects.id = sta.subject_group_subject_id');
        $this->db->join('subjects', 'subjects.id = subject_group_subjects.subject_id');
        $this->db->join('staff as substitute_teacher', 'substitute_teacher.id = sta.substitute_staff_id', 'left');

        // Apply filters if provided
        if (!empty($filters['start_date'])) {
            $this->db->where('sta.date >=', $filters['start_date']);
        }
        if (!empty($filters['end_date'])) {
            $this->db->where('sta.date <=', $filters['end_date']);
        }
        if (!empty($filters['leave_teacher_id'])) {
            $this->db->where('sta.leave_staff_id', $filters['leave_teacher_id']);
        }
        if (!empty($filters['substitute_teacher_id'])) {
            $this->db->where('sta.substitute_staff_id', $filters['substitute_teacher_id']);
        }

        $this->db->order_by('sta.date', 'asc');
        $this->db->order_by('sta.period_start', 'asc');

        return $this->db->get()->result_array();
    }
}