<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Student_MedicalCheckup_model extends MY_Model
{
	public function __construct()
    {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
        $this->current_date    = $this->setting_model->getDateYmd();
    }

	public function get($id=null)
	{
		$this->db->select('student_medical_checkup.*,students.firstname,students.middlename,students.lastname,classes.class,sections.section');
		$this->db->from('student_medical_checkup')
		->join('student_session','student_medical_checkup.student_session_id = student_session.id')
		->join('students','students.id = student_session.student_id')
		->join('classes','classes.id = student_medical_checkup.class_id')
		->join('sections','sections.id = student_medical_checkup.section_id');

		if ($id != null) {
			$this->db->where('student_medical_checkup.id',$id);
		}else{

			$this->db->order_by('student_medical_checkup.id');
		}

		$this->db->where('student_session.session_id',$this->current_session);

		$query=$this->db->get();

		if ($id != null) {
			return $query->row();
		}else{
			return $query->result_array();
		}

		
	}
	
	
	public function get_medical_checkup_count($search = '')
    {
        $this->db->from('student_medical_checkup AS checkup');
        $this->db->join('student_session', 'student_session.id = checkup.student_session_id');
        $this->db->join('students', 'students.id = student_session.student_id');
        $this->db->join('classes', 'classes.id = student_session.class_id');
        $this->db->join('sections', 'sections.id = student_session.section_id');
    
        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like("CONCAT_WS(' ', students.firstname, students.middlename, students.lastname)", $search);
            $this->db->group_end();
        }
    
        return $this->db->count_all_results();
    }

    public function get_medical_checkup_data($start, $length, $search = '', $order_by = 'students.id', $order_dir = 'asc')
    {
        $this->db->select("
            CONCAT_WS(' ', students.firstname, students.middlename, students.lastname) as student_name,
            classes.class as class_name,
            sections.section as section_name,
            checkup.weight,
            checkup.id,
            checkup.temprature,
            checkup.bp,
            checkup.symptoms,
            checkup.diagnosis,
            checkup.prescription,
            checkup.remark
        ");
        $this->db->from('student_medical_checkup AS checkup');
        $this->db->join('student_session', 'student_session.id = checkup.student_session_id');
        $this->db->join('students', 'students.id = student_session.student_id');
        $this->db->join('classes', 'classes.id = student_session.class_id');
        $this->db->join('sections', 'sections.id = student_session.section_id');
    
        
        
        if (!empty($search)) {
            $this->db->group_start();
            $this->db->like("CONCAT_WS(' ', students.firstname, students.middlename, students.lastname)", $search);
            $this->db->group_end();
        }
    
        $this->db->order_by($order_by, $order_dir);
        $this->db->limit($length, $start);
        $query = $this->db->get();
    
        $result = $query->result_array();
    
        // Append action buttons if needed
        foreach ($result as &$row) {
            
            
            $row['action'] = '';

            if ($this->rbac->hasPrivilege('student_checkup', 'can_edit')) {
                $row['action'] .= '<a href="' . base_url('admin/students_medical_checkup/edit/' . $row['id']) . '" class="btn btn-default btn-xs" data-toggle="tooltip" title="Edit">
                    <i class="fa fa-pencil"></i>
                </a> ';
            }
            
            if ($this->rbac->hasPrivilege('student_checkup', 'can_delete')) {
                $row['action'] .= '<a href="' . base_url('admin/students_medical_checkup/delete/' . $row['id']) . '" class="btn btn-default btn-xs" data-toggle="tooltip" title="Delete" onclick="return confirm(\'Are you sure you want to delete this record?\');">
                    <i class="fa fa-remove"></i>
                </a>';
            }

        }
    
        return $result;
    }



}