<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Staff_loan_model extends My_Model
{
 
    public function __construct()
    {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */
    
    

    public function get($id = null,$staff_id = null)
    {
        $this->db->select('staff_loan.*,staff.name,staff.surname')->from('staff_loan');
        $this->db->join('staff', 'staff_loan.staff_id = staff.id');
        if ($id != null) {
            $this->db->where('staff_loan.id', $id);
        } else {
            $this->db->order_by('staff_loan.id', 'DESC');
        }

        if (!empty($staff_id)) {
        	$this->db->where('staff_loan.staff_id', $staff_id);
        }

        $query = $this->db->get();
        if ($id != null) {
            return $query->row_array();
        } else {
            return $query->result_array();
        }
    }


    public function deductLoan($staff_id, $loan_deduction) {

    $this->db->trans_start(); // Start transaction

    // Fetch leave records for the staff_id, ordered by the oldest entries
    $loan_deduction_data = $this->db->order_by('id', 'ASC')
                               ->where('staff_id',$staff_id)
                               ->get('staff_loan')
                               ->result_array();

    foreach ($loan_deduction_data as $loan) {
        if ($loan_deduction <= 0) {
            break; // Exit loop if no more leaves to deduct
        }

        if ($loan['loan_amount'] > 0) {
            if ($loan['loan_amount'] >= $loan_deduction) {
                // Case: The current record has enough leaves to cover the deduction
                $this->db->where('id', $loan['id'])
                         ->update('staff_loan', [
                             'loan_amount' => $loan['loan_amount'] - $loan_deduction
                         ]);
                $loan_deduction = 0;
            } else {
                // Case: Deduct all leaves from the current record
                $loan_deduction -= $loan['loan_amount'];
                $this->db->where('id', $loan['id'])
                         ->update('staff_loan', [
                             'loan_amount' => 0
                         ]);
            }
        }
    }

    $this->db->trans_complete(); // Complete transaction

    if ($this->db->trans_status() === FALSE) {
        // Handle transaction failure
        return false;
    }

    return true;
}


public function adjustLoanAmount($staff_id, $deducted_amount) {
    $this->db->trans_start(); // Start a database transaction

    // Fetch all approved loan records for the staff, ordered by the earliest id
    $loan_data = $this->db->order_by('id', 'ASC')
                          ->where('staff_id', $staff_id)
                          ->get('staff_loan')
                          ->result_array();

    foreach ($loan_data as $loan) {
        if ($deducted_amount <= 0) {
            break; // No more amount to deduct
        }

        $actual_loan_amount = $loan['actual_loan_amount'];
        $loan_amount = $loan['loan_amount'];
        $loan_id = $loan['id'];

        // Calculate the total after adding deducted_amount to the current loan amount
        $total = $deducted_amount + $loan_amount;

        if ($total <= $actual_loan_amount) {
            // If the total is within the actual loan amount, update the loan and deduct all
            $new_loan_amount = $total;

            // Update the database
            $this->db->where('id', $loan_id)
                     ->update('staff_loan', ['loan_amount' => $new_loan_amount]);

            // Deduct the full amount
            $deducted_amount = 0;
        } else {
            // If the total exceeds the actual loan amount
            $remaining_amount = $actual_loan_amount - $loan_amount;

            // Update the loan amount to the actual loan amount
            $this->db->where('id', $loan_id)
                     ->update('staff_loan', ['loan_amount' => $actual_loan_amount]);

            // Deduct the used portion from the total deducted_amount
            $deducted_amount -= $remaining_amount;
        }
    }

    $this->db->trans_complete(); // Complete the transaction

    if ($this->db->trans_status() === FALSE) {
        // Handle transaction failure
        return false;
    }

    return true; // Transaction successful
}


     /**
     * This function is used to get income list by using datatable
     */
     public function getlist()
    {
        $this->datatables
            ->select('staff_loan.*,staff.name,staff.surname')
            ->searchable('staff_loan.*,staff.name,staff.surname')
            ->orderable('staff_loan.loan_amount,staff_loan.loan_emi,staff.name')
            ->join("staff", "staff_loan.staff_id = staff.id")
            ->sort('staff_loan.id', 'desc')
            ->from('staff_loan');
        return $this->datatables->generate('json');
    }

    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id)
    {

        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $this->db->where('id', $id);
        $this->db->delete('staff_loan');
        
        $message   = DELETE_RECORD_CONSTANT . " On  staff_loan   id " . $id;
        $action    = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {

            return $id;
        }
    }

    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data)
    {

        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        if (isset($data['id'])) {

            $this->db->where('id', $data['id']);
            $this->db->update('staff_loan', $data);
            $message   = UPDATE_RECORD_CONSTANT . " On  staff_loan   id " . $data['id'];
            $action    = "Update";
            $record_id = $data['id'];
        } else {
            $this->db->insert('staff_loan', $data);
            $return_value = $this->db->insert_id();
            $message      = INSERT_RECORD_CONSTANT . " On  staff_loan   id " . $return_value;
            $action       = "Insert";
            $record_id    = $return_value;
        }

        $this->log($message, $record_id, $action);

        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {

            return $record_id;
        }
    }

     public function createvoucher($data)
     {
        $oldv = $this->db->where('voucher_no', $data['voucher_no'])
                     ->get('voucher_details')
                     ->row_array();
        if (!empty($oldv)) {

            $this->db->where('voucher_no', $data['voucher_no']);
            $this->db->update('voucher_details', $data);
            $message   = UPDATE_RECORD_CONSTANT . " On  Voucher   id " . $data['voucher_no'];
            $action    = "Update";
            $record_id = $data['voucher_no'];
        } else {
            $this->db->insert('voucher_details', $data);
            $return_value = $this->db->insert_id();
            $message      = INSERT_RECORD_CONSTANT . " On  Voucher   id " . $return_value;
            $action       = "Insert";
            $insert_id    = $return_value;
        }
         
     }

    public function check_Exits_group($data)
    {
        $this->db->select('*');
        $this->db->from('income');
        $this->db->where('session_id', $this->current_session);
        $this->db->where('feetype_id', $data['feetype_id']);
        $this->db->where('class_id', $data['class_id']);
        $this->db->limit(1);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            return false;
        } else {
            return true;
        }
    }

    public function getTypeByFeecategory($type, $class_id)
    {
        $this->db->select('income.id,income.session_id,income.amount,income.invoice_no,income.documents,income.note,income_head.class,feetype.type')->from('income');
        $this->db->join('income_head', 'income.class_id = income_head.id');
        $this->db->join('feetype', 'income.feetype_id = feetype.id');
        $this->db->where('income.class_id', $class_id);
        $this->db->where('income.feetype_id', $type);
        $this->db->where('income.session_id', $this->current_session);
        $this->db->order_by('income.id');
        $query = $this->db->get();
        return $query->row_array();
    }

    public function getTotalExpenseBydate($date)
    {
        $query = 'SELECT sum(amount) as `amount` FROM `income` where date=' . $this->db->escape($date);
        $query = $this->db->query($query);
        return $query->row();
    }

    public function getTotalExpenseBwdate($date_from, $date_to)
    {
        $query = 'SELECT sum(amount) as `amount` FROM `income` where date between ' . $this->db->escape($date_from) . ' and ' . $this->db->escape($date_to);

        $query = $this->db->query($query);
        return $query->row();
    }

}
