<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Leaverequest_model extends MY_model
{

    // public function staff_leave_request($id = null)
    // {
    //     if ($id != null) {
    //         $this->db->where("staff_leave_request.staff_id", $id);
    //     } elseif ($this->session->has_userdata('admin')) {
    //         $getStaffRole = $this->customlib->getStaffRole();
    //         $staffrole    = json_decode($getStaffRole);

    //         $superadmin_visible = $this->customlib->superadmin_visible();
    //         if ($superadmin_visible == 'disabled' && $staffrole->id != 7) {
    //             $this->db->where("roles.id !=", 7);
    //         }
    //     }

    //     $query = $this->db->select('staff.name,staff.surname,staff.employee_id,staff_leave_request.*,leave_types.type')
    //         ->join("staff", "staff.id = staff_leave_request.staff_id")
    //         ->join("leave_types", "leave_types.id = staff_leave_request.leave_type_id")
    //         ->join("staff_roles", "staff_roles.staff_id = staff.id")
    //         ->join("roles", "staff_roles.role_id = roles.id")
    //         ->where("staff.is_active", "1")
    //         ->order_by("staff_leave_request.id", "desc")
    //         ->get("staff_leave_request");

    //     $result = $query->result_array();
    //     foreach ($result as $key => $value) {
    //         $applied_by = $this->staff_model->get($value['applied_by']);
    //         if (!empty($applied_by['employee_id'])) {
    //             $result[$key]['applied_by'] = $applied_by['name'] . ' ' . $applied_by['surname'] . ' (' . $applied_by['employee_id'] . ')';
    //         } else {
    //             $result[$key]['applied_by'] = '';
    //         }
    //     }
    //     return $result;
    // }
    
    // added by ashok singh
    public function staff_leave_request($id = null,$leave_type_id = null,$status = null) {

        if ($id != null) {
            $this->db->where("staff_leave_request.staff_id", $id);
        }

        if ($leave_type_id != null) {
            $this->db->where_in("staff_leave_request.leave_type_id", $leave_type_id);
        }

        if ($status != null) {
            $this->db->where("staff_leave_request.status", $status);
        }

        $query = $this->db->select('staff.name,staff.surname,staff.employee_id,staff_leave_request.*,leave_types.type')->join("staff", "staff.id = staff_leave_request.staff_id")->join("leave_types", "leave_types.id = staff_leave_request.leave_type_id")->where("staff.is_active", "1")->order_by("staff_leave_request.id", "desc")->get("staff_leave_request");

        return $query->result_array();
    }

    public function user_leave_request($id = null)
    {
        $this->db->select('staff.name,staff.surname,staff.employee_id,staff_leave_request.*,leave_types.type');
        $this->db->join("staff", "staff.id = staff_leave_request.staff_id");
        $this->db->join("staff_roles", "staff_roles.staff_id = staff.id", "left");
        $this->db->join("roles", "staff_roles.role_id = roles.id", "left");
        $this->db->join("leave_types", "leave_types.id = staff_leave_request.leave_type_id");
        $this->db->where("staff.is_active", "1");
        $this->db->where("staff.id", $id);

        if ($this->session->has_userdata('admin')) {
            $getStaffRole = $this->customlib->getStaffRole();
            $staffrole    = json_decode($getStaffRole);
            $superadmin_visible = $this->customlib->superadmin_visible();
            if ($superadmin_visible == 'disabled' && $staffrole->id != 7) {
                $this->db->where("roles.id !=", 7);
            }
        }

        $this->db->order_by("staff_leave_request.id", "desc");
        $query = $this->db->get("staff_leave_request");

        $result = $query->result_array();
        foreach ($result as $key => $value) {
            $applied_by = $this->staff_model->get($value['applied_by']);
            if (!empty($applied_by['employee_id'])) {
                $result[$key]['applied_by'] = $applied_by['name'] . ' ' . $applied_by['surname'] . ' (' . $applied_by['employee_id'] . ')';
            } else {
                $result[$key]['applied_by'] = '';
            }

        }
        return $result;
    }

    public function allotedLeaveType($id)
    {
        $query = $this->db->select('staff_leave_details.*,leave_types.type,leave_types.id as typeid')->where(array('staff_id' => $id))->join("leave_types", "staff_leave_details.leave_type_id = leave_types.id")->get("staff_leave_details");
        return $query->result_array();
    }

    public function myallotedLeaveType($id, $leave_type_id)
    {
        $query = $this->db->select('staff_leave_details.*,leave_types.type,leave_types.id as typeid , (SELECT sum(leave_days) from staff_leave_request WHERE leave_type_id=' . $leave_type_id . ' and staff_id=' . $id . ' and status !="disapprove") as `total_applied`', null, false)->where(array('staff_id' => $id, 'leave_types.id' => $leave_type_id))->join("leave_types", "staff_leave_details.leave_type_id = leave_types.id")->get("staff_leave_details");
        return $query->row_array();
    }

    public function countLeavesData($staff_id, $leave_type_id)
    {
        $query1 = $this->db->select('sum(leave_days) as approve_leave')->where(array('staff_id' => $staff_id, 'status!=' => 'disapprove', 'leave_type_id' => $leave_type_id))->get("staff_leave_request");
        return $query1->row_array();
    }

    public function changeLeaveStatus($data, $staff_id)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $this->db->where("id", $staff_id)->update("staff_leave_request", $data);
        $message   = UPDATE_RECORD_CONSTANT . " On staff leave request id " . $staff_id;
        $action    = "Update";
        $record_id = $staff_id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }

    public function getLeaveSummary()
    {
        $query = $this->db->select('*')->get("staff");
        return $query->result_array();
    }
    
    
    // Function to get leave data by staff ID and date
    public function getLeaveByStaffIdAndDate($staff_id, $date) {
        // Format the date to ensure it matches the database format (Y-m-d)
        $formatted_date = date('Y-m-d', strtotime($date));
        
        // Query to get leave details for the given staff ID and date
        $this->db->select('*');
        $this->db->from('staff_leave_request'); // The name of the table containing leave data
        $this->db->where('staff_id', $staff_id); // Match the staff ID
        $this->db->where("'$formatted_date' BETWEEN leave_from AND leave_to", null, false); // Match the date
        
        // Execute the query
        $query = $this->db->get();
        
        // Check if the query returns any result
        if ($query->num_rows() > 0) {
            // Return the first result as an associative array
            return $query->row_array();
        } else {
            // Return null if no leave record is found
            return null;
        }
    }
    
    public function check_leave($staff_id, $date) {
        $date = date('Y-m-d', strtotime($date));
        $this->db->from('staff_leave_request');
        $this->db->where('staff_id', $staff_id);
        $this->db->where("'$date' BETWEEN leave_from AND leave_to", null, false); // Check if date is between leave_from and leave_to
        $query = $this->db->get();

        // Return true if a record is found, otherwise false
        return $query->num_rows() > 0;
    }
    
    public function check_available_leave($staff_id = '')
    {
        $this->db->from('staff_leave_details');
        $this->db->where('staff_id', $staff_id);
        $this->db->where('alloted_leave !=', 0);
        $this->db->where('leave_type_id !=', 101); // Exclude leave_type_id 101
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
    public function countWeeklyLate($staff_id, $monday_date, $sunday_date) {
        $this->db->where('staff_id', $staff_id);
        $this->db->where('staff_attendance_type_id', 4); // Type 4 = half-day
        $this->db->where('date >=', $monday_date);
        $this->db->where('date <=', $sunday_date);
        return $this->db->count_all_results('staff_attendance');
    }


    public function adjustAllotedLeave($leave_type_id = '', $staff_id , $data)
    {
        $this->db->where("leave_type_id", $leave_type_id)->where("staff_id", $staff_id)->update("staff_leave_details", $data);
    }
    
    
    public function addAllotedLeave($leave_type_id, $staff_id, $leave_days)
    {
        // Step 1: Retrieve the current allocated leave for the given staff and leave type
        $this->db->select('alloted_leave');
        $this->db->from('staff_leave_details');
        $this->db->where('leave_type_id', $leave_type_id);
        $this->db->where('staff_id', $staff_id);
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            // Step 2: If the record exists, get the current allotted leave
            $current_alloted_leave = $query->row()->alloted_leave;
            
            // Step 3: Add the new value to the current allocated leave
            $new_alloted_leave = $current_alloted_leave + $leave_days; // Assuming 'alloted_leave' is the field you want to add
            
            // Step 4: Update the 'staff_leave_details' table with the new value
            $this->db->where('leave_type_id', $leave_type_id);
            $this->db->where('staff_id', $staff_id);
            $this->db->update('staff_leave_details', ['alloted_leave' => $new_alloted_leave]);
        }
    }
    
    
    public function removeAllotedLeave($leave_type_id, $staff_id, $leave_days)
    {
        // Step 1: Retrieve the current allocated leave for the given staff and leave type
        $this->db->select('alloted_leave');
        $this->db->from('staff_leave_details');
        $this->db->where('leave_type_id', $leave_type_id);
        $this->db->where('staff_id', $staff_id);
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            // Step 2: If the record exists, get the current allotted leave
            $current_alloted_leave = $query->row()->alloted_leave;
            
            // Step 3: Add the new value to the current allocated leave
            $new_alloted_leave = $current_alloted_leave - $leave_days; // Assuming 'alloted_leave' is the field you want to add
            
            // Step 4: Update the 'staff_leave_details' table with the new value
            $this->db->where('leave_type_id', $leave_type_id);
            $this->db->where('staff_id', $staff_id);
            $this->db->update('staff_leave_details', ['alloted_leave' => $new_alloted_leave]);
        }
    }
    
    
    public function addLeave($leave_request_id, $leave_days,$leave_type)
    {
        // Step 1: Retrieve the current allocated leave for the given staff and leave type
        $this->db->select('leave_days');
        $this->db->from('staff_leave_request');
        $this->db->where('id', $leave_request_id);
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            // Step 2: If the record exists, get the current allotted leave
            $current_leave = $query->row()->leave_days;
            
            // Step 3: Add the new value to the current allocated leave
            $new_leave = $current_leave + $leave_days; // Assuming 'alloted_leave' is the field you want to add
            
            // Step 4: Update the 'staff_leave_details' table with the new value
            $this->db->where('id', $leave_request_id);
            $this->db->update('staff_leave_request', ['leave_days' => $new_leave,'half_leave_status'=>$leave_type]);
        }
    }
    
    
    public function subtractLeave($leave_request_id, $leave_days,$leave_type)
    {
        // Step 1: Retrieve the current allocated leave for the given staff and leave type
       
        $this->db->select('leave_days');
        $this->db->from('staff_leave_request');
        $this->db->where('id', $leave_request_id);
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            // Step 2: If the record exists, get the current allotted leave
            $current_leave = $query->row()->leave_days;
            
            // Step 3: Add the new value to the current allocated leave
            $new_leave = $current_leave - $leave_days; // Assuming 'alloted_leave' is the field you want to add
            
            // Step 4: Update the 'staff_leave_details' table with the new value
            $this->db->where('id', $leave_request_id);
            $this->db->update('staff_leave_request', ['leave_days' => $new_leave,'half_leave_status'=>$leave_type]);
             
        }
    }

    public function leave_remove($id)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $this->db->where('id', $id);
        $this->db->delete('staff_leave_request');
        $message   = DELETE_RECORD_CONSTANT . " On staff leave request id " . $id;
        $action    = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }
    
    public function deductLeaves($staff_id, $leaves_to_deduct) {

            $this->db->trans_start(); // Start transaction
        
            $leave_requests = $this->db->order_by('id', 'ASC')
                           ->where('status','approve')
                           ->where('staff_id',$staff_id)
                           ->where_in('leave_type_id', [101, 4])
                           ->get('staff_leave_request')
                           ->result_array();

        
            foreach ($leave_requests as $leave) {
                if ($leaves_to_deduct <= 0) {
                    break; // Exit loop if no more leaves to deduct
                }
        
                if ($leave['leave_days'] > 0) {
                    if ($leave['leave_days'] >= $leaves_to_deduct) {
                        // Case: The current record has enough leaves to cover the deduction
                        $this->db->where('id', $leave['id'])
                                 ->update('staff_leave_request', [
                                     'leave_days' => $leave['leave_days'] - $leaves_to_deduct
                                 ]);
                        $leaves_to_deduct = 0;
                    } else {
                        // Case: Deduct all leaves from the current record
                        $leaves_to_deduct -= $leave['leave_days'];
                        $this->db->where('id', $leave['id'])
                                 ->update('staff_leave_request', [
                                     'leave_days' => 0
                                 ]);
                    }
                }
            }
        
            $this->db->trans_complete(); // Complete transaction
        
            if ($this->db->trans_status() === FALSE) {
                // Handle transaction failure
                return false;
            }
        
            return true;
        }
    
    
    public function adjustLeaveDays($staff_id, $required_leave_days) {
    $this->db->trans_start(); // Start a database transaction

    // Fetch all approved leave records for the staff, ordered by the earliest leave_from
    $leave_requests = $this->db->order_by('leave_from', 'ASC')
                               ->where('status', 'approve')
                               ->where('leave_type_id', 101)
                               ->where('staff_id', $staff_id)
                               ->get('staff_leave_request')
                               ->result_array();

    foreach ($leave_requests as $leave) {
        if ($required_leave_days <= 0) {
            break; // Exit loop if no more leave days to deduct
        }

        // Calculate the number of days between leave_from and leave_to
        $leave_from = new DateTime($leave['leave_from']);
        $leave_to = new DateTime($leave['leave_to']);
        $total_leave_days = $leave_to->diff($leave_from)->days + 1;

        // Check how many days can be added to this record
        $remaining_days_in_record = $total_leave_days - $leave['leave_days'];
        if ($remaining_days_in_record > 0) {
            if ($remaining_days_in_record >= $required_leave_days) {
                // Deduct the required leave days from this record
                $new_leave_days = $leave['leave_days'] + $required_leave_days;
                $this->db->where('id', $leave['id'])
                         ->update('staff_leave_request', ['leave_days' => $new_leave_days]);
                $required_leave_days = 0;
            } else {
                // Use up all remaining days in this record
                $new_leave_days = $leave['leave_days'] + $remaining_days_in_record;
                $this->db->where('id', $leave['id'])
                         ->update('staff_leave_request', ['leave_days' => $new_leave_days]);
                $required_leave_days -= $remaining_days_in_record;
            }
        }
    }

    $this->db->trans_complete(); // Complete the transaction

    if ($this->db->trans_status() === FALSE) {
        // Handle transaction failure
        return false;
    }

    return true; // Transaction successful
}

    public function addLeaveRequest($data)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        if (isset($data['id'])) {

            $this->db->where("id", $data["id"]);
            $this->db->update("staff_leave_request", $data);
            $message   = UPDATE_RECORD_CONSTANT . " On staff leave request id " . $data['id'];
            $action    = "Update";
            $record_id = $data['id'];
            $this->log($message, $record_id, $action);
            //======================Code End==============================

            $this->db->trans_complete(); # Completing transaction
            /* Optional */

            if ($this->db->trans_status() === false) {
                # Something went wrong.
                $this->db->trans_rollback();
                return false;
            } else {
                //return $return_value;
            }
        } else {

            $this->db->insert("staff_leave_request", $data);
            $id        = $this->db->insert_id();
            $message   = INSERT_RECORD_CONSTANT . " On staff leave request id " . $id;
            $action    = "Insert";
            $record_id = $id;
            $this->log($message, $record_id, $action);
            //======================Code End==============================

            $this->db->trans_complete(); # Completing transaction
            /* Optional */

            if ($this->db->trans_status() === false) {
                # Something went wrong.
                $this->db->trans_rollback();
                return false;
            } else {
                //return $return_value;
            }
        }
    }

    public function get_staff_leave($id)
    {
        $this->db->select('staff_leave_request.*');
        $this->db->from('staff_leave_request');
        $this->db->where('staff_leave_request.id', $id);
        $result = $this->db->get();
        return $result->row_array();
    }
    
     public function get_staff_leave_count($staff_id, $leave_type_id)
    {
        $this->db->select('SUM(leave_days) as total_days');
        $this->db->from('staff_leave_request');
        $this->db->where('staff_id', $staff_id);
        $this->db->where('leave_type_id', $leave_type_id);
        $result = $this->db->get()->row_array();
    
        return !empty($result['total_days']) ? (int)$result['total_days'] : 0;
    }

}
