<?php
class Generatetimetable_model extends CI_Model {
    // List of activity subjects and restricted periods
    private $activity_subjects = ['music', 'dance', 'art & craft', 'art and craft', 'art'];
    private $restricted_activity_periods = [9, 10];
    // List of optional/substitute subjects and restricted periods
    private $optional_subjects = ['optional', 'substitute'];
    private $restricted_optional_periods = [5, 8, 9];
    // Yoga restriction
    private $yoga_subjects = ['yoga'];
    private $allowed_yoga_periods = [2, 3, 6, 7];

    /**
     * Check if a period is allowed for activity subjects
     * @param string $subject_name
     * @param int $period_id
     * @return bool
     */
    public function is_activity_period_allowed($subject_name, $period_id) {
        $subject_name = strtolower(trim($subject_name));
        if (in_array($subject_name, $this->activity_subjects) && in_array($period_id, $this->restricted_activity_periods)) {
            return false;
        }
        return true;
    }

    /**
     * Check if a period is allowed for optional/substitute subjects
     * @param string $subject_name
     * @param int $period_id
     * @return bool
     */
    public function is_optional_period_allowed($subject_name, $period_id) {
        $subject_name = strtolower(trim($subject_name));
        foreach ($this->optional_subjects as $opt) {
            if (strpos($subject_name, $opt) !== false && in_array($period_id, $this->restricted_optional_periods)) {
                return false;
            }
        }
        return true;
    }

    /**
     * Check if a period is allowed for Yoga
     * @param string $subject_name
     * @param int $period_id
     * @return bool
     */
    public function is_yoga_period_allowed($subject_name, $period_id) {
        $subject_name = strtolower(trim($subject_name));
        if (in_array($subject_name, $this->yoga_subjects) && !in_array($period_id, $this->allowed_yoga_periods)) {
            return false;
        }
        return true;
    }
    // List of period numbers where sports is not allowed
    private $restricted_sports_periods = [1, 5, 8, 10];

    /**
     * Check if a period is allowed for sports
     * @param int $period_id
     * @return bool
     */
    public function is_sports_period_allowed($period_id) {
        return !in_array($period_id, $this->restricted_sports_periods);
    }

    public function get_subject_weekly_periods($section_id) {
        // Fetch from subject_periods table based on class and section
        return $this->db->where([
            'class_section_id' => $section_id
        ])->get('class_subject_periods')->result();
    }

    public function get_school_timing_config() {
        return $this->db->get('school_timings')->row(); // adjust table name if needed
    }

    public function get_short_break_subject_id() {
        // Assuming short break has subject entry or a fixed ID like -1
        return -1;
    }

    public function get_lunch_break_subject_id() {
        // Assuming lunch break has subject entry or a fixed ID like -2
        return -2;
    }

    public function get_period_time($period, $type, $config) {
        $start = strtotime($config->school_start_time);
        $lengths = [
            1 => $config->first_period,
            2 => $config->second_period,
            3 => $config->third_period,
            4 => $config->fourth_period,
            5 => $config->fifth_period,
            6 => $config->sixth_period,
            7 => $config->seventh_period,
            8 => $config->eight_period,
            9 => $config->seventh_period,
            10 => $config->eight_period,
        ];

        $offset = 0;
        for ($i = 1; $i < $period; $i++) {
            $offset += $lengths[$i] * 60;
        }

        $time = $start + $offset;

        if ($type == 'to') {
            $time += $lengths[$period] * 60;
        }

        return date('H:i:s', $time);
    }

    public function get_subject_id_by_name($subject_name)
    {
        if (empty($subject_name)) {
            return false;
        }

        $this->db->select('subject_group_subjects.id AS subject_group_subject_id');
        $this->db->from('subjects');
        $this->db->join('subject_group_subjects', 'subject_group_subjects.subject_id = subjects.id');
        $this->db->where('subjects.name', $subject_name);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row()->subject_group_subject_id;
        } else {
            return false;
        }
    }



    public function get_subject_ids_by_names($subject_names)
    {
        if (empty($subject_names) || !is_array($subject_names)) {
            return false;
        }

        $this->db->select('subject_group_subjects.id as subject_group_subject_id');
        $this->db->from('subjects');
        $this->db->join('subject_group_subjects','subject_group_subjects.subject_id = subjects.id');// replace with your actual table name
        $this->db->where_in('subjects.name', $subject_names);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            $result = $query->result();
            $ids = array_map(function($row) {
                return $row->subject_group_subject_id;
            }, $result);
            return $ids;
        } else {
            return false; // or []
        }
    }


    


    public function delete_existing_timetable($class_id, $section_id) {
        $this->db->where('class_id', $class_id)
                 ->where('section_id', $section_id)
                 ->delete('class_timeline');
    }


    /**
     * Save timetable with sports period restriction
     * @param array $timetable
     */
    public function save_timetable($timetable) {
        // Enforce sports period restriction
        // Track yoga assignment per day
        $yoga_count_per_day = [];
        $subject_per_day = [];
        foreach ($timetable as $key => $row) {
            $subject_name = isset($row['subject_name']) ? strtolower($row['subject_name']) : '';
            $period_id = isset($row['period_id']) ? (int)$row['period_id'] : 0;
            $day = isset($row['day']) ? $row['day'] : null;
            // Only allow one instance of a subject per day
            if ($day && $subject_name) {
                if (!isset($subject_per_day[$day])) {
                    $subject_per_day[$day] = [];
                }
                if (in_array($subject_name, $subject_per_day[$day])) {
                    unset($timetable[$key]);
                    continue;
                }
                $subject_per_day[$day][] = $subject_name;
            }
            // Sports restriction
            if (($subject_name === 'sports' || $subject_name === 'games') && !$this->is_sports_period_allowed($period_id)) {
                unset($timetable[$key]);
                continue;
            }
            // Activity subjects restriction
            if (!$this->is_activity_period_allowed($subject_name, $period_id)) {
                unset($timetable[$key]);
                continue;
            }
            // Optional/substitute subjects restriction
            if (!$this->is_optional_period_allowed($subject_name, $period_id)) {
                unset($timetable[$key]);
                continue;
            }
            // Yoga restriction: only allowed periods
            if (!$this->is_yoga_period_allowed($subject_name, $period_id)) {
                unset($timetable[$key]);
                continue;
            }
            // Yoga: only one per day
            if (in_array($subject_name, $this->yoga_subjects)) {
                if (!isset($yoga_count_per_day[$day])) {
                    $yoga_count_per_day[$day] = 0;
                }
                $yoga_count_per_day[$day]++;
                if ($yoga_count_per_day[$day] > 1) {
                    unset($timetable[$key]);
                    continue;
                }
            }
        }
        if (!empty($timetable)) {
            $this->db->insert_batch('class_timeline', $timetable);
        }
    }

    public function get_classteacher_subject($teacher_id,$section_id,$session_id) {
        $this->db->select('subject_group_subjects.id');
        $this->db->from('subject_group_subjects');
        $this->db->join('teacher_subjects', 'teacher_subjects.subject_id = subject_group_subjects.subject_id');
        $this->db->join('subject_group_class_sections', 'subject_group_class_sections.subject_group_id = subject_group_subjects.subject_group_id');
        $this->db->where('teacher_subjects.teacher_id', $teacher_id);
        $this->db->where('teacher_subjects.class_section_id', $section_id);
        $this->db->where('subject_group_class_sections.class_section_id', $section_id);
        $this->db->where('subject_group_subjects.session_id', $session_id);
        $this->db->where('teacher_subjects.session_id', $session_id);
        $query = $this->db->get();
        return $query->row();



    }

    public function get_class_timetable($class_id, $section_id)
    {
        $this->db->select('ct.id, ct.day, ct.time_from, ct.time_to, ct.period_id, ct.subject_id, 
                           subjects.name as subject_name, staff.name as teacher_name');
        $this->db->from('class_timeline ct');
        $this->db->join('subject_group_subjects', 'subject_group_subjects.id = ct.subject_id', 'left');
        $this->db->join('subjects', 'subjects.id = subject_group_subjects.subject_id', 'left');
        $this->db->join('classes', 'classes.id = ct.class_id');
        $this->db->join('class_sections', 'class_sections.id = ct.section_id');
        $this->db->join('sections', 'sections.id = class_sections.section_id');
        $this->db->join('teacher_subjects', 
                        'teacher_subjects.class_section_id = ct.section_id AND teacher_subjects.subject_id = subject_group_subjects.subject_id', 
                        'left');
        $this->db->join('staff_roles', 'staff_roles.id = teacher_subjects.teacher_id', 'left');
        $this->db->join('staff', 'staff.id = staff_roles.staff_id', 'left');
        $this->db->where('ct.class_id', $class_id);
        $this->db->where('ct.section_id', $section_id);
        $this->db->where('ct.status', 1);
        $this->db->order_by('day, period_id');

        $query = $this->db->get();
        $result = $query->result_array();

        $timetable = [];

        foreach ($result as $row) {
            $timetable[$row['day']][$row['period_id']] = $row;
        }

        return $timetable;
    }


    public function get_all_periods()
    {
        $this->db->order_by('start_time', 'asc');
        return $this->db->get('periods')->result();
    }

    public function get_class_teacher_subject($class_id, $class_section_id) {
        $this->db->select('ct.staff_id, ts.subject_id');
        $this->db->from('class_teacher ct');
        $this->db->join('teacher_subjects ts', 'ts.teacher_id = ct.staff_id', 'left');
        $this->db->join('class_sections cs', 'cs.id = ts.class_section_id', 'left');
        $this->db->where('ct.class_id', $class_id);
        $this->db->where('cs.id', $class_section_id);
        $this->db->where('ct.section_id = cs.section_id', null, false); // raw where for column comparison
        $this->db->limit(1);
        
        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_teacher_by_subject($subject_id, $section_id) {
        $this->db->select('teacher_id');
        $this->db->from('teacher_subjects');
        $this->db->where('subject_id', $subject_id);
        $this->db->where('class_section_id', $section_id);
        $query = $this->db->get();
        $row = $query->row();
        return $row ? $row->teacher_id : null;
    }
    public function is_teacher_available($teacher_id, $day, $period_id, $session_id) {
        // Step 1: Get all subject_ids assigned to this teacher
        $this->db->select('subject_id');
        $this->db->from('teacher_subjects');
        $this->db->where('teacher_id', $teacher_id);
        $this->db->where('session_id', $session_id);
        $query = $this->db->get();
        $subjects = $query->result_array();

        if (empty($subjects)) {
            return true; // No subjects assigned → teacher is available
        }

        $subject_ids = array_column($subjects, 'subject_id');

        // Step 2: Check if any of these subjects are already scheduled at the given time
        $this->db->from('class_timeline');
        $this->db->where_in('subject_id', $subject_ids);
        $this->db->where('day', $day);
        $this->db->where('period_id', $period_id);
        $conflict = $this->db->get()->num_rows();

        return $conflict === 0; // true if no conflict
    }

    public function gettimetable()
{
    $this->db->select('*');
    $this->db->from('class_timeline');
    $query = $this->db->get();
    $result = $query->result_array();

    $timetable = [];
    foreach ($result as $row) {
        $day = $row['day'];
        $timetable[$day][] = $row;
    }

    return $timetable;
}







}
