<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gatepass_model extends MY_Model {

    public function __construct() {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
        $this->current_session_name = $this->setting_model->getCurrentSessionName();
        $this->start_month = $this->setting_model->getStartMonth();
    }

    public function insert($table, $data) {

        $title = "Gatepass Create";

        
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $this->db->insert($table, $data);

        $return_value = $this->db->insert_id();
        $message = INSERT_RECORD_CONSTANT . " On  Gatepass  " . $title . " id " . $return_value;
        $action = "Insert";
        $record_id = $return_value;
        $this->log($message, $record_id, $action);
        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            return $return_value;
        }
    }

    public function image_add($type, $dispatch_id, $image) {
        $array = array('id' => $dispatch_id, 'type' => $type);
        $this->db->set('image', $image);
        $this->db->where($array);
        $this->db->update('dispatch_receive');
    }

    public function list($id='') {
    $this->db->select('gatepasses.*, 
                       students.firstname AS student_firstname, 
                       students.middlename AS student_middlename, 
                       students.lastname AS student_lastname,
                       classes.class AS student_class, 
                       sections.section AS student_section, 
                       staff.name AS staff_name, 
                       roles.name AS staff_role,
                       staff.surname AS staff_surname');
        $this->db->from('gatepasses');
    
        // Join the students table if student_id is not null
        $this->db->join('students', 'gatepasses.student_id = students.id', 'left');
        $this->db->join('student_session', 'student_session.student_id = students.id', 'left');
        $this->db->join('classes', 'classes.id = student_session.class_id', 'left');
        $this->db->join('sections', 'sections.id = student_session.section_id', 'left');

        // Check if the staff_id field is not null before joining the staff table
        $this->db->join('staff', 'gatepasses.staff_id = staff.id', 'left');
        $this->db->join('staff_roles', 'staff_roles.staff_id = staff.id', 'left');
        $this->db->join('roles', 'roles.id = staff_roles.role_id', 'left');

        

    
    $this->db->order_by('gatepasses.id', 'desc');
    if (!empty($id)) {
        $this->db->where('gatepasses.id',$id);
    }
    $query = $this->db->get();
    
    if (!empty($id)) {
        return $query->row();
    }else{
        return $query->result();
    }
    
}


    

    public function dis_rec_data($id) {
        $this->db->select('*');
        $this->db->where('id', $id);
        $this->db->from('gatepasses');
        $query = $this->db->get();
        return $query->row();
    }

    public function update($table, $id, $data) {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        
            $title = "Gatepass Update";
        
        $this->db->where('id', $id);
        $this->db->update($table, $data);
        
        $message = UPDATE_RECORD_CONSTANT . " On Admission Enquiry $title  id " . $id;
        $action = "Update";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }

    

    public function delete($id) {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $this->db->where('id', $id);
        $this->db->delete('gatepasses');
        $message = DELETE_RECORD_CONSTANT . " On Postal Dispatch id " . $id;
        $action = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
        $controller_name = $this->uri->segment(2);
        $this->session->set_flashdata('msg', '<div class="alert alert-success"> ' . $this->lang->line('delete_message') . '</div>');
        redirect('admin/' . $controller_name);
    }

}
