<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Feesessiongroup_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    public function add($data)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $parentid                     = $this->group_exists($data['fee_groups_id']);
        $data['fee_session_group_id'] = $parentid;
        $this->db->insert('fee_groups_feetype', $data);
        $id        = $this->db->insert_id();
        $message   = INSERT_RECORD_CONSTANT . " On  fee groups feetype id " . $id;
        $action    = "Insert";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
			 return $record_id;
        }
    }

    public function getFeesByGroupByStudent($student_session_id)
    {
        $this->db->select('fee_session_groups.*,fee_groups.name as `group_name`,IFNULL(student_fees_master.id,0) as `student_fees_master_id`,student_session.student_id,fee_groups.nature');
        $this->db->from('fee_session_groups');
        $this->db->join('fee_groups', 'fee_groups.id = fee_session_groups.fee_groups_id');
        $this->db->join('student_fees_master',
        'student_fees_master.student_session_id=' . $student_session_id . ' and student_fees_master.fee_session_group_id=fee_session_groups.id', 'LEFT');
        $this->db->join('student_session', 'student_session.id = student_fees_master.student_session_id', 'LEFT');
        $this->db->where('fee_session_groups.session_id', $this->current_session);
        $this->db->where('fee_groups.is_system', 0);
        $this->db->order_by('student_fees_master_id', 'desc');
        $query  = $this->db->get();
        $result = $query->result();
        foreach ($result as $key => $value) {
            $value->feetypes = $this->getfeeTypeByGroup($value->id, $value->fee_groups_id);
        }
        return $result;
    }

    public function getFeesByGroup($id = null,$display_system=NULL){
        $this->db->select('fee_session_groups.*,fee_groups.name as `group_name`,fee_groups.is_system');
        $this->db->from('fee_session_groups');
        $this->db->join('fee_groups', 'fee_groups.id = fee_session_groups.fee_groups_id');
        $this->db->where('fee_session_groups.session_id', $this->current_session);

         if ($display_system !== NULL) {
               $this->db->where('fee_groups.is_system', $display_system);
        }

        $this->db->where('fee_groups.nature !=', 'custom');
        if ($id != null) {
            $this->db->where('fee_session_groups.id', $id);
        }
            $this->db->order_by('fee_groups.id', 'asc');
        $query = $this->db->get();
        $result = $query->result();
        foreach ($result as $key => $value) {
            $value->feetypes = $this->getfeeTypeByGroup($value->id, $value->fee_groups_id);
        }
        return $result;
    }


   /* public function getfeeTypeByGroup($fee_session_group_id, $id = null)
    {
        $this->db->select('fee_groups_feetype.*,feetype.type,feetype.code');
        $this->db->from('fee_groups_feetype');
        $this->db->join('feetype', 'feetype.id=fee_groups_feetype.feetype_id');
        $this->db->where('fee_groups_feetype.fee_groups_id', $id);
        $this->db->where('fee_groups_feetype.fee_session_group_id', $fee_session_group_id);
        $this->db->order_by('fee_groups_feetype.id', 'asc');
        $query = $this->db->get();
        return $query->result();
    }
	*/
	
	public function getfeeTypeByGroup($fee_session_group_id, $id = null)
    {
        $this->db->select('fee_groups_feetype.*,feetype.type,feetype.code');
        $this->db->from('fee_groups_feetype');
        $this->db->join('feetype', 'feetype.id=fee_groups_feetype.feetype_id');
        $this->db->where('fee_groups_feetype.fee_groups_id', $id);
        $this->db->where('fee_groups_feetype.fee_session_group_id', $fee_session_group_id);
        $this->db->order_by('fee_groups_feetype.id', 'asc');
        $query = $this->db->get();
        $result = $query->result();

        foreach ($result as $key => $value) {
             $value->cumulative_fine_data = $this->get_cumulative_fine($value->id);
        }
        return $result;
        // return $query->result();
    }
	
	
    public function get_cumulative_fine($fee_groups_feetype_id)
    {
        $this->db->select('cumulative_fine.*');
        $this->db->from('cumulative_fine');
        $this->db->where('cumulative_fine.fee_groups_feetype_id', $fee_groups_feetype_id);
        $this->db->order_by('cumulative_fine.id', 'asc');
        $query = $this->db->get();
        return $query->result();
    }


    public function group_exists($fee_groups_id)
    {
        $this->db->where('fee_groups_id', $fee_groups_id);
        $this->db->where('session_id', $this->current_session);
        $query = $this->db->get('fee_session_groups');
        if ($query->num_rows() > 0) {
            return $query->row()->id;
        } else {
            $data = array('fee_groups_id' => $fee_groups_id, 'session_id' => $this->current_session);
            $this->db->insert('fee_session_groups', $data);
            return $this->db->insert_id();
        }
    }

    public function remove($id)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $sql = "delete fee_groups_feetype.* FROM fee_groups_feetype JOIN fee_session_groups ON fee_session_groups.id = fee_groups_feetype.fee_session_group_id WHERE fee_session_groups.id = ?";
        $this->db->query($sql, array($id));
        $this->db->where('id', $id);
        $this->db->delete('fee_session_groups');

        $message   = DELETE_RECORD_CONSTANT . " On fee session groups id " . $id;
        $action    = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }

    public function checkExists($data)
    {
        $this->db->where('fee_session_group_id', $data['fee_session_group_id']);
        $this->db->where('fee_groups_id', $data['fee_groups_id']);
        $this->db->where('feetype_id', $data['feetype_id']);
        $this->db->where('session_id', $this->current_session);
        $q = $this->db->get('fee_groups_feetype');

        if ($q->num_rows() > 0) {
            return $q->row()->id;
        } else {
            return false;
        }
    }

    public function valid_check_exists($str)
    {
        $fee_groups_id = $this->input->post('fee_groups_id');
        $feetype_id    = $this->input->post('feetype_id');
        $id            = $this->input->post('id');

        if (!isset($id)) {
            $id = 0;
        }

        if ($this->check_data_exists($fee_groups_id, $feetype_id, $id)) {
            $this->form_validation->set_message('check_exists', $this->lang->line('feegroup_combination_already_exists'));
            return false;
        } else {
            return true;
        }
    }

    public function check_data_exists($fee_groups_id, $feetype_id, $id)
    {
        $this->db->where('fee_groups_id', $fee_groups_id);
        $this->db->where('session_id', $this->current_session);
        $query = $this->db->get('fee_session_groups');

        if ($query->num_rows() > 0) {
            $fee_session_group_id = $query->row()->id;
            $this->db->where('fee_session_group_id', $fee_session_group_id);
            $this->db->where('fee_groups_id', $fee_groups_id);
            $this->db->where('feetype_id', $feetype_id);
            $this->db->where('id !=', $id);
            $query = $this->db->get('fee_groups_feetype');
            if ($query->num_rows() > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    //**** fees master ****//
    public function getStudentfeeTypeByGroup($student_session_id){
        $this->db->select('fee_groups_feetype.*,feetype.type,feetype.code');
        $this->db->from('fee_groups_feetype');
        $this->db->join('feetype', 'feetype.id=fee_groups_feetype.feetype_id');
        $this->db->where('feetype.student_session_id', $student_session_id);
        $this->db->order_by('fee_groups_feetype.id', 'asc');
        $query = $this->db->get();
        return $query->result();
    }

    public function searchstudentfeesmaster($fee_groups_id){
        $this->db->select('fee_groups.*,fee_session_groups.id as fee_session_groups_id');
        $this->db->from('fee_groups');          
        $this->db->join('fee_session_groups', 'fee_groups.id = fee_session_groups.fee_groups_id');
        $this->db->where('fee_groups.nature', 'custom');         
        $this->db->where('fee_groups.id',$fee_groups_id);       
        $query = $this->db->get();
        $result = $query->row();        
        return $result;
    }
	
	
//***fees master cumulative***//
    public function remove_comulative_by_fee_groups_id($id)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
       
        $this->db->where('fee_session_group_id', $id);
        $this->db->delete('cumulative_fine');

        $message   = DELETE_RECORD_CONSTANT . " On Cumulative Fine id " . $id;
        $action    = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }

    public function add_fine($data)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        
        //=======================Code Start===========================
        if (isset($data['id']) && $data['id']>0) {
            $this->db->where('id', $data['id']);
            $this->db->update('cumulative_fine', $data);
            $message   = UPDATE_RECORD_CONSTANT . " On cumulative_fine id " . $data['id'];
            $action    = "Update";
            $record_id = $data['id'];
            $this->log($message, $record_id, $action);
        } else {
            $this->db->insert('cumulative_fine', $data);
            $id        = $this->db->insert_id();
            $message   = INSERT_RECORD_CONSTANT . " On cumulative_fine id " . $id;
            $action    = "Insert";
            $record_id = $id;
            $this->log($message, $record_id, $action);
        }
        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            return $record_id;
        }

    }
    
    public function remove_cumulative($id)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
       
        $this->db->where('id', $id);
        $this->db->delete('cumulative_fine');

        $message   = DELETE_RECORD_CONSTANT . " On Cumulative Fine id " . $id;
        $action    = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }


  public function remove_cumulativeby_grouptypid($fee_groups_feetype_id)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
       
        $this->db->where('fee_groups_feetype_id', $fee_groups_feetype_id);
        $this->db->delete('cumulative_fine');

        $message   = DELETE_RECORD_CONSTANT . " On Cumulative Fine fee_groups_feetype_id id " . $fee_groups_feetype_id;
        $action    = "Delete";
        $record_id = $fee_groups_feetype_id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }
    
    
    // college fee master queries start
    
    
    public function addfeeHeadCourse($data)
    {
        $this->db->trans_start(); // Starting Transaction
        $this->db->trans_strict(false); // Disable strict mode if needed
    
        try {
            // Check if an ID is provided for updating an existing record
            if (isset($data['id'])) {
                $this->db->where('id', $data['id']);
                $this->db->update('fee_head_course', $data);
    
                // Log the update action if needed
                $message = UPDATE_RECORD_CONSTANT . " On fee head course id " . $data['id'];
                $action = "Update";
                $record_id = $data['id'];
                $this->log($message, $record_id, $action);
            } else {
                // Insert new record
                $this->db->insert('fee_head_course', $data);
                
                // Get the last inserted ID
                $id = $this->db->insert_id();
    
                // Log the insert action
                $message = INSERT_RECORD_CONSTANT . " On fee head course id " . $id;
                $action = "Insert";
                $record_id = $id;
                $this->log($message, $record_id, $action);
    
                // Return the ID of the newly inserted record
                $this->db->trans_complete(); // Completing transaction
                if ($this->db->trans_status() === FALSE) {
                    throw new Exception('Transaction failed.');
                }
    
                return $id;
            }
        } catch (Exception $e) {
            // Handle exceptions, rollback transaction
            $this->db->trans_rollback();
            log_message('error', $e->getMessage()); // Log the exception message
            return false;
        }
    
        // Complete the transaction
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE) {
            // Transaction failed, handle accordingly
            return false;
        }
    
        // No ID to return if updating
        return true;
    }
    
    
    public function changeStatus($data) {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        
        $this->db->where("id", $data["id"])->update("fee_head_course", $data);
        
        $message = UPDATE_RECORD_CONSTANT . " On fee headcourse status updated id " . $data['id'];
        $action = "Update";
        $record_id = $data['id'];
        $this->log($message, $record_id, $action);
        //======================Code End==============================

        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }
    
    
    public function getCourse($id = null) {
        $this->db->select('courses.*');
        $this->db->from('courses');
        if ($id != null) {
            $this->db->where('id', $id);
        }
        $this->db->where('course_status', 1);
        $query = $this->db->get();

        if ($id != null) {
            return $query->row();
        } else {
            return $query->result_array();
        }
        
        
    }
    
    public function getClassesByCourseId($course_id) {
        $this->db->where('course_id', $course_id);
        $query = $this->db->get('classes');
        return $query->result_array();
    }
    
    
    public function getSectionByclassId($class_id) {
        $this->db->where('class_id', $class_id);
        $query = $this->db->get('class_sections');
        return $query->result_array();
    }
    
    public function getFeesByFeeHeadCourse($id = null) {
        $this->db->select('fee_head_course.*');
        $this->db->from('fee_head_course');
        if ($id != null) {
            $this->db->where('fee_head_course.id', $id);
        }
        $query = $this->db->get();
        if ($id != null) {
            $result = $query->row();
        }else{
            $result = $query->result();
        }
        
        
            $result->feetypes = $this->getfeeTypeByFeeHeadCourse($result->fee_type_id);
        
        return $result;
    }

    public function getFeesHeadCourse($id = null) {
        $this->db->select('fee_head_course.*, feetype.type, feecategory.category, courses.course_name, classes.class');
        $this->db->from('fee_head_course');
        $this->db->join('feetype', 'feetype.id = fee_head_course.fee_type_id');
        $this->db->join('feecategory', 'feecategory.id = fee_head_course.fee_cat_id');
        $this->db->join('classes', 'classes.id = fee_head_course.class_ids');
        $this->db->join('courses', 'courses.id = fee_head_course.course_id');
        
        if ($id != null) {
            $this->db->where('fee_head_course.id', $id);
        }
        $query = $this->db->get();
    
        if ($id != null) {
            $result = $query->row();
        } else {
            $result = $query->result_array();
        }
    
        // Process section IDs
        if (!empty($result)) {
            if ($id != null) {
                $result = $this->processSections($result, true); // Pass true for single record (object)
            } else {
                foreach ($result as &$row) {
                    $row = $this->processSections($row, false); // Pass false for multiple records (array)
                }
            }
        }
    
        return $result;
    }

    private function processSections($row, $is_object = false) {
        if ($is_object) {
            $section_ids = json_decode($row->section_id); // Access as an object property
        } else {
            $section_ids = json_decode($row['section_id']); // Access as an array element
        }
    
        if (!empty($section_ids)) {
            // Fetch section names based on section IDs
            $this->db->select('section');
            $this->db->from('sections');
            $this->db->where_in('id', $section_ids);
            $sections_query = $this->db->get();
            $sections = $sections_query->result_array();
    
            // Combine section names into a single string or array
            $section_names = array_column($sections, 'section');
            $section_names_str = implode(', ', $section_names); // Storing the sections as a comma-separated string
    
            // Add section names to the result
            if ($is_object) {
                $row->section_names = $section_names_str; // Add as an object property
            } else {
                $row['section_names'] = $section_names_str; // Add as an array element
            }
        } else {
            if ($is_object) {
                $row->section_names = ''; // No sections found
            } else {
                $row['section_names'] = ''; // No sections found
            }
        }
    
        return $row;
    }



    public function getClasses($ids) {
        $this->db->where_in('id', $ids);
        $query = $this->db->get('classes');
        return $query->result_array();
    }
    
    public function getfeeTypeByFeeHeadCourse($fee_type_id) {
        $this->db->select('feetype.type,feetype.code');
        $this->db->from('feetype');
        $this->db->where('feetype.id', $fee_type_id);
        $this->db->order_by('feetype.id', 'asc');
        $query = $this->db->get();
        return $query->row();
    }
    
    public function remove_fee_headcourse($id) {
        $this->db->where('id', $id);
        $this->db->delete('fee_head_course');
    }


    // college fee master queries end





     

}
