<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Examsubject_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function add($insert_array, $update_array, $not_be_del, $exam_id)
    {
        if (!empty($insert_array)) {
            foreach ($insert_array as $insert_key => $insert_value) {
                $this->db->insert('exam_group_class_batch_exam_subjects', $insert_array[$insert_key]);
                $not_be_del[] = $this->db->insert_id();
            }
        }
        if (!empty($update_array)) {
            $this->db->update_batch('exam_group_class_batch_exam_subjects', $update_array, 'id');
        }

        if (!empty($not_be_del)) {
            $this->db->where('exam_group_class_batch_exams_id', $exam_id);
            $this->db->where_not_in('id', $not_be_del);
            $this->db->delete('exam_group_class_batch_exam_subjects');
        }
    }
    
    
    public function add_mh($insert_array, $update_array, $not_be_del, $exam_id) {

        if (!empty($insert_array)) {
            foreach ($insert_array as $insert_key => $insert_value) {
                $this->db->insert('mh_exam_group_class_batch_exam_subjects', $insert_array[$insert_key]);
                $not_be_del[] = $this->db->insert_id();
            }
        }
        if (!empty($update_array)) {
            $this->db->update_batch('mh_exam_group_class_batch_exam_subjects', $update_array, 'id');
        }

        if (!empty($not_be_del)) {

            $this->db->where('exam_group_class_batch_exams_id', $exam_id);
            $this->db->where_not_in('id', $not_be_del);
            $this->db->delete('mh_exam_group_class_batch_exam_subjects');
        }
    }
    
    
    public function get_exam_subjects($exam_id)
    {
        $this->db->select('mh_exam_group_class_batch_exam_subjects.*,subjects.name as subject_name')->from('mh_exam_group_class_batch_exam_subjects');
        $this->db->join('subjects', 'subjects.id = mh_exam_group_class_batch_exam_subjects.subject_id');
        $this->db->where('mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id', $exam_id);
        $query = $this->db->get();
        return $query->result_array();
        
    }
    
    
    public function get_exam_subjects_byexam($exam_group_class_batch_exam_id)
    {
       $this->db->select('*')->from('exam_group_class_batch_exam_subjects');
       $this->db->where('exam_group_class_batch_exams_id',$exam_group_class_batch_exam_id);
       $query = $this->db->get();
       return $query->result();

    }

    public function get_mh_exam_subjects_byexam($exam_group_class_batch_exam_id)
    {
       $this->db->select('*')->from('mh_exam_group_class_batch_exam_subjects');
       $this->db->where('exam_group_class_batch_exams_id',$exam_group_class_batch_exam_id);
       $query = $this->db->get();
       return $query->result();

    }

}
