<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Examresult_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */
    public function get($id = null)
    {
        $this->db->select()->from('exam_results');
        if ($id != null) {
            $this->db->where('id', $id);
        } else {
            $this->db->order_by('id');
        }
        $query = $this->db->get();
        if ($id != null) {
            return $query->row_array();
        } else {
            return $query->result_array();
        }
    }

    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('exam_results');
    }

    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data)
    {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('exam_results', $data);
        } else {
            $this->db->insert('exam_results', $data);
            return $this->db->insert_id();
        }
    }

    public function add_exam_result($data)
    {
        $this->db->where('exam_schedule_id', $data['exam_schedule_id']);
        $this->db->where('student_id', $data['student_id']);
        $q      = $this->db->get('exam_results');
        $result = $q->row();
        if ($q->num_rows() > 0) {
            $this->db->where('id', $result->id);
            $this->db->update('exam_results', $data);
            if ($result->get_marks != $data['get_marks']) {
                return $result->id;
            }
        } else {
            $this->db->insert('exam_results', $data);
            $insert_id = $this->db->insert_id();
            return $insert_id;
        }
        return false;
    }

    public function get_exam_result($exam_schedule_id = null, $student_id = null)
    {
        $this->db->select()->from('exam_results');
        $this->db->where('exam_schedule_id', $exam_schedule_id);
        $this->db->where('student_id', $student_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            $obj             = new stdClass();
            $obj->attendence = 'pre';
            $obj->get_marks  = "0.00";
            return $obj;
        }
    }

    public function get_result($exam_schedule_id = null, $student_id = null)
    {
        $this->db->select()->from('exam_results');
        $this->db->where('exam_schedule_id', $exam_schedule_id);
        $this->db->where('student_id', $student_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {

        }
    }

    public function checkexamresultpreparebyexam($exam_id, $class_id, $section_id)
    {
        $query = $this->db->query("SELECT count(*) `counter` FROM `exam_results`,exam_schedules,student_session WHERE exam_results.exam_schedule_id=exam_schedules.id and student_session.student_id=exam_results.student_id and student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_id=" . $this->db->escape($section_id) . " and exam_schedules.session_id=" . $this->db->escape($this->current_session) . " and exam_schedules.exam_id=" . $this->db->escape($exam_id));
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
        return $query->result_array();
    }

    public function getStudentExamResultByStudent($exam_id, $student_id, $exam_schedule)
    {
        $sql = "SELECT exam_schedules.id as `exam_schedules_id`,exam_results.id as `exam_results_id`,exam_schedules.exam_id,exam_schedules.date_of_exam,exam_schedules.full_marks,exam_schedules.passing_marks,exam_results.student_id,exam_results.get_marks,students.firstname,students.middlename,students.lastname,students.guardian_phone,students.email ,exams.name as `exam_name` FROM `exam_schedules` INNER JOIN exams on exams.id=exam_schedules.exam_id INNER JOIN exam_results ON exam_results.exam_schedule_id=exam_schedules.id INNER JOIN students on students.id=exam_results.student_id WHERE exam_schedules.session_id =" . $this->db->escape($this->current_session) . " and exam_schedules.exam_id =" . $this->db->escape($exam_id) . " and exam_results.student_id =" . $this->db->escape($student_id) . " and exam_schedules.id in (" . $exam_schedule . ") ORDER BY `exam_results`.`id` ASC";

        $query = $this->db->query($sql);
        return $query->result_array();
    }

    // public function getExamResults($exam_id, $post_exam_group_id, $students)
    // {
    //     $result           = array('exam_connection' => 0, 'students' => array(), 'exams' => array(), 'exam_connection_list' => array());
    //     $exam_connection  = false;
    //     $exam_connections = $this->examgroup_model->getExamGroupConnectionList($post_exam_group_id);
    //     if (!empty($exam_connections)) {
    //         $lastkey = key(array_slice($exam_connections, -1, 1, true));
    //         if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {
    //             $exam_connection           = true;
    //             $result['exam_connection'] = 1;
    //         }
    //     }
    //     $result['exam_connection_list'] = $exam_connections;
    //     foreach ($students as $student_key => $student_value) {
    //         $student = $this->examstudent_model->getExamStudentByID($student_value);

    //         $student['exam_result'] = array();
    //         if ($exam_connection) {
    //             foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {

    //                 $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByExamAndStudentID($student['student_id'], $exam_connection_value->exam_group_class_batch_exams_id);
    //                 if(!empty($exam_group_class_batch_exam_student)){
                        
    //                     $exam = $this->examgroup_model->getExamByID($exam_connection_value->exam_group_class_batch_exams_id);
    
    //                     $student['exam_result']['exam_roll_no_' . $exam_connection_value->exam_group_class_batch_exams_id] = $student['roll_no'];
    
    //                     $student['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id] = $this->getStudentResultByExam($exam_connection_value->exam_group_class_batch_exams_id, $exam_group_class_batch_exam_student->id);
    
    //                     $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;
    //                 }

    //             }
    //             $result['students'][] = $student;
    //         } else {
    //             $student['exam_roll_no'] = $student['roll_no'];
    //             $student['exam_result']  = $this->getStudentResultByExam($exam_id, $student['id']);
    //             $result['students'][]    = $student;
    //         }
    //     }

    //     return $result;
    // }
    
    public function getExamResults($exam_id, $post_exam_group_id, $students, $result_exam_ids = array()) {


        $result = array('exam_connection' => 0, 'students' => array(), 'exams' => array(), 'exam_connection_list' => array());

        $exam_connection = false;

        $exam_connections = $this->examgroup_model->getExamGroupConnectionListNew($post_exam_group_id);
        
        // $exam_connections = $this->examgroup_model->getExamGroupConnectionList($post_exam_group_id); comment by sweta 25 April

        if (!empty($exam_connections)) {

            $lastkey = key(array_slice($exam_connections, -1, 1, true));

            if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {

                $exam_connection = true;

                $result['exam_connection'] = 1;

            }

        }

        

        $result['exam_connection_list'] = $exam_connections;



        foreach ($students as $student_key => $student_value) {



            $student = $this->examstudent_model->getExamStudentByID($student_value);

         

            $student['exam_result'] = array();

            

            if ($exam_connection || (!empty($result_exam_ids) && count($result_exam_ids) > 0)) {

                $result['exam_connection'] = 1;

                if(!empty($result_exam_ids) && count($result_exam_ids) > 0)

                {

                    foreach ($result_exam_ids as $exam_connection_key => $exam_connection_value) {

                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByExamAndStudentID($student_value, $exam_connection_value);

                        $exam = $this->examgroup_model->getExamByID($exam_connection_value);

                        $student['exam_result']['exam_roll_no_' . $exam_connection_value] =  $student['roll_no'];



                        $student['exam_result']['exam_result_' . $exam_connection_value] = $this->getStudentResultByGroupExam($exam_connection_value, $student['student_id']);

                        $result['exams']['exam_' . $exam_connection_value] = $exam;

                    }

                } else {

                    foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {

                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByExamAndStudentID($student_value, $exam_connection_value->exam_group_class_batch_exams_id);



                        $exam = $this->examgroup_model->getExamByID($exam_connection_value->exam_group_class_batch_exams_id);



                        $student['exam_result']['exam_roll_no_' . $exam_connection_value->exam_group_class_batch_exams_id] =  $student['roll_no'];





                        $student['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id] =$this->getStudentResultByExam($exam_id, $student['id']);





                        $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;

                    }

                }

                          

                $result['students'][] = $student;

            } else {

                $student['exam_roll_no'] = $student['roll_no'];

                $student['exam_result'] = $this->getStudentResultByExam($exam_id, $student['id']);

                $result['students'][] = $student;

            }

        }



        return $result;

    }

    public function updaterank($update_array,$exam_group_class_batch_exam_id)
    {     
        if (!empty($update_array)) {
            $data_update = array('is_rank_generated' => 1);   
            $this->db->where('id', $exam_group_class_batch_exam_id);
            $this->db->update('exam_group_class_batch_exams', $data_update);
            $this->db->update_batch('exam_group_class_batch_exam_students', $update_array, 'id');
        }
       
    }

    public function getStudentResultByExam($exam_id, $student_id)
    {
        $sql   = "SELECT exam_group_class_batch_exam_subjects.*,exam_group_exam_results.id as `exam_group_exam_results_id`,exam_group_exam_results.attendence,exam_group_exam_results.get_marks,exam_group_exam_results.note,exam_group_exam_results.get_grade,subjects.name,subjects.code,exam_group_class_batch_exam_students.rank FROM `exam_group_class_batch_exam_subjects` inner JOIN exam_group_exam_results on exam_group_exam_results.exam_group_class_batch_exam_subject_id=exam_group_class_batch_exam_subjects.id INNER JOIN exam_group_class_batch_exam_students on exam_group_exam_results.exam_group_class_batch_exam_student_id=exam_group_class_batch_exam_students.id and exam_group_class_batch_exam_students.id=" . $this->db->escape($student_id) . " INNER JOIN subjects on subjects.id=exam_group_class_batch_exam_subjects.subject_id WHERE exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id=" . $this->db->escape($exam_id);
        $query = $this->db->query($sql);
        return $query->result();
    }
    
    
    // maharashtra exam start
    
    public function getMHExamResults($exam_id, $post_exam_group_id, $students, $result_exam_ids = array()) {

        $result = array('exam_connection' => 0, 'students' => array(), 'exams' => array(), 'exam_connection_list' => array());
        $exam_connection = false;
        $exam_connections = $this->examgroup_model->getMHExamGroupConnectionList($post_exam_group_id);
        if (!empty($exam_connections)) {
            $lastkey = key(array_slice($exam_connections, -1, 1, true));
            if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {
                $exam_connection = true;
                $result['exam_connection'] = 1;
            }
        }
        $result['exam_connection_list'] = $exam_connections;

        foreach ($students as $student_key => $student_value) {

            $student = $this->examstudent_model->getMHExamStudentByID($student_value);
         
            $student['exam_result'] = array();
            
            if ($exam_connection || (!empty($result_exam_ids) && count($result_exam_ids) > 0)) {
                $result['exam_connection'] = 1;
                if(!empty($result_exam_ids) && count($result_exam_ids) > 0)
                {
                    foreach ($result_exam_ids as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByMHExamAndStudentID($student_value, $exam_connection_value);
                        $exam = $this->examgroup_model->getMHExamByID($exam_connection_value);
                        $student['exam_result']['exam_roll_no_' . $exam_connection_value] =  $student['roll_no'];
        
                        $student['exam_result']['exam_result_' . $exam_connection_value] = $this->getMHStudentResultByGroupExam($exam_connection_value, $student['student_id']);
                        $result['exams']['exam_' . $exam_connection_value] = $exam;
                    }
                } else {
                    foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByMHExamAndStudentID($student_value, $exam_connection_value->exam_group_class_batch_exams_id);

                        $exam = $this->examgroup_model->getMHExamByID($exam_connection_value->exam_group_class_batch_exams_id);

                        $student['exam_result']['exam_roll_no_' . $exam_connection_value->exam_group_class_batch_exams_id] =  $student['roll_no'];


                        $student['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id] =$this->getStudentResultByMHExam($exam_id, $student['id']);


                        $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;
                    }
                }
                          
                $result['students'][] = $student;
            } else {                
                $student['exam_roll_no'] = $student['roll_no'];
                $student['exam_result'] = $this->getStudentResultByMHExam($exam_id, $student['id']);
                $result['students'][] = $student;
            }
        }

        return $result;
    }


    public function getMHFinalExamResults($exam_id, $post_exam_group_id, $students, $result_exam_ids = array()) {

        $result = array('exam_connection' => 0, 'students' => array(), 'exams' => array(), 'exam_connection_list' => array());
        $exam_connection = false;
        $exam_connections = $this->examgroup_model->getMHExamGroupConnectionList($post_exam_group_id);
        if (!empty($exam_connections)) {
            $lastkey = key(array_slice($exam_connections, -1, 1, true));
            if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {
                $exam_connection = true;
                $result['exam_connection'] = 1;
            }
        }
        $result['exam_connection_list'] = $exam_connections;

        foreach ($students as $student_key => $student_value) {

            $student = $this->examstudent_model->getMHExamStudentByID($student_value);
         
            $student['exam_result'] = array();
            
            if ((!empty($result_exam_ids) && count($result_exam_ids) > 0)) {
                $result['exam_connection'] = 1;
                if(!empty($result_exam_ids) && count($result_exam_ids) > 0)
                {
                    foreach ($result_exam_ids as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByMHExamAndStudentID($student_value, $exam_connection_value);
                        $exam = $this->examgroup_model->getMHExamByID($exam_connection_value);
                        $student['exam_result']['exam_roll_no_' . $exam_connection_value] =  $student['roll_no'];
        
                        $student['exam_result']['exam_result_' . $exam_connection_value] = $this->getMHStudentResultByGroupExam($exam_connection_value, $student['student_id']);
                        $result['exams']['exam_' . $exam_connection_value] = $exam;
                    }
                } else {
                    foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByMHExamAndStudentID($student_value, $exam_connection_value->exam_group_class_batch_exams_id);

                        $exam = $this->examgroup_model->getMHExamByID($exam_connection_value->exam_group_class_batch_exams_id);

                        $student['exam_result']['exam_roll_no_' . $exam_connection_value->exam_group_class_batch_exams_id] =  $student['roll_no'];


                        $student['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id] =$this->getStudentResultByMHExam($exam_id, $student['id']);


                        $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;
                    }
                }
                          
                $result['students'][] = $student;
            } else {                
                $student['exam_roll_no'] = $student['roll_no'];
                
                $student['exam_result'][$exam_id] = $this->getStudentResultByMHExam($exam_id, $student['id']);
                
                $result['students'][] = $student;
            }
        }



        return $result;
    }
    public function getStudentResultByMHExam($exam_id, $student_id) {
        $sql = "SELECT 
                    mh_exam_group_class_batch_exam_subjects.*, 
                    mh_exam_group_exam_results.id AS exam_group_exam_results_id, 
                    mh_exam_group_exam_results.attendence, 
                    mh_exam_group_exam_results.get_marks, 
                    mh_exam_group_exam_results.comp_marks, 
                    mh_exam_group_exam_results.get_grade, 
                    mh_exam_group_exam_results.note, 
                    subjects.name, 
                    subjects.code,
                    students.admission_no,
                    students.current_address,
                    students.roll_no AS student_roll_no,
                    mh_exam_group_class_batch_exam_students.student_session_id, 
                    mh_exam_group_class_batch_exam_students.exam_seat_no,
                    exam_subjectwise_remark.remark_name
                FROM `mh_exam_group_class_batch_exam_subjects`
                INNER JOIN mh_exam_group_exam_results 
                    ON mh_exam_group_exam_results.exam_group_class_batch_exam_subject_id = mh_exam_group_class_batch_exam_subjects.id
                INNER JOIN mh_exam_group_class_batch_exam_students 
                    ON mh_exam_group_exam_results.exam_group_class_batch_exam_student_id = mh_exam_group_class_batch_exam_students.id
                    AND mh_exam_group_class_batch_exam_students.id = " . $this->db->escape($student_id) . "
                INNER JOIN students 
                ON mh_exam_group_class_batch_exam_students.student_id = students.id

                INNER JOIN subjects 
                    ON subjects.id = mh_exam_group_class_batch_exam_subjects.subject_id
                LEFT JOIN exam_subjectwise_remark 
                    ON mh_exam_group_exam_results.note = exam_subjectwise_remark.id
                WHERE mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = " . $this->db->escape($exam_id) . " ORDER BY subjects.id ASC";

        $query = $this->db->query($sql);
        
        return $query->result();
    }
    
    public function getStudentFinalResultByGroupExam($exam_ids, $student_ids, $post_exam_class_id)
    {
        if (!is_array($student_ids)) {
            $student_ids = [$student_ids];
        }

        if (!is_array($exam_ids)) {
            $exam_ids = explode(',', $exam_ids);
        }

        $exam_ids_str = implode(',', array_map([$this->db, 'escape'], $exam_ids));

        $student_ids_str = [];
        foreach ($student_ids as $group) {
            $ids = explode(',', $group);
            $escaped_ids = array_map([$this->db, 'escape'], $ids);
            $student_ids_str[] = '(' . implode(',', $escaped_ids) . ')';
        }

        $student_ids_condition = implode(' OR ', array_map(function ($ids_group) {
            return "mh_exam_group_exam_results.exam_group_class_batch_exam_student_id IN $ids_group";
        }, $student_ids_str));

        $order_direction = ($post_exam_class_id == 36 || $post_exam_class_id == 37) ? 'DESC' : 'ASC';

        $sql = "SELECT 
                    mh_exam_group_class_batch_exam_subjects.*,
                    mh_exam_group_exam_results.id AS exam_group_exam_results_id,
                    mh_exam_group_exam_results.attendence,
                    mh_exam_group_exam_results.get_marks,
                    mh_exam_group_exam_results.previous_exammarks,
                    mh_exam_group_exam_results.note,
                    mh_exam_group_class_batch_exam_students.student_session_id,
                    exam_subjectwise_remark.remark_name,
                    mh_exam_group_class_batch_exams.exam AS exam_name,
                    mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id AS exam_id,
                    students.id AS student_id,
                    students.firstname,
                    students.dob,
                    students.admission_no,
                    students.middlename,
                    students.lastname,
                    students.father_occupation,
                    students.mother_occupation,
                    students.father_phone,
                    students.current_address,
                    students.weight,
                    students.height,
                    students.father_name,
                    students.roll_no,
                    students.mother_name,
                    students.mother_tongue,
                    classes.class,
                    sections.section,
                    sections.id as section_id,
                    classes.id as class_id,
                    subjects.name AS subject_name,
                    subjects.code AS subject_code
                FROM mh_exam_group_class_batch_exam_subjects 
                INNER JOIN mh_exam_group_exam_results 
                    ON mh_exam_group_exam_results.exam_group_class_batch_exam_subject_id = mh_exam_group_class_batch_exam_subjects.id 
                INNER JOIN mh_exam_group_class_batch_exams 
                    ON mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = mh_exam_group_class_batch_exams.id
                INNER JOIN mh_exam_group_class_batch_exam_students 
                    ON mh_exam_group_exam_results.exam_group_class_batch_exam_student_id = mh_exam_group_class_batch_exam_students.id
                INNER JOIN students 
                    ON mh_exam_group_class_batch_exam_students.student_id = students.id
                INNER JOIN student_session 
                    ON students.id = student_session.student_id
                INNER JOIN classes 
                    ON student_session.class_id = classes.id
                INNER JOIN sections 
                    ON student_session.section_id = sections.id
                INNER JOIN subjects 
                    ON subjects.id = mh_exam_group_class_batch_exam_subjects.subject_id 
                LEFT JOIN exam_subjectwise_remark 
                    ON mh_exam_group_exam_results.note = exam_subjectwise_remark.id
                WHERE mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id IN ($exam_ids_str)
                  AND ($student_ids_condition)
                ORDER BY students.id ASC, mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id $order_direction, subjects.id ASC";

        $query = $this->db->query($sql);
        $rows = $query->result_array();

        $subject_order = [
            'ENGLISH','MARATHI','HINDI / SAN','HINDI/SANSKRIT','SANKRIT 27/2','MATHEMATICS','ALGEBRA','GEOMETRY',
            'SCIENCE','SCIENCE-1','SCIENCE-2','Social Science','EVS','EVS PART 1','EVS PART 2','G.K','ARTS','DRAWING',
            'COMPUTER','WORK EXPERIENCE','PHYSICAL EDUCATION','HISTORY','HISTORY AND CIVICS','GEOMETRY','RHYMES',
            'MUSIC','ENGLISH GARAMER',''
        ];

        $results = [];
        $already_counted = [];
        foreach ($rows as $row) {
            $student_id = $row['student_id'];
            $student_session_id = $row['student_session_id'];
            $exam_id = $row['exam_id'];
            $subject_name = $row['subject_name'];
            $marks = $row['get_marks'];
            $remark_name = $row['remark_name'];
            $max_marks = $row['max_marks'];
            $min_marks = $row['min_marks'];
            $previous_exammarks = $row['previous_exammarks'];
            $attendance = $row['attendence'];

            $subject_key = $exam_id . '_' . $subject_name;
            if (!isset($already_counted[$student_id])) {
                    $already_counted[$student_id] = [];
                }


            if (!isset($results[$student_id])) {
                $results[$student_id] = [
                    'name' => $row['firstname'] . ' ' . ($row['middlename'] ? $row['middlename'] . ' ' : '') . $row['lastname'],
                    'class' => $row['class'],
                    'class_id' => $row['class_id'],
                    'section_id' => $row['section_id'],
                    'father_name' => $row['father_name'],
                    'student_id' => $student_id,
                    'weight' => $row['weight'],
                    'height' => $row['height'],
                    'student_session_id' => $student_session_id,
                    'mother_name' => $row['mother_name'],
                    'mother_tongue' => $row['mother_tongue'],
                    'father_phone' => $row['father_phone'],
                    'current_address' => $row['current_address'],
                    'section' => $row['section'],
                    'dob' => $row['dob'],
                    'admission_no' => $row['admission_no'],
                    'exams' => [],
                    'unique_subjects' => [],
                    'roll_no' => $row['roll_no'],
                    'total_marks_by_exam' => []
                ];
            }

            if (!isset($results[$student_id]['exams'][$exam_id])) {
                $results[$student_id]['exams'][$exam_id] = [
                    'exam_id' => $exam_id,
                    'exam_name' => $row['exam_name'],
                    'subjects' => []
                ];
            }

            if (!isset($results[$student_id]['unique_subjects'][$subject_name])) {
                $results[$student_id]['unique_subjects'][$subject_name] = [
                    'subject_name' => $subject_name,
                    'subject_max_marks' => $max_marks,
                    'subject_min_marks' => $min_marks
                ];
            }

            $results[$student_id]['exams'][$exam_id]['subjects'][$subject_name] = [
                'marks' => $marks,
                'max_marks' => $max_marks,
                'subject_name' => $subject_name,
                'remark_name' => $remark_name,
                'previous_exammarks' => $previous_exammarks,
                'attendance' => $attendance
            ];

            if (!in_array($subject_key, $already_counted[$student_id])) {
                if (!isset($results[$student_id]['total_marks_by_exam'][$exam_id])) {
                    $results[$student_id]['total_marks_by_exam'][$exam_id] = 0;
                }
                $results[$student_id]['total_marks_by_exam'][$exam_id] += is_numeric($marks) ? $marks : 0;

                $already_counted[$student_id][] = $subject_key;
            }
        }

        // Reorder subjects
        foreach ($results as &$student_data) {
            $ordered_unique_subjects = [];
            foreach ($subject_order as $subj) {
                if (isset($student_data['unique_subjects'][$subj])) {
                    $ordered_unique_subjects[$subj] = $student_data['unique_subjects'][$subj];
                }
            }
            $student_data['unique_subjects'] = $ordered_unique_subjects;

            foreach ($student_data['exams'] as &$exam) {
                $ordered_subjects = [];
                foreach ($subject_order as $subj) {
                    if (isset($exam['subjects'][$subj])) {
                        $ordered_subjects[$subj] = $exam['subjects'][$subj];
                    }
                }
                $exam['subjects'] = $ordered_subjects;
            }
        }

        // Ranking logic
        $examwise_class_section_data = [];

        foreach ($results as $student_id => $data) {
            foreach ($data['total_marks_by_exam'] as $exam_id => $total_marks) {
                $class_id = $data['class_id'];
                $section_id = $data['section_id'];

                $examwise_class_section_data[$exam_id]['class'][$class_id][$student_id] = $total_marks;
                $examwise_class_section_data[$exam_id]['section'][$section_id][$student_id] = $total_marks;
            }
        }

        foreach ($examwise_class_section_data as $exam_id => $groupings) {
            foreach (['class', 'section'] as $type) {
                foreach ($groupings[$type] as $group_id => $students) {
                    if ($order_direction == 'ASC') {
                        asort($students);
                    } else {
                        arsort($students);
                    }

                    $rank = 1;
                    foreach (array_keys($students) as $sid) {
                        $results[$sid]['exam_ranks'][$exam_id][$type . '_rank'] = $rank++;
                    }
                }
            }
        }


        // Step 1: Calculate total marks across all exams for final rank
        $final_total_marks = [];
        foreach ($results as $student_id => $data) {
            $final_total = 0;
            $final_max_total = 0;

            foreach ($data['exams'] as $exam) {
                foreach ($exam['subjects'] as $subject) {
                    $marks = is_numeric($subject['marks']) ? $subject['marks'] : 0;
                    $max_marks = is_numeric($subject['max_marks']) ? $subject['max_marks'] : 0;

                    $final_total += $marks;
                    $final_max_total += $max_marks;
                }
            }

            // Avoid divide by zero
            $final_percentage = ($final_max_total > 0) ? ($final_total / $final_max_total) * 100 : 0;

            $results[$student_id]['final_total_marks'] = $final_total;
            $results[$student_id]['final_max_total_marks'] = $final_max_total;
            $results[$student_id]['final_percentage'] = $final_percentage;
            $final_total_marks[$student_id] = $final_percentage;

        }

        // if ($order_direction == 'ASC') {
            // asort($final_total_marks);
        // } else {
            arsort($final_total_marks);
        // }

        $rank = 1;
        foreach (array_keys($final_total_marks) as $sid) {
            $results[$sid]['final_rank'] = $rank++;
        }


        



        return $results;
    }
    
    
    public function getStudentResultByGroupExam($exam_id, $student_id) {

        //$sql = "SELECT exam_group_class_batch_exam_subjects.*,exam_group_exam_results.id as `exam_group_exam_results_id`,exam_group_exam_results.attendence,exam_group_exam_results.get_marks,exam_group_exam_results.get_grade,exam_group_exam_results.note,subjects.name,subjects.code FROM `exam_group_class_batch_exam_subjects` inner JOIN exam_group_exam_results on exam_group_exam_results.exam_group_class_batch_exam_subject_id=exam_group_class_batch_exam_subjects.id INNER JOIN exam_group_class_batch_exam_students on exam_group_exam_results.exam_group_class_batch_exam_student_id=exam_group_class_batch_exam_students.id and (exam_group_class_batch_exam_students.student_id=" . $this->db->escape($student_id) . " AND exam_group_class_batch_exam_students.exam_group_class_batch_exam_id =" . $this->db->escape($exam_id) . ") INNER JOIN subjects on subjects.id=exam_group_class_batch_exam_subjects.subject_id WHERE exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id=" . $this->db->escape($exam_id) ." ORDER BY exam_group_class_batch_exam_subjects.subject_id ASC";

        $sql = "SELECT exam_group_class_batch_exam_subjects.*,exam_group_exam_results.id as `exam_group_exam_results_id`,exam_group_exam_results.attendence,exam_group_exam_results.get_marks,exam_group_exam_results.get_grade,exam_group_exam_results.note,subjects.name,subjects.code,exam_group_class_batch_exam_students.id as `exam_student_id`, exam_group_class_batch_exam_students.student_session_id as `exam_student_session_id`  FROM `exam_group_class_batch_exam_subjects` inner JOIN exam_group_exam_results on exam_group_exam_results.exam_group_class_batch_exam_subject_id=exam_group_class_batch_exam_subjects.id INNER JOIN exam_group_class_batch_exam_students on exam_group_exam_results.exam_group_class_batch_exam_student_id=exam_group_class_batch_exam_students.id and (exam_group_class_batch_exam_students.student_id=" . $this->db->escape($student_id) . " AND exam_group_class_batch_exam_students.exam_group_class_batch_exam_id =" . $this->db->escape($exam_id) . ") INNER JOIN subjects on subjects.id=exam_group_class_batch_exam_subjects.subject_id WHERE exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id=" . $this->db->escape($exam_id) ." ORDER BY subjects.code ASC";

        // print_r($sql);exit();

        $query = $this->db->query($sql);

        return $query->result();

    }


    public function getMHStudentResultByGroupExam($exam_id, $student_id) {
        $sql = "SELECT mh_exam_group_class_batch_exam_subjects.*,mh_exam_group_exam_results.id as `exam_group_exam_results_id`,mh_exam_group_exam_results.attendence,mh_exam_group_exam_results.get_marks,mh_exam_group_exam_results.get_grade,mh_exam_group_exam_results.note,subjects.name,subjects.code FROM `mh_exam_group_class_batch_exam_subjects` inner JOIN mh_exam_group_exam_results on mh_exam_group_exam_results.exam_group_class_batch_exam_subject_id=mh_exam_group_class_batch_exam_subjects.id INNER JOIN mh_exam_group_class_batch_exam_students on mh_exam_group_exam_results.exam_group_class_batch_exam_student_id=mh_exam_group_class_batch_exam_students.id and (mh_exam_group_class_batch_exam_students.student_id=" . $this->db->escape($student_id) . " AND mh_exam_group_class_batch_exam_students.exam_group_class_batch_exam_id =" . $this->db->escape($exam_id) . ") INNER JOIN subjects on subjects.id=mh_exam_group_class_batch_exam_subjects.subject_id WHERE mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id=" . $this->db->escape($exam_id) ." ORDER BY mh_exam_group_class_batch_exam_subjects.subject_id ASC";
        $query = $this->db->query($sql);
        return $query->result();
    }
    
    // maharashtra exam end

    public function getStudentExamResults($exam_id, $post_exam_group_id, $exam_group_class_batch_exam_student_id, $student_id)
    {
        $student          = $this->examstudent_model->getExamStudentByID($exam_group_class_batch_exam_student_id);
        $result           = array('student' => $student, 'exam_connection' => 0, 'result' => array(), 'exams' => array(), 'exam_connection_list' => array());
        $exam_connection  = false;
        $exam_connections = $this->examgroup_model->getExamGroupConnectionList($post_exam_group_id);
        if (!empty($exam_connections)) {
            $lastkey = key(array_slice($exam_connections, -1, 1, true));
            if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {
                $exam_connection           = true;
                $result['exam_connection'] = 1;
            }
        }
        $result['exam_connection_list'] = $exam_connections;
        if ($exam_connection) {
            $new_array = array();

            foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {

                $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByExamAndStudentID($student_id, $exam_connection_value->exam_group_class_batch_exams_id);

                $exam = $this->examgroup_model->getExamByID($exam_connection_value->exam_group_class_batch_exams_id);

                if (!empty($exam_group_class_batch_exam_student->id)) {

                    $result['exam_result']['exam_roll_no_' . $exam_connection_value->exam_group_class_batch_exams_id] = $student['roll_no'];
                    $result['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id]
                    = $this->getStudentResultByExam($exam_connection_value->exam_group_class_batch_exams_id, $exam_group_class_batch_exam_student->id);

                }
                $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;
            }

        } else {

            $result['exam_connection_list']    = $exam_connections;
            $result['student']['exam_roll_no'] = $student['roll_no'];
            $result['result']                  = $this->getStudentResultByExam($exam_id, $exam_group_class_batch_exam_student_id);
        }

        return $result;
    }

}
