<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Certificate_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    public function addcertificate($data)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('certificates', $data);
            $message   = UPDATE_RECORD_CONSTANT . " On  certificates id " . $data['id'];
            $action    = "Update";
            $record_id = $data['id'];
            $this->log($message, $record_id, $action);
            //======================Code End==============================

            $this->db->trans_complete(); # Completing transaction
            /* Optional */

            if ($this->db->trans_status() === false) {
                # Something went wrong.
                $this->db->trans_rollback();
                return false;
            } else {
                //return $return_value;
            }
        } else {
            $this->db->insert('certificates', $data);
            $insert_id = $this->db->insert_id();
            $message   = INSERT_RECORD_CONSTANT . " On certificates id " . $insert_id;
            $action    = "Insert";
            $record_id = $insert_id;
            $this->log($message, $record_id, $action);
            //======================Code End==============================

            $this->db->trans_complete(); # Completing transaction
            /* Optional */

            if ($this->db->trans_status() === false) {
                # Something went wrong.
                $this->db->trans_rollback();
                return false;
            } else {
                //return $return_value;
            }
            return $insert_id;
        }
    }

    public function certificateList()
    {
        $this->db->select('*');
        $this->db->from('certificates');
        $this->db->where('status = 1');
        $this->db->where('created_for = 2');
        $query = $this->db->get();
        return $query->result();
    }

    public function get($id)
    {
        $this->db->select('*');
        $this->db->from('certificates');
        $this->db->where('status = 1');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->result();
    }

    public function remove($id)
    {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        $this->db->where('id', $id);
        $this->db->delete('certificates');
        $message   = DELETE_RECORD_CONSTANT . " On certificates id " . $id;
        $action    = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */
        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }

    public function getstudentcertificate()
    {
        $this->db->select('*');
        $this->db->from('certificates');
        $this->db->where('created_for = 2');
        $query = $this->db->get();
        return $query->result();
    }

    public function certifiatebyid($id)
    {
        $this->db->select('*');
        $this->db->from('certificates');
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row();
    }
    
            public function getbycurrentsession($id = null)
{
    $this->db->select('
        students.id,
        students.firstname,
        students.middlename,
         students.father_name,
        students.lastname,
        students.admission_no,
        classes.class,
        sections.section
    ')
    ->from('students')
    ->join('student_session', 'student_session.student_id = students.id')
    ->join('classes', 'student_session.class_id = classes.id')
    ->join('sections', 'sections.id = student_session.section_id')
    ->where('student_session.session_id', $this->current_session);

    if ($id !== null) {
        $this->db->where('students.id', $id);
    } else {
        $this->db->where('students.is_active', 'yes');
        $this->db->order_by('students.id', 'desc');
    }

    $query = $this->db->get();

    if ($id !== null) {
        return $query->row_array();
    } else {
        return $query->result_array();
    }
}



public function getbycurrentsessioncertificate()
{
    $session_id = $this->setting_model->getCurrentSession();

    $this->db->select('
        event_certificates.id,
        event_certificates.certificate_name,
        event_certificates.event_name,
        event_certificates.position,
        event_certificates.date,
        students.firstname,
        students.lastname,
        students.father_name,
        classes.class,
        sections.section
    ');
    $this->db->from('event_certificates');
    $this->db->join('students', 'students.id = event_certificates.student_id', 'left');
    $this->db->join('classes', 'classes.id = event_certificates.class_id', 'left');
    $this->db->join('sections', 'sections.id = event_certificates.section_id', 'left');
    $this->db->where('event_certificates.session_id', $session_id);
    $this->db->order_by('event_certificates.id', 'DESC');

    $query = $this->db->get();
    return $query->result_array();
}
    public function getbycurrentsessioncertificategroupby()
{
    $session_id = $this->setting_model->getCurrentSession();

    $this->db->select('
        id,
        event_name,
        certificate_name,
        date
    ');
    $this->db->from('event_certificates');
    $this->db->where('session_id', $session_id);
    $this->db->group_by('event_name'); // Group by event_name to get only one record per event
    $this->db->order_by('event_name', 'ASC');

    $query = $this->db->get();
    return $query->result_array();
}
public function getCertificateById($id)
{
    $session_id = $this->setting_model->getCurrentSession();

    $this->db->select('
        event_certificates.id,
        event_certificates.certificate_name,
        event_certificates.event_name,
        event_certificates.position,
        event_certificates.date,
        students.firstname,
        students.lastname,
        students.father_name,
        classes.class,
        sections.section
    ');
    $this->db->from('event_certificates');
    $this->db->join('students', 'students.id = event_certificates.student_id', 'left');
    $this->db->join('classes', 'classes.id = event_certificates.class_id', 'left');
    $this->db->join('sections', 'sections.id = event_certificates.section_id', 'left');
    $this->db->where('event_certificates.id', $id);
    $this->db->where('event_certificates.session_id', $session_id);

    $query = $this->db->get();
    return $query->row_array();
}


public function multigetCertificateByStudentId($student_id)
{
    $session_id = $this->setting_model->getCurrentSession();

    $this->db->select('
        event_certificates.id,
        event_certificates.certificate_name,
        event_certificates.event_name,
        event_certificates.position,
        event_certificates.date,
        students.firstname,
        students.lastname,
        students.father_name,
        classes.class,
        sections.section
    ');
    $this->db->from('event_certificates');
    $this->db->join('students', 'students.id = event_certificates.student_id', 'left');
    $this->db->join('classes', 'classes.id = event_certificates.class_id', 'left');
    $this->db->join('sections', 'sections.id = event_certificates.section_id', 'left');
    $this->db->where('event_certificates.student_id', $student_id);
    $this->db->where('event_certificates.session_id', $session_id);
    $this->db->order_by('event_certificates.id', 'DESC'); // latest first

    $query = $this->db->get();
    return $query->row_array();
}

public function getStudentsByClassSectionEvent($class_id, $section_id, $event_name)
{
    $session_id = $this->setting_model->getCurrentSession();

    $this->db->select('
        students.id,
        students.admission_no,
        students.firstname,
        students.middlename,
        students.lastname,
        students.gender,
        classes.class,
        sections.section,
        event_certificates.certificate_name,
        event_certificates.event_name,
        event_certificates.position
    ');
    $this->db->from('event_certificates');
    
    // Join with students table
    $this->db->join('students', 'students.id = event_certificates.student_id', 'left');

    // Join with student_session table to get class and section for current session
    $this->db->join('student_session', 'student_session.student_id = students.id AND student_session.session_id = '.$session_id, 'inner');

    // Join with classes and sections through student_session
    $this->db->join('classes', 'classes.id = student_session.class_id', 'left');
    $this->db->join('sections', 'sections.id = student_session.section_id', 'left');

    // Filter by class, section, and event name
    $this->db->where('student_session.class_id', $class_id);
    if (!empty($section_id)) {
        $this->db->where('student_session.section_id', $section_id);
    }
    $this->db->where('event_certificates.event_name', $event_name);
    $this->db->where('event_certificates.session_id', $session_id);

    $this->db->group_by('students.id'); // Ensure unique students
    $this->db->order_by('students.admission_no', 'ASC');

    $query = $this->db->get();
    return $query->result_array();
}


}
