<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Cbse_examsubject_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function add($insert_array, $update_array, $not_be_del, $exam_id) {

        if (!empty($insert_array)) {
            foreach ($insert_array as $insert_key => $insert_value) {
                $this->db->insert('cbse_exam_group_class_batch_exam_subjects', $insert_array[$insert_key]);
                $not_be_del[] = $this->db->insert_id();
            }
        }
        if (!empty($update_array)) {
            $this->db->update_batch('cbse_exam_group_class_batch_exam_subjects', $update_array, 'id');
        }

        if (!empty($not_be_del)) {

            $this->db->where('exam_group_class_batch_exams_id', $exam_id);
            $this->db->where_not_in('id', $not_be_del);
            $this->db->delete('cbse_exam_group_class_batch_exam_subjects');
        }
    }
    
    public function get_exam_subjects_byexam($exam_group_class_batch_exam_id)
    {
       $this->db->select('*')->from('cbse_exam_group_class_batch_exam_subjects');
       $this->db->where('exam_group_class_batch_exams_id',$exam_group_class_batch_exam_id);
       $query = $this->db->get();
       return $query->result();

    }


    public function get_assessment_results($class_id, $section_id, $subject_id, $month, $session_id, $select_student_id)
    {
        $this->db->select('
            ar.id as result_id, 
            ar.student_id, 
            ar.get_marks, 
            ar.month, 
            a.assessment_type_id, 
            at.type as assessment_type, 
            a.id as assessment_id, 
            a.name as assessment_name, 
            at.assessment_max_marks, 
            s.firstname as student_firstname, 
            s.lastname as student_lastname
        ');
        $this->db->from('assessment_results ar');
        $this->db->join('assessments a', 'a.id = ar.assessment_id');
        $this->db->join('assessment_types at', 'at.id = a.assessment_type_id');
        $this->db->join('students s', 's.id = ar.student_id');
        $this->db->where('a.class_id', $class_id);
        $this->db->where('a.section_id', $section_id);
        $this->db->where('a.session_id', $session_id);
        $this->db->where('a.subject_id', $subject_id);
        $this->db->where_in('ar.student_id', $select_student_id);
        $this->db->where('ar.month', $month); 
        $this->db->order_by('ar.student_id', 'ASC'); // Ensuring student order

        $query = $this->db->get();
        $results = $query->result_array();

        // Organize results into a structured array
        $student_results = [];
        $student_avg = [];

        foreach ($results as $row) {
            $student_id = $row['student_id'];
            $assessment_type_id = $row['assessment_type_id'];

            // Initialize student entry if not exists
            if (!isset($student_results[$student_id])) {
                $student_results[$student_id] = [
                    'student_id' => $student_id,
                    'student_name' => $row['student_firstname'] . ' ' . $row['student_lastname'],
                    'assessments' => []
                ];
            }

            // Calculate average scores per student and assessment type
            $key = $student_id . '-' . $assessment_type_id;
            if (!isset($student_avg[$key])) {
                $student_avg[$key] = ['total' => 0, 'count' => 0];
            }
            $student_avg[$key]['total'] += $row['get_marks'];
            $student_avg[$key]['count']++;

            // Store assessments inside the student array
            $student_results[$student_id]['assessments'][] = [
                'assessment_id' => $row['assessment_id'],
                'assessment_name' => $row['assessment_name'],
                'assessment_type' => $row['assessment_type'],
                'assessment_type_id' => $assessment_type_id,
                'get_marks' => $row['get_marks'],
                'assessment_max_marks' => $row['assessment_max_marks']
            ];
        }

        // Attach calculated averages
        foreach ($student_results as &$student) {
            foreach ($student['assessments'] as &$assessment) {
                $key = $student['student_id'] . '-' . $assessment['assessment_type_id'];
                $assessment['avg_score'] = round($student_avg[$key]['total'] / $student_avg[$key]['count'], 2);
            }
        }

        return array_values($student_results); // Reset indexes
    }



    public function get_students_by_class_section($class_id, $section_id, $session_id)
    {
        $this->db->select('students.id as student_id, students.admission_no, students.firstname, students.lastname,students.middlename, students.roll_no,students.father_name,students.dob,students.father_phone,students.gender,student_session.section_id');
        $this->db->from('students');
        $this->db->join('student_session', 'student_session.student_id = students.id', 'inner'); // Correct JOIN syntax
        $this->db->where('student_session.class_id', $class_id);
        $this->db->where('student_session.section_id', $section_id);
        $this->db->where('student_session.session_id', $session_id); // Ensure students are fetched for the selected session
        $this->db->where('students.is_active', 'yes'); // Fetch only active students
        
        return $this->db->get()->result();
    }




    

    // public function get_exam_subjects($exam_id)
    // {
    //     $this->db->select('mh_cbse_exam_group_class_batch_exam_subjects.*,subjects.name as subject_name')->from('mh_cbse_exam_group_class_batch_exam_subjects');
    //     $this->db->join('subjects', 'subjects.id = mh_cbse_exam_group_class_batch_exam_subjects.subject_id');
    //     $this->db->where('mh_cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id', $exam_id);
    //     $query = $this->db->get();
    //     return $query->result_array();
        
    // }

}
