<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Cbse_examresult_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */
    public function get($id = null) {
        $this->db->select()->from('exam_results');
        if ($id != null) {
            $this->db->where('id', $id);
        } else {
            $this->db->order_by('id');
        }
        $query = $this->db->get();
        if ($id != null) {
            return $query->row_array();
        } else {
            return $query->result_array();
        }
    }

    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id) {
        $this->db->where('id', $id);
        $this->db->delete('exam_results');
    }

    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('exam_results', $data);
        } else {
            $this->db->insert('exam_results', $data);
            return $this->db->insert_id();
        }
    }

    public function add_exam_result($data) {
        $this->db->where('exam_schedule_id', $data['exam_schedule_id']);
        $this->db->where('student_id', $data['student_id']);
        $q = $this->db->get('exam_results');
        $result = $q->row();
        if ($q->num_rows() > 0) {
            $this->db->where('id', $result->id);
            $this->db->update('exam_results', $data);
            if ($result->get_marks != $data['get_marks']) {
                return $result->id;
            }
        } else {
            $this->db->insert('exam_results', $data);
            $insert_id = $this->db->insert_id();
            return $insert_id;
        }
        return false;
    }

    public function get_exam_result($exam_schedule_id = null, $student_id = null) {
        $this->db->select()->from('exam_results');
        $this->db->where('exam_schedule_id', $exam_schedule_id);
        $this->db->where('student_id', $student_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            $obj = new stdClass();
            $obj->attendence = 'pre';
            $obj->get_marks = "0.00";
            return $obj;
        }
    }

    public function get_result($exam_schedule_id = null, $student_id = null) {
        $this->db->select()->from('exam_results');
        $this->db->where('exam_schedule_id', $exam_schedule_id);
        $this->db->where('student_id', $student_id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            
        }
    }

    public function checkexamresultpreparebyexam($exam_id, $class_id, $section_id) {
        $query = $this->db->query("SELECT count(*) `counter` FROM `exam_results`,exam_schedules,student_session WHERE exam_results.exam_schedule_id=exam_schedules.id and student_session.student_id=exam_results.student_id and student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_id=" . $this->db->escape($section_id) . " and exam_schedules.session_id=" . $this->db->escape($this->current_session) . " and exam_schedules.exam_id=" . $this->db->escape($exam_id));
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
        return $query->result_array();
    }

    public function getStudentExamResultByStudent($exam_id, $student_id, $exam_schedule) {
        $sql = "SELECT exam_schedules.id as `exam_schedules_id`,exam_results.id as `exam_results_id`,exam_schedules.exam_id,exam_schedules.date_of_exam,exam_schedules.full_marks,exam_schedules.passing_marks,exam_results.student_id,exam_results.get_marks,students.firstname,students.middlename,students.lastname,students.guardian_phone,students.email ,exams.name as `exam_name` FROM `exam_schedules` INNER JOIN exams on exams.id=exam_schedules.exam_id INNER JOIN exam_results ON exam_results.exam_schedule_id=exam_schedules.id INNER JOIN students on students.id=exam_results.student_id WHERE exam_schedules.session_id =" . $this->db->escape($this->current_session) . " and exam_schedules.exam_id =" . $this->db->escape($exam_id) . " and exam_results.student_id =" . $this->db->escape($student_id) . " and exam_schedules.id in (" . $exam_schedule . ") ORDER BY `exam_results`.`id` ASC";

        $query = $this->db->query($sql);
        return $query->result_array();
    }

    public function getExamResults($exam_id, $post_exam_group_id, $students, $result_exam_ids = array()) {

        $result = array('exam_connection' => 0, 'students' => array(), 'exams' => array(), 'exam_connection_list' => array());
        $exam_connection = false;
        $exam_connections = $this->examgroup_model->getExamGroupConnectionList($post_exam_group_id);
        if (!empty($exam_connections)) {
            $lastkey = key(array_slice($exam_connections, -1, 1, true));
            if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {
                $exam_connection = true;
                $result['exam_connection'] = 1;
            }
        }
        $result['exam_connection_list'] = $exam_connections;

        foreach ($students as $student_key => $student_value) {

            $student = $this->examstudent_model->getExamStudentByID($student_value);
         
            $student['exam_result'] = array();
            
            if ($exam_connection || (!empty($result_exam_ids) && count($result_exam_ids) > 0)) {
                $result['exam_connection'] = 1;
                if(!empty($result_exam_ids) && count($result_exam_ids) > 0)
                {
                    foreach ($result_exam_ids as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByExamAndStudentID($student_value, $exam_connection_value);
                        $exam = $this->examgroup_model->getExamByID($exam_connection_value);
                        $student['exam_result']['exam_roll_no_' . $exam_connection_value] =  $student['roll_no'];
        
                        $student['exam_result']['exam_result_' . $exam_connection_value] = $this->getStudentResultByGroupExam($exam_connection_value, $student['student_id']);
                        $result['exams']['exam_' . $exam_connection_value] = $exam;
                    }
                } else {
                    foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByExamAndStudentID($student_value, $exam_connection_value->exam_group_class_batch_exams_id);

                        $exam = $this->examgroup_model->getExamByID($exam_connection_value->exam_group_class_batch_exams_id);

                        $student['exam_result']['exam_roll_no_' . $exam_connection_value->exam_group_class_batch_exams_id] =  $student['roll_no'];


                        $student['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id] =$this->getStudentResultByExam($exam_id, $student['id']);


                        $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;
                    }
                }
                          
                $result['students'][] = $student;
            } else {                
                $student['exam_roll_no'] = $student['roll_no'];
                $student['exam_result'] = $this->getStudentResultByExam($exam_id, $student['id']);
                $result['students'][] = $student;
            }
        }

        return $result;
    }


    public function getMHExamResults($exam_id, $post_exam_group_id, $students, $result_exam_ids = array()) {

        $result = array('exam_connection' => 0, 'students' => array(), 'exams' => array(), 'exam_connection_list' => array());
        $exam_connection = false;
        $exam_connections = $this->examgroup_model->getMHExamGroupConnectionList($post_exam_group_id);
        if (!empty($exam_connections)) {
            $lastkey = key(array_slice($exam_connections, -1, 1, true));
            if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {
                $exam_connection = true;
                $result['exam_connection'] = 1;
            }
        }
        $result['exam_connection_list'] = $exam_connections;

        foreach ($students as $student_key => $student_value) {

            $student = $this->examstudent_model->getMHExamStudentByID($student_value);
         
            $student['exam_result'] = array();
            
            if ($exam_connection || (!empty($result_exam_ids) && count($result_exam_ids) > 0)) {
                $result['exam_connection'] = 1;
                if(!empty($result_exam_ids) && count($result_exam_ids) > 0)
                {
                    foreach ($result_exam_ids as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByMHExamAndStudentID($student_value, $exam_connection_value);
                        $exam = $this->examgroup_model->getMHExamByID($exam_connection_value);
                        $student['exam_result']['exam_roll_no_' . $exam_connection_value] =  $student['roll_no'];
        
                        $student['exam_result']['exam_result_' . $exam_connection_value] = $this->getMHStudentResultByGroupExam($exam_connection_value, $student['student_id']);
                        $result['exams']['exam_' . $exam_connection_value] = $exam;
                    }
                } else {
                    foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {
                        $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByMHExamAndStudentID($student_value, $exam_connection_value->exam_group_class_batch_exams_id);

                        $exam = $this->examgroup_model->getMHExamByID($exam_connection_value->exam_group_class_batch_exams_id);

                        $student['exam_result']['exam_roll_no_' . $exam_connection_value->exam_group_class_batch_exams_id] =  $student['roll_no'];


                        $student['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id] =$this->getStudentResultByMHExam($exam_id, $student['id']);


                        $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;
                    }
                }
                          
                $result['students'][] = $student;
            } else {                
                $student['exam_roll_no'] = $student['roll_no'];
                $student['exam_result'] = $this->getStudentResultByMHExam($exam_id, $student['id']);
                $result['students'][] = $student;
            }
        }

        return $result;
    }

    public function getStudentResultByExam($exam_id, $student_id) {
        $sql = "SELECT exam_group_class_batch_exam_subjects.*,exam_group_exam_results.id as `exam_group_exam_results_id`,exam_group_exam_results.attendence,exam_group_exam_results.get_marks,exam_group_exam_results.get_grade,exam_group_exam_results.note,subjects.name,subjects.code FROM `exam_group_class_batch_exam_subjects` inner JOIN exam_group_exam_results on exam_group_exam_results.exam_group_class_batch_exam_subject_id=exam_group_class_batch_exam_subjects.id INNER JOIN exam_group_class_batch_exam_students on exam_group_exam_results.exam_group_class_batch_exam_student_id=exam_group_class_batch_exam_students.id and exam_group_class_batch_exam_students.id=" . $this->db->escape($student_id) . " INNER JOIN subjects on subjects.id=exam_group_class_batch_exam_subjects.subject_id WHERE exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id=" . $this->db->escape($exam_id);
        $query = $this->db->query($sql);
        
        return $query->result();
    }


    public function getStudentResultByMHExam($exam_id, $student_id) {
        $sql = "SELECT 
                    mh_exam_group_class_batch_exam_subjects.*, 
                    mh_exam_group_exam_results.id AS exam_group_exam_results_id, 
                    mh_exam_group_exam_results.attendence, 
                    mh_exam_group_exam_results.get_marks, 
                    mh_exam_group_exam_results.comp_marks, 
                    mh_exam_group_exam_results.get_grade, 
                    mh_exam_group_exam_results.note, 
                    subjects.name, 
                    subjects.code, 
                    exam_subjectwise_remark.remark_name
                FROM `mh_exam_group_class_batch_exam_subjects`
                INNER JOIN mh_exam_group_exam_results 
                    ON mh_exam_group_exam_results.exam_group_class_batch_exam_subject_id = mh_exam_group_class_batch_exam_subjects.id
                INNER JOIN mh_exam_group_class_batch_exam_students 
                    ON mh_exam_group_exam_results.exam_group_class_batch_exam_student_id = mh_exam_group_class_batch_exam_students.id
                    AND mh_exam_group_class_batch_exam_students.id = " . $this->db->escape($student_id) . "
                INNER JOIN subjects 
                    ON subjects.id = mh_exam_group_class_batch_exam_subjects.subject_id
                LEFT JOIN exam_subjectwise_remark 
                    ON mh_exam_group_exam_results.note = exam_subjectwise_remark.id
                WHERE mh_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = " . $this->db->escape($exam_id);

        $query = $this->db->query($sql);
        
        return $query->result();
    }

    
    public function getStudentResultByGroupExam($exam_id, $student_ids) {
    // Ensure $student_ids is an array
    if (!is_array($student_ids)) {
        $student_ids = [$student_ids];
    }

    // Escape and format student IDs for WHERE IN clause
    $student_ids_str = implode(',', array_map([$this->db, 'escape'], $student_ids));

    $sql = "SELECT 
                cbse_exam_group_class_batch_exam_subjects.*,
                cbse_exam_group_exam_results.id AS `cbse_exam_group_exam_results_id`,
                cbse_exam_group_exam_results.attendence,
                cbse_exam_group_exam_results.get_marks,
                cbse_exam_group_exam_results.get_grade,
                cbse_exam_group_exam_results.note,
                students.id AS student_id,
                students.firstname,
                students.middlename,
                 students.father_name,
                students.lastname,
                classes.class,
                sections.section,
                subjects.name AS subject_name,
                subjects.code AS subject_code
            FROM `cbse_exam_group_class_batch_exam_subjects` 
            INNER JOIN cbse_exam_group_exam_results 
                ON cbse_exam_group_exam_results.exam_group_class_batch_exam_subject_id = cbse_exam_group_class_batch_exam_subjects.id 
            INNER JOIN cbse_exam_group_class_batch_exam_students 
                ON cbse_exam_group_exam_results.exam_group_class_batch_exam_student_id = cbse_exam_group_class_batch_exam_students.id
            INNER JOIN students 
                ON cbse_exam_group_class_batch_exam_students.student_id = students.id
            INNER JOIN student_session 
                ON students.id = student_session.student_id
            INNER JOIN classes 
                ON student_session.class_id = classes.id
            INNER JOIN sections 
                ON student_session.section_id = sections.id
            INNER JOIN subjects 
                ON subjects.id = cbse_exam_group_class_batch_exam_subjects.subject_id 
            WHERE cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = " . $this->db->escape($exam_id) . " 
                  AND cbse_exam_group_exam_results.exam_group_class_batch_exam_student_id IN ($student_ids_str) 
            ORDER BY cbse_exam_group_class_batch_exam_subjects.subject_id ASC";

    $query = $this->db->query($sql);
    $rows = $query->result_array();

    // Organize data
    $subjects = []; // Unique subjects for header
    $results = [];

    foreach ($rows as $row) {
        $student_id = $row['student_id'];
        $subject_name = $row['subject_name'];
        $max_marks = $row['max_marks'];
        $min_marks = $row['min_marks'];
        $marks = $row['get_marks'];
        $attendance = $row['attendence']; 

        // Store marks by student and subject
        $results[$student_id]['name'] = $row['firstname'] . ' ' . ($row['father_name'] ? $row['father_name'] . ' ' : '') . $row['lastname'];
        $results[$student_id]['class'] = $row['class'];
        $results[$student_id]['section'] = $row['section'];
        $results[$student_id]['marks'][$subject_name] = [
            'marks' => $marks,
            'attendance' => $attendance // Store attendance
        ];

        // Track unique subjects
        if (!isset($subjects[$subject_name])) {
            $subjects[$subject_name] = [
                'subject_name' => $subject_name,
                'subject_max_marks' => $max_marks,
                'subject_min_marks' => $min_marks
                        ];
        }
    }

    return ['subjects' => $subjects, 'results' => $results];
}


    public function getStudentFinalResultByGroupExam($exam_ids, $student_ids)
    {
        // Ensure $student_ids is an array
        if (!is_array($student_ids)) {
            $student_ids = [$student_ids];
        }
    
        // Convert comma-separated string to array if needed
        if (!is_array($exam_ids)) {
            $exam_ids = explode(',', $exam_ids);
        }
    
        // Escape and format exam IDs
        $exam_ids_str = implode(',', array_map([$this->db, 'escape'], $exam_ids));
    
        // Initialize an array for formatted student IDs to be used in SQL
        $student_ids_str = [];
    
        // Format each student ID group (e.g., "52,58" -> ("52","58"))
        foreach ($student_ids as $group) {
            $ids = explode(',', $group); // Split comma-separated student IDs
            $escaped_ids = array_map([$this->db, 'escape'], $ids); // Escape each ID
            $student_ids_str[] = '(' . implode(',', $escaped_ids) . ')'; // Add each group to an array
        }
    
        // Join the student groups as `IN` conditions for SQL (e.g., "IN ((52,58), (53,59))")
        $student_ids_condition = implode(' OR ', array_map(function($ids_group) {
            return "cbse_exam_group_exam_results.exam_group_class_batch_exam_student_id IN $ids_group";
        }, $student_ids_str));
    
        // SQL Query to fetch results
        $sql = "SELECT 
                    cbse_exam_group_class_batch_exam_subjects.*,
                    cbse_exam_group_exam_results.id AS cbse_exam_group_exam_results_id,
                    cbse_exam_group_exam_results.attendence,
                    cbse_exam_group_exam_results.get_marks,
                    cbse_exam_group_exam_results.assessment_type_marks,
                    cbse_exam_group_exam_results.previous_exammarks,
                    cbse_exam_group_exam_results.get_grade,
                    cbse_exam_group_exam_results.term_marks,
                    cbse_exam_group_exam_results.note,
                    
                    cbse_exam_group_class_batch_exam_students.teacher_remark,
                    cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id AS exam_id,
                    students.id AS student_id,
                    students.firstname,
                    students.dob,
                    students.roll_no,
                    students.admission_no,
                    students.middlename,
                    students.lastname,
                    classes.class,
                    sections.section,
                    subjects.name AS subject_name,
                    subjects.code AS subject_code
                FROM cbse_exam_group_class_batch_exam_subjects 
                INNER JOIN cbse_exam_group_exam_results 
                    ON cbse_exam_group_exam_results.exam_group_class_batch_exam_subject_id = cbse_exam_group_class_batch_exam_subjects.id 
                INNER JOIN cbse_exam_group_class_batch_exam_students 
                    ON cbse_exam_group_exam_results.exam_group_class_batch_exam_student_id = cbse_exam_group_class_batch_exam_students.id
                INNER JOIN students 
                    ON cbse_exam_group_class_batch_exam_students.student_id = students.id
                INNER JOIN student_session 
                    ON students.id = student_session.student_id
                INNER JOIN classes 
                    ON student_session.class_id = classes.id
                INNER JOIN sections 
                    ON student_session.section_id = sections.id
                INNER JOIN subjects 
                    ON subjects.id = cbse_exam_group_class_batch_exam_subjects.subject_id 
                WHERE cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id IN ($exam_ids_str)
                  AND ($student_ids_condition)
                ORDER BY students.id ASC, cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id ASC, cbse_exam_group_class_batch_exam_subjects.subject_id ASC";
    
        // Execute query and get result
        $query = $this->db->query($sql);
        $rows = $query->result_array();
        // print_r($this->db->last_query()); die(); // Debugging SQL query
    
        // Organize the results into structured data
        $results = [];
    
        foreach ($rows as $row) {
            $student_id = $row['student_id'];
            $exam_id = $row['exam_id']; // Exam ID to group results
            $subject_name = $row['subject_name'];
            $marks = $row['get_marks'];
            $term_marks = $row['term_marks'];
            $max_marks = $row['max_marks'];
            $teacher_remark = $row['teacher_remark'];
            
            $min_marks = $row['min_marks'];
            $assessment_type_marks = $row['assessment_type_marks'];
            $previous_exammarks = $row['previous_exammarks'];
            $attendance = $row['attendence'];
    
            // Initialize student structure if it doesn't exist
            if (!isset($results[$student_id])) {
                $results[$student_id] = [
                    'name' => $row['firstname'] . ' ' . ($row['middlename'] ? $row['middlename'] . ' ' : '') . $row['lastname'],
                    'class' => $row['class'],
                    'section' => $row['section'],
                    'dob' => $row['dob'],
                    'admission_no' => $row['admission_no'],
                    'exams' => [],
                    'unique_subjects' => [],
                    'exam_roll_no' => $row['roll_no'],
                ];
            }
    
            // Initialize exam structure if it doesn't exist for the student
            if (!isset($results[$student_id]['exams'][$exam_id])) {
                $results[$student_id]['exams'][$exam_id] = [
                    'exam_id' => $exam_id,
                    'subjects' => [],
                    'teacher_remark' => $teacher_remark, // Add teacher's remark to exam level
                ];
            }
    
            if (!isset($results[$student_id]['unique_subjects'][$subject_name])) {
                $results[$student_id]['unique_subjects'][$subject_name] = [
                    'subject_name' => $subject_name,
                    'subject_max_marks' => $max_marks,
                    'subject_min_marks' => $min_marks
                ];
            }
    
            // Add subject marks for the current exam and student
            $results[$student_id]['exams'][$exam_id]['subjects'][$subject_name] = [
                'marks' => $marks,
                'term_marks' => $term_marks,
                'max_marks' => $max_marks,
                'subject_name' => $subject_name,
                'assessment_type_marks' => $assessment_type_marks,
                'previous_exammarks' => $previous_exammarks,
                'attendance' => $attendance
            ];
        }
    
        return $results;
    }







   

    public function getStudentExamResults($exam_id, $post_exam_group_id, $exam_group_class_batch_exam_student_id, $student_id) {

        $result = array('exam_connection' => 0, 'result' => array(), 'exams' => array(), 'exam_connection_list' => array());
        $exam_connection = false;
        $exam_connections = $this->examgroup_model->getExamGroupConnectionList($post_exam_group_id);
        if (!empty($exam_connections)) {
            $lastkey = key(array_slice($exam_connections, -1, 1, true));
            if ($exam_connections[$lastkey]->exam_group_class_batch_exams_id == $exam_id) {
                $exam_connection = true;
                $result['exam_connection'] = 1;
            }
        }
        $result['exam_connection_list'] = $exam_connections;
        if ($exam_connection) {
            $new_array = array(); 
			
            foreach ($exam_connections as $exam_connection_key => $exam_connection_value) {

                $exam_group_class_batch_exam_student = $this->examstudent_model->getStudentByExamAndStudentID($student_id, $exam_connection_value->exam_group_class_batch_exams_id);
				
                $exam = $this->examgroup_model->getExamByID($exam_connection_value->exam_group_class_batch_exams_id);
				if(!empty($exam_group_class_batch_exam_student->id)){
                $result['exam_result']['exam_result_' . $exam_connection_value->exam_group_class_batch_exams_id] 
				= $this->getStudentResultByExam($exam_connection_value->exam_group_class_batch_exams_id, $exam_group_class_batch_exam_student->id);
				}
                $result['exams']['exam_' . $exam_connection_value->exam_group_class_batch_exams_id] = $exam;
            }

        } else {

            $result['exam_connection_list'] = $exam_connections;

            $result['result'] = $this->getStudentResultByExam($exam_id, $exam_group_class_batch_exam_student_id);
        }

        return $result;
    }

}
