<?php



if (!defined('BASEPATH')) {

    exit('No direct script access allowed');

}



class Cbse_examgroupstudent_model extends CI_Model {



    public function __construct() {

        parent::__construct();

        $this->current_session = $this->setting_model->getCurrentSession();

    }



    public function searchExamGroupStudentAttempted1($exam_group_id, $class_id, $batch_id) {

        $sql = "select IFNULL(exam_group_students.id, 0) as `exam_group_student_id`,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname, students.middlename, students.lastname,students.image,    students.mobileno, students.email ,students.state ,   students.city , students.pincode ,     students.religion,students.dob ,students.current_address,    students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`,   students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,`classes`.`class`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,students.batch_id,batch.name,student_session.* from student_session INNER join students on students.id=student_session.student_id JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` inner join batch on students.batch_id=batch.id INNER JOIN exam_group_students on exam_group_students.exam_group_id=" . $this->db->escape($exam_group_id) . " and exam_group_students.student_id =students.id WHERE student_session.class_id=" . $this->db->escape($class_id) . " and students.batch_id=" . $this->db->escape($batch_id) . " GROUP BY students.id ORDER BY students.id asc";

        $query = $this->db->query($sql);

        return $query->result_array();

    }



   



    public function searchExamGroupStudentAttempted($exam_group_id, $exam_id, $class_id, $section_id, $session_id) {

        $sql = "select IFNULL(exam_group_students.id, 0) as `exam_group_student_id`,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,`classes`.`class`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,student_session.* from student_session INNER join students on students.id=student_session.student_id and student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_ids=" . $this->db->escape($section_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` INNER JOIN exam_group_students on exam_group_students.exam_group_id=" . $this->db->escape($exam_group_id) . " and exam_group_students.student_id =students.id ORDER BY students.id asc";

        $query = $this->db->query($sql);

        return $query->result_array();

    }



    public function searchExamStudentsByExam($exam_id) {

        $sql = "SELECT  cbse_exam_group_class_batch_exam_students.id as `exam_group_class_batch_exam_student_id`,cbse_exam_group_class_batch_exam_students.roll_no as `exam_roll_no`,cbse_exam_group_class_batch_exam_students.teacher_remark,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,students.guardian_email,`classes`.`class`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,`students`.`app_key`,`students`.`parent_app_key` FROM `cbse_exam_group_class_batch_exam_students` INNER JOIN student_session on student_session.id=cbse_exam_group_class_batch_exam_students.student_session_id INNER join students on students.id=student_session.student_id  INNER JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` WHERE exam_group_class_batch_exam_id=" . $this->db->escape($exam_id) . " AND students.is_active='yes'";



        $query = $this->db->query($sql);



        return $query->result();

    }



    



    public function searchExamStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id) {

        // if (!empty($section_id)) {

        //     $section_ids = implode(',', $section_id);

        // }

        if(is_array($exam_id) && !empty($exam_id)){

            $sql = "SELECT  cbse_exam_group_class_batch_exam_students.id as `exam_group_class_batch_exam_student_id`,cbse_exam_group_class_batch_exam_students.roll_no as `exam_roll_no`,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,`classes`.`class`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,`student_session`.`section_id` FROM `cbse_exam_group_class_batch_exam_students` INNER JOIN student_session on student_session.id=cbse_exam_group_class_batch_exam_students.student_session_id INNER join students on students.id=student_session.student_id  INNER JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` WHERE exam_group_class_batch_exam_id IN(" . implode(',',$exam_id) . ") AND students.is_active='yes' AND student_session.class_id=" . $this->db->escape($class_id) . " AND student_session.section_id =". $this->db->escape($section_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " ORDER BY `students`.`gender` ASC, students.firstname ASC ";

        }

        else{

            $sql = "SELECT  cbse_exam_group_class_batch_exam_students.id as `exam_group_class_batch_exam_student_id`,cbse_exam_group_class_batch_exam_students.roll_no as `exam_roll_no`,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,`classes`.`class`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,`student_session`.`section_id` FROM `cbse_exam_group_class_batch_exam_students` INNER JOIN student_session on student_session.id=cbse_exam_group_class_batch_exam_students.student_session_id INNER join students on students.id=student_session.student_id  INNER JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` WHERE exam_group_class_batch_exam_id=" . $this->db->escape($exam_id) . " AND students.is_active='yes' AND student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_id=" . $this->db->escape($section_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " ORDER BY `students`.`gender` ASC, students.firstname ASC ";

        }

        

        $query = $this->db->query($sql);



        return $query->result();

    }





    public function getAssessments($exam_subject_id, $class_id, $section_id, $session_id,$from_date,$to_date)

{

    $this->db->select('

        assessment_types.type as assessment_type,

        assessment_types.id as assessment_type_id,

        assessment_types.term_exam_out_of_marks,

        assessment_types.assessment_max_marks,

        assessment_results.student_id,

        AVG(assessment_results.get_marks) as avg_marks

    ');

    $this->db->from('assessments');

    $this->db->join('assessment_types', 'assessments.assessment_type_id = assessment_types.id', 'left');

    $this->db->join('assessment_results', 'assessment_results.assessment_id = assessments.id');

    $this->db->where('assessments.class_id', $class_id);

    $this->db->where('assessments.section_id', $section_id);

    $this->db->where('assessments.session_id', $session_id);

    $this->db->group_start(); // Start grouping conditions

    $this->db->where('assessment_results.month >=', $from_date); // October to December

    $this->db->or_where('assessment_results.month <=', $to_date); // January to March

    $this->db->group_end(); // End grouping conditions

    $this->db->where('assessments.subject_id', $exam_subject_id);

    $this->db->group_by(['assessment_results.student_id', 'assessment_types.id']);

    $query = $this->db->get();

    

    return $query->result_array();





}









    







    // public function searchExamsStudents($exam_group_id, $exam_id, $class_id, $section_id, $session_id) {

    //     if(is_array($exam_id) && !empty($exam_id)){

    //         $sql = "SELECT  cbse_exam_group_class_batch_exam_students.id as `exam_group_class_batch_exam_student_id`,cbse_exam_group_class_batch_exam_students.roll_no as `exam_roll_no`,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,`classes`.`class`,`sections`.`section`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,`student_session`.`section_id` FROM `cbse_exam_group_class_batch_exam_students` INNER JOIN student_session on student_session.id=cbse_exam_group_class_batch_exam_students.student_session_id INNER join students on students.id=student_session.student_id  INNER JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` INNER JOIN `sections` ON `student_session`.`section_id` = `sections`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` WHERE exam_group_class_batch_exam_id IN(" . implode(',',$exam_id) . ") AND students.is_active='yes' AND student_session.class_id=" . $this->db->escape($class_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " ORDER BY `students`.`gender` ASC, students.firstname ASC ";

    //     }

    //     else{

    //         $sql = "SELECT  cbse_exam_group_class_batch_exam_students.id as `exam_group_class_batch_exam_student_id`,cbse_exam_group_class_batch_exam_students.roll_no as `exam_roll_no`,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,`classes`.`class`,`sections`.`section`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,`student_session`.`section_id` FROM `cbse_exam_group_class_batch_exam_students` INNER JOIN student_session on student_session.id=cbse_exam_group_class_batch_exam_students.student_session_id INNER join students on students.id=student_session.student_id  INNER JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` INNER JOIN `sections` ON `student_session`.`section_id` = `sections`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` WHERE exam_group_class_batch_exam_id=" . $this->db->escape($exam_id) . " AND students.is_active='yes' AND student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_id=" . $this->db->escape($section_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " ORDER BY `students`.`gender` ASC, students.firstname ASC ";

    //     }

        

    //     $query = $this->db->query($sql);



    //     return $query->result();



    // }





    public function searchExamsStudents($exam_group_id, $exam_ids, $class_id, $section_id = null, $session_id) {

    // Check if $exam_ids is a valid, non-empty array

    if (empty($exam_ids) || !is_array($exam_ids)) {

        return []; // Return an empty array if no valid exam IDs are provided

    }



    $this->db->select([

        'cbse_exam_group_class_batch_exam_students.id as exam_group_class_batch_exam_student_id',

        'cbse_exam_group_class_batch_exam_students.roll_no as exam_roll_no',

        'students.admission_no',

        'students.id as student_id',

        'students.roll_no',

        'students.admission_date',

        'students.firstname',

        'students.middlename',

        'students.lastname',

        'students.image',

        'students.mobileno',

        'students.email',

        'students.state',

        'students.city',

        'students.pincode',

        'students.religion',

        'students.dob',

        'students.current_address',

        'students.permanent_address',

        'students.category_id',

        'IFNULL(categories.category, "") as category',

        'students.adhar_no',

        'students.samagra_id',

        'students.bank_account_no',

        'students.bank_name',

        'students.ifsc_code',

        'students.guardian_name',

        'students.guardian_relation',

        'students.guardian_phone',

        '`classes`.class',

        '`sections`.section',

        'students.guardian_address',

        'students.is_active',

        'students.father_name',

        'students.gender',

        'student_session.section_id'

    ]);



    $this->db->from('cbse_exam_group_class_batch_exam_students');

    $this->db->join('student_session', 'student_session.id = cbse_exam_group_class_batch_exam_students.student_session_id');

    $this->db->join('students', 'students.id = student_session.student_id');

    $this->db->join('classes', 'student_session.class_id = classes.id');

    $this->db->join('sections', 'student_session.section_id = sections.id');

    $this->db->join('categories', 'students.category_id = categories.id', 'left');



    // Add WHERE conditions

    $this->db->where_in('cbse_exam_group_class_batch_exam_students.exam_group_class_batch_exam_id', $exam_ids);

    $this->db->where('students.is_active', 'yes');

    $this->db->where('student_session.class_id', $class_id);

    $this->db->where('student_session.session_id', $session_id);



    // Add optional filter for section_id

    if ($section_id) {

        $this->db->where('student_session.section_id', $section_id);

    }



    // Add ORDER BY clause

    $this->db->order_by('students.gender', 'ASC');

    $this->db->order_by('students.firstname', 'ASC');



    // Execute query

    $query = $this->db->get();



    return $query->result();

}







    public function searchExamGroupStudents($exam_group_id, $class_id, $section_id, $session_id) {

        $sql = "select IFNULL(exam_group_students.id, 0) as `exam_group_student_id`,students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,`classes`.`class`,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,student_session.* from student_session INNER join students on students.id=student_session.student_id and student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_id=" . $this->db->escape($section_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " JOIN `classes` ON `student_session`.`class_id` = `classes`.`id` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` LEFT JOIN exam_group_students on exam_group_students.exam_group_id=" . $this->db->escape($exam_group_id) . " and exam_group_students.student_id =students.id ORDER BY students.id asc";

        $query = $this->db->query($sql);

        return $query->result_array();

    }



    public function add($data_insert, $data_delete, $exam_group_id) {



        $this->db->trans_begin();



        if (!empty($data_insert)) {



            foreach ($data_insert as $student_key => $student_value) {

                $this->db->where('exam_group_id', $student_value['exam_group_id']);

                $this->db->where('student_id', $student_value['student_id']);

                $q = $this->db->get('exam_group_students');



                if ($q->num_rows() == 0) {



                    $this->db->insert('exam_group_students', $data_insert[$student_key]);

                }

            }

        }

        if (!empty($data_delete)) {



            $this->db->where('exam_group_id', $exam_group_id);

            $this->db->where_in('student_id', $data_delete);

            $this->db->delete('exam_group_students');

        }



        if ($this->db->trans_status() === false) {

            $this->db->trans_rollback();

            return false;

        } else {

            $this->db->trans_commit();

            return true;

        }

    }



    public function examGroupSubjectResult($exam_subject_id, $class_id, $section_id, $session_id) {

        $sql = "SELECT IFNULL(cbse_exam_group_exam_results.id, 0) as exam_group_exam_result_id,IFNULL(cbse_exam_group_exam_results.attendence,'') as `exam_group_exam_result_attendance`,IFNULL(cbse_exam_group_exam_results.get_marks,'') as `exam_group_exam_result_get_marks`,IFNULL(cbse_exam_group_exam_results.term_marks,'') as `exam_group_exam_result_term_marks`, IFNULL(cbse_exam_group_exam_results.get_grade,'') as `exam_group_exam_result_get_grade` ,IFNULL(cbse_exam_group_exam_results.note,'') as `exam_group_exam_result_note`,cbse_exam_group_class_batch_exam_students.id as `exam_group_class_batch_exam_students_id`,cbse_exam_group_class_batch_exam_students.roll_no as `exam_roll_no`,cbse_exam_group_exam_results.assessment_type_marks as `exam_group_exam_assessment_type_marks`,cbse_exam_group_class_batch_exam_students.exam_seat_no,cbse_exam_group_class_batch_exam_subjects.*,subjects.name,subjects.code,subjects.type,students.admission_no , students.roll_no,students.id as `student_id`, students.roll_no,students.admission_date,students.firstname,students.middlename, students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender`,cbse_exam_group_class_batch_exams.use_exam_roll_no FROM `cbse_exam_group_class_batch_exam_subjects` INNER JOIN cbse_exam_group_class_batch_exams on cbse_exam_group_class_batch_exams.id=cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id INNER JOIN subjects on subjects.id=cbse_exam_group_class_batch_exam_subjects.subject_id INNER JOIN cbse_exam_group_class_batch_exam_students on cbse_exam_group_class_batch_exam_students.exam_group_class_batch_exam_id=cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id INNER join student_session on student_session.id=cbse_exam_group_class_batch_exam_students.student_session_id LEFT join cbse_exam_group_exam_results on cbse_exam_group_exam_results.exam_group_class_batch_exam_subject_id=cbse_exam_group_class_batch_exam_subjects.id and cbse_exam_group_exam_results.exam_group_class_batch_exam_student_id=cbse_exam_group_class_batch_exam_students.id  INNER JOIN students on students.id=student_session.student_id LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id`  WHERE students.is_active='yes' AND cbse_exam_group_class_batch_exam_subjects.id=" . $this->db->escape($exam_subject_id) . " and  student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_id=" . $this->db->escape($section_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " ORDER BY `students`.`gender` ASC, students.firstname ASC";



        $query = $this->db->query($sql);

        return $query->result_array();

    }



    



//     public function getPreviousExamMarks($exam_subject_id, $class_id, $section_id, $session_id) {

//     $sql = "SELECT 

//                 cbse_exam_group_class_batch_exams.exam AS previous_exam_name,cbse_exam_group_class_batch_exam_subjects.max_marks AS previous_exam_max_marks,cbse_exam_group_class_batch_exams.id AS previous_exam_id,

//                 IFNULL(cbse_exam_group_exam_results.get_marks, '') AS previous_exam_marks,

//                 students.id AS student_id,

//                 students.firstname, students.middlename, students.lastname,

//                 students.roll_no

//             FROM cbse_exam_group_class_batch_exam_subjects

//             INNER JOIN cbse_exam_group_class_batch_exams 

//                 ON cbse_exam_group_class_batch_exams.id = cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id

//             INNER JOIN cbse_exam_group_class_batch_exam_students 

//                 ON cbse_exam_group_class_batch_exam_students.exam_group_class_batch_exam_id = cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id

//             INNER JOIN student_session 

//                 ON student_session.id = cbse_exam_group_class_batch_exam_students.student_session_id

//             LEFT JOIN cbse_exam_group_exam_results 

//                 ON cbse_exam_group_exam_results.exam_group_class_batch_exam_subject_id = cbse_exam_group_class_batch_exam_subjects.id 

//                 AND cbse_exam_group_exam_results.exam_group_class_batch_exam_student_id = cbse_exam_group_class_batch_exam_students.id

//             INNER JOIN students 

//                 ON students.id = student_session.student_id

//             WHERE students.is_active = 'yes'

//                 AND cbse_exam_group_class_batch_exam_subjects.id = (

//                     SELECT id FROM cbse_exam_group_class_batch_exam_subjects

//                     WHERE subject_id = (

//                         SELECT subject_id FROM cbse_exam_group_class_batch_exam_subjects WHERE id = " . $this->db->escape($exam_subject_id) . "

//                     )

//                     AND id < " . $this->db->escape($exam_subject_id) . "

//                     ORDER BY id DESC LIMIT 1

//                 )

//                 AND student_session.class_id = " . $this->db->escape($class_id) . "

//                 AND student_session.section_id = " . $this->db->escape($section_id) . "

//                 AND student_session.session_id = " . $this->db->escape($session_id) . "

//             ORDER BY students.firstname ASC";



//     $query = $this->db->query($sql);

//     return $query->result_array();

// }



    public function getPreviousExamMarks($exam_subject_id, $class_id, $section_id, $session_id)

    {

        $sql = "

            SELECT 

                ex.exam AS previous_exam_name,

                sub.max_marks AS previous_exam_max_marks,

                ex.id AS previous_exam_id,

                IFNULL(res.get_marks, '') AS previous_exam_marks,

                stu.id AS student_id,

                stu.firstname, stu.middlename, stu.lastname,

                stu.roll_no

            FROM cbse_exam_group_class_batch_exam_subjects AS sub

            INNER JOIN cbse_exam_group_class_batch_exams AS ex 

                ON ex.id = sub.exam_group_class_batch_exams_id

            INNER JOIN cbse_exam_group_class_batch_exam_students AS stu_exam

                ON stu_exam.exam_group_class_batch_exam_id = sub.exam_group_class_batch_exams_id

            INNER JOIN student_session AS ss

                ON ss.id = stu_exam.student_session_id

            LEFT JOIN cbse_exam_group_exam_results AS res

                ON res.exam_group_class_batch_exam_subject_id = sub.id 

                AND res.exam_group_class_batch_exam_student_id = stu_exam.id

            INNER JOIN students AS stu 

                ON stu.id = ss.student_id

            WHERE stu.is_active = 'yes'

              AND sub.id = (

                  SELECT sub2.id

                  FROM cbse_exam_group_class_batch_exam_subjects AS sub2

                  INNER JOIN cbse_exam_group_class_batch_exams AS ex2 

                      ON ex2.id = sub2.exam_group_class_batch_exams_id

                  WHERE sub2.subject_id = (

                          SELECT subject_id 

                          FROM cbse_exam_group_class_batch_exam_subjects 

                          WHERE id = " . $this->db->escape($exam_subject_id) . "

                      )

                    AND ex2.exam_group_id = (

                          SELECT ex3.exam_group_id

                          FROM cbse_exam_group_class_batch_exams AS ex3

                          INNER JOIN cbse_exam_group_class_batch_exam_subjects AS sub3 

                              ON sub3.exam_group_class_batch_exams_id = ex3.id

                          WHERE sub3.id = " . $this->db->escape($exam_subject_id) . "

                      )

                    AND ex2.is_termexam = 0

                  ORDER BY ex2.id ASC

                  LIMIT 1

              )

              AND ss.class_id = " . $this->db->escape($class_id) . "

              AND ss.section_id = " . $this->db->escape($section_id) . "

              AND ss.session_id = " . $this->db->escape($session_id) . "

            ORDER BY stu.firstname ASC

        ";

    

        // Debugging aid: Uncomment this to check the generated SQL

        // echo $sql; die;

    

        $query = $this->db->query($sql);

        return $query->result_array();

    }





    public function getavgPreviousExamMarks($exam_subject_id, $class_id, $section_id, $session_id) {

        $sql = "SELECT 

                    students.id AS student_id,

                    students.firstname, students.middlename, students.lastname,

                    students.roll_no,

                    ROUND(AVG(IFNULL(cbse_exam_group_exam_results.get_marks, 0)), 2) AS previous_exam_marks,

                    GROUP_CONCAT(cbse_exam_group_class_batch_exams.exam ORDER BY cbse_exam_group_class_batch_exams.id) AS previous_exam_names,

                    GROUP_CONCAT(cbse_exam_group_class_batch_exam_subjects.max_marks ORDER BY cbse_exam_group_class_batch_exam_subjects.id) AS previous_exam_max_marks

                FROM cbse_exam_group_class_batch_exam_subjects

                INNER JOIN cbse_exam_group_class_batch_exams 

                    ON cbse_exam_group_class_batch_exams.id = cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id

                INNER JOIN cbse_exam_group_class_batch_exam_students 

                    ON cbse_exam_group_class_batch_exam_students.exam_group_class_batch_exam_id = cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id

                INNER JOIN student_session 

                    ON student_session.id = cbse_exam_group_class_batch_exam_students.student_session_id

                LEFT JOIN cbse_exam_group_exam_results 

                    ON cbse_exam_group_exam_results.exam_group_class_batch_exam_subject_id = cbse_exam_group_class_batch_exam_subjects.id 

                    AND cbse_exam_group_exam_results.exam_group_class_batch_exam_student_id = cbse_exam_group_class_batch_exam_students.id

                INNER JOIN students 

                    ON students.id = student_session.student_id

                WHERE students.is_active = 'yes'

                    -- restrict to the same exam_group as current exam_subject_id

                    AND cbse_exam_group_class_batch_exams.exam_group_id = (

                        SELECT cbse_exam_group_class_batch_exams.exam_group_id

                        FROM cbse_exam_group_class_batch_exam_subjects 

                        INNER JOIN cbse_exam_group_class_batch_exams 

                            ON cbse_exam_group_class_batch_exams.id = cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id

                        WHERE cbse_exam_group_class_batch_exam_subjects.id = " . $this->db->escape($exam_subject_id) . "

                    )

                    -- same subject only

                    AND cbse_exam_group_class_batch_exam_subjects.subject_id = (

                        SELECT subject_id FROM cbse_exam_group_class_batch_exam_subjects 

                        WHERE id = " . $this->db->escape($exam_subject_id) . "

                    )

                    -- exclude term exams

                    AND cbse_exam_group_class_batch_exams.is_termexam != 'yes'

                    -- filter by class/section/session

                    AND student_session.class_id = " . $this->db->escape($class_id) . "

                    AND student_session.section_id = " . $this->db->escape($section_id) . "

                    AND student_session.session_id = " . $this->db->escape($session_id) . "

                GROUP BY students.id

                ORDER BY students.firstname ASC";

    

        $query = $this->db->query($sql);

        return $query->result_array();

    }







        public function getLastExamId($exam_group_id)

    {

        $this->db->select('id');

        $this->db->from('cbse_exam_group_class_batch_exams');

        $this->db->where('exam_group_id', $exam_group_id);

        $this->db->order_by('id', 'DESC');

        $this->db->limit(1);

        $query = $this->db->get();

        $row = $query->row();

        return $row ? $row->id : null;

    }



    public function add_result($insert_array) {



        $this->db->trans_start(); # Starting Transaction

        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well



        if (!empty($insert_array)) {

            foreach ($insert_array as $student_key => $student_value) {



                $student_value['exam_group_class_batch_exam_subject_id'];

                $student_value['exam_group_class_batch_exam_student_id'];



                $this->db->where('exam_group_class_batch_exam_subject_id', $student_value['exam_group_class_batch_exam_subject_id']);

                $this->db->where('exam_group_class_batch_exam_student_id', $student_value['exam_group_class_batch_exam_student_id']);

                $q = $this->db->get('cbse_exam_group_exam_results');



                if ($q->num_rows() > 0) {

                    $update_result = $q->row();

                    $this->db->where('id', $update_result->id);

                    $this->db->update('cbse_exam_group_exam_results', $student_value);

                } else {



                    $this->db->insert('cbse_exam_group_exam_results', $student_value);

                }

            }

        }



        $this->db->trans_complete(); # Completing transaction



        /* Optional */



        if ($this->db->trans_status() === false) {

            # Something went wrong.

            $this->db->trans_rollback();

            return false;

        } else {

            # Everything is Perfect.

            # Committing data to the database.

            $this->db->trans_commit();

            return true;

        }

    }





   

    public function searchStudentByClassSectionSession($class_id, $section_id, $session_id) {

        $sql = "SELECT students.admission_no , students.id as `student_id`, students.roll_no,students.admission_date,students.firstname, students.middlename,students.lastname,students.image, students.mobileno, students.email ,students.state , students.city , students.pincode , students.religion,students.dob ,students.current_address, students.permanent_address,students.category_id, IFNULL(categories.category, '') as `category`, students.adhar_no,students.samagra_id,students.bank_account_no,students.bank_name, students.ifsc_code , students.guardian_name, students.guardian_relation,students.guardian_phone,students.guardian_address,students.is_active,`students`.`father_name`,`students`.`gender` FROM `students` LEFT JOIN `categories` ON `students`.`category_id` = `categories`.`id` INNER join student_session on students.id=student_session.student_id and student_session.class_id=" . $this->db->escape($class_id) . " and student_session.section_id=" . $this->db->escape($section_id) . " and student_session.session_id=" . $this->db->escape($session_id) . " ORDER BY students.id asc";



        $query = $this->db->query($sql);

        return $query->result_array();

    }



    public function searchStudentExams($student_session_id, $is_active = false, $is_publish = false) {

        $inner_sql = "";

        if ($is_active) {

            $inner_sql = "and cbse_exam_group_class_batch_exams.is_active=1 ";

        }

        if ($is_publish) {

            $inner_sql .= "and cbse_exam_group_class_batch_exams.is_publish=1 ";

        }

        $sql = "SELECT cbse_exam_group_class_batch_exam_students.*,cbse_exam_group_class_batch_exams.exam_group_id,cbse_exam_group_class_batch_exams.exam,cbse_exam_group_class_batch_exams.date_from,cbse_exam_group_class_batch_exams.date_to,cbse_exam_group_class_batch_exams.description,exam_groups.name,exam_groups.exam_type FROM `cbse_exam_group_class_batch_exam_students` INNER JOIN cbse_exam_group_class_batch_exams on cbse_exam_group_class_batch_exams.id=cbse_exam_group_class_batch_exam_students.exam_group_class_batch_exam_id  INNER JOIN exam_groups on exam_groups.id=cbse_exam_group_class_batch_exams.exam_group_id WHERE student_session_id=" . $this->db->escape($student_session_id) . $inner_sql . " ORDER BY id asc";





        $query = $this->db->query($sql);

        $student_exam = $query->result();



        if (!empty($student_exam)) {

            foreach ($student_exam as $student_exam_key => $student_exam_value) {

                $student_exam_value->exam_result = $this->examresult_model->getStudentExamResults($student_exam_value->exam_group_class_batch_exam_id, $student_exam_value->exam_group_id, $student_exam_value->id, $student_exam_value->student_id);

            }

        }

        return $student_exam;

    }



    public function studentExams($student_session_id) {

        $sql = "SELECT cbse_exam_group_class_batch_exam_students.*,cbse_exam_group_class_batch_exams.id as `exam_group_class_batch_exam_id`,cbse_exam_group_class_batch_exams.exam FROM `cbse_exam_group_class_batch_exam_students` INNER JOIN cbse_exam_group_class_batch_exams on cbse_exam_group_class_batch_exam_students.exam_group_class_batch_exam_id=cbse_exam_group_class_batch_exams.id WHERE student_session_id=" . $this->db->escape($student_session_id) . " and cbse_exam_group_class_batch_exams.is_active=1";



        $query = $this->db->query($sql);

        $student_exam = $query->result();

        return $student_exam;

    }

    public function updateExamStudent($data){

        $this->db->update_batch('cbse_exam_group_class_batch_exam_students', $data, 'id');

    }



    



}

