<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Cbse_examgroup_model extends MY_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * This funtion takes id as a parameter and will fetch the record.
     * If id is not provided, then it will fetch all the records form the table.
     * @param int $id
     * @return mixed
     */
    public function get($id = null) {

        $this->db->select('cbse_exam_groups.*,(select count(*) from cbse_exam_group_class_batch_exams WHERE cbse_exam_group_class_batch_exams.exam_group_id=cbse_exam_groups.id) as `counter`')->from('cbse_exam_groups');
        if ($id != null) {
            $this->db->where('id', $id);
        } else {
            $this->db->order_by('id');
        }
        $query = $this->db->get();
        if ($id != null) {
            return $query->row();
        } else {
            return $query->result();
        }
    }


    

    public function add_result($insert_array) {

        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well

        if (!empty($insert_array)) {
            foreach ($insert_array as $student_key => $student_value) {

                $student_value['assessment_id'];
                $student_value['student_id'];

                $this->db->where('assessment_id', $student_value['assessment_id']);
                $this->db->where('student_id', $student_value['student_id']);
                $this->db->where('month', $student_value['month']);
                $q = $this->db->get('assessment_results');

                if ($q->num_rows() > 0) {
                    $update_result = $q->row();
                    $this->db->where('id', $update_result->id);
                    $this->db->update('assessment_results', $student_value);
                } else {

                    $this->db->insert('assessment_results', $student_value);
                }
            }
        }

        $this->db->trans_complete(); # Completing transaction

        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            # Everything is Perfect.
            # Committing data to the database.
            $this->db->trans_commit();
            return true;
        }
    }

    public function getExamByID($id = null) {

        $sql = "SELECT cbse_exam_groups.name as `exam_group_name`,cbse_exam_groups.exam_type as `exam_group_type`,cbse_exam_groups.id as `exam_group_id`,cbse_exam_group_class_batch_exams.*,sessions.session FROM `cbse_exam_group_class_batch_exams` INNER JOIN cbse_exam_groups on cbse_exam_groups.id= cbse_exam_group_class_batch_exams.exam_group_id INNER JOIN sessions on sessions.id = cbse_exam_group_class_batch_exams.session_id WHERE cbse_exam_group_class_batch_exams.id=" . $this->db->escape($id);
        // $this->db->select('cbse_exam_group_class_batch_exams.*')->from('cbse_exam_group_class_batch_exams');
        $query = $this->db->query($sql);

        return $query->row();
    }

    




    /**
     * This function will delete the record based on the id
     * @param $id
     */
    public function remove($id) {
        $this->db->trans_begin();
        $this->db->where('id', $id);
        $this->db->delete('cbse_exam_groups'); //class record delete.
        $message = DELETE_RECORD_CONSTANT . " On exam groups id " . $id;
        $action = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return true;
    }

    
        public function getExamCount($session_id, $exam_group_id)
    {
        $this->db->where('session_id', $session_id);
        $this->db->where('exam_group_id', $exam_group_id);
        return $this->db->count_all_results('mh_cbse_exam_group_class_batch_exams');
    }


    /**
     * This function will take the post data passed from the controller
     * If id is present, then it will do an update
     * else an insert. One function doing both add and edit.
     * @param $data
     */
    public function add($data) {
        $this->db->trans_start(); # Starting Transaction
        $this->db->trans_strict(false); # See Note 01. If you wish can remove as well
        //=======================Code Start===========================
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('cbse_exam_groups', $data);
            $message = UPDATE_RECORD_CONSTANT . " On  exam groups id " . $data['id'];
            $action = "Update";
            $record_id = $data['id'];
            $this->log($message, $record_id, $action);
        } else {
            $this->db->insert('cbse_exam_groups', $data);
            $id = $this->db->insert_id();
            $message = INSERT_RECORD_CONSTANT . " On exam groups id " . $id;
            $action = "Insert";
            $record_id = $id;
            $this->log($message, $record_id, $action);
        }

        //======================Code End==============================
        $this->db->trans_complete(); # Completing transaction
        /* Optional */

        if ($this->db->trans_status() === false) {
            # Something went wrong.
            $this->db->trans_rollback();
            return false;
        } else {
            //return $return_value;
        }
    }

    

    public function delete_exam($id) {
        $this->db->trans_start();
        $this->db->where('id', $id);
        $this->db->delete('cbse_exam_group_class_batch_exams');
        $message = DELETE_RECORD_CONSTANT . " On exam groups exams name id " . $id;
        $action = "Delete";
        $record_id = $id;
        $this->log($message, $record_id, $action);
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            return false;
        } else {
            return true;
        }
    }


    

    public function add_exam($data) {
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('cbse_exam_group_class_batch_exams', $data);
            $message = UPDATE_RECORD_CONSTANT . " On cbse exam group exams name id " . $data['id'];
            $action = "Update";
            $record_id = $data['id'];
            $this->log($message, $record_id, $action);
        } else {
            $this->db->trans_start(); # Starting Transaction
            $this->db->trans_strict(false); # See Note 01. If you wish can remove as well

            $exam_group = $this->examgroup_model->get($data['exam_group_id']);
            $this->db->insert('cbse_exam_group_class_batch_exams', $data);
            $insert_id = $this->db->insert_id();
            $message = INSERT_RECORD_CONSTANT . " On exam group exams name id " . $insert_id;
            $action = "Insert";
            $record_id = $insert_id;
            $this->log($message, $record_id, $action);
            // if ($exam_group->exam_type != "coll_grade_system") {
            //     $batch_subjects = $this->batchsubject_model->getClassBatchSubjects($data['class_batch_id']);
            //     if (!empty($batch_subjects)) {
            //         $exam_subjects = array();
            //         foreach ($batch_subjects as $batch_subject_key => $batch_subject_value) {
            //             $exam_subjects[] = array(
            //                 'cbse_exam_group_class_batch_exams_id' => $insert_id,
            //                 'class_batch_subject_id'          => $batch_subject_value->id,
            //             );
            //         }
            //         if (!empty($exam_subjects)) {
            //             $this->db->insert_batch('cbse_exam_group_class_batch_exam_subjects', $exam_subjects);
            //         }
            //     }
            // }
            $this->db->trans_complete(); # Completing transaction

            /* Optional */

            if ($this->db->trans_status() === false) {
                # Something went wrong.
                $this->db->trans_rollback();
                return false;
            } else {
                # Everything is Perfect.
                # Committing data to the database.
                $this->db->trans_commit();
                return $record_id;
            }
        }
    }


   


    public function assessmentSubjectResult($assessment_id, $class_id, $section_id, $month) {
    $this->db->select("IFNULL(assessment_results.id, 0) AS assessment_result_id,
                       IFNULL(assessment_results.attendance, '') AS assessment_result_attendance,
                       IFNULL(assessment_results.get_marks, '') AS assessment_result_get_marks,
                       assessments.*, 
                       subjects.name, 
                       subjects.code, 
                       subjects.type, 
                       students.admission_no, 
                       students.roll_no, 
                       students.id AS student_id, 
                       students.admission_date, 
                       students.firstname, 
                       students.middlename, 
                       students.lastname, 
                       students.image, 
                       students.mobileno, 
                       students.email, 
                       students.state, 
                       students.city, 
                       students.pincode, 
                       students.religion, 
                       students.dob, 
                       students.current_address, 
                       students.permanent_address, 
                       students.category_id, 
                       IFNULL(categories.category, '') AS category, 
                       students.adhar_no, 
                       students.samagra_id, 
                       students.bank_account_no, 
                       students.bank_name, 
                       students.ifsc_code, 
                       students.guardian_name, 
                       students.guardian_relation, 
                       students.guardian_phone, 
                       students.guardian_address, 
                       students.is_active, 
                       students.father_name, 
                       students.gender");

    $this->db->from('assessments');
    $this->db->join('subjects', 'assessments.subject_id = subjects.id');
    $this->db->join('student_session', 'student_session.class_id = ' . $this->db->escape($class_id) . ' AND student_session.section_id = ' . $this->db->escape($section_id));
    $this->db->join('students', 'student_session.student_id = students.id');
    $this->db->join('assessment_results', 'assessments.id = assessment_results.assessment_id AND assessment_results.student_id = students.id AND assessment_results.month = ' . $this->db->escape($month), 'left'); // Corrected LEFT JOIN
    $this->db->join('categories', 'students.category_id = categories.id', 'left');
    $this->db->where('students.is_active', 'yes');
    $this->db->where('assessments.id', $assessment_id);
    $this->db->order_by('students.gender', 'ASC');
    $this->db->order_by('students.firstname', 'ASC');

    $query = $this->db->get();
    return $query->result_array();
}




    public function getExamByExamGroup($id, $is_termexam = false) {
        $this->db->select('cbse_exam_group_class_batch_exams.*,cbse_exam_groups.exam_type as `exam_group_type`,sessions.session,(select COUNT(*) from cbse_exam_group_class_batch_exam_subjects WHERE cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = cbse_exam_group_class_batch_exams.id) as `total_subjects`')->from('cbse_exam_group_class_batch_exams');
        $this->db->join('sessions', 'sessions.id = cbse_exam_group_class_batch_exams.session_id');
        $this->db->join('cbse_exam_groups', 'cbse_exam_groups.id = cbse_exam_group_class_batch_exams.exam_group_id');
        if ($is_termexam) {
            $this->db->where('cbse_exam_group_class_batch_exams.is_termexam', $is_termexam);
        }
        $this->db->where('cbse_exam_group_class_batch_exams.exam_group_id', $id);
        $this->db->order_by('cbse_exam_group_class_batch_exams.exam_group_id');

        $query = $this->db->get();

        return $query->result();
    }



    public function getExamsByExamGroups($id, $is_termexam = false) {
        $this->db->select('cbse_exam_group_class_batch_exams.*,cbse_exam_groups.exam_type as `exam_group_type`,sessions.session,(select COUNT(*) from cbse_exam_group_class_batch_exam_subjects WHERE cbse_exam_group_class_batch_exam_subjects.exam_group_class_batch_exams_id = cbse_exam_group_class_batch_exams.id) as `total_subjects`')->from('cbse_exam_group_class_batch_exams');
        $this->db->join('sessions', 'sessions.id = cbse_exam_group_class_batch_exams.session_id');
        $this->db->join('cbse_exam_groups', 'cbse_exam_groups.id = cbse_exam_group_class_batch_exams.exam_group_id');
        if ($is_termexam) {
            $this->db->where('cbse_exam_group_class_batch_exams.is_termexam', $is_termexam);
        }
        $this->db->where_in('cbse_exam_group_class_batch_exams.exam_group_id', $id);
        $this->db->order_by('cbse_exam_group_class_batch_exams.exam_group_id');

        $query = $this->db->get();

        return $query->result();
    }


    


    

    public function getBacklogExam($parent_exam_id) {

        $this->db->select()->from('cbse_exam_group_class_batch_exams');
        $this->db->where('parent_exam_id', $parent_exam_id);
        $query = $this->db->get();
        return $query->result();
    }

    public function getExamGroupDetailByID($id) {

        $this->db->select()->from('cbse_exam_groups');
        $this->db->where('id', $id);
        $query = $this->db->get();
        if ($query->num_rows() >= 1) {
            $result = $query->row();
            $result->exams = $this->getExamByExamGroup($result->id);
            return $result;
        }
        return false;
    }

    public function getExamGroupsDetailByID($id) {

        $this->db->select()->from('cbse_exam_groups');
        $this->db->where_in('id', $id);
        $query = $this->db->get();
        if ($query->num_rows() >= 1) {
            $result = $query->row();
            $result->exams = $this->getExamByExamGroup($result->id);
            return $result;
        }
        return false;
    }

    public function verifyExamConnection($exam_array) {

        $sql = "SELECT cbse_exam_group_class_batch_exam_subjects.cbse_exam_group_class_batch_exams_id,cbse_exam_group_class_batch_exam_subjects.subject_id,count(subject_id) as subject_count FROM `cbse_exam_group_class_batch_exam_subjects` WHERE cbse_exam_group_class_batch_exams_id in(" . implode(",", $exam_array) . ") GROUP by subject_id,cbse_exam_group_class_batch_exams_id";

        $query = $this->db->query($sql);
        $result = $query->result();

        $sub_array = array();
        $exams_array = array();
        $ex_array = array();
        $no_record = 0;
        if (!empty($result)) {
            $no_record = 1;
            foreach ($result as $result_key => $result_value) {
                $exams_array[$result_value->cbse_exam_group_class_batch_exams_id] = $result_value->cbse_exam_group_class_batch_exams_id;
                $ex_array[$result_value->cbse_exam_group_class_batch_exams_id][$result_value->subject_id] = $result_value->subject_count;
            }
        }
        return array('sub_array' => $sub_array, 'exams_array' => $exams_array, 'exam_subject_array' => $ex_array, 'no_record' => $no_record);
    }

    public function getExamByExamGroupConnection($id = null) {

        $this->db->select('cbse_exam_group_class_batch_exams.*,IFNULL(exam_group_exam_connections.id,0) as `exam_group_exam_connection_id`,IFNULL(exam_group_exam_connections.exam_weightage,"0.00") as exam_weightage,(select COUNT(*) from cbse_exam_group_class_batch_exam_subjects WHERE cbse_exam_group_class_batch_exam_subjects.cbse_exam_group_class_batch_exams_id = cbse_exam_group_class_batch_exams.id) as `total_subjects`')->from('cbse_exam_group_class_batch_exams');
        $this->db->join('exam_group_exam_connections', 'exam_group_exam_connections.exam_group_id = cbse_exam_group_class_batch_exams.exam_group_id and exam_group_exam_connections.cbse_exam_group_class_batch_exams_id = cbse_exam_group_class_batch_exams.id', 'left');
        $this->db->where('cbse_exam_group_class_batch_exams.exam_group_id', $id);
        $this->db->order_by('cbse_exam_group_class_batch_exams.id', 'asc');

        $query = $this->db->get();

        return $query->result();
    }

    public function getAssessments($id='')
    {
        $this->db->select('assessments.*,classes.class,sections.section,assessment_types.type,subject_groups.name as subject_group_name,subjects.name as subject_name')
        ->from('assessments')->join('classes','classes.id = assessments.class_id')->join('sections','sections.id = assessments.section_id')->join('assessment_types','assessment_types.id=assessments.assessment_type_id')->join('subject_groups','subject_groups.id=assessments.subject_group_id')->join('subjects','subjects.id=assessments.subject_id')->where('assessments.status',1);
        if (!empty($id)) {
            $this->db->where('assessments.id',$id);
        }
        $query = $this->db->get();
        if (!empty($id)) {
            return $query->row();
        }else{

            return $query->result_array();

        }

        
    }



    public function getClassAssessments($class_id='',$section_id='')
    {
        $this->db->select('assessments.*,classes.class,sections.section,assessment_types.type,subject_groups.name as subject_group_name,subjects.name as subject_name')
        ->from('assessments')->join('classes','classes.id = assessments.class_id')->join('sections','sections.id = assessments.section_id')->join('assessment_types','assessment_types.id=assessments.assessment_type_id')->join('subject_groups','subject_groups.id=assessments.subject_group_id')->join('subjects','subjects.id=assessments.subject_id')->where('assessments.status',1);
        if (!empty($class_id)) {
            $this->db->where('assessments.class_id',$class_id);
        }

        if (!empty($section_id)) {
            $this->db->where('assessments.section_id',$section_id);
        }
        $query = $this->db->get();
        if (!empty($id)) {
            return $query->row();
        }else{

            return $query->result_array();

        }

        
    }

    public function getUsedAssessmentTypes($class_id = '', $section_id = '')
    {
        $this->db->distinct()
            ->select('assessment_types.id,assessments.assessment_type_id, assessment_types.type, assessment_types.term_exam_out_of_marks')
            ->from('assessments')
            ->join('assessment_types', 'assessment_types.id = assessments.assessment_type_id')
            ->where('assessments.status', 1);

        if (!empty($class_id)) {
            $this->db->where('assessments.class_id', $class_id);
        }

        if (!empty($section_id)) {
            $this->db->where('assessments.section_id', $section_id);
        }

        $this->db->order_by('assessment_types.type', 'ASC');
        
        $query = $this->db->get();
        return $query->result_array();
    }






    public function getExamGroupConnectionList($exam_group_id = null) {

        $this->db->select('exam_group_exam_connections.*')->from('exam_group_exam_connections');
        $this->db->where('exam_group_exam_connections.exam_group_id', $exam_group_id);
        $this->db->order_by('exam_group_exam_connections.id', 'asc');
        $query = $this->db->get();
        return $query->result();
    }

   

    public function connectExam($insert_array, $exam_group_id) {
        $not_be_delted = array();
        if (!empty($insert_array)) {

            foreach ($insert_array as $array_key => $array_value) {
                $this->db->where('exam_group_id', $array_value['exam_group_id']);
                $this->db->where('cbse_exam_group_class_batch_exams_id', $array_value['cbse_exam_group_class_batch_exams_id']);
                $q = $this->db->get('exam_group_exam_connections');

                if ($q->num_rows() == 0) {

                    $this->db->insert('exam_group_exam_connections', $insert_array[$array_key]);
                    $not_be_delted[] = $array_value['cbse_exam_group_class_batch_exams_id'];
                } else {
                    $id = $q->row()->id;
                    $cbse_exam_group_class_batch_exams_id = $q->row()->cbse_exam_group_class_batch_exams_id;
                    $this->db->where('id', $id);
                    $this->db->update('exam_group_exam_connections', $insert_array[$array_key]);
                    $not_be_delted[] = $cbse_exam_group_class_batch_exams_id;
                }
            }
        }

        if (!empty($not_be_delted)) {

            $this->db->where('exam_group_id', $exam_group_id);
            $this->db->where_not_in('cbse_exam_group_class_batch_exams_id', $not_be_delted);
            $this->db->delete('exam_group_exam_connections');
        } else {
            $this->db->where('exam_group_id', $exam_group_id);
            $this->db->delete('exam_group_exam_connections');
        }
    }

    public function deleteExamGroupConnection($exam_group_id) {
        $this->db->where('exam_group_id', $exam_group_id);
        $this->db->delete('exam_group_exam_connections');
    }

    public function getExamGroupByStudent($student_id, $active = 1) {

        $this->db->select('exam_group_students.*,cbse_exam_groups.name,cbse_exam_groups.exam_type,cbse_exam_groups.exam_type')->from('exam_group_students');
        $this->db->join('cbse_exam_groups', 'cbse_exam_groups.id = exam_group_students.exam_group_id');
        $this->db->where('student_session_id', $student_id);
        $this->db->where('cbse_exam_groups.is_active', $active);
        $query = $this->db->get();

        return $query->result();
    }

    public function getExamGroupByStudentSession($student_session_id, $active = 1) {

        $this->db->select('exam_group_students.*,cbse_exam_groups.name,cbse_exam_groups.exam_type,cbse_exam_groups.exam_type')->from('exam_group_students');
        $this->db->join('cbse_exam_groups', 'cbse_exam_groups.id = exam_group_students.exam_group_id');
        $this->db->where('student_session_id', $student_session_id);
        $this->db->where('cbse_exam_groups.is_active', $active);
        $query = $this->db->get();

        $cbse_exam_groups = $query->result();
        $exam_results = array();
        if (!empty($cbse_exam_groups)) {
            foreach ($cbse_exam_groups as $exam_group_key => $exam_group_value) {
                $cbse_exam_groups[$exam_group_key]->exam_group_connection = $this->getExamGroupConnection($exam_group_value->exam_group_id);
                $cbse_exam_groups[$exam_group_key]->exam_results = $this->getExamGroupExamsResultByStudentID($exam_group_value->exam_group_id, $student_session_id);
            }
            return $cbse_exam_groups;
        }
        return false;
    }

    public function getExamResultStudent($exam_group_exam_id, $exam_group_id, $student_id) {

        $sql = "SELECT `cbse_exam_group_class_batch_exam_subjects`.*,IFNULL(exam_group_student.id, 0) as exam_group_exam_result_id,exam_group_student.get_marks,exam_group_student.attendence,exam_group_student.note,subjects.id as `subject_id`,subjects.`name`,subjects.`code` FROM `cbse_exam_group_class_batch_exam_subjects` LEFT join (SELECT exam_group_exam_results.* FROM `exam_group_students` INNER JOIN exam_group_exam_results on exam_group_exam_results.exam_group_student_id = exam_group_students.id WHERE exam_group_students.exam_group_id=" . $this->db->escape($exam_group_id) . " and exam_group_students.student_session_id =" . $this->db->escape($student_id) . " ORDER BY `exam_group_id`) as `exam_group_student` on exam_group_student.exam_group_class_batch_exam_subject_id =cbse_exam_group_class_batch_exam_subjects.id INNER join subjects on subjects.id= cbse_exam_group_class_batch_exam_subjects.subject_id WHERE cbse_exam_group_class_batch_exam_subjects.cbse_exam_group_class_batch_exams_id=" . $this->db->escape($exam_group_exam_id) . " ORDER BY `cbse_exam_group_class_batch_exams_id`";
        $query = $this->db->query($sql);
        return $query->result();
    }

    public function getExamResultDetailStudent($exam_group_exam_id, $exam_group_id, $student_id) {

        $this->db->select('cbse_exam_groups.*')->from('cbse_exam_groups');

        $this->db->where('id', $exam_group_id);

        $query = $this->db->get();

        $exam_group = $query->row();
        $exam_group->exam_results = $this->getExamResultStudent($exam_group_exam_id, $exam_group_id, $student_id);
        return $exam_group;
    }

    public function getExamGroupExamsResultByStudentID($exam_group_id, $student_id) {
        $exam_group_exams = $this->getExamByExamGroup($exam_group_id, 1);
        if (!empty($exam_group_exams)) {
            foreach ($exam_group_exams as $exam_key => $exam_value) {
                $exam_group_exams[$exam_key]->exam_results = $this->getExamResultStudent($exam_value->id, $exam_value->exam_group_id, $student_id);
            }
        }
        return $exam_group_exams;
    }

    public function getExamGroupConnection($exam_group_id) {

        $result_array = array();
        $sql = "SELECT exam_group_exam_connections.*,cbse_exam_group_class_batch_exams.id as `exam_group_class_batch_exam_id`,cbse_exam_group_class_batch_exams.exam,cbse_exam_group_class_batch_exams.description FROM `exam_group_exam_connections` INNER JOIN cbse_exam_group_class_batch_exams on cbse_exam_group_class_batch_exams.id = exam_group_exam_connections.cbse_exam_group_class_batch_exams_id WHERE exam_group_exam_connections.exam_group_id=" . $exam_group_id;
        $query = $this->db->query($sql);
        $result = $query->result();
        $result_array['exam_connections'] = $result;
        if (!empty($result)) {
            $sql_inner = "SELECT exam_group_exam_connections.*,cbse_exam_group_class_batch_exam_subjects.id as exam_group_class_batch_exam_subject_id,cbse_exam_group_class_batch_exam_subjects.cbse_exam_group_class_batch_exams_id,cbse_exam_group_class_batch_exam_subjects.subject_id,cbse_exam_group_class_batch_exam_subjects.credit_hours,cbse_exam_group_class_batch_exam_subjects.date_from,cbse_exam_group_class_batch_exam_subjects.date_from,cbse_exam_group_class_batch_exam_subjects.date_to,cbse_exam_group_class_batch_exam_subjects.room_no,cbse_exam_group_class_batch_exam_subjects.max_marks,cbse_exam_group_class_batch_exam_subjects.max_marks,subjects.name,subjects.code FROM `exam_group_exam_connections`INNER JOIN cbse_exam_group_class_batch_exams on cbse_exam_group_class_batch_exams.id=exam_group_exam_connections.cbse_exam_group_class_batch_exams_id INNER JOIN cbse_exam_group_class_batch_exam_subjects on cbse_exam_group_class_batch_exam_subjects.cbse_exam_group_class_batch_exams_id = cbse_exam_group_class_batch_exams.id  INNER JOIN subjects on subjects.id=cbse_exam_group_class_batch_exam_subjects.subject_id WHERE exam_group_exam_connections.exam_group_id=" . $exam_group_id . " GROUP BY cbse_exam_group_class_batch_exam_subjects.subject_id";
            $query = $this->db->query($sql_inner);
            $result_array['connect_subjects'] = $query->result();
        }

        return $result_array;
    }

    public function getExamGroupByClassSection($class_id, $section_id, $session_id) {

        $result_array = array();
        $sql = "SELECT student_session.*,exam_group_students.exam_group_id,cbse_exam_groups.name FROM `student_session` INNER join exam_group_students on exam_group_students.student_id=student_session.student_id INNER JOIN cbse_exam_groups on cbse_exam_groups.id=exam_group_students.exam_group_id WHERE class_id= " . $this->db->escape($class_id) . " and section_id=" . $this->db->escape($section_id) . " and session_id=" . $this->db->escape($session_id) . " GROUP BY exam_group_students.exam_group_id";
        $query = $this->db->query($sql);

        $result = $query->result();
        return $result;
    }

}
