<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Paystack extends Studentgateway_Controller
{

    public $api_config = "";

    public function __construct()
    {
        parent::__construct();
        $this->api_config = $this->paymentsetting_model->getActiveMethod();
        $this->setting    = $this->setting_model->get();
        $this->setting[0]['currency_symbol'] = $this->customlib->getSchoolCurrencyFormat();
        $this->load->library('mailsmsconf');
    }

    public function index()
    {
        $data                 = array();
        $data['params']       = $this->session->userdata('params');
        $data['setting']      = $this->setting;
        $data['api_error']    = array();
        $data['student_data'] = $this->student_model->get($data['params']['student_id']);
        $data['student_fees_master_array'] = $data['params']['student_fees_master_array'];
        $this->load->view('user/gateway/paystack/index', $data);
    }

    public function paystack_pay()
    {
        $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $data                 = array();
            $data['params']       = $this->session->userdata('params');
            $data['setting']      = $this->setting;
            $data['api_error']    = array();
            $data['student_data'] = $this->student_model->get($data['params']['student_id']);
            $data['student_fees_master_array'] = $data['params']['student_fees_master_array'];
            $this->load->view('user/gateway/paystack/index', $data);
        } else {
            $params                         = $this->session->userdata('params');

            $data                           = array();
            $amount                         = number_format((float) (convertBaseAmountCurrencyFormat(($params['fine_amount_balance'] + $params['total'] - $params['applied_fee_discount']+ $params['gateway_processing_charge']))), 2, '.', '');
            $total                          = $amount;
            $data['student_id']             = $params['student_id'];
            $data['total']                  = $total * 100;
            $data['symbol']                 = $params['invoice']->symbol;
            $data['currency_name']          = $params['invoice']->currency_name;
            $data['name']                   = $params['name'];
            $data['guardian_phone']         = $params['guardian_phone'];

            if (isset($data)) {
                $result       = array();
                $amount       = $data['total'];
                $ref          = time() . "02";
                $callback_url = base_url() . 'user/gateway/paystack/verify_payment/' . $ref;
                $postdata     = array('email' => $_POST['email'], 'amount' => $amount, "reference" => $ref, "callback_url" => $callback_url);
                $url          = "https://api.paystack.co/transaction/initialize";
                $ch           = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata)); //Post Fields
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                $headers = [
                    'Authorization: Bearer ' . $this->api_config->api_secret_key,
                    'Content-Type: application/json',
                ];
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $request = curl_exec($ch);
                curl_close($ch);
                $result = json_decode($request, true);

                if ($result['status']) {

                    $redir = $result['data']['authorization_url'];
                    header("Location: " . $redir);
                } else {

                    $data['params']    = $this->session->userdata('params');
                    $data['setting']   = $this->setting;
                    $data['api_error'] = $data['api_error'] = $result['message'];
                    $data['student_fees_master_array'] = $data['params']['student_fees_master_array'];
                    $this->load->view('user/gateway/paystack/index', $data);
                }
            }
        }
    }

    public function verify_payment($ref)
    {
        $result = array();
        $url    = 'https://api.paystack.co/transaction/verify/' . $ref;
        $ch     = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            ['Authorization: Bearer ' . $this->api_config->api_secret_key]
        );
        $request = curl_exec($ch);
        curl_close($ch);

        if ($request) {
            $result = json_decode($request, true);

            if ($result) {
                if ($result['data']) {
                    //something came in
                    if ($result['data']['status'] == 'success') {

                        $params     = $this->session->userdata('params');
                        $ref_id     = $ref;
                        $bulk_fees = array();
                        $params     = $this->session->userdata('params');

                        foreach ($params['student_fees_master_array'] as $fee_key => $fee_value) {

                            $json_array = array(
                                'amount'          =>  $fee_value['amount_balance']-$fee_value['applied_fee_discount'],
                                'date'            => date('Y-m-d'),
                                'amount_discount' => $fee_value['applied_fee_discount'],
								'processing_charge_type'=>$params['processing_charge_type'],
                                'gateway_processing_charge'=>$params['gateway_processing_charge'],
                                'amount_fine'     => $fee_value['fine_balance'],
                                'description'     => $this->lang->line('online_fees_deposit_through_paystack_txn_id') . $ref_id,
                                'received_by'     => '',
                                'payment_mode'    => 'Paystack',
                            );

                            $insert_fee_data = array(
                                'fee_category' => $fee_value['fee_category'],
                                'student_transport_fee_id' => $fee_value['student_transport_fee_id'],
                                'student_fees_master_id' => $fee_value['student_fees_master_id'],
                                'fee_groups_feetype_id'  => $fee_value['fee_groups_feetype_id'],
                                'amount_detail'          => $json_array,
                            );
                            $bulk_fees[] = $insert_fee_data;
                            //========
                        }
                        $send_to     = $params['guardian_phone'];


                        // $response = $this->studentfeemaster_model->fee_deposit_bulk($bulk_fees, $params['student_fees_discount_id']);
                        $response = $this->studentfeemaster_model->fee_deposit_bulk($bulk_fees, $params['fee_discount_group']);
                        //========================
                        $student_id            = $this->customlib->getStudentSessionUserID();
                        $student_current_class = $this->customlib->getStudentCurrentClsSection();
                        $student_session_id    = $student_current_class->student_session_id;
                        $fee_group_name        = [];
                        $type                  = [];
                        $code                  = [];

                        $amount          = [];
                        $fine_type       = [];
                        $due_date        = [];
                        $fine_percentage = [];
                        $fine_amount     = [];

                        $invoice     = [];

                        $student = $this->student_model->getStudentByClassSectionID($student_current_class->class_id, $student_current_class->section_id, $student_id);

                        if ($response && is_array($response)) {
                            foreach ($response as $response_key => $response_value) {
                                $fee_category = $response_value['fee_category'];
                                $invoice[]   = array(
                                    'invoice_id'     => $response_value['invoice_id'],
                                    'sub_invoice_id' => $response_value['sub_invoice_id'],
                                    'fee_category' => $fee_category,
                                );


                                if ($response_value['student_transport_fee_id'] != 0 && $response_value['fee_category'] == "transport") {

                                    $data['student_fees_master_id']   = null;
                                    $data['fee_groups_feetype_id']    = null;
                                    $data['student_transport_fee_id'] = $response_value['student_transport_fee_id'];

                                    $mailsms_array     = $this->studenttransportfee_model->getTransportFeeMasterByStudentTransportID($response_value['student_transport_fee_id']);
                                    $fee_group_name[]  = $this->lang->line("transport_fees");
                                    $type[]            = $mailsms_array->month;
                                    $code[]            = "-";
                                    $fine_type[]       = $mailsms_array->fine_type;
                                    $due_date[]        = $mailsms_array->due_date;
                                    $fine_percentage[] = $mailsms_array->fine_percentage;
                                    $fine_amount[]     = $mailsms_array->fine_amount;
                                    $amount[]          = $mailsms_array->amount;
                                } else {

                                    $mailsms_array = $this->feegrouptype_model->getFeeGroupByIDAndStudentSessionID($response_value['fee_groups_feetype_id'], $student_session_id);

                                    $fee_group_name[]  = $mailsms_array->fee_group_name;
                                    $type[]            = $mailsms_array->type;
                                    $code[]            = $mailsms_array->code;
                                    $fine_type[]       = $mailsms_array->fine_type;
                                    $due_date[]        = $mailsms_array->due_date;
                                    $fine_percentage[] = $mailsms_array->fine_percentage;
                                    $fine_amount[]     = $mailsms_array->fine_amount;

                                    if ($mailsms_array->is_system) {
                                        $amount[] = $mailsms_array->balance_fee_master_amount;
                                    } else {
                                        $amount[] = $mailsms_array->amount;
                                    }
                                }
                            }
                            $obj_mail                     = [];
                            $obj_mail['student_id']  = $student_id;
                            $obj_mail['student_session_id'] = $student_session_id;

                            $obj_mail['invoice']         = $invoice;
                            $obj_mail['contact_no']      = $student['guardian_phone'];
                            $obj_mail['email']           = $student['email'];
                            $obj_mail['parent_app_key']  = $student['parent_app_key'];
                            $obj_mail['amount']         = "(" . implode(',', $amount) . ")";
                            $obj_mail['fine_type']       = "(" . implode(',', $fine_type) . ")";
                            $obj_mail['due_date']        = "(" . implode(',', $due_date) . ")";
                            $obj_mail['fine_percentage'] = "(" . implode(',', $fine_percentage) . ")";
                            $obj_mail['fine_amount']     = "(" . implode(',', $fine_amount) . ")";
                            $obj_mail['fee_group_name']  = "(" . implode(',', $fee_group_name) . ")";
                            $obj_mail['type']            = "(" . implode(',', $type) . ")";
                            $obj_mail['code']            = "(" . implode(',', $code) . ")";
                            $obj_mail['fee_category']    = $fee_category;
                            $obj_mail['send_type']    = 'group';


                            $this->mailsmsconf->mailsms('fee_submission', $obj_mail);
                        }

                        //=============================
                        if ($response) {
                            redirect(base_url("user/gateway/payment/successinvoice"));
                        } else {
                            redirect(base_url('user/gateway/payment/paymentfailed'));
                        }
                    } else {
                        // the transaction was not successful, do not deliver value'
                        //uncomment this line to inspect the result, to check why it failed.
                        redirect(base_url("user/gateway/payment/paymentfailed"));
                    }
                } else {

                    redirect(base_url("user/gateway/payment/paymentfailed"));
                }
            } else {

                //die("Something went wrong while trying to convert the request variable to json. Uncomment the print_r command to see what is in the result variable.");
                redirect(base_url("user/gateway/payment/paymentfailed"));
            }
        } else {
            //die("Something went wrong while executing curl. Uncomment the var_dump line above this line to see what the issue is. Please check your CURL command to make sure everything is ok");
            redirect(base_url("user/gateway/payment/paymentfailed"));
        }
    }
}
