<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Visitors extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('media_storage');
        $this->config->load('front_office');
        $this->meeting_with = $this->config->item('meeting_with');
         $this->load->model("Visitors_model");
    }

    public function index()
    {
        if (!$this->rbac->hasPrivilege('visitor_book', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'front_office');
        $this->session->set_userdata('sub_menu', 'admin/visitors');

        $data['visitor_list'] = $this->visitors_model->visitors_list();
        $data['Purpose']      = $this->visitors_model->getPurpose();
        $data['meeting_with'] = $this->meeting_with;
        $data['stafflist']    = $this->staff_model->searchFullText("", 1);
        $data['classlist']    = $this->class_model->get();

        $this->load->view('layout/header');
        $this->load->view('admin/frontoffice/visitorview', $data);
        $this->load->view('layout/footer');
    }
    
    
    public function Visitor_id_card($id) {
        
        
       
        if (!$this->rbac->hasPrivilege('visitor_book', 'can_view')) {

            access_denied();

        }

		$data['result']         = $this->setting_model->getSetting();

        $data['data'] = $this->Visitors_model->visitors_list($id);

        $this->load->view('admin/frontoffice/VisitorCardModelView', $data);

		//echo "<pre>";     print_r($data);

    }
    
    public function visitor_id_card_print($id = '')    {

        if (!valid($id))        {

            redirect('student/search');

        }

		$data['result']         = $this->setting_model->getSetting();

        $visitor_data = $data['visitor_data'] = $this->Visitors_model->visitors_list($id);

        $row = $visitor_data;

        //$html = $this->load->view('reports/bonafiedCertificate', $data, true);

        // loading fpdf library

        $this->load->library('Pdf');



        // create new PDF document

//        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        $pdf = new FPDF();

        $pdf->AddPage();

        $pdf->SetFont('Arial', '', 10);

        //if($student['schoolType']=="primary"){



        $pdf->SetTextColor(255, 255, 255);

		// dyanamic use 

		  if ($result->admin_logo == "") {

		$logo_img =	 base_url(). 'uploads/school_content/admin_logo/1.png'  ;

		} else {

		$logo_img =	 base_url(). 'uploads/school_content/admin_logo/$result->admin_logo';

		}

		$school_name = $data['result']->name;

		$school_add = $data['result']->address;

		//echo "<pre>";     print_r($data['result']->name);

		////

        $pdf->Image(base_url() . '/uploads/certificate/student_idcard.jpg', 5, 5, 120, 80);

		//$pdf->Image($logo_img, 5, 5, 120, 80);

       // $pdf->Cell(130, 0, 'St Johns Education Society', 0, 0, "C");

        $pdf->Ln(3);

        $pdf->SetFont('Arial', 'B', 14);

        $pdf->SetTextColor(255, 255, 255);

        $pdf->Cell(130, 5, $school_name, 0, 0, "C");

	//	$pdf->Cell(130, 5, 'TIMES PUBLIC SCHOOL, UDGIR', 0, 0, "C");

        $pdf->SetTextColor(255, 255, 255);

        $pdf->Ln(5);

        $pdf->SetFont('Arial', 'B', 8);

    //    $pdf->Cell(130, 5, 'Behind Uday PetrolPump,Nanded-Bidar Road,Udgir', 0, 0, "C");

		$pdf->Cell(130, 5, $school_add, 0, 0, "C");



        $pdf->Ln(5);

        $pdf->SetFont('Arial', 'B', 10);



        $pdf->Cell(45, 10, '', 0, 0, "C");

        $pdf->SetFillColor(255, 0, 0);

        $pdf->SetTextColor(255, 255, 255);

        $pdf->Cell(40, 5, 'Visitors Card', 1, 1, "C", true);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Image($logo_img, 8, 12, 22, 10);

		//$pdf->Image(base_url() . '/uploads/certificate/logo.png', 7.5, 6, 22, 0);





        $fullname = ucwords($row['name']);

        $fatherImage = $row['image'];

        if ($fatherImage == null || $fatherImage == '')

        {



//            $pdf->Image(base_url() . '/uploads/certificate/father.jpg', 40, 29.5, 23, 23);

            $pdf->Image(base_url() . '/uploads/certificate/father.jpg', 95, 29.5, 23, 23);

        }

        else

        {

            $fimage = base_url() . '/uploads/front_office/visitors/' . $row['image'];

            $pdf->Image($fimage, 95, 29.5, 23, 23);

        }



        $pdf->Ln(5);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(36, 4, 'Visitor Pass:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(100, 4, $row['id'], 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);



        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(36, 4, 'Name:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(100, 4, $fullname, 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);



        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(36, 4, 'Phone:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(100, 4, $row['contact'], 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);



        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(37, 4, 'Number Of Person:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(100, 4, $row['no_of_pepple'], 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);



        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(35.5, 4, 'In Time:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(100, 4, $row['in_time'], 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);

        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(35.5, 4, 'Out Time:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(120, 4, $row['out_time'], 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);





        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(35.5, 4, 'Purpose:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(120, 4, $row['purpose'], 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);



        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(35.5, 4, 'Date:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(120, 4, date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($row['date'])), 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);



        $pdf->Ln(4);

        $pdf->SetFont('Courier', 'BI', 10);

        $pdf->SetTextColor(146, 27, 25);

        $pdf->Cell(20, 4, 'Remarks:', 0, 0, "L");

        $pdf->SetFont('Arial', '', 10);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(150, 4, $row['note'], 0, 0, "L");

        $pdf->SetFont('Arial', 'B', 14);







        $pdf->Ln(10);



        $pdf->SetFont('Arial', '', 8);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->Cell(40, 4, 'SIGN OF VISITOR', 0, 0, "L");

        $pdf->Cell(40, 4, 'EMPLOYEE SIGN', 0, 0, "L");

        $pdf->Cell(40, 4, 'SECURITY OFFICER', 0, 0, "L");







        //$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);   

        // ---------------------------------------------------------    

        // Close and output PDF document

        // This method has several options, check the source code documentation for more information.

        $pdf->Output($fullname . '.pdf', 'I');

    }


    public function delete()
    {
        if (!$this->rbac->hasPrivilege('visitor_book', 'can_delete')) {
            access_denied();
        }

        $id  = $this->input->post('id');
        $row = $this->visitors_model->visitors_list($id);

        if ($row['image'] != '') {
            $this->media_storage->filedelete($row['image'], "uploads/front_office/visitors/");
        }

        $this->visitors_model->delete($id);
        echo json_encode(array('message' => $this->lang->line('delete_message')));
    }

    public function details($id)
    {
        if (!$this->rbac->hasPrivilege('visitor_book', 'can_view')) {
            access_denied();
        }

        $data['data'] = $this->visitors_model->visitors_list($id);
        $this->load->view('admin/frontoffice/visitormodelview', $data);
    }

    public function download($id)
    {
        $result = $this->visitors_model->visitors_list($id);
        $this->media_storage->filedownload($result['image'], "./uploads/front_office/visitors");
    }

    public function check_default($post_string)
    {
        return $post_string == "" ? false : true;
    }

    public function handle_upload($str, $var)
    {
        $image_validate = $this->config->item('file_validate');
        $result         = $this->filetype_model->get();
        if (isset($_FILES[$var]) && !empty($_FILES[$var]['name'])) {

            $file_type = $_FILES[$var]['type'];
            $file_size = $_FILES[$var]["size"];
            $file_name = $_FILES[$var]["name"];

            $allowed_extension = array_map('trim', array_map('strtolower', explode(',', $result->file_extension)));
            $allowed_mime_type = array_map('trim', array_map('strtolower', explode(',', $result->file_mime)));
            $ext               = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

            if ($files = filesize($_FILES[$var]['tmp_name'])) {

                if (!in_array($file_type, $allowed_mime_type)) {
                    $this->form_validation->set_message('handle_upload', $this->lang->line('file_type_not_allowed'));
                    return false;
                }

                if (!in_array($ext, $allowed_extension) || !in_array($file_type, $allowed_mime_type)) {
                    $this->form_validation->set_message('handle_upload', $this->lang->line('extension_not_allowed'));
                    return false;
                }
                if ($file_size > $result->file_size) {
                    $this->form_validation->set_message('handle_upload', $this->lang->line('file_size_shoud_be_less_than') . number_format($result->file_size / 1048576, 2) . " MB");
                    return false;
                }

            } else {
                $this->form_validation->set_message('handle_upload', $this->lang->line('file_type_extension_error_uploading_image'));
                return false;
            }

            return true;
        }
        return true;
    }

    public function add()
    {
        $this->form_validation->set_rules('meeting_with', $this->lang->line('meeting_with'), 'required');
        $this->form_validation->set_rules('purpose', $this->lang->line('purpose'), 'required');
        $this->form_validation->set_rules('name', $this->lang->line('visitor_name'), 'required');
        $this->form_validation->set_rules('date', $this->lang->line('date'), 'required');
        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload[file]');
        
        $meeting_with       = $this->input->post('meeting_with');
        if ($meeting_with == 'staff') {
            $this->form_validation->set_rules('staff_id', $this->lang->line('staff'), 'required');                  
        } else if ($meeting_with == 'student') {
            $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'required');   
            $this->form_validation->set_rules('class_section_id', $this->lang->line('section'), 'required');   
            $this->form_validation->set_rules('student_session_id', $this->lang->line('student'), 'required');              
        }
        

        if ($this->form_validation->run() == false) {
            $msg = array(
                'purpose'      => form_error('purpose'),
                'meeting_with' => form_error('meeting_with'),
                'name'         => form_error('name'),
                'date'         => form_error('date'),
                'file'         => form_error('file'),
            );
            
            if ($meeting_with == 'staff') {
                $msg['staff_id'] = form_error('staff_id') ;                   
            } else if ($meeting_with == 'student') {
                $msg['class_id'] = form_error('class_id') ;
                $msg['class_section_id'] = form_error('class_section_id') ;
                $msg['student_session_id'] = form_error('student_session_id') ;               
            }       

            $array = array('status' => 'fail', 'error' => $msg, 'message' => '');
        } else {

            $meeting_with       = $this->input->post('meeting_with');
            $staff_id           = NULL;
            $student_session_id = NULL;

            if ($meeting_with == 'staff') {
                $staff_id = $this->input->post('staff_id');
            } else {
                $student_session_id = $this->input->post('student_session_id');
            }

            $img_name = $this->media_storage->fileupload("file", "./uploads/front_office/visitors/");

            $visitors = array(
                'purpose'            => $this->input->post('purpose'),
                'name'               => $this->input->post('name'),
                'contact'            => $this->input->post('contact'),
                'id_proof'           => $this->input->post('id_proof'),
                'no_of_people'       => $this->input->post('pepples'),
                'date'               => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('date'))),
                'in_time'            => $this->input->post('time'),
                'out_time'           => $this->input->post('out_time'),
                'note'               => $this->input->post('note'),
                'meeting_with'       => $meeting_with,
                'staff_id'           => $staff_id,
                'student_session_id' => $student_session_id,
                'image'              => $img_name,
            );

            $visitor_id = $this->visitors_model->add($visitors);           

            $msg   = $this->lang->line('success_message');
            $array = array('status' => 'success', 'error' => '', 'message' => $msg);
        }
        echo json_encode($array);
    }

    public function editvisitor()
    {
        $visitorid            = $this->input->post('visitorid');
        $data['Purpose']      = $this->visitors_model->getPurpose();
        $data['visitor_data'] = $this->visitors_model->visitors_list($visitorid);
        $data['meeting_with'] = $this->meeting_with;
        $data['stafflist']    = $this->staff_model->searchFullText("", 1);
        $data['classlist']    = $this->class_model->get();
        $page = $this->load->view('admin/frontoffice/_visitoreditview', $data, true);
        echo json_encode(array('page' => $page));
    }

    public function edit()
    {
        $this->form_validation->set_rules('purpose', $this->lang->line('purpose'), 'required');
        $this->form_validation->set_rules('edit_meeting_with', $this->lang->line('meeting_with'), 'required');
        $this->form_validation->set_rules('name', $this->lang->line('visitor_name'), 'required');
        $this->form_validation->set_rules('file', $this->lang->line('file'), 'callback_handle_upload[file]');
        $this->form_validation->set_rules('date', $this->lang->line('date'), 'required');
        
        $meeting_with       = $this->input->post('edit_meeting_with');     

        if ($meeting_with == 'staff') {
            $this->form_validation->set_rules('edit_staff_id', $this->lang->line('staff'), 'required');   
        } else if ($meeting_with == 'student') {
            $this->form_validation->set_rules('edit_class_id', $this->lang->line('class'), 'required');
            $this->form_validation->set_rules('edit_class_section_id', $this->lang->line('section'), 'required');
            $this->form_validation->set_rules('edit_student_session_id', $this->lang->line('student'), 'required');          
        }
            
        if ($this->form_validation->run() == false) {
            $msg = array(
                'purpose'           => form_error('purpose'),
                'edit_meeting_with' => form_error('edit_meeting_with'),
                'name'              => form_error('name'),
                'date'              => form_error('date'),
                'file'              => form_error('file'),
            );
                
            if ($meeting_with == 'staff') {
                $msg['edit_staff_id'] =  form_error('edit_staff_id');
            } else if ($meeting_with == 'student') {
                $msg['edit_class_id'] =  form_error('edit_class_id');
                $msg['edit_class_section_id'] =  form_error('edit_class_section_id');
                $msg['edit_student_session_id'] =  form_error('edit_student_session_id');                
            }           

            $array = array('status' => 'fail', 'error' => $msg, 'message' => '');
        } else {

            $meeting_with       = $this->input->post('edit_meeting_with');
            $staff_id           = NULL;
            $student_session_id = NULL;

            if ($meeting_with == 'staff') {
                $staff_id = $this->input->post('edit_staff_id');
            } else {
                $student_session_id = $this->input->post('edit_student_session_id');
            }

            $visitors_list = $this->visitors_model->visitors_list($this->input->post('visitor_id'));

            $visitors = array(
                'purpose'            => $this->input->post('purpose'),
                'name'               => $this->input->post('name'),
                'contact'            => $this->input->post('contact'),
                'id_proof'           => $this->input->post('id_proof'),
                'no_of_people'       => $this->input->post('pepples'),
                'date'               => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('date'))),
                'in_time'            => $this->input->post('time'),
                'out_time'           => $this->input->post('out_time'),
                'note'               => $this->input->post('note'),
                'meeting_with'       => $meeting_with,
                'staff_id'           => $staff_id,
                'student_session_id' => $student_session_id,
            );

            if (isset($_FILES["file"]) && $_FILES['file']['name'] != '' && (!empty($_FILES['file']['name']))) {

                $img_name = $this->media_storage->fileupload("file", "./uploads/front_office/visitors/");
            } else {
                $img_name = $visitors_list['image'];
            }

            $visitors['image'] = $img_name;

            if (isset($_FILES["file"]) && $_FILES['file']['name'] != '' && (!empty($_FILES['file']['name']))) {

                if ($visitors_list['image'] != '') {
                    $this->media_storage->filedelete($visitors_list['image'], "uploads/front_office/visitors/");
                }
            }

            $this->visitors_model->update($this->input->post('visitor_id'), $visitors);         

            $msg   = $this->lang->line('success_message');
            $array = array('status' => 'success', 'error' => '', 'message' => $msg);
        }
        echo json_encode($array);
    }

    public function getstudent()
    {
        $class_id            = $this->input->post('class_id');
        $section_id          = $this->input->post('section_id');
        $data['studentlist'] = $this->visitors_model->getstudent($class_id, $section_id);
        echo json_encode($data);
    }

    public function staffvisitor()
    {
        $this->session->set_userdata('top_menu', 'visitors');
        $userdata             = $this->customlib->getUserData();
        $staffid              = $userdata['id'];
        $data['visitor_list'] = $this->visitors_model->visitorbystaffid($staffid);
        $this->load->view('layout/header');
        $this->load->view('admin/frontoffice/staffvisitorview', $data);
        $this->load->view('layout/footer');
    }

}
