<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Timetable extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model("staff_model");
        $this->load->model("classteacher_model");
        $this->load->model("Generatetimetable_model");
        $this->load->model('exam_model');
    }

    public function index()
    {

        if (!$this->rbac->hasPrivilege('class_time_table', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'Academics/timetable');
        $session            = $this->setting_model->getCurrentSession();
        $data['title']      = 'Exam Marks';
        $data['exam_id']    = "";
        $data['class_id']   = "";
        $data['section_id'] = "";

        $class             = $this->class_model->get();
        $data['classlist'] = $class;

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('group_id', $this->lang->line('subject_group'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/timetable/timetableList', $data);
            $this->load->view('layout/footer', $data);
        } else {

            $class_id           = $this->input->post('class_id');
            $section_id         = $this->input->post('section_id');
            $section_id         = $this->input->post('group_id');
            $data['class_id']   = $class_id;
            $data['section_id'] = $section_id;
            $result_subjects    = $this->teachersubject_model->getSubjectByClsandSection($class_id, $section_id);

            $getDaysnameList         = $this->customlib->getDaysname();
            $data['getDaysnameList'] = $getDaysnameList;
            $final_array             = array();
            if (!empty($result_subjects)) {
                foreach ($result_subjects as $subject_k => $subject_v) {
                    $result_array = array();
                    foreach ($getDaysnameList as $day_key => $day_value) {
                        $where_array = array(
                            'teacher_subject_id' => $subject_v['id'],
                            'day_name'           => $day_value,
                        );
                        $result = $this->timetable_model->get($where_array);
                        if (!empty($result)) {
                            $obj                      = new stdClass();
                            $obj->status              = "Yes";
                            $obj->start_time          = $result[0]['start_time'];
                            $obj->end_time            = $result[0]['end_time'];
                            $obj->room_no             = $result[0]['room_no'];
                            $result_array[$day_value] = $obj;
                        } else {
                            $obj                      = new stdClass();
                            $obj->status              = "No";
                            $obj->start_time          = "N/A";
                            $obj->end_time            = "N/A";
                            $obj->room_no             = "N/A";
                            $result_array[$day_value] = $obj;
                        }
                    }
                    $final_array[$subject_v['name']] = $result_array;
                }
            }

            $data['result_array'] = $final_array;
            $this->load->view('layout/header', $data);
            $this->load->view('admin/timetable/timetableList', $data);
            $this->load->view('layout/footer', $data);
        }
    }
    
    
    public function show_timetable()
    {
        if (!$this->rbac->hasPrivilege('class_timetable', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'Academics/timetable');
        $session                 = $this->setting_model->getCurrentSession();
        $data['title']           = 'Exam Schedule';
        $data['subject_id']      = "";
        $data['class_id']        = "";
        $data['section_id']      = "";
        $exam                    = $this->exam_model->get();
        $class                   = $this->class_model->get('', $classteacher = 'yes');
        $data['examlist']        = $exam;
        $data['classlist']       = $class;
        $userdata                = $this->customlib->getUserData();
        $staff                   = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['staff']           = $staff;
        $data['subject']         = array();
        // $feecategory             = $this->feecategory_model->get();
        // $data['feecategorylist'] = $feecategory;
        $sessionData = $this->session_model->get($session);
        
        $data['current_session'] = $sessionData['session'];
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id[]', $this->lang->line('section'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == true) {
            if (isset($_POST['search'])) {
                $class_id = $this->input->post('class_id');
                $section_id = $this->input->post('section_id');

                $class_teacher=$this->classteacher_model->getteacherByClassSectionNew($class_id,$section_id);
                $data['class_teacher'] = $class_teacher ? $class_teacher->name . ' ' . $class_teacher->surname : 'Not Assigned';
               

                $data['class_id'] = $class_id;
                $data['section_id'] = $section_id;

                // Load timetable data
                $data['timetable'] = $this->Generatetimetable_model->get_class_timetable($class_id, $section_id);
                
                // Check if timetable is generated
                $data['is_generated'] = !empty($data['timetable']);

                $data['sectionList'] = $this->db->select('class_sections.id,class_sections.section_id,sections.section')
                ->from('class_sections')
                ->join('sections', 'sections.id = class_sections.section_id')
                ->where('class_sections.id', $section_id)
                ->order_by('class_sections.id')
                ->get()
                ->result_array();
                
                // Load subject groups for editing if timetable exists
                if ($data['is_generated']) {
                    $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);
                    if ($dt) {
                        $subject_groups = $this->db->select('subject_group_class_sections.subject_group_id, subject_groups.name')
                            ->from('subject_group_class_sections')
                            ->join('subject_groups', 'subject_groups.id = subject_group_class_sections.subject_group_id')
                            ->where('subject_group_class_sections.class_section_id', $dt['id'])
                            ->where('subject_group_class_sections.session_id', $session)
                            ->get()
                            ->result_array();
                        
                        // Get ALL subjects from ALL subject groups for editing
                        $all_subjects = array();
                        if (!empty($subject_groups)) {
                            foreach ($subject_groups as $group) {
                                $group_subjects = $this->subjectgroup_model->getGroupsubjects($group['subject_group_id'], $session);
                                if (!empty($group_subjects)) {
                                    foreach ($group_subjects as $subj) {
                                        // Avoid duplicates by using subject_group_subject_id as key
                                        $subj_id = is_object($subj) ? $subj->id : (isset($subj['id']) ? $subj['id'] : '');
                                        if ($subj_id && !isset($all_subjects[$subj_id])) {
                                            $all_subjects[$subj_id] = $subj;
                                        }
                                    }
                                }
                            }
                            $data['subjects'] = array_values($all_subjects); // Convert back to indexed array
                            $data['subject_group_id'] = !empty($subject_groups) ? $subject_groups[0]['subject_group_id'] : null;
                        } else {
                            // Fallback: Get subjects from timetable entries
                            $data['subjects'] = $this->get_subjects_from_timetable($class_id, $section_id);
                        }
                    } else {
                        // Fallback: Get subjects from timetable entries
                        $data['subjects'] = $this->get_subjects_from_timetable($class_id, $section_id);
                    }
                } else {
                    $data['subjects'] = array();
                }
                }
            }
        $menu_data['selected'] = 'show_timetable'; 
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
        $this->load->view('layout/header', $data);
        $this->load->view('admin/timetable/timetable_view', $data);
        $this->load->view('layout/footer', $data);
    }

    public function mytimetable()
    {
        if (!$this->rbac->hasPrivilege('teachers_time_table', 'can_view')) {
            access_denied();
        }

        $data['title'] = 'My Timetable';
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'Academics/timetable/mytimetable');
        $my_role  = $this->customlib->getStaffRole();
        $role     = json_decode($my_role);
        $is_admin = false;

        if ($role->id != "2") {
            $staff_list         = $this->staff_model->getStaffbyroles([1, 2, 4]);
            $data['staff_list'] = $staff_list;
            $is_admin           = true;
        }

        $staff_id          = $this->customlib->getStaffID();
        $data['timetable'] = array();
        $days              = $this->customlib->getDaysname();

        foreach ($days as $day_key => $day_value) {
            $data['timetable'][$day_value] = $this->subjecttimetable_model->getByStaffandDay($staff_id, $day_key);
        }

        $this->load->view('layout/header', $data);
        if ($is_admin) {
            $this->load->view('admin/timetable/admintimetable', $data);
        } else {
            $data['staff_id']=$staff_id;
            $this->load->view('admin/timetable/mytimetable', $data);
        }
        $this->load->view('layout/footer', $data);
    }

    public function view($id)
    {
        if (!$this->rbac->hasPrivilege('class_timetable', 'can_view')) {
            access_denied();
        }
        $data['title'] = $this->lang->line('mark_list');
        $mark          = $this->mark_model->get($id);
        $data['mark']  = $mark;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/timetable/timetableShow', $data);
        $this->load->view('layout/footer', $data);
    }

    public function delete($id)
    {
        $data['title'] = 'Mark List';
        $this->mark_model->remove($id);
        redirect('admin/timetable/index');
    }

    public function create()
    {
        if (!$this->rbac->hasPrivilege('class_timetable', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'Academics/timetable');

        $session            = $this->setting_model->getCurrentSession();
        $data['title']      = 'Exam Schedule';
        $data['subject_id'] = "";
        $data['class_id']   = "";
        $data['section_id'] = "";
        $exam               = $this->exam_model->get();
        $class              = $this->class_model->get('', $classteacher = 'yes');
        $data['examlist']   = $exam;
        $data['classlist']  = $class;
        $userdata           = $this->customlib->getUserData();
        $staff                   = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['staff']           = $staff;
        $data['subject']         = array();
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_group_id', $this->lang->line('subject_group'), 'trim|required|xss_clean');
        $class_id         = $this->input->post('class_id');
        $section_id       = $this->input->post('section_id');
        $subject_group_id = $this->input->post('subject_group_id');

        $data['class_id']         = $class_id;
        $data['section_id']       = $section_id;
        $data['subject_group_id'] = $subject_group_id;

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/timetable/timetableCreate', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $getDaysnameList         = $this->customlib->getDaysname();
            $data['getDaysnameList'] = $getDaysnameList;
            $subject                 = $this->subjectgroup_model->getGroupsubjects($subject_group_id);
            $data['subject']         = $subject;
            $this->load->view('layout/header', $data);
            $this->load->view('admin/timetable/timetableCreate', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    public function classreport()
    {
        if (!$this->rbac->hasPrivilege('class_timetable', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'Academics/timetable');
        $session                 = $this->setting_model->getCurrentSession();
        $data['title']           = 'Exam Schedule';
        $data['subject_id']      = "";
        $data['class_id']        = "";
        $data['section_id']      = "";
        $exam                    = $this->exam_model->get();
        $class                   = $this->class_model->get('', $classteacher = 'yes');
        $data['examlist']        = $exam;
        $data['classlist']       = $class;
        $userdata                = $this->customlib->getUserData();
        $staff                   = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['staff']           = $staff;
        $data['subject']         = array();

        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == true) {
            if (isset($_POST['search'])) {

                $class_id    = $this->input->post('class_id');
                $section_id  = $this->input->post('section_id');
                $days        = $this->customlib->getDaysname();
                $days_record = array();
                foreach ($days as $day_key => $day_value) {
                    $class_id              = $this->input->post('class_id');
                    $section_id            = $this->input->post('section_id');
                    $days_record[$day_key] = $this->subjecttimetable_model->getSubjectByClassandSectionDay($class_id, $section_id, $day_key);
                }

                $data['timetable'] = $days_record;
            }
        }

        $this->load->view('layout/header', $data);
        $this->load->view('admin/timetable/classreport', $data);
        $this->load->view('layout/footer', $data);
    }

    public function edit($id)
    {
        if (!$this->rbac->hasPrivilege('class_timetable', 'can_edit')) {
            access_denied();
        }
        $data['title'] = $this->lang->line('edit_mark');
        $data['id']    = $id;
        $mark          = $this->mark_model->get($id);
        $data['mark']  = $mark;
        $this->form_validation->set_rules('name', $this->lang->line('mark'), 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/timetable/timetableEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id'   => $id,
                'name' => $this->input->post('name'),
                'note' => $this->input->post('note'),
            );
            $this->mark_model->add($data);
            $this->session->set_flashdata('msg', '<div mark="alert alert-success text-center">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/timetable/index');
        }
    }

    public function getBydategroupclasssection()
    {
        $data                = array();
        $data['total_count'] = 1;
        $day                 = $this->input->post('day');
        $class_id            = $this->input->post('class_id');
        $section_id          = $this->input->post('section_id');
        $subject_group_id    = $this->input->post('subject_group_id');
        $subject             = $this->subjectgroup_model->getGroupsubjects($subject_group_id);

        // Check if timetable is generated (exists in class_timeline)
        $generated_timetable = $this->Generatetimetable_model->get_class_timetable($class_id, $section_id);
        $is_generated = !empty($generated_timetable);
        
        if ($is_generated) {
            // Load from generated timetable (class_timeline)
            $prev_record = $this->load_generated_timetable_for_day($class_id, $section_id, $day, $subject_group_id);
            $data['is_generated'] = true;
        } else {
            // Load from old timetable (subject_timetable)
            $prev_record = $this->subjecttimetable_model->getBySubjectGroupDayClassSection($subject_group_id, $day, $class_id, $section_id);
            $data['is_generated'] = false;
        }

        $staff         = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['staff'] = $staff;
        if (empty($prev_record)) {
            $data['prev_record'] = array();
        } else {
            $data['total_count'] = count($prev_record);
            $data['prev_record'] = $prev_record;
        }
        $data['subject']          = $subject;
        $data['day']              = $day;
        $data['class_id']         = $class_id;
        $data['section_id']       = $section_id;
        $data['subject_group_id'] = $subject_group_id;

        $data['html'] = $this->load->view('admin/timetable/addrow', $data, true);
        echo json_encode($data);
    }

    private function load_generated_timetable_for_day($class_id, $section_id, $day, $subject_group_id)
    {
        $this->load->model('Generatetimetable_model');
        $this->db->select('ct.id, ct.day, ct.time_from, ct.time_to, ct.period_id, ct.subject_id as subject_group_subject_id, 
                           ct.teacher_id as staff_id, ct.room_no, ct.start_time, ct.end_time,
                           subjects.name as subject_name, subjects.code');
        $this->db->from('class_timeline ct');
        $this->db->join('subject_group_subjects', 'subject_group_subjects.id = ct.subject_id', 'left');
        $this->db->join('subjects', 'subjects.id = subject_group_subjects.subject_id', 'left');
        $this->db->join('subject_group_class_sections', 'subject_group_class_sections.subject_group_id = subject_group_subjects.subject_group_id', 'left');
        $this->db->where('ct.class_id', $class_id);
        $this->db->where('ct.section_id', $section_id);
        $this->db->where('ct.day', $day);
        $this->db->where('subject_group_class_sections.subject_group_id', $subject_group_id);
        $this->db->where('ct.status', 1);
        $this->db->order_by('ct.period_id', 'asc');
        $query = $this->db->get();
        return $query->result();
    }

    private function get_subjects_from_timetable($class_id, $section_id)
    {
        // Get unique subjects from timetable entries
        $this->db->distinct();
        $this->db->select('ct.subject_id as id, subjects.name, subjects.code')
            ->from('class_timeline ct')
            ->join('subject_group_subjects sgs', 'sgs.id = ct.subject_id', 'left')
            ->join('subjects', 'subjects.id = sgs.subject_id', 'left')
            ->where('ct.class_id', $class_id)
            ->where('ct.section_id', $section_id)
            ->where('ct.status', 1)
            ->where('ct.subject_id >', 0)
            ->where('subjects.name IS NOT NULL', null, false)
            ->order_by('subjects.name', 'asc');
        $query = $this->db->get();
        return $query->result();
    }

    private function update_generated_timetable_subjects($update_array, $class_id, $section_id, $day)
    {
        $this->db->trans_start();
        $this->db->trans_strict(false);
        
        // Get subject names for Yoga validation
        $this->load->model('Generatetimetable_model');
        $allowed_yoga_periods = [2, 3, 6, 7];
        
        foreach ($update_array as $update_row) {
            // Get period_id for this record
            $period_record = $this->db->select('period_id, subject_id')
                ->from('class_timeline')
                ->where('id', $update_row['id'])
                ->get()
                ->row();
            
            if ($period_record) {
                $period_id = $period_record->period_id;
                
                // Get subject name
                $subject_info = $this->db->select('subjects.name')
                    ->from('subject_group_subjects')
                    ->join('subjects', 'subjects.id = subject_group_subjects.subject_id')
                    ->where('subject_group_subjects.id', $update_row['subject_group_subject_id'])
                    ->get()
                    ->row();
                
                if ($subject_info) {
                    $subject_name = strtolower(trim($subject_info->name));
                    
                    // Validate Yoga period restriction
                    if (strpos($subject_name, 'yoga') !== false) {
                        if (!in_array($period_id, $allowed_yoga_periods)) {
                            $this->db->trans_rollback();
                            return false; // Invalid period for Yoga
                        }
                        
                        // Check for duplicate Yoga in the same day
                        $this->db->select('COUNT(*) as count');
                        $this->db->from('class_timeline ct');
                        $this->db->join('subject_group_subjects sgs', 'sgs.id = ct.subject_id');
                        $this->db->join('subjects s', 's.id = sgs.subject_id');
                        $this->db->where('ct.class_id', $class_id);
                        $this->db->where('ct.section_id', $section_id);
                        $this->db->where('ct.day', $day);
                        $this->db->where("LOWER(s.name) LIKE '%yoga%'", null, false);
                        $this->db->where('ct.status', 1);
                        $this->db->where('ct.id !=', $update_row['id']);
                        $yoga_count = $this->db->get()->row()->count;
                        
                        if ($yoga_count > 0) {
                            $this->db->trans_rollback();
                            return false; // Already has Yoga in this day
                        }
                    }
                }
            }
            
            // Only update subject_id, keep period_id, time_from, time_to, teacher_id unchanged
            $this->db->where('id', $update_row['id']);
            $this->db->where('class_id', $class_id);
            $this->db->where('section_id', $section_id);
            $this->db->where('day', $day);
            $this->db->update('class_timeline', array(
                'subject_id' => $update_row['subject_group_subject_id']
            ));
        }
        
        $this->db->trans_complete();
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            return false;
        } else {
            $this->db->trans_commit();
            return true;
        }
    }

    public function savegroup()
    {
        $json = array();
        $this->form_validation->set_rules('subject_group_id', $this->lang->line('subject_group'), 'trim|required');
        $this->form_validation->set_rules('day', $this->lang->line('day'), 'trim|required');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required');
        $total_rows = $this->input->post('total_row');
        
        // Check if timetable is generated
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $generated_timetable = $this->Generatetimetable_model->get_class_timetable($class_id, $section_id);
        $is_generated = !empty($generated_timetable);

        if (isset($total_rows) && !empty($total_rows)) {

            foreach ($this->input->post('total_row') as $key => $value) {
                $this->form_validation->set_rules('subject_' . $value, 'Subject', 'trim|required');
                // For generated timetables, staff is not required (it's locked)
                if (!$is_generated) {
                    $this->form_validation->set_rules('staff_' . $value, 'Staff', 'trim|required');
                }
                // For generated timetables, time fields are not required (they're locked)
                if (!$is_generated) {
                    $this->form_validation->set_rules('time_from_' . $value, 'Time From', 'trim|required');
                    $this->form_validation->set_rules('time_to_' . $value, 'Time To', 'trim|required');
                }
                // $this->form_validation->set_rules('room_no_' . $value, 'Room No', 'trim|required');
            }
        }

        if (!$this->form_validation->run()) {
            $json = array(
                'subject_group_id' => form_error('subject_group_id', '<li>', '</li>'),
                'section_id'       => form_error('section_id', '<li>', '</li>'),
                'day'              => form_error('day', '<li>', '</li>'),
                'class_id'         => form_error('class_id', '<li>', '</li>'),
                'rows'             => form_error('rows', '<li>', '</li>'),
            );
            if (isset($total_rows) && !empty($total_rows)) {
                foreach ($this->input->post('total_row') as $key => $value) {
                    $json['subject_' . $value]   = form_error('subject_' . $value, '<li>', '</li>');
                    $json['staff_' . $value]     = form_error('staff_' . $value, '<li>', '</li>');
                    $json['time_from_' . $value] = form_error('time_from_' . $value, '<li>', '</li>');
                    $json['time_to_' . $value]   = form_error('time_to_' . $value, '<li>', '</li>');
                    // $json['room_no_' . $value]   = form_error('room_no_' . $value, '<li>', '</li>');
                }
            }

            $json_array = array('status' => '0', 'error' => $json);
        } else {
            $day              = $this->input->post('day');
            $class_id         = $this->input->post('class_id');
            $section_id       = $this->input->post('section_id');
            $subject_group_id = $this->input->post('subject_group_id');
            $total_row        = $this->input->post('total_row');
            $session          = $this->setting_model->getCurrentSession();
            $insert_array     = array();
            $update_array     = array();
            $old_input        = array();
            $prev_array       = $this->input->post('prev_array');
            if (isset($prev_array)) {
                foreach ($prev_array as $prev_arr_key => $prev_arr_value) {
                    $old_input[] = $prev_arr_value;
                }
            }
            $preserve_array = array();
            if (isset($total_row)) {
                foreach ($total_row as $total_key => $total_value) {
                    $prev_id = $this->input->post('prev_id_' . $total_value);

                    if ($prev_id == 0) {
                        $insert_array[] = array(
                            'day'                      => $day,
                            'class_id'                 => $class_id,
                            'section_id'               => $section_id,
                            'subject_group_id'         => $subject_group_id,
                            'subject_group_subject_id' => $this->input->post('subject_' . $total_value),
                            'staff_id'                 => $this->input->post('staff_' . $total_value),
                            'time_from'                => $this->input->post('time_from_' . $total_value),
                            'time_to'                  => $this->input->post('time_to_' . $total_value),
                            'start_time'               => $this->customlib->timeFormat($this->input->post('time_from_' . $total_value), true),
                            'end_time'                 => $this->customlib->timeFormat($this->input->post('time_to_' . $total_value), true),
                            'room_no'                  => $this->input->post('room_no_' . $total_value),
                            'session_id'               => $session,
                        );
                    } else {
                        $preserve_array[] = $prev_id;
                        $update_array[]   = array(
                            'id'                       => $prev_id,
                            'day'                      => $day,
                            'class_id'                 => $class_id,
                            'section_id'               => $section_id,
                            'subject_group_id'         => $subject_group_id,
                            'subject_group_subject_id' => $this->input->post('subject_' . $total_value),
                            'staff_id'                 => $this->input->post('staff_' . $total_value),
                            'time_from'                => $this->input->post('time_from_' . $total_value),
                            'time_to'                  => $this->input->post('time_to_' . $total_value),
                            'start_time'               => $this->customlib->timeFormat($this->input->post('time_from_' . $total_value), true),
                            'end_time'                 => $this->customlib->timeFormat($this->input->post('time_to_' . $total_value), true),
                            'room_no'                  => $this->input->post('room_no_' . $total_value),
                            'session_id'               => $session,
                        );
                    }
                }
            }

            $delete_array = array_diff($old_input, $preserve_array);

            // Check if timetable is generated - update class_timeline instead of subject_timetable
            if ($is_generated) {
                // Update only subject_id in class_timeline (other fields are locked)
                $result = $this->update_generated_timetable_subjects($update_array, $class_id, $section_id, $day);
            } else {
                // Update subject_timetable as before
                $result = $this->subjecttimetable_model->add($delete_array, $insert_array, $update_array);
            }
            
            if ($result) {
                $json_array = array('status' => '1', 'error' => '', 'message' => $this->lang->line('success_message'));
            } else {
                $json_array = array('status' => '2', 'error' => '', 'message' => $this->lang->line('something_went_wrong'));
            }
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($json_array));
    }

    public function getteachertimetable()
    {
        $json = array();
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('teacher', $this->lang->line('teacher'), 'trim|required');

        if (!$this->form_validation->run()) {
            $json = array(
                'teacher' => form_error('teacher'),
            );

            $json_array = array('status' => '0', 'error' => $json);
        } else {
            $staff_id          = $this->input->post('teacher');
            $data['timetable'] = array();
            $data['staff_id'] = $staff_id;

            $days              = $this->customlib->getDaysname();

            foreach ($days as $day_key => $day_value) {
                $data['timetable'][$day_value] = $this->subjecttimetable_model->getByStaffandDay($staff_id, $day_key);
            }

            $timetable_page = $this->load->view('admin/timetable/_partialgetteachertimetable', $data, true);
            $json_array = array('status' => '1', 'error' => '', 'message' => $timetable_page);
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($json_array));
    }


    public function printclasstimetable()
    {


        $class_id    = $this->input->post('class_id');
        $section_id  = $this->input->post('section_id');
        $days        = $this->customlib->getDaysname();
        $class_section=$this->section_model->getClassAndSectionNameByClassIDSectionID($class_id, $section_id);
        $data['class_section']=$class_section;
        $days_record = array();
        foreach ($days as $day_key => $day_value) {

            $days_record[$day_key] = $this->subjecttimetable_model->getSubjectByClassandSectionDay($class_id, $section_id, $day_key);
        }
        $data['timetable']=$days_record;
        $timetable_page = $this->load->view('admin/timetable/_printclasstimetable', $data, true);
        $json_array = array('status' => '1', 'error' => '', 'page' => $timetable_page);
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($json_array));
    }


    public function printteachertimetable()
    {

        $staff_id          = $this->input->post('staff_id');
        $staff = $this->staff_model->get($staff_id);
        $data['staff'] = $staff;
        $data['timetable'] = array();
        $days              = $this->customlib->getDaysname();

        foreach ($days as $day_key => $day_value) {
            $data['timetable'][$day_value] = $this->subjecttimetable_model->getByStaffandDay($staff_id, $day_key);
        }

        $timetable_page = $this->load->view('admin/timetable/_printteachertimetable', $data, true);
        $json_array = array('status' => '1', 'error' => '', 'page' => $timetable_page);
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($json_array));
    }

    public function update_timetable_subject()
    {
        $json = array();
        $this->form_validation->set_rules('timetable_id', 'Timetable ID', 'trim|required|numeric');
        $this->form_validation->set_rules('subject_id', 'Subject', 'trim|required|numeric');
        $this->form_validation->set_rules('day', 'Day', 'trim|required');
        $this->form_validation->set_rules('period_id', 'Period', 'trim|required|numeric');
        $this->form_validation->set_rules('class_id', 'Class', 'trim|required|numeric');
        $this->form_validation->set_rules('section_id', 'Section', 'trim|required|numeric');

        if (!$this->form_validation->run()) {
            $json_array = array('status' => '0', 'error' => validation_errors());
        } else {
            $timetable_id = $this->input->post('timetable_id');
            $subject_id = $this->input->post('subject_id');
            $day = $this->input->post('day');
            $period_id = $this->input->post('period_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');

            // Validate Yoga period restriction
            $subject_info = $this->db->select('subjects.name')
                ->from('subject_group_subjects')
                ->join('subjects', 'subjects.id = subject_group_subjects.subject_id')
                ->where('subject_group_subjects.id', $subject_id)
                ->get()
                ->row();

            if ($subject_info) {
                $subject_name = strtolower(trim($subject_info->name));
                $allowed_yoga_periods = [2, 3, 6, 7];

                if (strpos($subject_name, 'yoga') !== false) {
                    if (!in_array($period_id, $allowed_yoga_periods)) {
                        $json_array = array('status' => '0', 'error' => 'Yoga can only be assigned in Periods 2, 3, 6, or 7.');
                        $this->output->set_content_type('application/json')->set_output(json_encode($json_array));
                        return;
                    }

                    // Check for duplicate Yoga in the same day
                    $yoga_count = $this->db->select('COUNT(*) as count')
                        ->from('class_timeline ct')
                        ->join('subject_group_subjects sgs', 'sgs.id = ct.subject_id')
                        ->join('subjects s', 's.id = sgs.subject_id')
                        ->where('ct.class_id', $class_id)
                        ->where('ct.section_id', $section_id)
                        ->where('ct.day', $day)
                        ->where("LOWER(s.name) LIKE '%yoga%'", null, false)
                        ->where('ct.status', 1)
                        ->where('ct.id !=', $timetable_id)
                        ->get()
                        ->row()->count;

                    if ($yoga_count > 0) {
                        $json_array = array('status' => '0', 'error' => 'Only one Yoga period should be allotted per day.');
                        $this->output->set_content_type('application/json')->set_output(json_encode($json_array));
                        return;
                    }
                }
            }

            // Update only subject_id
            $this->db->where('id', $timetable_id);
            $this->db->where('class_id', $class_id);
            $this->db->where('section_id', $section_id);
            $this->db->where('day', $day);
            $this->db->where('period_id', $period_id);
            $result = $this->db->update('class_timeline', array('subject_id' => $subject_id));

            if ($result) {
                $json_array = array('status' => '1', 'error' => '', 'message' => 'Subject updated successfully.');
            } else {
                $json_array = array('status' => '0', 'error' => 'Failed to update subject.');
            }
        }

            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($json_array));
    }

    public function get_subjects_for_class_section()
    {
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $session = $this->setting_model->getCurrentSession();
        
        $subjects = array();
        if ($class_id && $section_id) {
            $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);
            if ($dt) {
                $subject_groups = $this->db->select('subject_group_class_sections.subject_group_id')
                    ->from('subject_group_class_sections')
                    ->where('subject_group_class_sections.class_section_id', $dt['id'])
                    ->where('subject_group_class_sections.session_id', $session)
                    ->get()
                    ->result_array();
                
                $all_subjects = array();
                if (!empty($subject_groups)) {
                    foreach ($subject_groups as $group) {
                        $group_subjects = $this->subjectgroup_model->getGroupsubjects($group['subject_group_id'], $session);
                        if (!empty($group_subjects)) {
                            foreach ($group_subjects as $subj) {
                                $subj_id = is_object($subj) ? $subj->id : (isset($subj['id']) ? $subj['id'] : '');
                                if ($subj_id && !isset($all_subjects[$subj_id])) {
                                    $all_subjects[$subj_id] = $subj;
                                }
                            }
                        }
                    }
                    $subjects = array_values($all_subjects);
                } else {
                    // Fallback: Get subjects from timetable
                    $subjects = $this->get_subjects_from_timetable($class_id, $section_id);
                }
            } else {
                // Fallback: Get subjects from timetable
                $subjects = $this->get_subjects_from_timetable($class_id, $section_id);
            }
        }
        
        // Convert to array format for JSON
        $subjects_array = array();
        foreach ($subjects as $subj) {
            $subj_id = is_object($subj) ? $subj->id : (isset($subj['id']) ? $subj['id'] : '');
            $subj_name = is_object($subj) ? $subj->name : (isset($subj['name']) ? $subj['name'] : '');
            $subj_code = is_object($subj) ? (isset($subj->code) ? $subj->code : '') : (isset($subj['code']) ? $subj['code'] : '');
            if ($subj_id && $subj_name) {
                $subjects_array[] = array(
                    'id' => $subj_id,
                    'name' => $subj_name,
                    'code' => $subj_code
                );
            }
        }
        
        $json_array = array('status' => '1', 'subjects' => $subjects_array);
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($json_array));
    }
}
