<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Teacher extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('mailsmsconf');
        $this->load->model("classteacher_model");
        $this->load->model("class_model");
        $this->load->model("section_model");
        $this->load->model("subjectgroup_model");
        $this->load->model("Generatetimetable_model");
        $this->role;
        $this->current_session = $this->setting_model->getCurrentSession();
    }

    public function index()
    {
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'teacher/index');
        $data['title'] = 'Add Teacher';
        $data['teacherlist'] = $this->teacher_model->get();
        $data['genderList'] = $this->customlib->getGender();
        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/teacherList', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getSubjctByClassandSection()
    {
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $data = $this->teachersubject_model->getSubjectByClsandSection($class_id, $section_id);
        echo json_encode($data);
    }

    public function assignteacher()
    {
        if (!$this->rbac->hasPrivilege('assignteacher', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Academics');

        $this->session->set_userdata('sub_menu', 'admin/teacher/viewassignteacher');

        $data['title'] = 'Assign Teacher with Class and Subject wise';



        $teacher = $this->staff_model->getStaffbyroles([1, 2, 4]);

        $data['teacherlist'] = $teacher;

        $subject = $this->subject_model->get();

        $data['subjectlist'] = $subject;

        $class = $this->class_model->get();

        $data['classlist'] = $class;

        $userdata = $this->customlib->getUserData();



        $this->load->view('layout/header', $data);

        $this->load->view('admin/teacher/assignTeacher', $data);

        $this->load->view('layout/footer', $data);

        if ($this->input->server('REQUEST_METHOD') == "POST") {

            $loop = $this->input->post('i');

            $array = array();

            $dt = array();



            foreach ($loop as $key => $value) {

                $s = array();

                $s['session_id'] = $this->setting_model->getCurrentSession();

                $class_id = $this->input->post('class_id');

                $section_id = $this->input->post('section_id');

                $dt = $this->classsection_model->getDetailbyClassSection($class_id, $section_id);



                $s['class_section_id'] = $dt['id'];

                $s['teacher_id'] = $this->input->post('teacher_id_' . $value);

                $s['subject_id'] = $this->input->post('subject_id_' . $value);

                $row_id = $this->input->post('row_id_' . $value);

                if ($row_id == 0) {

                    $insert_id = $this->teachersubject_model->add($s);

                    $array[] = $insert_id;

                } else {

                    $s['id'] = $row_id;

                    $array[] = $row_id;

                    $this->teachersubject_model->add($s);

                }

            }



            $ids = $array;

            $class_section_id = $dt['id'];

            $this->teachersubject_model->deleteBatch($ids, $class_section_id);

            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');

            redirect('admin/teacher/assignteacher');

        }

    }

    // timetable start here 

    public function generate_timetable()
    {
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/class_subject_periods');
        $data['title'] = 'Assign Class Subject Counts';
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');

        if ($this->form_validation->run()) {

            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $subject_group_id = $this->input->post('subject_group_id');
            $data['class_post'] = $class_id;
            $data['section_post'] = $section_id;
            $data['subject_group_id'] = $subject_group_id;

            $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);
            $subjects = $this->teachersubject_model->getClassSectionSubjectgroupSubjects($dt['id'], $subject_group_id);
            $class_week_periods = $this->teachersubject_model->getWeekPeriodsForClass($dt['id']);
            // print_r($subjects); die();


            $data['subjects'] = $subjects;
            $data['class_week_periods'] = $class_week_periods['periods'];

        }
        $menu_data['selected'] = 'generate_timetable';
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/generate_timetable', $data);
        $this->load->view('layout/footer', $data);
    }
    //  public function savetimeline()
    // {
    //     $class_id = $this->input->post('class_id');
    //     $section_id = $this->input->post('section_id'); 
    //     $subjectPeriods = $this->Generatetimetable_model->get_subject_weekly_periods($section_id);
    //     $timingConfig   = $this->Generatetimetable_model->get_school_timing_config();
    //     $shortBreakId   = $this->Generatetimetable_model->get_short_break_subject_id();
    //     $lunchBreakId   = $this->Generatetimetable_model->get_lunch_break_subject_id();

    //     $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    //     $daily_slots = 6; // 8 periods/day - 2 breaks = 6 subject periods/day
    //     $totalSlots = $daily_slots * count($days);

    //     // Flatten subject IDs by weekly count
    //     $subject_slots = [];
    //     foreach ($subjectPeriods as $row) {
    //         if (!empty($row->subject_group_subject_id) && $row->subject_group_subject_id > 0) {
    //             for ($i = 0; $i < $row->periods; $i++) {
    //                 $subject_slots[] = $row->subject_group_subject_id;
    //             }
    //         }
    //     }


    //     shuffle($subject_slots); // random order

    //     $this->Generatetimetable_model->delete_existing_timetable($class_id, $section_id);

    //     $timetable = [];
    //     $slotIndex = 0;

    //     foreach ($days as $dayIndex => $day) {
    //         for ($period = 1; $period <= 8; $period++) {
    //             if ($period == 3) {
    //                 $subject_id = $shortBreakId;
    //             } elseif ($period == 6) {
    //                 $subject_id = $lunchBreakId;
    //             } else {
    //                 if (isset($subject_slots[$slotIndex])) {
    //                     $subject_id = $subject_slots[$slotIndex];
    //                     $slotIndex++;
    //                 } else {
    //                     // If all subjects used, fallback or skip
    //                     $subject_id = 0; // or you could break here
    //                 }
    //             }

    //             $raw_time_from = $this->Generatetimetable_model->get_period_time($period, 'from', $timingConfig);
    //             $raw_time_to   = $this->Generatetimetable_model->get_period_time($period, 'to', $timingConfig);

    //             $time_from = date("h:i A", strtotime($raw_time_from));
    //             $time_to   = date("h:i A", strtotime($raw_time_to));

    //             $timetable[] = [
    //                 'class_id'   => $class_id,
    //                 'section_id' => $section_id,
    //                 'day'        => $day, 
    //                 'period_id'  => $period,
    //                 'subject_id' => $subject_id,
    //                 'time_from'  => $time_from,
    //                 'time_to'    => $time_to,
    //                 'status'     => 1,
    //             ];
    //         }
    //     }


    //     $this->Generatetimetable_model->save_timetable($timetable);


    //     echo json_encode(['status' => true, 'message' => 'Timetable generated successfully.']);
    // }


    // public function savetimeline()
    // {
    //     // error_reporting(E_ALL);
    //     // ini_set('display_errors', 1);
    //     $class_id = $this->input->post('class_id');
    //     $section_id = $this->input->post('section_id');
    //     $session = $this->setting_model->getCurrentSession();


    //     $subjectPeriods = $this->Generatetimetable_model->get_subject_weekly_periods($section_id);


    //     $timingConfig = $this->Generatetimetable_model->get_school_timing_config();
    //     $shortBreakId = $this->Generatetimetable_model->get_short_break_subject_id();
    //     $lunchBreakId = $this->Generatetimetable_model->get_lunch_break_subject_id();

    //     $class_teacher = $this->classteacher_model->getteacherByClassSectionNew($class_id, $section_id);

    //     $class_teacher_subject_id = $this->Generatetimetable_model->get_classteacher_subject($class_teacher->id, $section_id, $session);
    //     $fixed_subject_id = $class_teacher_subject_id->id ?? 0;


    //     $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    //     $total_periods = 10;

    //     $daily_mandatory_subjects = [];
    //     $subject_total_counts = [];
    //     $total_weekly_periods = 48;
    //     $current_total = 0;
    //     $subject_slots = [];

    //     $sportsId = $this->Generatetimetable_model->get_subject_ids_by_names(['Sports']);
    //     if(empty($sportsId)){

    //         $sportsId = [];

    //     }
    //     $yogaId = $this->Generatetimetable_model->get_subject_ids_by_names(['YOGA']);
    //     if(empty($yogaId)){

    //         $yogaId = [];

    //     }
    //     $activityId = $this->Generatetimetable_model->get_subject_ids_by_names(['Activity']);
    //     if(empty($activityId)){

    //         $activityId = [];

    //     }

    //     $restricted_subjects = ['MUSIC', 'Robotics', 'ARTS', 'Library'];
    //     $restricted_subject_ids = $this->Generatetimetable_model->get_subject_ids_by_names($restricted_subjects);
    //     if(empty($restricted_subject_ids)){

    //         $restricted_subject_ids = [];

    //     }

    //     // print_r($subjectPeriods); die();

    //     foreach ($subjectPeriods as $row) {
    //         if ($row->periods > 0) {
    //             $sid = (int)$row->subject_group_subject_id;
    //             if ($sid <= 0) continue;
    //             if (in_array($sid, [$shortBreakId, $lunchBreakId, $fixed_subject_id])) continue;

    //             $subject_total_counts[$sid] = $row->periods;
    //             $current_total += $row->periods;
    //             for ($i = 0; $i < $row->periods; $i++) {
    //                 $subject_slots[] = $sid;
    //             }
    //             if ($row->periods >= 6) {
    //                 $daily_mandatory_subjects[] = $sid;
    //             }
    //         }
    //     }



    //     $this->Generatetimetable_model->delete_existing_timetable($class_id, $section_id);

    //     $repeatable_subjects = [];
    //     $non_repeatable_subjects = [];

    //     foreach ($subjectPeriods as $subject) {
    //         $sid = $subject->subject_group_subject_id;
    //         $count = (int)$subject->periods;
    //         if ($count >= 7) {
    //             $repeatable_subjects[$sid] = $count;
    //         } elseif ($count <= 6 && $count > 0) {
    //             $non_repeatable_subjects[$sid] = $count;
    //         }
    //     }

    //     $weekly_subject_usage = array_fill_keys(array_keys($subject_total_counts), 0);

    //     $deferred_subjects_by_day = [];

    //     $subject_teacher_map = [];
    //     $subject_teachers = $this->db->select('teacher_subjects.teacher_id, subject_group_subjects.id as subject_id')
    //         ->from('teacher_subjects')
    //         ->join('subject_group_subjects', 'subject_group_subjects.subject_id = teacher_subjects.subject_id')
    //         ->where('teacher_subjects.class_section_id', $section_id)
    //         ->where('teacher_subjects.session_id', $this->current_session)
    //         ->get()
    //         ->result_array();

    //     foreach ($subject_teachers as $row) {
    //         $subject_teacher_map[$row['subject_id']] = $row['teacher_id'];
    //     }

    //     $period_durations = [
    //         1 => $timingConfig->first_period ?? 40,
    //         2 => $timingConfig->second_period ?? 40,
    //         3 => $timingConfig->third_period ?? 40,
    //         4 => 0,
    //         5 => $timingConfig->fourth_period ?? 40,
    //         6 => $timingConfig->fifth_period ?? 40,
    //         7 => $timingConfig->sixth_period ?? 40,
    //         8 => 0,
    //         9 => $timingConfig->seventh_period ?? 40,
    //         10 => $timingConfig->eight_period ?? 40,
    //     ];

    //     $timetable = [];

    //     $class_teacher_first_period_count = 0;
    //     $max_class_teacher_first_periods = min($non_repeatable_subjects[$fixed_subject_id] ?? 0, 6);


    //     foreach ($days as $dayIndex => $day) {
    //         $daily_subject_usage = [];
    //         $current_time = strtotime($timingConfig->school_start_time);

    //         for ($period = 1; $period <= $total_periods; $period++) {
    //             $from_time = '';
    //             $to_time = '';
    //             $subject_id = 0;

    //             if ($period == 4) {
    //                 $subject_id = $lunchBreakId;
    //                 $from_time = $timingConfig->lunch_break_start_time;
    //                 $to_time = $timingConfig->lunch_break_end_time;
    //                 $current_time = strtotime($to_time);
    //             } elseif ($period == 8) {
    //                 $subject_id = $shortBreakId;
    //                 $from_time = $timingConfig->short_break_start_time;
    //                 $to_time = $timingConfig->short_break_end_time;
    //                 $current_time = strtotime($to_time);
    //             } elseif ($period == 1) {
    //                 $from_time = date("H:i", $current_time);
    //                 $duration = $period_durations[$period] ?? 40;
    //                 $to_time = date("H:i", strtotime("+{$duration} minutes", $current_time));

    //                 if ($class_teacher_first_period_count < $max_class_teacher_first_periods) {
    //                     // Assign class teacher's subject
    //                     $subject_id = $fixed_subject_id;
    //                     $class_teacher_first_period_count++;
    //                 } else {
    //                     // Assign alternate subject (excluding restricted/yoga/sports/activity)
    //                     $available_subjects = array_diff(
    //                         array_keys($subject_total_counts),
    //                         array_merge($restricted_subject_ids, $yogaId, $sportsId, $activityId, [$fixed_subject_id])
    //                     );
    //                     shuffle($available_subjects);
    //                     foreach ($available_subjects as $sid) {
    //                         $used_week = $weekly_subject_usage[$sid] ?? 0;
    //                         $used_today = $daily_subject_usage[$sid] ?? 0;
    //                         if ($used_week < $subject_total_counts[$sid] &&
    //                             (!isset($non_repeatable_subjects[$sid]) || $used_today < 1)) {
    //                             $subject_id = $sid;
    //                             break;
    //                         }
    //                     }
    //                 }

    //                 if ($subject_id) {
    //                     $weekly_subject_usage[$subject_id] = ($weekly_subject_usage[$subject_id] ?? 0) + 1;
    //                     $daily_subject_usage[$subject_id] = ($daily_subject_usage[$subject_id] ?? 0) + 1;
    //                 }

    //                 $current_time = strtotime($to_time);
    //             } else {
    //                 $available_subjects = [];

    //                 if (!empty($deferred_subjects_by_day[$dayIndex])) {
    //                     foreach ($deferred_subjects_by_day[$dayIndex] as $key => $sid) {
    //                         $used_week = $weekly_subject_usage[$sid] ?? 0;
    //                         $used_today = $daily_subject_usage[$sid] ?? 0;

    //                         if ($used_week < $subject_total_counts[$sid] &&
    //                             (!isset($non_repeatable_subjects[$sid]) || $used_today < 1)) {
    //                             $available_subjects[] = $sid;
    //                             unset($deferred_subjects_by_day[$dayIndex][$key]);
    //                         }
    //                     }
    //                 }

    //                 foreach ($daily_mandatory_subjects as $mand_subject) {
    //                     if (empty($daily_subject_usage[$mand_subject]) &&
    //                         ($weekly_subject_usage[$mand_subject] ?? 0) < $subject_total_counts[$mand_subject]) {
    //                         $available_subjects[] = $mand_subject;
    //                     }
    //                 }

    //                 foreach ($subject_total_counts as $sid => $total_allowed) {
    //                     $used_week = $weekly_subject_usage[$sid] ?? 0;
    //                     $used_today = $daily_subject_usage[$sid] ?? 0;

    //                     if ($used_week >= $total_allowed) continue;

    //                     if (isset($non_repeatable_subjects[$sid]) && $used_today >= 1) {
    //                         $deferred_subjects_by_day[$dayIndex + 1][] = $sid;
    //                         continue;
    //                     }

    //                     $available_subjects[] = $sid;
    //                 }

    //                 if (empty($available_subjects)) {
    //                     foreach ($subject_total_counts as $sid => $total_allowed) {
    //                         $used_week = $weekly_subject_usage[$sid] ?? 0;
    //                         if ($used_week < $total_allowed) {
    //                             $available_subjects[] = $sid;
    //                         }
    //                     }
    //                 }

    //                 if (!empty($available_subjects)) {
    //                     shuffle($available_subjects);
    //                     foreach ($available_subjects as $sid) {
    //                         $valid = true;

    //                         if (
    //                             in_array($sid, $sportsId)
    //                              &&
    //                             in_array($period, [1, 5, 8, 9, 10])
    //                         ) $valid = false;

    //                         if (
    //                             in_array($sid, $yogaId)
    //                              &&
    //                             in_array($period, [1, 5, 9, 10])
    //                         ) $valid = false;

    //                         if (
    //                             in_array($sid, $restricted_subject_ids) &&
    //                             isset($non_repeatable_subjects[$fixed_subject_id]) &&
    //                             $subject_total_counts[$fixed_subject_id] < 6
    //                         ) {
    //                             if (in_array($period, [9, 10])) $valid = false;
    //                         }

    //                         if (
    //                             in_array($sid, $activityId)
    //                              &&
    //                             (
    //                                 (
    //                                     in_array($class_id, [38, 39, 40]) &&
    //                                     in_array($day, ['Thursday', 'Friday', 'Saturday']) &&
    //                                     in_array($period, [9, 10])
    //                                 ) ||
    //                                 (
    //                                     in_array($class_id, [41, 43, 23]) &&
    //                                     in_array($day, ['Monday', 'Tuesday', 'Wednesday']) &&
    //                                     in_array($period, [9, 10])
    //                                 )
    //                             )
    //                         ) {
    //                             // valid activity slot
    //                         } elseif (in_array($sid, $activityId)) {
    //                             $valid = false;
    //                         }

    //                         if ($valid) {
    //                             $subject_id = $sid;
    //                             break;
    //                         }
    //                     }

    //                     if ($subject_id) {
    //                         $weekly_subject_usage[$subject_id] = ($weekly_subject_usage[$subject_id] ?? 0) + 1;
    //                         $daily_subject_usage[$subject_id] = ($daily_subject_usage[$subject_id] ?? 0) + 1;
    //                     }
    //                 }

    //                 $from_time = date("H:i", $current_time);
    //                 $duration = $period_durations[$period] ?? 40;
    //                 $current_time += $duration * 60;
    //                 $to_time = date("H:i", $current_time);
    //             }

    //             $timetable[] = [
    //                 'class_id' => $class_id,
    //                 'section_id' => $section_id,
    //                 'day' => $day,
    //                 'period_id' => $period,
    //                 'subject_id' => $subject_id,
    //                 'teacher_id' => $subject_teacher_map[$subject_id],
    //                 'time_from' => date("h:i A", strtotime($from_time)),
    //                 'time_to' => date("h:i A", strtotime($to_time)),
    //                 'status' => 1,
    //             ];
    //         }
    //     }

    //     $this->Generatetimetable_model->save_timetable($timetable);
    //     echo json_encode(['status' => true, 'message' => 'Timetable generated successfully.']);
    // }


    public function savetimeline()
    {
        // error_reporting(E_ALL);
        // ini_set('display_errors', 1);
        // Debug start
        log_message('debug', '==== STARTING TIMETABLE GENERATION ====');

        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $session = $this->setting_model->getCurrentSession();
        $this->current_session = $session;

        log_message('debug', "Input Received: class_id=$class_id, section_id=$section_id, session=$session");

        $subjectPeriods = $this->Generatetimetable_model->get_subject_weekly_periods($section_id);
        log_message('debug', 'Subject Periods: ' . print_r($subjectPeriods, true));

        $timingConfig = $this->Generatetimetable_model->get_school_timing_config();
        log_message('debug', 'Timing Config: ' . print_r($timingConfig, true));

        $shortBreakId = $this->Generatetimetable_model->get_short_break_subject_id();
        $lunchBreakId = $this->Generatetimetable_model->get_lunch_break_subject_id();

        log_message('debug', "Short Break ID: $shortBreakId, Lunch Break ID: $lunchBreakId");

        $class_teacher = $this->classteacher_model->getteacherByClassSectionNew($class_id, $section_id);
        log_message('debug', 'Class Teacher: ' . print_r($class_teacher, true));

        $class_teacher_subject_id = $this->Generatetimetable_model->get_classteacher_subject($class_teacher->id, $section_id, $session);


        log_message('debug', 'Class Teacher Subject ID: ' . print_r($class_teacher_subject_id, true));

        $fixed_subject_id = $class_teacher_subject_id->id ?? 0;

        $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
        $total_periods = 10;

        $daily_mandatory_subjects = [];
        $subject_total_counts = [];
        $subject_slots = [];

        $sportsId = $this->Generatetimetable_model->get_subject_ids_by_names(['Sports']);
        if (empty($sportsId)) {

            $sportsId = [];

        }
        $yogaId = $this->Generatetimetable_model->get_subject_ids_by_names(['YOGA']);
        if (empty($yogaId)) {

            $yogaId = [];

        }
        $activityId = $this->Generatetimetable_model->get_subject_ids_by_names(['Activity']);
        if (empty($activityId)) {

            $activityId = [];

        }

        $restricted_subjects = ['MUSIC', 'Robotics', 'ARTS', 'Library'];
        $restricted_subject_ids = $this->Generatetimetable_model->get_subject_ids_by_names($restricted_subjects);
        if (empty($restricted_subject_ids)) {

            $restricted_subject_ids = [];

        }

        // $sportsId = $this->Generatetimetable_model->get_subject_ids_by_names(['Sport']);
        // $yogaId = $this->Generatetimetable_model->get_subject_ids_by_names(['Sanskrit']);
        // $activityId = $this->Generatetimetable_model->get_subject_ids_by_names(['Physical education']);
        // $restricted_subjects = ['MUSIC', 'Robotics', 'ARTS', 'Library'];
        // $restricted_subject_ids = $this->Generatetimetable_model->get_subject_ids_by_names($restricted_subjects);

        log_message('debug', 'Sports ID: ' . print_r($sportsId, true));
        log_message('debug', 'Yoga ID: ' . print_r($yogaId, true));
        log_message('debug', 'Activity ID: ' . print_r($activityId, true));
        log_message('debug', 'Restricted IDs: ' . print_r($restricted_subject_ids, true));

        foreach ($subjectPeriods as $row) {
            if ($row->periods > 0) {
                $sid = (int) $row->subject_group_subject_id;
                if ($sid <= 0)
                    continue;
                if (in_array($sid, [$shortBreakId, $lunchBreakId]))
                    continue;

                $subject_total_counts[$sid] = $row->periods;
                for ($i = 0; $i < $row->periods; $i++) {
                    $subject_slots[] = $sid;
                }
                if ($row->periods >= 6) {
                    $daily_mandatory_subjects[] = $sid;
                }
            }
        }

        // print_r($daily_mandatory_subjects); die;

        log_message('debug', 'Subject Total Counts: ' . print_r($subject_total_counts, true));
        log_message('debug', 'Daily Mandatory Subjects: ' . print_r($daily_mandatory_subjects, true));

        $this->Generatetimetable_model->delete_existing_timetable($class_id, $section_id);
        log_message('debug', "Existing timetable deleted for class_id=$class_id, section_id=$section_id");



        $repeatable_subjects = [];
        $non_repeatable_subjects = [];

        foreach ($subjectPeriods as $subject) {
            $sid = $subject->subject_group_subject_id;
            $count = (int) $subject->periods;
            if ($count >= 7) {
                $repeatable_subjects[$sid] = $count;
            } elseif ($count <= 6 && $count > 0) {
                $non_repeatable_subjects[$sid] = $count;
            }
        }

        log_message('debug', 'Repeatable Subjects: ' . print_r($repeatable_subjects, true));
        log_message('debug', 'Non-Repeatable Subjects: ' . print_r($non_repeatable_subjects, true));

        $weekly_subject_usage = array_fill_keys(array_keys($subject_total_counts), 0);
        $deferred_subjects_by_day = [];

        $subject_teacher_map = [];
        $subject_teachers = $this->db->select('teacher_subjects.teacher_id, subject_group_subjects.id as subject_id')
            ->from('teacher_subjects')
            ->join('subject_group_subjects', 'subject_group_subjects.subject_id = teacher_subjects.subject_id')
            ->where('teacher_subjects.class_section_id', $section_id)
            ->where('teacher_subjects.session_id', $this->current_session)
            ->where('subject_group_subjects.session_id', $this->current_session)
            ->get()
            ->result_array();

        foreach ($subject_teachers as $row) {
            $subject_teacher_map[$row['subject_id']] = $row['teacher_id'];
        }

        // print_r($subject_teacher_map); die();

        log_message('debug', 'Subject-Teacher Map: ' . print_r($subject_teacher_map, true));

        $period_durations = [
            1 => $timingConfig->first_period ?? 40,
            2 => $timingConfig->second_period ?? 40,
            3 => $timingConfig->third_period ?? 40,
            4 => 0,
            5 => $timingConfig->fourth_period ?? 40,
            6 => $timingConfig->fifth_period ?? 40,
            7 => $timingConfig->sixth_period ?? 40,
            8 => 0,
            9 => $timingConfig->seventh_period ?? 40,
            10 => $timingConfig->eight_period ?? 40,
        ];

        log_message('debug', 'Period Durations: ' . print_r($period_durations, true));

        $existing_timetables = $this->db->select('day, period_id, teacher_id')
            ->from('class_timeline')
            ->where('status', 1) // Optional: only active
            ->get()
            ->result_array();

        $teacher_schedule = [];

        foreach ($existing_timetables as $row) {
            $day = $row['day'];
            $period = $row['period_id'];
            $teacher_id = $row['teacher_id'];

            // Populate conflict map
            $teacher_schedule[$day][$period][$teacher_id] = true;
        }


        $timetable = [];
        $subject_daily_distribution = [];

        $class_teacher_first_period_count = 0;
        $class_teacher_first_period_days = [];
        $max_class_teacher_first_periods = min($subject_total_counts[$fixed_subject_id] ?? 0, 6);


        foreach ($days as $dayIndex => $day) {
            log_message('debug', "=== Generating Timetable for $day ===");
            $daily_subject_usage = [];
            $current_time = strtotime($timingConfig->school_start_time);

            for ($period = 1; $period <= $total_periods; $period++) {
                $from_time = '';
                $to_time = '';
                $subject_id = 0;

                // Fixed periods
                if ($period == 4) {
                    $subject_id = $lunchBreakId;
                    $from_time = $timingConfig->lunch_break_start_time;
                    $to_time = $timingConfig->lunch_break_end_time;
                    $current_time = strtotime($to_time);
                } elseif ($period == 8) {
                    $subject_id = $shortBreakId;
                    $from_time = $timingConfig->short_break_start_time;
                    $to_time = $timingConfig->short_break_end_time;
                    $current_time = strtotime($to_time);
                } elseif ($period == 1) {
                    $from_time = date("H:i", $current_time);
                    $duration = $period_durations[$period] ?? 40;
                    $to_time = date("H:i", strtotime("+{$duration} minutes", $current_time));

                    if (
                        $class_teacher_first_period_count < $max_class_teacher_first_periods &&
                        !in_array($day, $class_teacher_first_period_days) &&
                        ($weekly_subject_usage[$fixed_subject_id] ?? 0) < ($subject_total_counts[$fixed_subject_id] ?? 0)
                    ) {
                        // Assign class teacher subject ONLY in first period of 6 different days
                        $subject_id = $fixed_subject_id;
                        $class_teacher_first_period_count++;
                        $class_teacher_first_period_days[] = $day;
                    } else {
                        // Assign alternate subject (excluding restricted/yoga/sports/activity/class_teacher_subject)
                        $available_subjects = array_diff(
                            array_keys($subject_total_counts),
                            array_merge($restricted_subject_ids, $yogaId, $sportsId, $activityId, [$fixed_subject_id])
                        );
                        shuffle($available_subjects);
                        foreach ($available_subjects as $sid) {
                            $used_week = $weekly_subject_usage[$sid] ?? 0;
                            $used_today = $daily_subject_usage[$sid] ?? 0;
                            if (
                                $used_week < $subject_total_counts[$sid] &&
                                (!isset($non_repeatable_subjects[$sid]) || $used_today < 1)
                            ) {
                                $subject_id = $sid;
                                break;
                            }
                        }
                    }

                    if ($subject_id) {
                        $weekly_subject_usage[$subject_id] = ($weekly_subject_usage[$subject_id] ?? 0) + 1;
                        $daily_subject_usage[$subject_id] = ($daily_subject_usage[$subject_id] ?? 0) + 1;
                    }

                    $current_time = strtotime($to_time);
                } else {
                    // Subject assignment logic
                    $available_subjects = [];

                    if (!empty($deferred_subjects_by_day[$dayIndex])) {
                        foreach ($deferred_subjects_by_day[$dayIndex] as $key => $sid) {
                            if (
                                ($weekly_subject_usage[$sid] ?? 0) < $subject_total_counts[$sid] &&
                                (!isset($non_repeatable_subjects[$sid]) || ($daily_subject_usage[$sid] ?? 0) < 1)
                            ) {
                                $available_subjects[] = $sid;
                                unset($deferred_subjects_by_day[$dayIndex][$key]);
                            }
                        }
                    }

                    foreach ($daily_mandatory_subjects as $mand_subject) {
                        // if (
                        //     empty($daily_subject_usage[$mand_subject]) &&
                        //     ($weekly_subject_usage[$mand_subject] ?? 0) < $subject_total_counts[$mand_subject]
                        // ) {
                        //     $available_subjects[] = $mand_subject;
                        // }

                        $used_today = $daily_subject_usage[$mand_subject] ?? 0;
                        $used_week = $weekly_subject_usage[$mand_subject] ?? 0;
                        $max_allowed = $subject_total_counts[$mand_subject] ?? 0;

                        if ($used_today < 1 && $used_week < $max_allowed) {
                            // Force it into the available subjects for today
                            array_unshift($available_subjects, $mand_subject); // give it priority
                        }
                    }

                    foreach ($subject_total_counts as $sid => $total_allowed) {

                        if (
                            $sid == $fixed_subject_id &&
                            (
                                ($weekly_subject_usage[$sid] ?? 0) >= $total_allowed ||
                                count($class_teacher_first_period_days) < 6 // not yet assigned first period for 6 days
                            )
                        )
                            continue;

                        if (($weekly_subject_usage[$sid] ?? 0) >= $total_allowed)
                            continue;

                        if (isset($non_repeatable_subjects[$sid]) && ($daily_subject_usage[$sid] ?? 0) >= 1) {
                            $deferred_subjects_by_day[$dayIndex + 1][] = $sid;
                            continue;
                        }



                        if (
                            $sid == $fixed_subject_id &&
                            $subject_total_counts[$fixed_subject_id] <= 6
                        ) {
                            continue;
                        }

                        $used_days = $subject_daily_distribution[$sid] ?? [];
                        if (in_array($day, $used_days)) {
                            if (count($used_days) < count($days)) {
                                $deferred_subjects_by_day[$dayIndex + 1][] = $sid;
                                continue; // Don't allow same-day repeat until all days used
                            }
                        }

                        $available_subjects[] = $sid;
                    }

                    log_message('debug', "No available subject found for class $class_id, section $section_id on $day, period $period. Weekly Usage: " . print_r($weekly_subject_usage, true) . " Daily: " . print_r($daily_subject_usage, true));

                    if (empty($available_subjects)) {
                        foreach ($subject_total_counts as $sid => $total_allowed) {
                            if (($weekly_subject_usage[$sid] ?? 0) < $total_allowed) {
                                $available_subjects[] = $sid;
                            }
                        }
                    }

                    shuffle($available_subjects);

                    foreach ($available_subjects as $sid) {
                        if (($weekly_subject_usage[$sid] ?? 0) >= ($subject_total_counts[$sid] ?? 0)) {
                            continue;
                        }
                        $potential_teacher_id = $subject_teacher_map[$sid] ?? null;
                        $valid = true;
                        log_message('debug', "Checking subject ID: $sid for period: $period, day: $day, class: $class_id");

                        // Sports restriction
                        if (in_array($sid, $sportsId) && in_array($period, [1, 5, 8, 9, 10])) {
                            $valid = false;
                            log_message('debug', "Subject $sid is in sportsId and restricted for this period $period.");
                        }

                        // Yoga restriction
                        if (in_array($sid, $yogaId) && in_array($period, [1, 5, 9, 10])) {
                            $valid = false;
                            log_message('debug', "Subject $sid is in yogaId and restricted for this period $period.");
                        }

                        // Restricted subjects
                        if (in_array($sid, $restricted_subject_ids) && in_array($period, [1, 9, 10])) {
                            $valid = false;
                            log_message('debug', "Subject $sid is in restricted_subject_ids and restricted for this period $period.");
                        }

                        // Activity restrictions
                        if (
                            in_array($sid, $activityId) &&
                            (
                                (in_array($class_id, [18, 19, 20]) && in_array($day, ['Thursday', 'Friday', 'Saturday']) && in_array($period, [9, 10])) ||
                                (in_array($class_id, [21, 22, 23]) && in_array($day, ['Monday', 'Tuesday', 'Wednesday']) && in_array($period, [9, 10]))
                            )
                        ) {
                            log_message('debug', "Subject $sid is a valid activity for this class/day/period.");
                            // valid remains true
                        } elseif (in_array($sid, $activityId)) {
                            $valid = false;
                            log_message('debug', "Subject $sid is in activityId but NOT allowed for class/day/period.");
                        }

                        $potential_teacher_id = $subject_teacher_map[$sid] ?? null;

                        // Final decision
                        if ($valid) {
                            if (!isset($teacher_schedule[$day][$period][$potential_teacher_id])) {
                                $subject_id = $sid;
                                $teacher_id = $potential_teacher_id;
                                $weekly_subject_usage[$sid]++;
                                $daily_subject_usage[$sid] = ($daily_subject_usage[$sid] ?? 0) + 1;
                                $teacher_schedule[$day][$period][$teacher_id] = true;
                                if (!isset($subject_daily_distribution[$sid])) {
                                    $subject_daily_distribution[$sid] = [];
                                }
                                if (!in_array($day, $subject_daily_distribution[$sid])) {
                                    $subject_daily_distribution[$sid][] = $day;
                                }
                                break;
                            } else {
                                log_message('debug', "Teacher $potential_teacher_id already assigned at period $period on $day.");
                            }
                        }
                    }

                    if ($subject_id == 0 && !empty($available_subjects)) {
                        foreach ($available_subjects as $sid) {

                            if (($weekly_subject_usage[$sid] ?? 0) >= ($subject_total_counts[$sid] ?? 0)) {
                                continue;
                            }
                            $potential_teacher_id = $subject_teacher_map[$sid] ?? null;

                            // Check for teacher conflict
                            if ($potential_teacher_id !== null && !isset($teacher_schedule[$day][$period][$potential_teacher_id])) {
                                // No conflict — assign this subject and teacher
                                $subject_id = $sid;
                                $teacher_id = $potential_teacher_id;

                                // Track usage
                                $weekly_subject_usage[$sid]++;
                                $daily_subject_usage[$sid] = ($daily_subject_usage[$sid] ?? 0) + 1;

                                // Mark the teacher as assigned for this day and period
                                $teacher_schedule[$day][$period][$teacher_id] = true;

                                break; // Stop loop once a valid subject-teacher pair is assigned
                            } else {
                                log_message('debug', "Conflict: Teacher $potential_teacher_id already assigned at $day, period $period.");
                            }
                        }
                    }


                    if ($subject_id == 0) {
                        // Step 1: Force daily mandatory subjects first
                        foreach ($daily_mandatory_subjects as $sid) {
                            $used_today = $daily_subject_usage[$sid] ?? 0;
                            $used_week = $weekly_subject_usage[$sid] ?? 0;
                            $max_allowed = $subject_total_counts[$sid] ?? 0;
                            $teacher_id = $subject_teacher_map[$sid] ?? 0;

                            if ($used_today < 1 && $used_week < $max_allowed) {
                                if (!isset($teacher_schedule[$day][$period][$teacher_id])) {
                                    $subject_id = $sid;
                                    $weekly_subject_usage[$sid]++;
                                    $daily_subject_usage[$sid] = 1;
                                    $teacher_schedule[$day][$period][$teacher_id] = true;

                                    if (!isset($subject_daily_distribution[$sid])) {
                                        $subject_daily_distribution[$sid] = [];
                                    }
                                    if (!in_array($day, $subject_daily_distribution[$sid])) {
                                        $subject_daily_distribution[$sid][] = $day;
                                    }

                                    log_message('debug', "FORCED daily-mandatory subject_id $sid on $day, period $period.");
                                    break;
                                }
                            }
                        }

                        // Step 2: Fallback to *any* subject with available quota
                        if ($subject_id == 0) {
                            foreach ($subject_total_counts as $sid => $max_allowed) {
                                if (($weekly_subject_usage[$sid] ?? 0) < $max_allowed) {
                                    $teacher_id = $subject_teacher_map[$sid] ?? 0;

                                    if (isset($teacher_schedule[$day][$period][$teacher_id])) {
                                        continue;
                                    }

                                    $subject_id = $sid;
                                    $weekly_subject_usage[$sid]++;
                                    $daily_subject_usage[$sid] = ($daily_subject_usage[$sid] ?? 0) + 1;
                                    $teacher_schedule[$day][$period][$teacher_id] = true;

                                    if (!isset($subject_daily_distribution[$sid])) {
                                        $subject_daily_distribution[$sid] = [];
                                    }
                                    if (!in_array($day, $subject_daily_distribution[$sid])) {
                                        $subject_daily_distribution[$sid][] = $day;
                                    }

                                    log_message('debug', "FALLBACK subject_id $sid filled on $day, period $period.");
                                    break;
                                }
                            }
                        }
                    }







                    $from_time = date("H:i", $current_time);
                    $duration = $period_durations[$period];
                    $current_time += $duration * 60;
                    $to_time = date("H:i", $current_time);




                }

                $timetable[] = [
                    'class_id' => $class_id,
                    'section_id' => $section_id,
                    'day' => $day,
                    'teacher_id' => $teacher_id ?? 0,
                    'period_id' => $period,
                    'subject_id' => $subject_id,
                    'time_from' => date("h:i A", strtotime($from_time)),
                    'time_to' => date("h:i A", strtotime($to_time)),
                    'status' => 1,
                ];
            }
        }



        // Final debug log
        log_message('debug', 'Generated Timetable: ' . print_r($timetable, true));

        // Uncomment to save
        $this->Generatetimetable_model->save_timetable($timetable);

        log_message('debug', "Final subject_daily_distribution: " . print_r($subject_daily_distribution, true));

        $this->session->set_flashdata('msg', 'Timetable generated successfully.');
        redirect('admin/timetable/show_timetable');

    }


    public function edit_timetable()
    {
        if (!$this->rbac->hasPrivilege('class_timetable', 'can_view')) {
            access_denied();
        }

        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/timetable');

        $session = $this->setting_model->getCurrentSession();
        $data['title'] = 'Exam Schedule';
        $data['subject_id'] = "";
        $data['class_id'] = "";
        $data['section_id'] = "";
        $exam = $this->exam_model->get();
        $class = $this->class_model->get('', $classteacher = 'yes');
        $data['examlist'] = $exam;
        $data['classlist'] = $class;
        $userdata = $this->customlib->getUserData();
        $staff = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['staff'] = $staff;
        $data['subject'] = array();
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_group_id', $this->lang->line('subject_group'), 'trim|required|xss_clean');
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $subject_group_id = $this->input->post('subject_group_id');

        $data['class_id'] = $class_id;
        $data['section_id'] = $section_id;
        $data['subject_group_id'] = $subject_group_id;
        $menu_data['selected'] = 'edit_timetable';
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);

        if ($this->form_validation->run() == false) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/teacher/edit_timetable', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $getDaysnameList = $this->customlib->getDaysname();
            $data['getDaysnameList'] = $getDaysnameList;
            $subject = $this->subjectgroup_model->getGroupsubjects($subject_group_id);
            $data['subject'] = $subject;

            $this->load->view('layout/header', $data);
            $this->load->view('admin/teacher/edit_timetable', $data);
            $this->load->view('layout/footer', $data);
        }
    }


    public function class_subject_periods()
    {
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/class_subject_periods');
        $data['title'] = 'Assign Class Subject Counts';
        $class = $this->class_model->get();
        $data['classlist'] = $class;



        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('subject_group_id', $this->lang->line('subject_group'), 'trim|required|xss_clean');
        if ($this->form_validation->run()) {

            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $subject_group_id = $this->input->post('subject_group_id');
            $data['class_post'] = $class_id;
            $data['section_post'] = $section_id;
            $data['subject_group_id'] = $subject_group_id;

            $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);
            $subjects = $this->teachersubject_model->getClassSectionSubjectgroupSubjects($dt['id'], $subject_group_id);
            $class_week_periods = $this->teachersubject_model->getWeekPeriodsForClass($dt['id']);
            // print_r($subjects); die();


            $data['subjects'] = $subjects;
            $data['class_week_periods'] = $class_week_periods['periods'];

        }
        $menu_data['selected'] = 'class_subject_periods';
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/view_class_subject_periods', $data);
        $this->load->view('layout/footer', $data);

    }

    public function save_class_subject_periods()
    {
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $subject_group_subject_ids = $this->input->post('subject_group_subject_id'); // Array
        $periods = $this->input->post('periods'); // Array

        $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);

        // print_r($subject_group_subject_ids); die();

        if (empty($class_id) || empty($section_id) || empty($subject_group_subject_ids) || empty($periods)) {
            echo json_encode(['status' => false, 'message' => 'All fields are required!']);
            return;
        }

        $insert_data = [];

        foreach ($subject_group_subject_ids as $key => $subject_id) {
            $insert_data[] = [
                'class_section_id' => $dt['id'],
                'subject_group_subject_id' => $subject_id,
                'periods' => $periods[$key] // Matching periods with subject ID
            ];
        }

        $this->teachersubject_model->add_class_subject_periods($insert_data);

        echo json_encode(['status' => true, 'message' => 'Data processed successfully!']);
    }

    public function class_periods_for_week()
    {
        if (!$this->rbac->hasPrivilege('automatictimetable', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/class_total_periods_for_week');
        $data['title'] = 'class total periods for week';
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        if ($this->form_validation->run()) {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['class_post'] = $class_id;
            $data['section_post'] = $section_id;
            $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);
            $weekperiods = $this->teachersubject_model->getWeekPeriodsForClass($dt['id']);
            if ($weekperiods) {
                $week_periods = $weekperiods;
            } else {
                $week_periods = [];
            }
            $data['week_periods'] = $week_periods;
        }
        $menu_data['selected'] = 'class_total_periods_for_week';
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/view_class_periods_for_week', $data);
        $this->load->view('layout/footer', $data);
    }

    public function save_class_week_periods()
    {
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        $periods = $this->input->post('periods');
        $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);
        if (empty($class_id) || empty($section_id) || empty($periods)) {
            echo json_encode(['status' => false, 'message' => 'All fields are required!']);
            return;
        }
        $insert_data = [
            'class_section_id' => $dt['id'],
            'periods' => $periods
        ];
        $this->teachersubject_model->add_class_week_periods($insert_data);
        echo json_encode(['status' => true, 'message' => 'Data processed successfully!']);
    }

    public function periods_time()
    {
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/periods_time');
        $data['title'] = 'Assign Periods Time';
        $data['periods_data'] = $this->teachersubject_model->get_periods_time();
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $school_start_time = $this->input->post('school_start_time');
            $school_end_time = $this->input->post('school_end_time');
            $lunch_start_time = $this->input->post('lunch_break_start_time');
            $lunch_end_time = $this->input->post('lunch_break_end_time');
            $short_break_start_time = $this->input->post('short_break_start_time');
            $short_break_end_time = $this->input->post('short_break_end_time');
            // Capture period times
            $first_period = $this->input->post('first_period');
            $second_period = $this->input->post('second_period');
            $third_period = $this->input->post('third_period');
            $fourth_period = $this->input->post('fourth_period');
            $fifth_period = $this->input->post('fifth_period');
            $sixth_period = $this->input->post('sixth_period');
            $seventh_period = $this->input->post('seventh_period');
            $eighth_period = $this->input->post('eighth_period');
            // Data array
            $data = array(
                'school_start_time' => $school_start_time,
                'school_end_time' => $school_end_time,
                'lunch_break_start_time' => $lunch_start_time,
                'lunch_break_end_time' => $lunch_end_time,
                'short_break_start_time' => $short_break_start_time,
                'short_break_end_time' => $short_break_end_time,
                'first_period' => $first_period,
                'second_period' => $second_period,
                'third_period' => $third_period,
                'fourth_period' => $fourth_period,
                'fifth_period' => $fifth_period,
                'sixth_period' => $sixth_period,
                'seventh_period' => $seventh_period,
                'eight_period' => $eighth_period
            );
            // Insert or update
            $this->teachersubject_model->insert_or_update_periods_time($data);
            // Redirect with message
            $this->session->set_flashdata('msg', 'Periods time saved successfully.');
            redirect('admin/teacher/periods_time');
        }
        $menu_data['selected'] = 'periods_time';
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);
        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/periods_time', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getteacher()
    {
        $subject_group_id = $this->input->post('subject_id');
        $class_id = $this->input->post('class_id');
        $section_id = $this->input->post('section_id');
        // Get details for the class and section
        $dt = $this->classsection_model->getDetailbyClassSection($class_id, $section_id);
        $subject = $this->teachersubject_model->SubjectsBySubjectGroup($subject_group_id);
        $subject_id = $subject['subject_id'];
        // Get teacher for the class, section, and subject
        $class_section_id = $dt['id'];
        $class_teacher = $this->teachersubject_model->TeacherClassSectionSjubject($subject_id, $class_section_id);
        // Fetch teacher data
        if (!empty($class_teacher)) {
            $teacherData = $this->staff_model->get($class_teacher['teacher_id']);
            if (!empty($teacherData)) {
                echo json_encode([
                    'status' => 'success',
                    'teacher' => [
                        'id' => $teacherData['id'],
                        'name' => $teacherData['name'],
                        'surname' => $teacherData['surname'],
                        'employee_id' => $teacherData['employee_id'],
                    ],
                ]);
                return;
            }
        }

        echo json_encode(['status' => 'error', 'message' => 'No teacher found.']);
    }


    public function cbse_assignteacher()
    {
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/viewassignteacher');
        $data['title'] = 'Assign Teacher with Class and Subject Wise';

        $data['teacherlist'] = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['subjectlist'] = $this->subject_model->get();
        $data['classlist'] = $this->class_model->get();
        $session = $this->setting_model->getCurrentSession();
        $menu_data['selected'] = 'cbse_assign_subject_teacher';
        $data['top_menu_option'] = $this->load->view('admin/teacher/topMenuOptions', $menu_data, true);

        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/cbseassignTeacher', $data);
        $this->load->view('layout/footer', $data);

        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $subject_group_id = $this->input->post('subject_group_id');

            $dt = $this->subjectgroup_model->getDetailofClassSection($class_id, $section_id);
            $week_total_periods = $this->teachersubject_model->getWeekPeriodsForClass($dt['id']);
            $total_periods = $week_total_periods['periods'];
            $periods_per_day = ceil($total_periods / 6);

            $days_array = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            $periods_data = $this->teachersubject_model->get_periods_time();
            $start_time = $periods_data['school_start_time'];
            $subject_time_slots = [40, 40, 40, 25, 40, 40, 40, 10, 35, 35];

            $subject_periods_per_week = $this->teachersubject_model->getClassSectionSubjectwisePeriods($dt['id']);

            $delete_array = [];
            $insert_array = [];
            $prev_records = $this->subjecttimetable_model->getBySubjectGroupDayStaffClassSection($class_id, $section_id);
            if (!empty($prev_records)) {
                foreach ($prev_records as $prev_record) {
                    $delete_array[] = $prev_record['id'];
                }
            }

            $subject_allocation = [];
            foreach ($subject_periods_per_week as $subject_data) {
                $subject_allocation[$subject_data['subject_group_subject_id']] = $subject_data['periods'];
            }

            $schedule = [];
            foreach ($days_array as $day) {
                $current_time = $start_time;
                $day_schedule = [];

                foreach ($subject_allocation as $subject_id => $remaining_periods) {
                    if ($remaining_periods > 0) {
                        $subject_periods_today = ceil($remaining_periods / count($days_array));

                        for ($i = 0; $i < $subject_periods_today; $i++) {
                            $teacher_id = $this->input->post("teacher_id_$subject_id");
                            $room_no = $this->input->post("room_no_$subject_id");
                            $time_increment = $subject_time_slots[array_rand($subject_time_slots)];
                            $end_time = date("h:i A", strtotime("+{$time_increment} minutes", strtotime($current_time)));

                            $conflict = $this->subjecttimetable_model->checkTeacherConflict($teacher_id, $day, $current_time, $end_time);
                            if (!$conflict) {
                                $day_schedule[] = [
                                    'day' => $day,
                                    'class_id' => $class_id,
                                    'section_id' => $section_id,
                                    'subject_group_id' => $subject_group_id,
                                    'subject_group_subject_id' => $subject_id,
                                    'staff_id' => $teacher_id,
                                    'time_from' => $current_time,
                                    'time_to' => $end_time,
                                    'start_time' => $this->customlib->timeFormat($current_time, true),
                                    'end_time' => $this->customlib->timeFormat($end_time, true),
                                    'room_no' => $room_no,
                                    'session_id' => $session,
                                ];
                                $current_time = $end_time;
                                $subject_allocation[$subject_id]--;
                            }
                        }
                    }
                }
                shuffle($day_schedule);
                $schedule = array_merge($schedule, $day_schedule);
            }

            $this->subjecttimetable_model->add($delete_array, $schedule, []);
            // $this->teachersubject_model->deleteBatch(array_keys($subject_allocation), $dt['id']);

            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/teacher/cbse_assignteacher');
        }
    }

    // timetable ends here

    public function viewassignteacher()
    {
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/viewassignteacher');
        $data['title'] = 'Assign Teacher with Class and Subject wise';

        $teacher = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['teacherlist'] = $teacher;
        $subject = $this->subject_model->get();
        $data['subjectlist'] = $subject;
        $class = $this->class_model->get();
        $data['classlist'] = $class;
        $userdata = $this->customlib->getUserData();

        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/viewassignTeacher', $data);
        $this->load->view('layout/footer', $data);
        if ($this->input->server('REQUEST_METHOD') == "POST") {
            $loop = $this->input->post('i');
            $array = array();
            foreach ($loop as $key => $value) {
                $s = array();
                $s['session_id'] = $this->setting_model->getCurrentSession();
                $class_id = $this->input->post('class_id');
                $section_id = $this->input->post('section_id');
                $dt = $this->classsection_model->getDetailbyClassSection($class_id, $section_id);

                $s['class_section_id'] = $dt['id'];
                $s['teacher_id'] = $this->input->post('teacher_id_' . $value);
                $s['subject_id'] = $this->input->post('subject_id_' . $value);
                $row_id = $this->input->post('row_id_' . $value);
                if ($row_id == 0) {
                    $insert_id = $this->teachersubject_model->add($s);
                    $array[] = $insert_id;
                } else {
                    $s['id'] = $row_id;
                    $array[] = $row_id;
                    $this->teachersubject_model->add($s);
                }
            }

            $ids = $array;
            $class_section_id = $dt['id'];
            $this->teachersubject_model->deleteBatch($ids, $class_section_id);
            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/teacher/assignteacher');
        }
    }

    public function getSubjectTeachers()
    {
        if (!$this->rbac->hasPrivilege('assign_subject', 'can_view')) {
            access_denied();
        }
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        if ($this->form_validation->run()) {
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $dt = $this->classsection_model->getDetailbyClassSection($class_id, $section_id);
            $data = $this->teachersubject_model->getDetailByclassAndSection($dt['id']);
            $subjects = $this->teachersubject_model->getSubjectsByclassAndSection($dt['id']);
            echo json_encode(array('st' => 0, 'msg' => $data, 'subjects' => $subjects));
        } else {
            $data = array(
                'class_id' => form_error('class_id'),
                'section_id' => form_error('section_id'),
            );
            echo json_encode(array('st' => 1, 'msg' => $data));
        }
    }

    public function view($id)
    {
        if (!$this->rbac->hasPrivilege('assign_subject', 'can_view')) {
            access_denied();
        }
        $data['title'] = 'Teacher List';
        $teacher = $this->teacher_model->get($id);
        $teachersubject = $this->teachersubject_model->getTeacherClassSubjects($id);
        $data['teacher'] = $teacher;
        $data['teachersubject'] = $teachersubject;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/teacher/teacherShow', $data);
        $this->load->view('layout/footer', $data);
    }

    public function delete($id)
    {
        if (!$this->rbac->hasPrivilege('assign_subject', 'can_delete')) {
            access_denied();
        }
        $data['title'] = 'Teacher List';
        $this->teacher_model->remove($id);
        redirect('admin/teacher/index');
    }

    public function create()
    {
        if (!$this->rbac->hasPrivilege('assign_subject', 'can_add')) {
            access_denied();
        }
        $data['title'] = 'Add teacher';
        $genderList = $this->customlib->getGender();
        $data['genderList'] = $genderList;
        $this->form_validation->set_rules('name', $this->lang->line('teacher'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('gender', $this->lang->line('gender'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('dob', $this->lang->line('date_of_birth'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');
        if ($this->form_validation->run() == false) {
            $teacher_result = $this->teacher_model->get();
            $data['teacherlist'] = $teacher_result;
            $genderList = $this->customlib->getGender();
            $data['genderList'] = $genderList;
            $this->load->view('layout/header', $data);
            $this->load->view('admin/teacher/teacherCreate', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'password' => $this->input->post('password'),
                'sex' => $this->input->post('gender'),
                'dob' => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('dob'))),
                'address' => $this->input->post('address'),
                'phone' => $this->input->post('phone'),
                'image' => 'uploads/student_images/no_image.png',
            );
            $insert_id = $this->teacher_model->add($data);
            $user_password = $this->role->get_random_password($chars_min = 6, $chars_max = 6, $use_upper_case = false, $include_numbers = true, $include_special_chars = false);
            $data_student_login = array(
                'username' => $this->teacher_login_prefix . $insert_id,
                'password' => $user_password,
                'user_id' => $insert_id,
                'role' => 'teacher',
            );
            $this->user_model->add($data_student_login);
            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
                $fileInfo = pathinfo($_FILES["file"]["name"]);
                $img_name = $insert_id . '.' . $fileInfo['extension'];
                move_uploaded_file($_FILES["file"]["tmp_name"], "./uploads/teacher_images/" . $img_name);
                $data_img = array('id' => $insert_id, 'image' => 'uploads/teacher_images/' . $img_name);
                $this->teacher_model->add($data_img);
            }
            $teacher_login_detail = array('id' => $insert_id, 'credential_for' => 'teacher', 'username' => $this->teacher_login_prefix . $insert_id, 'password' => $user_password, 'contact_no' => $this->input->post('phone'));

            $this->mailsmsconf->mailsms('login_credential', $teacher_login_detail);

            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/teacher/index');
        }
    }

    public function handle_upload()
    {
        if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
            $allowedExts = array('jpg', 'jpeg', 'png');
            $temp = explode(".", $_FILES["file"]["name"]);
            $extension = end($temp);
            $error = "";
            if ($_FILES["file"]["error"] > 0) {
                $error .= "Error opening the file<br />";
            }
            if (
                $_FILES["file"]["type"] != 'image/gif' &&
                $_FILES["file"]["type"] != 'image/jpeg' &&
                $_FILES["file"]["type"] != 'image/png'
            ) {

                $this->form_validation->set_message('handle_upload', $this->lang->line('file_type_not_allowed'));
                return false;
            }
            if (!in_array($extension, $allowedExts)) {

                $this->form_validation->set_message('handle_upload', $this->lang->line('extension_not_allowed'));
                return false;
            }
            if ($_FILES["file"]["size"] > 10240000) {

                $this->form_validation->set_message('handle_upload', $this->lang->line('file_size_shoud_be_less_than'));
                return false;
            }
            if ($error == "") {
                return true;
            }
        } else {
            return true;
        }
    }

    public function edit($id)
    {

        if (!$this->rbac->hasPrivilege('assign_subject', 'can_edit')) {
            access_denied();
        }

        $data['title'] = 'Edit Teacher';
        $data['id'] = $id;
        $genderList = $this->customlib->getGender();
        $data['genderList'] = $genderList;
        $teacher = $this->teacher_model->get($id);
        $data['teacher'] = $teacher;
        $this->form_validation->set_rules('name', $this->lang->line('teacher'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('gender', $this->lang->line('gender'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('dob', $this->lang->line('date_of_birth'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('file', $this->lang->line('image'), 'callback_handle_upload');

        if ($this->form_validation->run() == false) {

            $teacher_result = $this->teacher_model->get();
            $data['teacherlist'] = $teacher_result;
            $this->load->view('layout/header', $data);
            $this->load->view('admin/teacher/teacherEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {

            $data = array(
                'id' => $id,
                'name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'password' => $this->input->post('password'),
                'sex' => $this->input->post('gender'),
                'dob' => date('Y-m-d', $this->customlib->datetostrtotime($this->input->post('dob'))),
                'address' => $this->input->post('address'),
                'phone' => $this->input->post('phone'),
            );
            $insert_id = $this->teacher_model->add($data);
            if (isset($_FILES["file"]) && !empty($_FILES['file']['name'])) {
                $fileInfo = pathinfo($_FILES["file"]["name"]);
                $img_name = $id . '.' . $fileInfo['extension'];
                move_uploaded_file($_FILES["file"]["tmp_name"], "./uploads/teacher_images/" . $img_name);
                $data_img = array('id' => $id, 'image' => 'uploads/teacher_images/' . $img_name);
                $this->teacher_model->add($data_img);
            }
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/teacher/index');
        }
    }

    public function getlogindetail()
    {
        $teacher_id = $this->input->post('teacher_id');
        $examSchedule = $this->user_model->getTeacherLoginDetails($teacher_id);
        echo json_encode($examSchedule);
    }

    public function assign_class_teacher()
    {
        if (!$this->rbac->hasPrivilege('assign_class_teacher', 'can_view')) {
            access_denied();
        }
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'admin/teacher/assign_class_teacher');
        $data['title'] = 'Add Class Teacher';
        $data['title_list'] = 'Class List';

        $this->form_validation->set_rules(
            'class',
            $this->lang->line('class'),
            array(
                'required',
                array('class_exists', array($this->class_model, 'class_teacher_exists')),
            )
        );
        $this->form_validation->set_rules('section', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('teachers[]', $this->lang->line('class_teacher'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

        } else {

            $class = $this->input->post("class");
            $section = $this->input->post("section");
            $teachers = $this->input->post("teachers");

            $i = 0;
            foreach ($teachers as $key => $value) {

                $classteacherid = $this->input->post("classteacherid");
                if (isset($classteacherid)) {

                    $data = array(
                        'id' => $classteacherid[$i],
                        'class_id' => $class,
                        'section_id' => $section,
                        'staff_id' => $teachers[$i],
                        'session_id' => $this->current_session,
                    );
                } else {
                    $data = array(
                        'class_id' => $class,
                        'section_id' => $section,
                        'staff_id' => $teachers[$i],
                        'session_id' => $this->current_session,
                    );
                }
                $i++;
                $this->classteacher_model->addClassTeacher($data);
            }
            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/teacher/assign_class_teacher');
        }
        $classlist = $this->class_model->get();
        $data['classlist'] = $classlist;

        $sectionlist = $this->section_model->get();
        $data['sectionlist'] = $sectionlist;

        $assignteacherlist = $this->class_model->getClassTeacher();
        $data['assignteacherlist'] = $assignteacherlist;

        foreach ($assignteacherlist as $key => $value) {
            $class_id = $value["class_id"];
            $section_id = $value["section_id"];

            $tlist[] = $this->classteacher_model->teacherByClassSection($class_id, $section_id);
        }
        if (!empty($tlist)) {
            $data["tlist"] = $tlist;
        }
        $teacherlist = $this->staff_model->getStaffbyroles([1, 2, 4]);

        $data['teacherlist'] = $teacherlist;

        $this->load->view('layout/header', $data);
        $this->load->view('class/classTeacher', $data);
        $this->load->view('layout/footer', $data);
    }

    public function classteacheredit1111($class_id, $section_id)
    {
        if (!$this->rbac->hasPrivilege('assign_class_teacher', 'can_edit')) {
            access_denied();
        }

        $result = $this->classteacher_model->teacherByClassSection($class_id, $section_id);

        $data["result"] = $result;

        $assignteacherlist = $this->class_model->getClassTeacher();
        $data['assignteacherlist'] = $assignteacherlist;
        foreach ($assignteacherlist as $key => $value) {
            $classid = $value["class_id"];
            $sectionid = $value["section_id"];

            $tlist[] = $this->classteacher_model->teacherByClassSection($classid, $sectionid);
        }

        $data["tlist"] = $tlist;
        $teacherlist = $this->staff_model->getStaffbyroles([1, 2, 4]);
        $data['teacherlist'] = $teacherlist;
        $data['class_id'] = $class_id;
        $data['section_id'] = $section_id;
        $classlist = $this->class_model->get();
        $data['classlist'] = $classlist;
        $sectionlist = $this->section_model->get();
        $data['sectionlist'] = $sectionlist;

        $this->load->view('layout/header', $data);
        $this->load->view('class/classTeacherEdit', $data);
        $this->load->view('layout/footer', $data);
    }

    public function update_class_teacher($class_id, $section_id)
    {
        $this->session->set_userdata('top_menu', 'Academics');
        $this->session->set_userdata('sub_menu', 'classes/index');
        $data['title'] = 'Add Class Teacher';
        $data['title_list'] = 'Class List';

        $this->form_validation->set_rules(
            'class',
            $this->lang->line('class'),
            array(
                'required',
                array('class_exists', array($this->class_model, 'class_teacher_exists')),
            )
        );
        $this->form_validation->set_rules('section', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('teachers[]', $this->lang->line('class_teacher'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
            $result = $this->classteacher_model->teacherByClassSection($class_id, $section_id);

            $data["result"] = $result;

            $assignteacherlist = $this->class_model->getClassTeacher();
            $data['assignteacherlist'] = $assignteacherlist;
            foreach ($assignteacherlist as $key => $value) {
                $classid = $value["class_id"];
                $sectionid = $value["section_id"];

                $tlist[] = $this->classteacher_model->teacherByClassSection($classid, $sectionid);
            }

            $data["tlist"] = $tlist;
            $teacherlist = $this->staff_model->getStaffbyroles([1, 2, 4]);
            $data['teacherlist'] = $teacherlist;
            $data['class_id'] = $class_id;
            $data['section_id'] = $section_id;
            $classlist = $this->class_model->get();
            $data['classlist'] = $classlist;
            $sectionlist = $this->section_model->get();
            $data['sectionlist'] = $sectionlist;
        } else {

            $section = $this->input->post('section');
            $prev_teacher = $this->input->post('classteacherid');
            $staff_id = $this->input->post('teachers');
            $class_id = $this->input->post('class');
            if (!isset($prev_teacher)) {
                $prev_teacher = array();
            }
            $add_result = array_diff($staff_id, $prev_teacher);
            $delete_result = array_diff($prev_teacher, $staff_id);

            if (!empty($add_result)) {
                $teacher_batch_array = array();
                foreach ($add_result as $teacher_add_key => $teacher_add_value) {
                    $teacher_batch_array[] = $teacher_add_value;
                }

                $insert_array = array();
                foreach ($teacher_batch_array as $vec_key => $vec_value) {

                    $vehicle_array = array(
                        'class_id' => $class_id,
                        'section_id' => $section,
                        'staff_id' => $vec_value,
                        'session_id' => $this->current_session,
                    );
                    $this->classteacher_model->addClassTeacher($vehicle_array);
                    $insert_array[] = $vehicle_array;
                }
            } else {
                $prev_class_id = $this->input->post('prev_class_id');
                $prev_section_id = $this->input->post('prev_section_id');
                $previd = $this->input->post('previd');

                if (!empty($previd)) {

                    if ($prev_class_id != $class_id || $prev_section_id != $section) {
                        $this->classteacher_model->updateTeacher($previd, $class_id, $section);
                    }
                }
            }

            if (!empty($delete_result)) {
                $classteacher_delete_array = array();
                foreach ($delete_result as $vec_delete_key => $vec_delete_value) {
                    $classteacher_delete_array[] = $vec_delete_value;
                }

                $this->classteacher_model->delete($class_id, $section, $classteacher_delete_array);
            }
            $this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/teacher/assign_class_teacher');
        }

        $this->load->view('layout/header', $data);
        $this->load->view('class/classTeacherEdit', $data);
        $this->load->view('layout/footer', $data);
    }

    public function classteacherdelete($class_id, $section_id)
    {
        if ((!empty($class_id)) && (!empty($section_id))) {

            $this->classteacher_model->delete($class_id, $section_id, null);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-center">' . $this->lang->line('delete_message') . '</div>');
            redirect("admin/teacher/assign_class_teacher");
        }
    }

}
