<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Students_medical_checkup extends Admin_Controller
{
 
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->config->load('app-config');
        $this->load->library("datatables");
        
        $this->load->model('Student_MedicalCheckup_model');
    }

    public function index()
    {

        // if (!$this->rbac->hasPrivilege('income', 'can_view')) {
        //     access_denied();
        // }

        $this->session->set_userdata('top_menu', 'students_medical_checkup');
        $this->session->set_userdata('sub_menu', 'students_medical_checkup/index');
        $data['title']      = 'Add Medical Checkup';
        $data['title_list'] = 'Medical Checkup';
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('student_session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        

        if ($this->form_validation->run() == false) {

        } else {
            $symptoms = implode(",", $this->input->post('symptoms'));
            $prescription = implode(',', $this->input->post('prescription'));



       
            $data = array(
                'class_id' => $this->input->post('class_id'),
                'section_id'        => $this->input->post('section_id'),
                'student_session_id'        => $this->input->post('student_session_id'),
                'weight'      => $this->input->post('weight'),
                'temprature'  => $this->input->post('temprature'),
                'bp'        => $this->input->post('bp'),
                'spo2'   => $this->input->post('spo2'),
                'symptoms'      => $symptoms,
                'diagnosis'  => $this->input->post('diagnosis'),
                'prescription'        => $prescription,
                'remark'   => $this->input->post('remark'),
                'created_by' => $this->customlib->getStaffID()
            );
            $result = $this->db->insert('student_medical_checkup', $data);
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/Students_medical_checkup/');
        }

        
        $data['resultlist']= $this->Student_MedicalCheckup_model->get();
        
        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/students_medical_checkup/list', $data);
        $this->load->view('layout/footer', $data);
    }

    
    
  
    public function delete($id)
    {
        
        
        $this->db->where('id',$id);
        $this->db->delete('student_medical_checkup');
        $this->session->set_flashdata('msg', '<div class="alert alert-success text-left"> Record Deleted Successfully </div>');
            redirect('admin/Students_medical_checkup/');
    }

    
    public function getStudentByClassSection()
    {
        $class           = $this->input->post('class_id');
        $section         = $this->input->post('section_id');

        $resultlist = $this->student_model->getStudentByClassSectionID($class, $section);

        echo json_encode($resultlist);
    }

    public function edit($id)
    {
        $this->session->set_userdata('top_menu', 'students_medical_checkup');
        $this->session->set_userdata('sub_menu', 'students_medical_checkup/index');
        $data['title']      = 'Add Medical Checkup';
        $data['title_list'] = 'Medical Checkup';
        $this->form_validation->set_rules('class_id', $this->lang->line('class'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', $this->lang->line('section'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('student_session_id', $this->lang->line('student'), 'trim|required|xss_clean');
        

        if ($this->form_validation->run() == false) {

        } else {
            $symptoms = implode(",", $this->input->post('symptoms'));
            $prescription = implode(',', $this->input->post('prescription'));



       
            $data = array(
                'class_id' => $this->input->post('class_id'),
                'section_id'        => $this->input->post('section_id'),
                'student_session_id'        => $this->input->post('student_session_id'),
                'weight'      => $this->input->post('weight'),
                'temprature'  => $this->input->post('temprature'),
                'bp'        => $this->input->post('bp'),
                'spo2'   => $this->input->post('spo2'),
                'symptoms'      => $symptoms,
                'diagnosis'  => $this->input->post('diagnosis'),
                'prescription'        => $prescription,
                'remark'   => $this->input->post('remark'),
                'created_by' => $this->customlib->getStaffID()
            );
            $this->db->where('id', $id);
            $result = $this->db->update('student_medical_checkup', $data);
            
            
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/Students_medical_checkup/');
        }

        
        $data['resultlist']= $this->Student_MedicalCheckup_model->get();
        $data['editData']= $this->Student_MedicalCheckup_model->get($id);

        
        $class                   = $this->class_model->get();
        $data['classlist']       = $class;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/students_medical_checkup/edit', $data);
        $this->load->view('layout/footer', $data);
    }

    public function incomeSearch()
    {
        if (!$this->rbac->hasPrivilege('search_due_fees', 'can_view')) {
            access_denied();
        }
        $data['searchlist'] = $this->customlib->get_searchtype();
        $this->session->set_userdata('top_menu', 'Income');
        $this->session->set_userdata('sub_menu', 'income/incomesearch');
        $data['search_type'] = '';
        $data['title']       = 'Search Income';
        $this->load->view('layout/header', $data);
        $this->load->view('admin/income/incomeSearch', $data);
        $this->load->view('layout/footer', $data);

    }
    
    
    
    public function studentlist()
    {
        
    
        $student_name = $this->input->post('student_name');
    
        $start = $this->input->post('start');
        $length = $this->input->post('length');
        $draw = $this->input->post('draw');
    
        $searchValue = trim($student_name);
        $order_column = $this->input->post('order')[0]['column'];
        $order_dir = $this->input->post('order')[0]['dir'];
    
        // Column mapping (index => column name in DB)
        $columns = [
            0 => 'students.firstname',
            1 => 'students.middlename',
            2 => 'students.lastname',
            3 => 'classes.class',
            4 => 'sections.section',
            5 => 'checkup.weight',
            6 => 'checkup.temprature',
            7 => 'checkup.bp',
            8 => 'checkup.symptoms',
            9 => 'checkup.diagnosis',
            10 => 'checkup.prescription',
            11 => 'checkup.remark',
        ];
    
        $order_by_column = isset($columns[$order_column]) ? $columns[$order_column] : "CONCAT_WS(' ', students.firstname, students.middlename, students.lastname)";;
    
        // Total records without filtering
        $totalRecords = $this->Student_MedicalCheckup_model->get_medical_checkup_count();
    
        // Filtered records
        $filteredRecords = $this->Student_MedicalCheckup_model->get_medical_checkup_count($searchValue);
    
        // Get paginated data
        $data = $this->Student_MedicalCheckup_model->get_medical_checkup_data($start, $length, $searchValue, $order_by_column, $order_dir);
        
        
    
        $response = [
            'draw' => intval($draw),
            'recordsTotal' => $totalRecords,
            'recordsFiltered' => $filteredRecords,
            'data' => $data,
        ];
        
        // print_r($response); die();
    
        echo json_encode($response);
    }


    

}
